/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.dialect;

import io.github.wycst.wast.jdbc.dialect.Dialect;
import io.github.wycst.wast.jdbc.dialect.PageDialectAgent;
import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public abstract class DialectImpl
implements Dialect {
    protected PageDialectAgent pageDialectAgent;

    @Override
    public boolean supportsLimit() {
        return false;
    }

    @Override
    public boolean supportsBackquote() {
        return false;
    }

    @Override
    public abstract String getLimitString(String var1, boolean var2);

    @Override
    public abstract String getLimitString(String var1, long var2, int var4);

    @Override
    public void setParameter(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param instanceof String) {
            ps.setString(index, (String)param);
        } else if (param instanceof Timestamp) {
            ps.setTimestamp(index, (Timestamp)param);
        } else if (param instanceof Date) {
            if (param.getClass() == Date.class) {
                ps.setTimestamp(index, new Timestamp(((Date)param).getTime()));
            } else {
                ps.setDate(index, new java.sql.Date(((Date)param).getTime()));
            }
        } else if (param instanceof Enum) {
            ps.setString(index, param.toString());
        } else {
            ps.setObject(index, param);
        }
    }

    @Override
    public PreparedStatement prepareStatement(Connection conn, String sql, int type, int resultSetConcurrency) throws SQLException {
        if (type > -1 && resultSetConcurrency > -1) {
            return conn.prepareStatement(sql, type, resultSetConcurrency);
        }
        if (type == 1) {
            return conn.prepareStatement(sql, type);
        }
        return conn.prepareStatement(sql);
    }

    @Override
    public void setPageDialectAgent(PageDialectAgent pageDialectAgent) {
        this.pageDialectAgent = pageDialectAgent;
    }

    public PageDialectAgent getPageDialectAgent() {
        if (this.pageDialectAgent == null) {
            throw new SqlExecuteException("No dialect proxy is set for paging query");
        }
        return this.pageDialectAgent;
    }
}

