/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.annotations.Column;
import io.github.wycst.wast.jdbc.annotations.Id;
import io.github.wycst.wast.jdbc.transform.TypeTransformer;
import io.github.wycst.wast.jdbc.transform.TypeTransformerFactory;
import io.github.wycst.wast.jdbc.transform.UndoTypeTransformer;
import java.lang.reflect.Field;
import java.util.HashMap;

public class FieldColumn {
    private final Column column;
    private final Field field;
    private final String columnName;
    private final TypeTransformer typeTransformer;
    private final boolean useTypeTransformer;
    private final GetterInfo getterInfo;
    private final SetterInfo setterInfo;
    private final boolean equalName;
    private final String queryColumnSyntax;
    private final boolean disabledOnSelect;
    private final boolean disabledOnUpdate;
    private final boolean disabledOnInsert;
    private final String placeholderOnReadTemplate;
    private final String placeholderOnWriteTemplate;
    private Class<?> fetchEntityClass;
    private Id id;
    private boolean primary;

    FieldColumn(Field field, Column column, String columnName, SetterInfo setterInfo, GetterInfo getterInfo) {
        String queryColumnSyntax;
        HashMap<String, String> context;
        this.field = field;
        this.column = column;
        this.columnName = columnName;
        this.getterInfo = getterInfo;
        this.setterInfo = setterInfo;
        TypeTransformer typeTransformer = null;
        if (column != null && column.transformer() != UndoTypeTransformer.class) {
            typeTransformer = TypeTransformerFactory.getTransformer(column, setterInfo);
        }
        this.disabledOnInsert = column != null && column.disabledOnInsert();
        this.disabledOnUpdate = column != null && column.disabledOnUpdate();
        this.disabledOnSelect = column != null && column.disabledOnSelect();
        this.typeTransformer = typeTransformer;
        this.useTypeTransformer = typeTransformer != null;
        this.equalName = field.getName().equals(columnName);
        String placeholderOnReadTemplate = null;
        String placeholderOnWriteTemplate = null;
        if (column != null) {
            String placeholderOnWrite;
            String placeholderOnRead = column.placeholderOnRead().trim();
            if (StringUtils.isNotEmpty(placeholderOnRead)) {
                context = new HashMap<String, String>();
                context.put("value", "${alias}." + columnName);
                placeholderOnReadTemplate = Expression.renderTemplate(placeholderOnRead, context);
                if (placeholderOnReadTemplate.equals(placeholderOnRead)) {
                    placeholderOnReadTemplate = null;
                }
            }
            if (StringUtils.isNotEmpty(placeholderOnWrite = column.placeholderOnWrite().trim())) {
                HashMap<String, String> context2 = new HashMap<String, String>();
                context2.put("value", "${" + field.getName() + "}");
                placeholderOnWriteTemplate = Expression.renderTemplate(placeholderOnWrite, context2);
                if (placeholderOnWriteTemplate.equals(placeholderOnWrite)) {
                    placeholderOnWriteTemplate = null;
                }
            }
        }
        this.placeholderOnReadTemplate = placeholderOnReadTemplate;
        this.placeholderOnWriteTemplate = placeholderOnWriteTemplate;
        if (placeholderOnReadTemplate == null) {
            queryColumnSyntax = this.equalName ? "t." + columnName + "," : "t." + columnName + " as \"" + field.getName() + "\",";
        } else {
            context = new HashMap();
            context.put("alias", "t");
            queryColumnSyntax = Expression.renderTemplate(placeholderOnReadTemplate, context) + " as \"" + field.getName() + "\",";
        }
        this.queryColumnSyntax = queryColumnSyntax;
    }

    boolean usePlaceholderOnWrite() {
        return this.placeholderOnWriteTemplate != null;
    }

    String getPlaceholderOnWriteTemplate() {
        return this.placeholderOnWriteTemplate;
    }

    Object getFieldValue(Object entity) {
        return this.getterInfo.invoke(entity);
    }

    <E> void setFieldValue(E entity, Object value) {
        this.setterInfo.invoke(entity, value);
    }

    TypeTransformer getTypeTransformer() {
        return this.typeTransformer;
    }

    public Class<?> getFetchEntityClass() {
        return this.fetchEntityClass;
    }

    public void setFetchEntityClass(Class<?> fetchEntityClass) {
        this.fetchEntityClass = fetchEntityClass;
    }

    public Field getField() {
        return this.field;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public Column getColumn() {
        return this.column;
    }

    public boolean isEqualName() {
        return this.equalName;
    }

    String getQueryColumnSyntax() {
        return this.queryColumnSyntax;
    }

    String getQueryColumnSyntax(String tableAlias) {
        if (this.placeholderOnReadTemplate == null) {
            return tableAlias + "." + this.getColumnName();
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("alias", tableAlias);
        return Expression.renderTemplate(this.placeholderOnReadTemplate, context);
    }

    public SetterInfo getSetterInfo() {
        return this.setterInfo;
    }

    public boolean isUseTypeTransformer() {
        return this.useTypeTransformer;
    }

    public Object transform(Object fieldValue) {
        return this.typeTransformer.toJavaField(fieldValue);
    }

    boolean isDisabledOnSelect() {
        return this.disabledOnSelect;
    }

    boolean isDisabledOnUpdate() {
        return this.disabledOnUpdate;
    }

    boolean isDisabledOnInsert() {
        return this.disabledOnInsert;
    }
}

