/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.AsciiStringSource;
import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.ISO_8859_1CharSource;
import io.github.wycst.wast.common.beans.UTF16ByteArraySource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONReader;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.JSONTypeMapper;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONValidator;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.json.options.WriteOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class JSON
extends JSONGeneral {
    public static final String VERSION = "0.0.12.1";

    public static Object parse(String json, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        return JSONDefaultParser.parse(json, readOptions);
    }

    public static Map parseMap(String json, Class<? extends Map> mapCls, ReadOption ... readOptions) {
        return JSONDefaultParser.parseMap(json, mapCls, readOptions);
    }

    public static Collection parseCollection(String json, Class<? extends Collection> collectionCls, ReadOption ... readOptions) {
        return JSONDefaultParser.parseCollection(json, collectionCls, readOptions);
    }

    public static Object parse(char[] buf, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(buf, readOptions);
    }

    public static Object parse(byte[] bytes, ReadOption ... readOptions) {
        if (bytes == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(bytes, 0, bytes.length)) {
                return JSONDefaultParser.parse((CharSource)AsciiStringSource.of(bytes), bytes, null, readOptions);
            }
            return JSONDefaultParser.parse((CharSource)ISO_8859_1CharSource.of(bytes), bytes, null, readOptions);
        }
        return JSONDefaultParser.parse(bytes, readOptions);
    }

    public static Object parse(String json, Class<?> actualType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
            if (bytes.length == json.length()) {
                AsciiStringSource charSource = AsciiStringSource.of(json, bytes);
                return JSON.parse((CharSource)charSource, bytes, actualType, null, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSON.parse((CharSource)UTF16ByteArraySource.of(json), chars, actualType, null, readOptions);
        }
        return JSON.parse(null, JSON.getChars(json), actualType, null, readOptions);
    }

    public static <T> T parseObject(String json, Class<T> actualType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
            if (bytes.length == json.length()) {
                AsciiStringSource charSource = AsciiStringSource.of(json, bytes);
                return JSON.parseObject(typeDeserializer, (CharSource)charSource, bytes, actualType, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSON.parseObject(typeDeserializer, (CharSource)UTF16ByteArraySource.of(json), chars, actualType, readOptions);
        }
        return JSON.parseObject(typeDeserializer, null, JSON.getChars(json), actualType, readOptions);
    }

    public static <T> T parseObject(char[] buf, Class<T> actualType, ReadOption ... readOptions) {
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        return JSON.parseObject(typeDeserializer, null, buf, actualType, readOptions);
    }

    public static <T> T parseObject(byte[] buf, Class<T> actualType, ReadOption ... readOptions) {
        JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
        if (EnvUtils.JDK_9_PLUS) {
            if (!EnvUtils.hasNegatives(buf, 0, buf.length)) {
                return JSON.parseObject(typeDeserializer, (CharSource)AsciiStringSource.of(buf), buf, actualType, readOptions);
            }
            return JSON.parseObject(typeDeserializer, (CharSource)ISO_8859_1CharSource.of(buf), buf, actualType, readOptions);
        }
        return JSON.parseObject(typeDeserializer, null, buf, actualType, readOptions);
    }

    public static <T> T parse(String json, Type type, ReadOption ... readOptions) {
        if (type instanceof Class) {
            return (T)JSON.parse(json, (Class)type, readOptions);
        }
        GenericParameterizedType genericParameterizedType = GenericParameterizedType.of(type);
        if (genericParameterizedType == null) {
            throw new JSONException("not supported type " + type);
        }
        return JSON.parse(json, genericParameterizedType, readOptions);
    }

    private static <T> T parseObject(final JSONTypeDeserializer deserializer, final CharSource charSource, char[] buf, final Class<T> actualType, ReadOption[] readOptions) {
        return (T)JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType();
                if (genericParameterizedType == null) {
                    genericParameterizedType = GenericParameterizedType.actualType(actualType);
                }
                return deserializer.deserialize(charSource, buf, fromIndex, toIndex, genericParameterizedType, null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static <T> T parseObject(final JSONTypeDeserializer deserializer, final CharSource charSource, byte[] buf, final Class<T> actualType, ReadOption[] readOptions) {
        return (T)JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                GenericParameterizedType genericParameterizedType = deserializer.getGenericParameterizedType();
                if (genericParameterizedType == null) {
                    genericParameterizedType = GenericParameterizedType.actualType(actualType);
                }
                return deserializer.deserialize(charSource, buf, fromIndex, toIndex, genericParameterizedType, null, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    public static <T> T parseObject(String json, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return JSON.parse(json, genericParameterizedType, readOptions);
    }

    public static <T> T parseObject(char[] buf, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return JSON.parse(buf, genericParameterizedType, readOptions);
    }

    public static <T> T parse(String json, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        if (json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSON.parse((CharSource)AsciiStringSource.of(json, bytes), bytes, genericParameterizedType, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSON.parse((CharSource)UTF16ByteArraySource.of(json), chars, genericParameterizedType, readOptions);
        }
        return JSON.parseObject(JSON.getChars(json), genericParameterizedType, readOptions);
    }

    public static <T> T parse(char[] buf, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return JSON.parse(null, buf, genericParameterizedType, readOptions);
    }

    public static <T> T parse(byte[] buf, GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            return JSON.parse(new String(buf), genericParameterizedType, readOptions);
        }
        return JSON.parse(null, buf, genericParameterizedType, readOptions);
    }

    private static <T> T parse(final CharSource charSource, char[] buf, final GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return (T)JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                ReflectConsts.ClassCategory classCategory = genericParameterizedType.getActualClassCategory();
                return JSONTypeDeserializer.TYPE_DESERIALIZERS[classCategory.ordinal()].deserialize(charSource, buf, fromIndex, toIndex, genericParameterizedType, null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static <T> T parse(final CharSource charSource, byte[] buf, final GenericParameterizedType<T> genericParameterizedType, ReadOption ... readOptions) {
        return (T)JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                ReflectConsts.ClassCategory classCategory = genericParameterizedType.getActualClassCategory();
                return JSONTypeDeserializer.TYPE_DESERIALIZERS[classCategory.ordinal()].deserialize(charSource, buf, fromIndex, toIndex, genericParameterizedType, null, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    public static <T> List<T> parseArray(String json, Class<T> actualType, ReadOption ... readOptions) {
        byte code;
        if (json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS && (code = UnsafeHelper.getStringCoder(json)) == 1) {
            char[] chars = JSON.getChars(json);
            return JSON.parseArray(UTF16ByteArraySource.of(json), chars, actualType, readOptions);
        }
        return JSON.parseArray(JSON.getChars(json), actualType, readOptions);
    }

    public static <T> List<T> parseArray(char[] buf, Class<T> actualType, ReadOption ... readOptions) {
        return JSON.parseArray(null, buf, actualType, readOptions);
    }

    private static <T> List<T> parseArray(final CharSource charSource, char[] buf, final Class<T> actualType, ReadOption ... readOptions) {
        return (List)JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), null, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    public static Object parse(char[] buf, Class<?> actualType, ReadOption ... readOptions) {
        return JSON.parse(null, buf, 0, buf.length, actualType, null, readOptions);
    }

    public static Object parse(char[] buf, int fromIndex, int toIndex, Class<?> actualType, ReadOption ... readOptions) {
        return JSON.parse(null, buf, fromIndex, toIndex, actualType, null, readOptions);
    }

    public static Object parse(byte[] buf, Class<?> actualType, ReadOption ... readOptions) {
        if (EnvUtils.JDK_9_PLUS) {
            return JSON.parse(new String(buf), actualType, readOptions);
        }
        return JSON.parse(null, buf, actualType, null, readOptions);
    }

    private static Object parse(CharSource charSource, char[] buf, Class<?> actualType, Object defaultValue, ReadOption ... readOptions) {
        return JSON.parse(charSource, buf, 0, buf.length, actualType, defaultValue, readOptions);
    }

    private static Object parse(final CharSource charSource, char[] buf, int fromIndex, int toIndex, final Class<?> actualType, final Object defaultValue, ReadOption ... readOptions) {
        return JSON.deserialize(buf, fromIndex, toIndex, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                char beginChar = buf[fromIndex];
                switch (beginChar) {
                    case '[': {
                        return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), defaultValue == null ? new ArrayList() : defaultValue, jsonParseContext);
                    }
                }
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = typeDeserializer.getGenericParameterizedType();
                if (type == null) {
                    type = GenericParameterizedType.actualType(actualType);
                }
                return typeDeserializer.deserialize(charSource, buf, fromIndex, toIndex, type, defaultValue, '\u0000', jsonParseContext);
            }
        }, readOptions);
    }

    private static Object parse(final CharSource charSource, byte[] buf, final Class<?> actualType, final Object defaultValue, ReadOption ... readOptions) {
        return JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                byte beginByte = buf[fromIndex];
                switch (beginByte) {
                    case 91: {
                        return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(ArrayList.class, actualType), defaultValue == null ? new ArrayList() : defaultValue, jsonParseContext);
                    }
                }
                JSONTypeDeserializer typeDeserializer = JSONTypeDeserializer.getTypeDeserializer(actualType);
                GenericParameterizedType type = typeDeserializer.getGenericParameterizedType();
                if (type == null) {
                    type = GenericParameterizedType.actualType(actualType);
                }
                return typeDeserializer.deserialize(charSource, buf, fromIndex, toIndex, type, defaultValue, (byte)0, jsonParseContext);
            }
        }, readOptions);
    }

    public static Object parseToObject(String json, Object instance, ReadOption ... readOptions) {
        byte code;
        if (instance == null || json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS && (code = UnsafeHelper.getStringCoder(json)) == 1) {
            char[] chars = JSON.getChars(json);
            return JSON.parseToObject(UTF16ByteArraySource.of(json), chars, instance, readOptions);
        }
        return JSON.parseToObject(null, JSON.getChars(json), instance, readOptions);
    }

    private static Object parseToObject(final CharSource charSource, char[] buf, final Object instance, ReadOption ... readOptions) {
        return JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                if (instance instanceof Map) {
                    return JSONTypeDeserializer.MAP.deserialize(charSource, buf, fromIndex, toIndex, GenericParameterizedType.DefaultMap, instance, '\u0000', jsonParseContext);
                }
                return JSONTypeDeserializer.OBJECT.deserializeObject(charSource, buf, fromIndex, toIndex, GenericParameterizedType.actualType(instance.getClass()), instance, jsonParseContext);
            }
        }, readOptions);
    }

    public static <E> Object parseToList(String json, Collection instance, Class<E> actualType, ReadOption ... readOptions) {
        byte code;
        if (instance == null || json == null) {
            return null;
        }
        if (EnvUtils.JDK_9_PLUS && (code = UnsafeHelper.getStringCoder(json)) == 1) {
            char[] chars = JSON.getChars(json);
            return JSON.parseToList(UTF16ByteArraySource.of(json), chars, instance, actualType, readOptions);
        }
        return JSON.parseToList(null, JSON.getChars(json), instance, actualType, readOptions);
    }

    private static <E> Object parseToList(final CharSource charSource, char[] buf, final Collection instance, final Class<E> actualType, ReadOption ... readOptions) {
        return JSON.deserialize(buf, new Deserializer(){

            @Override
            Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
                return JSONTypeDeserializer.COLLECTION.deserializeCollection(charSource, buf, fromIndex, toIndex, GenericParameterizedType.collectionType(instance.getClass(), actualType), (Object)instance, jsonParseContext);
            }
        }, readOptions);
    }

    private static Object deserialize(char[] buf, Deserializer deserializer, ReadOption ... readOptions) {
        return JSON.deserialize(buf, 0, buf.length, deserializer, readOptions);
    }

    private static Object deserialize(char[] buf, int fromIndex, int toIndex, Deserializer deserializer, ReadOption ... readOptions) {
        char beginChar = '\u0000';
        while (fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' ') {
            ++fromIndex;
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, jsonParseContext);
        try {
            boolean allowComment = jsonParseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSON.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, jsonParseContext);
            }
            Object result = deserializer.deserialize(buf, fromIndex, toIndex, jsonParseContext);
            int endIndex = jsonParseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSON.clearCommentAndWhiteSpaces(buf, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex);
                throw new JSONException("Syntax error, at pos " + endIndex + " extra characters found, '" + new String(buf, endIndex, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSON.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            jsonParseContext.clear();
        }
    }

    private static Object deserialize(byte[] buf, Deserializer deserializer, ReadOption ... readOptions) {
        int fromIndex;
        int toIndex = buf.length;
        byte beginByte = 0;
        for (fromIndex = 0; fromIndex < toIndex && (beginByte = buf[fromIndex]) <= 32; ++fromIndex) {
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= 32) {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, jsonParseContext);
        try {
            boolean allowComment = jsonParseContext.allowComment;
            if (allowComment && beginByte == 47) {
                fromIndex = JSON.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, jsonParseContext);
            }
            Object result = deserializer.deserialize(buf, fromIndex, toIndex, jsonParseContext);
            int endIndex = jsonParseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSON.clearCommentAndWhiteSpaces(buf, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex);
                throw new JSONException("Syntax error, at pos " + endIndex + " extra characters found, '" + new String(buf, endIndex, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSON.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            jsonParseContext.clear();
        }
    }

    public static final Date parseDate(String dateStr, Class<? extends Date> dateCls) {
        char[] buf = JSON.getChars(dateStr);
        return JSON.matchDate(buf, 0, dateStr.length(), null, dateCls);
    }

    public static Object read(byte[] bytes, ReadOption ... readOptions) {
        if (bytes == null) {
            return null;
        }
        return JSONDefaultParser.parse(bytes, readOptions);
    }

    public static Object read(InputStream is, ReadOption ... readOptions) throws IOException {
        if (is == null) {
            return null;
        }
        return JSON.read(is, (long)is.available(), readOptions);
    }

    private static Object read(InputStream is, long size, ReadOption ... readOptions) throws IOException {
        if (size <= 0L) {
            size = is.available();
        }
        if (size <= 8192L) {
            char[] buf = JSON.readInputStream(is, (int)size);
            return JSON.parse(buf, readOptions);
        }
        JSONReader jsonReader = new JSONReader(is);
        jsonReader.setOptions(readOptions);
        return jsonReader.read();
    }

    public static <T> T read(byte[] bytes, Class<T> actualType, ReadOption ... readOptions) {
        return (T)JSON.parse(null, bytes, actualType, null, readOptions);
    }

    public static <T> T read(InputStream is, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read(is, Integer.MAX_VALUE, actualType, readOptions);
    }

    private static <T> T read(InputStream is, long size, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        if (size <= 0L) {
            size = is.available();
        }
        if (size <= 8192L) {
            if (size == 0L) {
                return null;
            }
            char[] buf = JSON.readInputStream(is, (int)size);
            return (T)JSON.parse(buf, actualType, readOptions);
        }
        JSONReader jsonReader = new JSONReader(is);
        jsonReader.setOptions(readOptions);
        return jsonReader.readAsResult(GenericParameterizedType.actualType(actualType));
    }

    public static <T> T read(File file, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read((InputStream)new FileInputStream(file), Integer.MAX_VALUE, actualType, readOptions);
    }

    public static <T> T read(URL url, Class<T> actualType, ReadOption ... readOptions) throws IOException {
        return JSON.read(url, actualType, false, -1, readOptions);
    }

    public static <T> T read(URL url, Class<T> actualType, boolean forceStreamMode, int timeout, ReadOption ... readOptions) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (timeout > 0) {
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
        }
        conn.connect();
        return JSON.read(conn.getInputStream(), forceStreamMode ? Integer.MAX_VALUE : (long)conn.getContentLength(), actualType, readOptions);
    }

    public static <T> T read(File file, GenericParameterizedType<T> genericType, ReadOption ... readOptions) throws IOException {
        JSONReader jsonReader = JSONReader.from(file);
        jsonReader.setOptions(readOptions);
        return jsonReader.readAsResult(genericType);
    }

    public static <T> T read(InputStream is, GenericParameterizedType<T> genericType, ReadOption ... readOptions) throws IOException {
        JSONReader jsonReader = JSONReader.from(is);
        jsonReader.setOptions(readOptions);
        return jsonReader.readAsResult(genericType);
    }

    public static String toJsonString(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, new JSONConfig(), 0);
    }

    public static String toJsonString(Object obj, WriteOption ... options) {
        if (obj == null) {
            return null;
        }
        JSONConfig jsonConfig = new JSONConfig();
        JSONOptions.writeOptions(options, jsonConfig);
        return JSON.stringify(obj, jsonConfig, 0);
    }

    public static byte[] toJsonBytes(Object obj, WriteOption ... options) {
        return JSON.toJsonBytes(obj, Charset.defaultCharset(), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toJsonBytes(Object obj, Charset charset, WriteOption ... options) {
        if (obj == null) {
            return null;
        }
        JSONWriter stringWriter = JSONWriter.forBytesWriter(charset);
        try {
            JSON.writeToJSONWriter(obj, stringWriter, options);
            byte[] byArray = stringWriter.toBytes();
            return byArray;
        }
        finally {
            stringWriter.reset();
        }
    }

    public static String toJsonString(Object obj, JSONConfig jsonConfig) {
        if (obj == null) {
            return null;
        }
        return JSON.stringify(obj, jsonConfig, 0);
    }

    private static String stringify(Object obj, JSONConfig jsonConfig, int indentLevel) {
        JSONWriter content = JSONWriter.forStringWriter();
        try {
            JSON.stringify(obj, content, jsonConfig, indentLevel);
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            throw e instanceof JSONException ? (JSONException)e : new JSONException(e);
        }
        finally {
            content.reset();
            jsonConfig.clear();
        }
    }

    public static void writeJsonTo(Object object, File file, WriteOption ... options) {
        try {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            JSON.writeJsonTo(object, (OutputStream)new FileOutputStream(file), options);
        }
        catch (FileNotFoundException e) {
            throw new JSONException("file not found", e);
        }
    }

    public static void writeJsonTo(Object object, OutputStream os, WriteOption ... options) {
        JSON.writeJsonTo(object, os, Charset.defaultCharset(), options);
    }

    public static void writeJsonTo(Object object, OutputStream os, Charset charset, WriteOption ... options) {
        JSONWriter streamWriter = JSONWriter.forStreamWriter(charset);
        try {
            JSON.writeToJSONWriter(object, streamWriter, options);
            streamWriter.toOutputStream(os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            streamWriter.reset();
        }
    }

    static void writeToJSONWriter(Object object, JSONWriter writer, WriteOption ... options) {
        if (object != null) {
            JSONConfig jsonConfig = new JSONConfig();
            JSONOptions.writeOptions(options, jsonConfig);
            try {
                JSON.stringify(object, writer, jsonConfig, 0);
                writer.flush();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            finally {
                jsonConfig.clear();
                if (jsonConfig.isAutoCloseStream()) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void writeJsonTo(Object object, Writer writer, WriteOption ... options) {
        JSON.writeToJSONWriter(object, JSONWriter.wrap(writer), options);
    }

    static void stringify(Object obj, JSONWriter content, JSONConfig jsonConfig, int indentLevel) throws Exception {
        JSONTypeSerializer serializer = JSONTypeSerializer.getTypeSerializer(obj.getClass());
        serializer.serialize(obj, content, jsonConfig, indentLevel);
    }

    public static boolean validate(String json, ReadOption ... readOptions) {
        return JSON.validate(json, false, readOptions);
    }

    public static boolean validate(String json, boolean printIfException, ReadOption ... readOptions) {
        if (json == null) {
            return false;
        }
        return JSON.validate(JSON.getChars(json), printIfException, readOptions);
    }

    public static boolean validate(char[] buf, ReadOption ... readOptions) {
        return JSON.validate(buf, false, readOptions);
    }

    public static boolean validate(char[] buf, boolean printIfException, ReadOption ... readOptions) {
        JSONValidator jsonValidator = new JSONValidator(buf);
        boolean result = jsonValidator.validate(readOptions);
        if (printIfException) {
            // empty if block
        }
        return result;
    }

    public static String validateMessage(String json, ReadOption ... readOptions) {
        if (json == null) {
            return "Exception: java.lang.NullPointerException";
        }
        return JSON.validateMessage(JSON.getChars(json), readOptions);
    }

    public static String validateMessage(char[] buf, ReadOption ... readOptions) {
        JSONValidator jsonValidator = new JSONValidator(buf);
        jsonValidator.validate(true, readOptions);
        return jsonValidator.getValidateMessage();
    }

    public static synchronized void registerTypeDeserializer(Class<?> type, JSONTypeDeserializer typeDeserializer) {
        type.getClass();
        if (JSONTypeDeserializer.isBuiltInType(type)) {
            throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for " + type);
        }
        JSONTypeDeserializer.putTypeDeserializer(typeDeserializer, type);
    }

    public static synchronized void registerTypeSerializer(Class<?> type, JSONTypeSerializer typeSerializer) {
        type.getClass();
        if (JSONTypeSerializer.isBuiltInType(type)) {
            throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for " + type);
        }
        JSONTypeSerializer.putTypeSerializer(typeSerializer, type);
    }

    public static <T> void registerTypeMapper(Class<T> type, JSONTypeMapper<T> mapper) {
        JSON.registerTypeMapper(type, mapper, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void registerTypeMapper(Class<T> type, final JSONTypeMapper<T> mapper, boolean ignoreIfExist) {
        type.getClass();
        Class<T> clazz = type;
        synchronized (clazz) {
            if (JSONTypeDeserializer.isBuiltInType(type)) {
                if (!ignoreIfExist) {
                    throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for " + type);
                }
            } else {
                JSONTypeDeserializer.putTypeDeserializer(new JSONTypeDeserializer(){

                    @Override
                    protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
                        Object value = JSONTypeDeserializer.ANY.deserialize(charSource, buf, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
                        return mapper.read(value);
                    }

                    @Override
                    protected Object deserialize(CharSource charSource, byte[] bytes, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
                        Object value = JSONTypeDeserializer.ANY.deserialize(charSource, bytes, fromIndex, toIndex, parameterizedType, defaultValue, endToken, jsonParseContext);
                        return mapper.read(value);
                    }
                }, type);
            }
            if (JSONTypeSerializer.isBuiltInType(type)) {
                if (!ignoreIfExist) {
                    throw new UnsupportedOperationException("Existing built-in implementation, does not support overwrite for class " + type);
                }
            } else {
                JSONTypeSerializer.putTypeSerializer(new JSONTypeSerializer(){

                    @Override
                    protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
                        mapper.write(writer, value, jsonConfig, indent);
                    }
                }, type);
            }
        }
    }

    static abstract class Deserializer {
        Deserializer() {
        }

        Object deserialize(char[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            throw new UnsupportedOperationException();
        }

        Object deserialize(byte[] buf, int fromIndex, int toIndex, JSONParseContext jsonParseContext) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

