/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.IOUtils;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

class JSONCharArrayStreamWriter
extends JSONCharArrayWriter {
    protected final Charset charset;

    JSONCharArrayStreamWriter(Charset charset) {
        this.charset = charset == null ? Charset.defaultCharset() : charset;
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        String source;
        byte[] bytes;
        boolean isByteArrayOs = os.getClass() == ByteArrayOutputStream.class;
        boolean emptyByteArrayOs = false;
        if (isByteArrayOs) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)os;
            boolean bl = emptyByteArrayOs = byteArrayOutputStream.size() == 0;
        }
        if ((bytes = (byte[])UnsafeHelper.getStringValue(source = new String(this.buf, 0, this.count))).length == this.count) {
            if (emptyByteArrayOs) {
                UnsafeHelper.getUnsafe().putObject(os, UnsafeHelper.BAO_BUF_OFFSET, bytes);
                UnsafeHelper.getUnsafe().putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, this.count);
            } else {
                os.write(bytes, 0, this.count);
            }
        } else if (this.charset == EnvUtils.CHARSET_UTF_8) {
            byte[] output = new byte[this.count * 3];
            int length = IOUtils.encodeUTF8(this.buf, 0, this.count, output);
            if (emptyByteArrayOs) {
                UnsafeHelper.getUnsafe().putObject(os, UnsafeHelper.BAO_BUF_OFFSET, output);
                UnsafeHelper.getUnsafe().putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, length);
            } else {
                os.write(output, 0, length);
            }
        } else {
            bytes = source.getBytes(this.charset);
            if (emptyByteArrayOs) {
                UnsafeHelper.getUnsafe().putObject(os, UnsafeHelper.BAO_BUF_OFFSET, bytes);
                UnsafeHelper.getUnsafe().putInt(os, UnsafeHelper.BAO_COUNT_OFFSET, bytes.length);
            } else {
                os.write(bytes);
            }
        }
        os.flush();
    }
}

