/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.IOUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;

class JSONCharArrayWriter
extends JSONWriter {
    char[] buf;
    int count;
    static final char[] EMPTY_BUF = new char[0];
    private static final CharBufCache[] CHAR_BUF_CACHES = new CharBufCache[CACHE_COUNT];
    private CharBufCache charBufCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharBufCache getCharBufCache() {
        CharBufCache cache;
        int cacheIndex = (Integer)THREAD_CACHE_INDEX.get();
        CharBufCache charBufCache = cache = CHAR_BUF_CACHES[cacheIndex];
        synchronized (charBufCache) {
            if (cache.inUse) {
                return null;
            }
            cache.inUse = true;
            if (cache.cacheChars == null) {
                cache.cacheChars = new char[CACHE_BUFFER_SIZE];
            }
        }
        return cache;
    }

    void setCharAt(int index, char c) {
        this.buf[index] = c;
    }

    protected char[] toChars() {
        return Arrays.copyOf(this.buf, this.count);
    }

    JSONCharArrayWriter() {
        CharBufCache charBufCache = JSONCharArrayWriter.getCharBufCache();
        if (charBufCache != null) {
            this.buf = charBufCache.cacheChars;
            this.charBufCache = charBufCache;
        } else {
            this.buf = new char[512];
        }
    }

    @Override
    public void write(int c) {
        this.ensureCapacity(129);
        this.buf[this.count++] = (char)c;
    }

    @Override
    public void writeJSONToken(char c) {
        this.buf[this.count++] = c;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count += len;
    }

    char[] ensureCapacity(int increment) {
        return this.expandCapacity(this.count + increment);
    }

    char[] expandCapacity(int newCap) {
        if (newCap > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, newCap * 3 >> 1);
        }
        return this.buf;
    }

    void writeBytes(byte[] bytes, int offset, int len) {
        if (len == 0) {
            return;
        }
        String str = new String(bytes, offset, len);
        len = str.length();
        this.ensureCapacity(len);
        str.getChars(0, len, this.buf, this.count);
        this.count += len;
    }

    @Override
    public void write(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len + 128);
        str.getChars(off, off + len, this.buf, this.count);
        this.count += len;
    }

    @Override
    public void writeFieldString(String value, int offset, int len) throws IOException {
        if (len >= 128) {
            this.ensureCapacity(len + 128);
        }
        value.getChars(offset, offset + len, this.buf, this.count);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected StringBuffer toStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append(this.buf, 0, this.count);
        return stringBuffer;
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(this.count);
        stringBuilder.append(this.buf, 0, this.count);
        return stringBuilder;
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] toBytes(Charset charset) {
        String source = new String(this.buf, 0, this.count);
        byte[] bytes = (byte[])UnsafeHelper.getStringValue(source);
        if (bytes.length == this.count) {
            return bytes;
        }
        if (charset == EnvUtils.CHARSET_UTF_8) {
            byte[] output = new byte[this.count * 3];
            int length = IOUtils.encodeUTF8(this.buf, 0, this.count, output);
            return Arrays.copyOf(output, length);
        }
        bytes = source.getBytes(charset);
        return bytes;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    public final void writeShortChars(char[] chars, int offset, int len) {
        this.ensureCapacity(len + 128);
        int count = this.count;
        for (int i = 0; i < len; ++i) {
            this.buf[count++] = chars[offset++];
        }
        this.count = count;
    }

    final void writeShortJSONChars(char[] chars) {
        int len = chars.length;
        this.ensureCapacity(len + 130);
        int count = this.count;
        this.buf[count++] = 34;
        for (char ch : chars) {
            String escapeStr;
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) {
                this.buf[count++] = ch;
                continue;
            }
            int escapesLen = escapeStr.length();
            this.ensureCapacity(escapesLen + 128);
            for (int j = 0; j < escapesLen; ++j) {
                this.buf[count++] = escapeStr.charAt(j);
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeLong(long numValue) throws IOException {
        if (numValue == 0L) {
            this.ensureCapacity(129);
            this.buf[this.count++] = 48;
            return;
        }
        this.ensureCapacity(148);
        if (numValue < 0L) {
            if (numValue == Long.MIN_VALUE) {
                this.write("-9223372036854775808");
                return;
            }
            numValue = -numValue;
            this.buf[this.count++] = 45;
        }
        this.count += NumberUtils.writePositiveLong(numValue, this.buf, this.count);
    }

    @Override
    public void writeUUID(UUID uuid) {
        long mostSigBits = uuid.getMostSignificantBits();
        long leastSigBits = uuid.getLeastSignificantBits();
        this.ensureCapacity(166);
        int off = this.count;
        this.buf[off++] = 34;
        off += NumberUtils.writeUUIDMostSignificantBits(mostSigBits, this.buf, off);
        off += NumberUtils.writeUUIDLeastSignificantBits(leastSigBits, this.buf, off);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeDouble(double numValue) {
        this.ensureCapacity(152);
        this.count += NumberUtils.writeDouble(numValue, this.buf, this.count);
    }

    @Override
    public void writeFloat(float numValue) {
        this.ensureCapacity(152);
        this.count += NumberUtils.writeFloat(numValue, this.buf, this.count);
    }

    @Override
    public void writeJSONLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nano, String zoneId) throws IOException {
        this.ensureCapacity(164);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += NumberUtils.writeFourDigits(year, this.buf, off)) : (off += NumberUtils.writePositiveLong((long)year, this.buf, off));
        off += NumberUtils.writeTwoDigitsAndPreSuffix(month, '-', '-', this.buf, off);
        off += NumberUtils.writeTwoDigits(day, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(hour, 'T', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(minute, this.buf, off);
        this.buf[off++] = 58;
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        if (nano > 0) {
            nano += 1000000000;
            while (nano % 1000 == 0) {
                nano /= 1000;
            }
            int pointIndex = off;
            off += NumberUtils.writePositiveLong((long)nano, this.buf, off);
            this.buf[pointIndex] = 46;
        }
        this.count = off;
        this.writeZoneId(zoneId);
        this.buf[this.count++] = 34;
    }

    @Override
    public void writeJSONLocalDate(int year, int month, int day) {
        this.ensureCapacity(141);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += NumberUtils.writeFourDigits(year, this.buf, off)) : (off += NumberUtils.writePositiveLong((long)year, this.buf, off));
        off += NumberUtils.writeTwoDigitsAndPreSuffix(month, '-', '-', this.buf, off);
        off += NumberUtils.writeTwoDigits(day, this.buf, off);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeTime(int hourOfDay, int minute, int second) {
        this.ensureCapacity(138);
        int off = this.count;
        off += NumberUtils.writeTwoDigits(hourOfDay, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(minute, ':', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        this.count = off;
    }

    @Override
    public void writeJSONTimeWithNano(int hourOfDay, int minute, int second, int nano) {
        this.ensureCapacity(150);
        int off = this.count;
        this.buf[off++] = 34;
        off += NumberUtils.writeTwoDigits(hourOfDay, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(minute, ':', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        if (nano > 0) {
            nano += 1000000000;
            while (nano % 1000 == 0) {
                nano /= 1000;
            }
            int pointIndex = off;
            off += NumberUtils.writePositiveLong((long)nano, this.buf, off);
            this.buf[pointIndex] = 46;
        }
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.ensureCapacity(152);
        int off = this.count;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off = year < 10000 ? (off += NumberUtils.writeFourDigits(year, this.buf, off)) : (off += NumberUtils.writePositiveLong((long)year, this.buf, off));
        off += NumberUtils.writeTwoDigitsAndPreSuffix(month, '-', '-', this.buf, off);
        off += NumberUtils.writeTwoDigits(day, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(hourOfDay, ' ', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(minute, this.buf, off);
        this.buf[off++] = 58;
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        this.count = off;
    }

    @Override
    public void writeBigInteger(BigInteger bigInteger) {
        int increment = (bigInteger.bitLength() / 60 + 1) * 18;
        this.ensureCapacity(increment + 128);
        this.count += NumberUtils.writeBigInteger(bigInteger, this.buf, this.count);
    }

    @Override
    public void writeJSONChars(char[] chars) throws IOException {
        int len = chars.length;
        if (len <= 64) {
            this.writeShortJSONChars(chars);
        } else {
            this.ensureCapacity(len + 130);
            int count = this.count;
            int beginIndex = 0;
            this.buf[count++] = 34;
            for (int i = 0; i < len; ++i) {
                String escapeStr;
                char ch = chars[i];
                if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) continue;
                int length = i - beginIndex;
                this.expandCapacity(length + count + 133);
                if (length > 0) {
                    System.arraycopy(chars, beginIndex, this.buf, count, length);
                    count += length;
                }
                int escapesLen = escapeStr.length();
                escapeStr.getChars(0, escapesLen, this.buf, count);
                count += escapesLen;
                beginIndex = i + 1;
            }
            int length = len - beginIndex;
            System.arraycopy(chars, beginIndex, this.buf, count, length);
            count += length;
            this.buf[count++] = 34;
            this.count = count;
        }
    }

    @Override
    public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
        int len = bytes.length;
        this.ensureCapacity(len + 130);
        int count = this.count;
        this.buf[count++] = 34;
        int beginIndex = 0;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            String escapeStr = JSONGeneral.ESCAPE_VALUES[b & 0xFF];
            if (escapeStr == null) continue;
            int length = i - beginIndex;
            this.expandCapacity(length + count + 8);
            if (length > 0) {
                value.getChars(beginIndex, i, this.buf, count);
                count += length;
            }
            int escapesLen = escapeStr.length();
            escapeStr.getChars(0, escapesLen, this.buf, count);
            count += escapesLen;
            beginIndex = i + 1;
        }
        int length = len - beginIndex;
        if (length > 0) {
            value.getChars(beginIndex, len, this.buf, count);
            count += length;
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeUnsafe(long fourChars, int fourBytes, int len) throws IOException {
        UnsafeHelper.putLong(this.buf, this.count, fourChars);
        this.count += len;
    }

    @Override
    public void writeUnsafe(long[] fourChars, int[] fourBytes, int totalCount) throws IOException {
        int n = fourChars.length;
        this.ensureCapacity((n << 2) + 128);
        int count = this.count;
        for (long fourChar : fourChars) {
            UnsafeHelper.putLong(this.buf, count, fourChar);
            count += 4;
        }
        this.count += totalCount;
    }

    void clearCache() {
        if (this.charBufCache != null) {
            if (this.buf.length <= MAX_CACHE_BUFFER_SIZE) {
                this.charBufCache.cacheChars = this.buf;
            }
            this.charBufCache.inUse = false;
            this.charBufCache = null;
        }
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    @Override
    void reset() {
        this.clear();
        this.clearCache();
        this.buf = EMPTY_BUF;
    }

    static {
        for (int i = 0; i < CACHE_COUNT; ++i) {
            CharBufCache charBufCache = new CharBufCache();
            charBufCache.index = i;
            if (i < AVAILABLE_PROCESSORS) {
                charBufCache.cacheChars = new char[CACHE_BUFFER_SIZE];
            }
            JSONCharArrayWriter.CHAR_BUF_CACHES[i] = charBufCache;
        }
    }

    private static class CharBufCache {
        char[] cacheChars;
        boolean inUse;
        int index;

        private CharBufCache() {
        }
    }
}

