/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.AsciiStringSource;
import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.UTF16ByteArraySource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JSONDefaultParser
extends JSONGeneral {
    public static Object parse(String json, ReadOption ... readOptions) {
        json.getClass();
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
            if (bytes.length == json.length()) {
                return JSONDefaultParser.parse((CharSource)AsciiStringSource.of(json, bytes), bytes, null, readOptions);
            }
            char[] chars = json.toCharArray();
            return JSONDefaultParser.parse((CharSource)UTF16ByteArraySource.of(json), chars, null, readOptions);
        }
        return JSONDefaultParser.parse(JSONDefaultParser.getChars(json), readOptions);
    }

    public static Object parse(char[] buf, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(null, buf, null, readOptions);
    }

    static Map parseMap(String json, Class<? extends Map> mapCls, ReadOption ... readOptions) {
        json.getClass();
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
            if (bytes.length == json.length()) {
                return (Map)JSONDefaultParser.parse((CharSource)AsciiStringSource.of(json, bytes), bytes, (Object)JSONDefaultParser.createMapInstance(mapCls), readOptions);
            }
            char[] chars = json.toCharArray();
            return (Map)JSONDefaultParser.parse((CharSource)UTF16ByteArraySource.of(json), chars, (Object)JSONDefaultParser.createMapInstance(mapCls), readOptions);
        }
        return (Map)JSONDefaultParser.parse(JSONDefaultParser.getChars(json), JSONDefaultParser.createMapInstance(mapCls), readOptions);
    }

    static Collection parseCollection(String json, Class<? extends Collection> listCls, ReadOption ... readOptions) {
        json.getClass();
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(json);
            if (bytes.length == json.length()) {
                return (Collection)JSONDefaultParser.parse((CharSource)AsciiStringSource.of(json, bytes), bytes, (Object)JSONDefaultParser.createCollectionInstance(listCls), readOptions);
            }
            char[] chars = json.toCharArray();
            return (Collection)JSONDefaultParser.parse((CharSource)UTF16ByteArraySource.of(json), chars, (Object)JSONDefaultParser.createCollectionInstance(listCls), readOptions);
        }
        return (Collection)JSONDefaultParser.parse(JSONDefaultParser.getChars(json), JSONDefaultParser.createCollectionInstance(listCls), readOptions);
    }

    static Object parse(char[] buf, Object defaultValue, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(null, buf, defaultValue, readOptions);
    }

    static Object parse(CharSource source, char[] buf, Object defaultValue, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(source, buf, 0, buf.length, defaultValue, readOptions);
    }

    static Object parse(CharSource source, char[] buf, int fromIndex, int toIndex, Object defaultValue, ReadOption ... readOptions) {
        char beginChar = '\u0000';
        while (fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' ') {
            ++fromIndex;
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, jsonParseContext);
        try {
            Object result;
            boolean allowComment = jsonParseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, jsonParseContext);
                beginChar = buf[fromIndex];
            }
            switch (beginChar) {
                case '{': {
                    result = JSONDefaultParser.parseJSONObject(source, buf, fromIndex, toIndex, defaultValue == null ? new LinkedHashMap() : (Map)defaultValue, jsonParseContext);
                    break;
                }
                case '[': {
                    result = JSONDefaultParser.parseJSONArray(source, buf, fromIndex, toIndex, defaultValue == null ? new ArrayList(10) : (Collection)defaultValue, jsonParseContext);
                    break;
                }
                case '\"': 
                case '\'': {
                    result = JSONDefaultParser.parseJSONString(source, buf, fromIndex, toIndex, beginChar, jsonParseContext);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginChar + "'");
                }
            }
            int endIndex = jsonParseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex && (commentStart = buf[++endIndex]) <= 32) {
                }
                if (commentStart == 47) {
                    endIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(buf, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSONDefaultParser.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            jsonParseContext.clear();
        }
    }

    static Collection parseJSONArray(CharSource source, char[] buf, int fromIndex, int toIndex, Collection list, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        int i = fromIndex;
        block8: while (true) {
            if ((ch = buf[++i]) <= ' ') {
                continue;
            }
            if (jsonParseContext.allowComment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            if (ch == ']') {
                if (list.size() > 0) {
                    throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                }
                jsonParseContext.endIndex = i;
                return list;
            }
            switch (ch) {
                case '{': {
                    Object value = JSONDefaultParser.parseJSONObject(source, buf, i, toIndex, new LinkedHashMap(), jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case '[': {
                    Object value = JSONDefaultParser.parseJSONArray(source, buf, i, toIndex, new ArrayList(10), jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case '\"': 
                case '\'': {
                    Object value = JSONDefaultParser.parseJSONString(source, buf, i, toIndex, ch, jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 'n': {
                    Object value = JSONTypeDeserializer.NULL.deserialize(null, buf, i, toIndex, null, null, '\u0000', jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 't': {
                    Object value = JSONTypeDeserializer.BOOLEAN.deserializeTrue(buf, i, toIndex, null, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 'f': {
                    Object value = JSONTypeDeserializer.BOOLEAN.deserializeFalse(buf, i, toIndex, null, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                default: {
                    char next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, buf, i, toIndex, jsonParseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, ']', jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    if ((next = buf[++i]) != ']') continue block8;
                    jsonParseContext.endIndex = i;
                    return list;
                }
            }
            while ((ch = buf[++i]) <= ' ') {
            }
            if (jsonParseContext.allowComment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            if (ch != ',') break;
        }
        if (ch == ']') {
            jsonParseContext.endIndex = i;
            return list;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or ']'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map parseJSONObject(CharSource source, char[] buf, int fromIndex, int toIndex, Map instance, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        int i = fromIndex;
        boolean empty = true;
        boolean allowomment = jsonParseContext.allowComment;
        boolean disableCacheMapKey = jsonParseContext.disableCacheMapKey;
        block8: while (true) {
            String key;
            if ((ch = buf[++i]) <= ' ') {
                continue;
            }
            if (allowomment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            int fieldKeyFrom = i;
            if (ch == '\"') {
                key = disableCacheMapKey ? JSONDefaultParser.parseJSONString(source, buf, i, toIndex, '\"', jsonParseContext) : JSONDefaultParser.parseMapKeyByCache(buf, i, toIndex, '\"', jsonParseContext);
                i = jsonParseContext.endIndex;
                empty = false;
                ++i;
            } else {
                if (ch == '}') {
                    if (!empty) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return instance;
                }
                if (ch == '\'') {
                    if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                    while (i + 1 < toIndex && (buf[++i] != '\'' || buf[i - 1] == '\\')) {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, ++i, false);
                } else if (jsonParseContext.allowUnquotedFieldNames) {
                    while (i + 1 < toIndex && buf[++i] != ':') {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, i, true);
                    if (key.equals("null")) {
                        key = null;
                    }
                } else {
                    int j = i++;
                    boolean isNullKey = false;
                    key = null;
                    if (ch == 'n' && buf[i] == 'u' && buf[++i] == 'l' && buf[++i] == 'l') {
                        isNullKey = true;
                        ++i;
                    }
                    if (!isNullKey) {
                        String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, j);
                        throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                    }
                }
            }
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowomment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            if (ch != ':') throw new JSONException("Syntax error, at pos " + i + ", unexpected '" + ch + "', token ':' is expected.");
            while ((ch = buf[++i]) <= ' ') {
            }
            if (jsonParseContext.allowComment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            switch (ch) {
                case '{': {
                    Object value = JSONDefaultParser.parseJSONObject(source, buf, i, toIndex, new LinkedHashMap(), jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case '[': {
                    Object value = JSONDefaultParser.parseJSONArray(source, buf, i, toIndex, new ArrayList(10), jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case '\"': 
                case '\'': {
                    Object value = JSONDefaultParser.parseJSONString(source, buf, i, toIndex, ch, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 'n': {
                    Object value = JSONTypeDeserializer.NULL.deserialize(null, buf, i, toIndex, null, null, '\u0000', jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 't': {
                    Object value = JSONTypeDeserializer.BOOLEAN.deserializeTrue(buf, i, toIndex, null, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 'f': {
                    Object value = JSONTypeDeserializer.BOOLEAN.deserializeFalse(buf, i, toIndex, null, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                default: {
                    char next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, buf, i, toIndex, jsonParseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, '}', jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    if ((next = buf[++i]) != '}') continue block8;
                    jsonParseContext.endIndex = i;
                    return instance;
                }
            }
            while ((ch = buf[++i]) <= ' ') {
            }
            if (allowomment && ch == '/') {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                ch = buf[i];
            }
            if (ch != ',') break;
        }
        if (ch == '}') {
            jsonParseContext.endIndex = i;
            return instance;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
    }

    static String parseJSONString(CharSource charSource, char[] buf, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int beginIndex = from + 1;
        JSONCharArrayWriter writer = null;
        if (charSource != null) {
            int endIndex;
            String source = charSource.input();
            if (!jsonParseContext.checkEscapeUseChar(source, beginIndex, endIndex = source.indexOf(endCh, beginIndex))) {
                jsonParseContext.endIndex = endIndex;
                return new String(buf, beginIndex, endIndex - beginIndex);
            }
            writer = JSONDefaultParser.getContextWriter(jsonParseContext);
            do {
                int escapeIndex;
                if ((beginIndex = JSONDefaultParser.escapeNext(buf, buf[(escapeIndex = jsonParseContext.getEscapeOffset()) + 1], escapeIndex, beginIndex, writer, jsonParseContext)) <= endIndex) continue;
                endIndex = source.indexOf(endCh, endIndex + 1);
            } while (jsonParseContext.checkEscapeUseChar(source, beginIndex, endIndex));
            jsonParseContext.endIndex = endIndex;
            writer.write(charSource.input(), beginIndex, endIndex - beginIndex);
            return writer.toString();
        }
        int i = beginIndex;
        boolean escape = false;
        while (true) {
            char next;
            char ch;
            if ((ch = buf[i]) != '\\' && ch != endCh) {
                ++i;
                continue;
            }
            if (ch == '\\') {
                next = buf[i + 1];
                if (writer == null) {
                    writer = JSONDefaultParser.getContextWriter(jsonParseContext);
                    escape = true;
                }
            } else {
                jsonParseContext.endIndex = i;
                int len = i - beginIndex;
                if (escape) {
                    writer.write(buf, beginIndex, len);
                    return writer.toString();
                }
                return new String(buf, beginIndex, len);
            }
            beginIndex = JSONDefaultParser.escapeNext(buf, next, i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.endIndex;
            ++i;
        }
    }

    static String parseMapKeyByCache(char[] buf, int from, int toIndex, char endCh, JSONParseContext jsonParseContext) {
        int hashValue;
        int beginIndex = from + 1;
        int i = from;
        JSONCharArrayWriter writer = null;
        boolean escape = false;
        while (true) {
            char ch;
            boolean flag;
            hashValue = 0;
            char ch1 = '\u0000';
            while (true) {
                boolean bl = flag = (ch = buf[++i]) != '\\' && ch != endCh;
                if (!bl || (ch1 = buf[++i]) == '\\' || ch1 == endCh) break;
                hashValue = (hashValue << 2) + (ch << 1) + ch1;
            }
            if (flag) {
                hashValue = (hashValue << 1) + ch;
                ch = ch1;
            }
            if (ch != '\\') break;
            if (writer == null) {
                writer = JSONDefaultParser.getContextWriter(jsonParseContext);
            }
            escape = true;
            beginIndex = JSONDefaultParser.escapeNext(buf, buf[i + 1], i, beginIndex, writer, jsonParseContext);
            i = jsonParseContext.endIndex;
        }
        jsonParseContext.endIndex = i;
        int len = i - beginIndex;
        if (escape) {
            writer.write(buf, beginIndex, len);
            return writer.toString();
        }
        if (len > 32) {
            return new String(buf, beginIndex, len);
        }
        return len == 0 ? "" : jsonParseContext.getCacheKey(buf, beginIndex, len, (long)hashValue);
    }

    static String parseKeyOfMap(char[] buf, int from, int to, boolean isUnquotedFieldName) {
        if (isUnquotedFieldName) {
            while (from < to && buf[from] <= ' ') {
                ++from;
            }
            while (to > from && buf[to - 1] <= ' ') {
                --to;
            }
            return new String(buf, from, to - from);
        }
        int len = to - from - 2;
        return new String(buf, from + 1, len);
    }

    public static Object parse(byte[] bytes, ReadOption ... readOptions) {
        return JSONDefaultParser.parse(null, bytes, null, readOptions);
    }

    static Object parse(CharSource source, byte[] bytes, Object defaultValue, ReadOption ... readOptions) {
        bytes.getClass();
        return JSONDefaultParser.parse(source, bytes, 0, bytes.length, defaultValue, readOptions);
    }

    static Object parse(CharSource source, byte[] bytes, int fromIndex, int toIndex, Object defaultValue, ReadOption ... readOptions) {
        byte beginByte = 0;
        while (fromIndex < toIndex && (beginByte = bytes[fromIndex]) <= 32) {
            ++fromIndex;
        }
        while (toIndex > fromIndex && bytes[toIndex - 1] <= 32) {
            --toIndex;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        JSONOptions.readOptions(readOptions, jsonParseContext);
        try {
            Object result;
            boolean allowComment = jsonParseContext.allowComment;
            if (allowComment && beginByte == 47) {
                fromIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, fromIndex + 1, toIndex, jsonParseContext);
                beginByte = bytes[fromIndex];
            }
            switch (beginByte) {
                case 123: {
                    result = JSONDefaultParser.parseJSONObject(source, bytes, fromIndex, toIndex, defaultValue == null ? new LinkedHashMap() : (Map)defaultValue, jsonParseContext);
                    break;
                }
                case 91: {
                    result = JSONDefaultParser.parseJSONArray(source, bytes, fromIndex, toIndex, defaultValue == null ? new ArrayList() : (Collection)defaultValue, jsonParseContext);
                    break;
                }
                case 34: 
                case 39: {
                    result = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, bytes, fromIndex, toIndex, beginByte, GenericParameterizedType.StringType, jsonParseContext);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginByte + "'");
                }
            }
            int endIndex = jsonParseContext.endIndex;
            if (allowComment && endIndex < toIndex - 1) {
                int commentStart = 0;
                while (endIndex + 1 < toIndex) {
                    char c = (char)bytes[++endIndex];
                    commentStart = c;
                    if (c <= ' ') continue;
                }
                if (commentStart == 47) {
                    endIndex = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, endIndex + 1, toIndex, jsonParseContext);
                }
            }
            if (endIndex != toIndex - 1) {
                int wordNum = Math.min(50, bytes.length - endIndex - 1);
                String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, endIndex + 1);
                throw new JSONException("Syntax error, at pos " + endIndex + ", context text by '" + errorContextTextAt + "', extra characters found, '" + new String(bytes, endIndex + 1, wordNum) + " ...'");
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            JSONDefaultParser.handleCatchException((Throwable)ex, bytes, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
        finally {
            jsonParseContext.clear();
        }
    }

    static Collection parseJSONArray(CharSource source, byte[] bytes, int fromIndex, int toIndex, Collection list, JSONParseContext jsonParseContext) throws Exception {
        byte b;
        int i = fromIndex;
        block8: while (true) {
            if ((b = bytes[++i]) <= 32) {
                continue;
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
                b = bytes[i];
            }
            if (b == 93) {
                if (list.size() > 0) {
                    throw new JSONException("Syntax error, at pos " + i + ", the closing symbol ']' is not allowed here.");
                }
                jsonParseContext.endIndex = i;
                return list;
            }
            switch (b) {
                case 123: {
                    Object value = JSONDefaultParser.parseJSONObject(source, bytes, i, toIndex, new LinkedHashMap(), jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 91: {
                    Object value = JSONDefaultParser.parseJSONArray(source, bytes, i, toIndex, new ArrayList(), jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 34: 
                case 39: {
                    Object value = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, bytes, i, toIndex, b, GenericParameterizedType.StringType, jsonParseContext);
                    list.add(value);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 110: {
                    Object value = JSONTypeDeserializer.parseNull(bytes, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 116: {
                    Object value = JSONTypeDeserializer.parseTrue(bytes, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                case 102: {
                    Object value = JSONTypeDeserializer.parseFalse(bytes, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    break;
                }
                default: {
                    byte next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, bytes, i, toIndex, jsonParseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, (byte)93, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    list.add(value);
                    if ((next = bytes[++i]) != 93) continue block8;
                    jsonParseContext.endIndex = i;
                    return list;
                }
            }
            while ((b = bytes[++i]) <= 32) {
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
                b = bytes[i];
            }
            if (b != 44) break;
        }
        if (b == 93) {
            jsonParseContext.endIndex = i;
            return list;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + b + "', expected ',' or ']'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map parseJSONObject(CharSource source, byte[] bytes, int fromIndex, int toIndex, Map instance, JSONParseContext jsonParseContext) throws Exception {
        byte b;
        boolean empty = true;
        boolean allowomment = jsonParseContext.allowComment;
        boolean disableCacheMapKey = jsonParseContext.disableCacheMapKey;
        int i = fromIndex;
        block8: while (true) {
            String key;
            if ((b = bytes[++i]) <= 32) {
                continue;
            }
            if (allowomment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
                b = bytes[i];
            }
            int fieldKeyFrom = i;
            if (b == 34) {
                key = disableCacheMapKey ? JSONTypeDeserializer.parseMapKey(bytes, i, toIndex, '\"', jsonParseContext) : JSONTypeDeserializer.parseMapKeyByCache(bytes, i, toIndex, '\"', jsonParseContext);
                i = jsonParseContext.endIndex;
                empty = false;
                ++i;
            } else {
                if (b == 125) {
                    if (!empty) {
                        throw new JSONException("Syntax error, at pos " + i + ", the closing symbol '}' is not allowed here.");
                    }
                    jsonParseContext.endIndex = i;
                    return instance;
                }
                if (b == 39) {
                    if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, at pos " + i + ", the single quote symbol ' is not allowed here.");
                    while (i + 1 < toIndex && (bytes[++i] != 39 || bytes[i - 1] == 92)) {
                    }
                    empty = false;
                    key = JSONTypeDeserializer.parseKeyOfMap(bytes, fieldKeyFrom, ++i, false);
                } else if (jsonParseContext.allowUnquotedFieldNames) {
                    while (i + 1 < toIndex && bytes[++i] != 58) {
                    }
                    empty = false;
                    key = JSONTypeDeserializer.parseKeyOfMap(bytes, fieldKeyFrom, i, true);
                    if (key.equals("null")) {
                        key = null;
                    }
                } else {
                    int j = i++;
                    boolean isNullKey = false;
                    key = null;
                    if (b == 110 && bytes[i] == 117 && bytes[++i] == 108 && bytes[++i] == 108) {
                        isNullKey = true;
                        ++i;
                    }
                    if (!isNullKey) {
                        String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, j);
                        throw new JSONException("Syntax error, at pos " + j + ", context text by '" + errorContextTextAt + "', unexpected '" + b + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                    }
                }
            }
            while ((b = bytes[i]) <= 32) {
                ++i;
            }
            if (allowomment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
                b = bytes[i];
            }
            if (b != 58) throw new JSONException("Syntax error, at pos " + i + ", unexpected '" + (char)b + "', colon ':' is expected.");
            while ((b = bytes[++i]) <= 32) {
            }
            if (jsonParseContext.allowComment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
                b = bytes[i];
            }
            switch (b) {
                case 123: {
                    Object value = JSONDefaultParser.parseJSONObject(source, bytes, i, toIndex, new LinkedHashMap(), jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 91: {
                    Object value = JSONDefaultParser.parseJSONArray(source, bytes, i, toIndex, new ArrayList(), jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 34: 
                case 39: {
                    Object value = JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(source, bytes, i, toIndex, b, GenericParameterizedType.StringType, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 110: {
                    Object value = JSONTypeDeserializer.parseNull(bytes, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 116: {
                    Object value = JSONTypeDeserializer.parseTrue(bytes, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                case 102: {
                    Object value = JSONTypeDeserializer.parseFalse(bytes, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    break;
                }
                default: {
                    byte next;
                    Object value = JSONTypeDeserializer.NUMBER.deserialize(source, bytes, i, toIndex, jsonParseContext.useBigDecimalAsDefault ? GenericParameterizedType.BigDecimalType : GenericParameterizedType.AnyType, null, (byte)125, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    instance.put(key, value);
                    if ((next = bytes[++i]) != 125) continue block8;
                    jsonParseContext.endIndex = i;
                    return instance;
                }
            }
            while ((b = bytes[++i]) <= 32) {
            }
            if (allowomment && b == 47) {
                i = JSONDefaultParser.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
                b = bytes[i];
            }
            if (b != 44) break;
        }
        if (b == 125) {
            jsonParseContext.endIndex = i;
            return instance;
        }
        String errorContextTextAt = JSONDefaultParser.createErrorContextText(bytes, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)b + "', expected ',' or '}'");
    }
}

