/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.tools.Base64;
import io.github.wycst.wast.json.JSONDefaultParser;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONNodeContext;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONPojoFieldDeserializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class JSONNode
extends JSONGeneral
implements Comparable<JSONNode> {
    private JSONNode root;
    private final JSONNodeContext parseContext;
    private JSONNode parent;
    private final char[] buf;
    private int beginIndex;
    private int endIndex;
    private String text;
    private int offset;
    private boolean completed;
    private Map<Serializable, JSONNode> fieldValues;
    private JSONNode[] elementValues;
    private int length;
    private int type;
    public static final int OBJECT = 1;
    public static final int ARRAY = 2;
    public static final int STRING = 3;
    public static final int NUMBER = 4;
    public static final int BOOLEAN = 5;
    public static final int NULL = 6;
    private final boolean isArray;
    private final boolean leaf;
    private Serializable leafValue;
    private boolean changed;

    JSONNode(char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
        this.buf = buf;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.parseContext = parseContext;
        this.root = this;
        this.init();
        this.leaf = this.type > 2;
        this.isArray = this.type == 2;
        this.offset = this.beginIndex;
    }

    JSONNode(List<JSONNode> elementValues, char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
        this.length = elementValues.size();
        this.elementValues = elementValues.toArray(new JSONNode[this.length]);
        this.completed = true;
        this.isArray = true;
        this.leaf = false;
        this.type = 2;
        this.parseContext = parseContext;
        this.buf = buf;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.root = this;
    }

    JSONNode(Map<Serializable, JSONNode> fieldValues, char[] buf, int beginIndex, int endIndex, JSONNodeContext parseContext) {
        this.fieldValues = fieldValues;
        this.completed = true;
        this.isArray = false;
        this.leaf = false;
        this.type = 1;
        this.parseContext = parseContext;
        this.buf = buf;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.root = this;
    }

    JSONNode(Serializable leafValue, char[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext) {
        this.leafValue = leafValue;
        this.completed = true;
        this.isArray = false;
        this.leaf = true;
        this.parseContext = parseContext;
        this.buf = buf;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.type = type;
    }

    private JSONNode(char[] buf, int beginIndex, int endIndex, int type, JSONNodeContext parseContext, JSONNode rootNode) {
        this.buf = buf;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.parseContext = parseContext;
        this.root = rootNode;
        this.type = type;
        this.leaf = type > 2;
        this.isArray = type == 2;
        this.offset = this.beginIndex;
    }

    public static JSONNode parse(String source, ReadOption ... readOptions) {
        return JSONNode.parse(source, null, readOptions);
    }

    public static JSONNode parse(String source, boolean reverseParseNode, ReadOption ... readOptions) {
        return JSONNode.parse(source, null, reverseParseNode, readOptions);
    }

    public static JSONNode parse(String source, String path, ReadOption ... readOptions) {
        return JSONNode.parse(source, path, false, readOptions);
    }

    public static JSONNode from(String source, String path, ReadOption ... readOptions) {
        return JSONNode.from(source, path, false, readOptions);
    }

    public static JSONNode from(String source, String path, boolean lazy, ReadOption ... readOptions) {
        return JSONNode.from(JSONNode.getChars(source), path, lazy, readOptions);
    }

    public static JSONNode from(char[] buf, String path, ReadOption ... readOptions) {
        return JSONNode.from(buf, path, false, readOptions);
    }

    public static JSONNode from(char[] buf, String path, boolean lazy, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.lazy = lazy;
        int toIndex = buf.length;
        if (path == null || (path = path.trim()).length() == 0) {
            return new JSONNode(buf, 0, toIndex, parseContext);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return JSONNode.parseNode(buf, path, false, parseContext);
    }

    public static List extract(String json, String path, ReadOption ... readOptions) {
        return JSONNode.extract(JSONNode.getChars(json), path, readOptions);
    }

    public static List extract(char[] buf, String path, ReadOption ... readOptions) {
        JSONNodeContext parseContext = new JSONNodeContext();
        JSONOptions.readOptions(readOptions, parseContext);
        parseContext.extract = true;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        JSONNode.parseNode(buf, path, false, parseContext);
        return parseContext.getExtractValues();
    }

    private static JSONNode parseNode(char[] buf, String path, boolean skipValue, JSONNodeContext parseContext) {
        int toIndex = buf.length;
        try {
            int endIndex;
            JSONNode result;
            int fromIndex;
            char beginChar = '\u0000';
            for (fromIndex = 0; fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' '; ++fromIndex) {
            }
            while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
                --toIndex;
            }
            boolean allowComment = parseContext.allowComment;
            if (allowComment && beginChar == '/') {
                fromIndex = JSONNode.clearCommentAndWhiteSpaces(buf, fromIndex + 1, toIndex, (JSONParseContext)parseContext);
                beginChar = buf[fromIndex];
            }
            switch (beginChar) {
                case '{': {
                    result = JSONNode.parseObjectPathNode(buf, fromIndex, toIndex, path, 0, skipValue, true, parseContext);
                    break;
                }
                case '[': {
                    result = JSONNode.parseArrayPathNode(buf, fromIndex, toIndex, path, 0, skipValue, true, parseContext);
                    break;
                }
                case '\"': {
                    result = JSONNode.parseStringPathNode(buf, fromIndex, toIndex, skipValue, parseContext);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported for begin character with '" + beginChar + "'");
                }
            }
            if (parseContext.validate && (endIndex = parseContext.endIndex) != toIndex - 1) {
                int wordNum = Math.min(50, buf.length - endIndex - 1);
                throw new JSONException("Syntax error, extra characters found, '" + new String(buf, endIndex + 1, wordNum) + "', at pos " + endIndex);
            }
            return result;
        }
        catch (Exception ex) {
            JSONNode.handleCatchException((Throwable)ex, buf, toIndex);
            throw new JSONException("Error: " + ex.getMessage(), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JSONNode parseObjectPathNode(char[] buf, int fromIndex, int toIndex, String path, int beginPathIndex, boolean skipValue, boolean returnIfMatched, JSONNodeContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        String key = null;
        boolean empty = true;
        boolean allowComment = jsonParseContext.allowComment;
        LinkedHashMap<Serializable, JSONNode> fieldValues = null;
        boolean matched = false;
        boolean isLastPathLevel = false;
        int nextPathIndex = -1;
        if (!skipValue) {
            if (beginPathIndex == -1) {
                isLastPathLevel = true;
            } else {
                nextPathIndex = path.indexOf(47, beginPathIndex + 1);
                boolean bl = isLastPathLevel = beginPathIndex == path.length() - 1;
            }
        }
        if (isLastPathLevel) {
            fieldValues = new LinkedHashMap<Serializable, JSONNode>();
        }
        boolean lazyParseLastNode = isLastPathLevel && jsonParseContext.lazy;
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isClosingSymbol;
            JSONNode value;
            char ch;
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (jsonParseContext.allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            int fieldKeyFrom = i;
            boolean isUnquotedFieldName = false;
            if (ch == '\"') {
                while (i + 1 < toIndex && (buf[++i] != '\"' || buf[i - 1] == '\\')) {
                }
                empty = false;
                ++i;
            } else {
                if (ch == '}') {
                    if (!empty) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not allowed at pos " + i);
                    }
                    jsonParseContext.endIndex = i;
                    return null;
                }
                if (ch == '\'') {
                    if (!jsonParseContext.allowSingleQuotes) throw new JSONException("Syntax error, the single quote symbol ' is not allowed at pos " + i);
                    while (i + 1 < toIndex && buf[++i] != '\'') {
                    }
                    empty = false;
                    ++i;
                } else if (jsonParseContext.allowUnquotedFieldNames) {
                    while (i + 1 < toIndex && buf[++i] != ':') {
                    }
                    empty = false;
                    isUnquotedFieldName = true;
                }
            }
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            int fieldKeyTo = i;
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (ch != ':') throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            if (!skipValue) {
                key = JSONDefaultParser.parseKeyOfMap(buf, fieldKeyFrom, fieldKeyTo, isUnquotedFieldName);
                if (!isLastPathLevel) {
                    matched = JSONNode.stringEqual(path, beginPathIndex + 1, (nextPathIndex == -1 ? path.length() : nextPathIndex) - beginPathIndex - 1, key, 0, key.length());
                }
            }
            while ((ch = buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            boolean isLeafValue = false;
            boolean isSkipValue = isLastPathLevel ? false : !matched || skipValue;
            boolean lazy = lazyParseLastNode || nextPathIndex == -1;
            switch (ch) {
                case '{': {
                    if (lazy) {
                        isSkipValue = true;
                    }
                    value = JSONNode.parseObjectPathNode(buf, i, toIndex, path, nextPathIndex, isSkipValue, returnIfMatched, jsonParseContext);
                    if (lazy) {
                        value = new JSONNode(buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                    }
                    i = jsonParseContext.endIndex;
                    break;
                }
                case '[': {
                    if (lazy) {
                        isSkipValue = true;
                    }
                    value = JSONNode.parseArrayPathNode(buf, i, toIndex, path, nextPathIndex, isSkipValue, returnIfMatched, jsonParseContext);
                    if (lazy) {
                        value = new JSONNode(buf, i, jsonParseContext.endIndex + 1, jsonParseContext);
                    }
                    i = jsonParseContext.endIndex;
                    break;
                }
                case '\"': {
                    isLeafValue = true;
                    value = JSONNode.parseStringPathNode(buf, i, toIndex, isSkipValue, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 'n': {
                    isLeafValue = true;
                    value = JSONNode.parseNullPathNode(buf, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 't': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolTruePathNode(buf, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    break;
                }
                case 'f': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolFalsePathNode(buf, i, toIndex, jsonParseContext);
                    i = jsonParseContext.endIndex;
                    break;
                }
                default: {
                    isLeafValue = true;
                    value = JSONNode.parseNumberPathNode(buf, i, toIndex, '}', jsonParseContext);
                    i = jsonParseContext.endIndex;
                }
            }
            while ((ch = buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (matched) {
                if (isLeafValue && nextPathIndex > -1) {
                    throw new JSONException(String.format("path '%s' error, '%s' is the last leaf level, The following path '%s' does not exist ", path, path.substring(0, nextPathIndex), path.substring(nextPathIndex)));
                }
                if ((isLastPathLevel || isLeafValue || nextPathIndex == -1) && jsonParseContext.extract) {
                    jsonParseContext.extractValue(isLeafValue ? value.leafValue : value);
                }
                jsonParseContext.endIndex = i;
                if (returnIfMatched) {
                    return value;
                }
            }
            boolean bl = isClosingSymbol = ch == '}';
            if (ch != ',' && !isClosingSymbol) throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            if (fieldValues != null) {
                fieldValues.put((Serializable)((Object)key), value);
            }
            if (!isClosingSymbol) continue;
            jsonParseContext.endIndex = i;
            if (!isLastPathLevel) return null;
            return new JSONNode(fieldValues, buf, fromIndex, i + 1, jsonParseContext);
        }
        throw new JSONException("Syntax error, the closing symbol '}' is not found ");
    }

    private static boolean stringEqual(String path, int s1, int len1, String key, int s2, int len2) {
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (path.charAt(s1 + i) == key.charAt(s2 + i)) continue;
            return false;
        }
        return true;
    }

    private static JSONNode parseArrayPathNode(char[] buf, int fromIndex, int toIndex, String path, int beginPathIndex, boolean skipValue, boolean returnIfMatched, JSONNodeContext jsonParseContext) throws Exception {
        int beginIndex = fromIndex + 1;
        ArrayList<JSONNode> elementValues = null;
        boolean allowComment = jsonParseContext.allowComment;
        int elementIndex = 0;
        boolean fetchAllElement = false;
        boolean matched = false;
        boolean isLastPathLevel = false;
        boolean returnValueIfMathched = false;
        int targetElementIndex = -1;
        boolean EqualMode = false;
        boolean GtMode = true;
        int LtMode = -1;
        int AllMode = 2;
        int compareMode = 0;
        int nextPathIndex = -1;
        if (!skipValue) {
            if (beginPathIndex == -1) {
                isLastPathLevel = true;
                matched = true;
                fetchAllElement = true;
            } else {
                int endPathIndex;
                nextPathIndex = path.indexOf(47, beginPathIndex + 1);
                int n = endPathIndex = nextPathIndex == -1 ? path.length() : nextPathIndex;
                if (beginPathIndex + 1 < endPathIndex) {
                    int numEndIndex;
                    int numBeginIndex;
                    if (path.charAt(beginPathIndex + 1) == '[' && path.charAt(endPathIndex - 1) == ']') {
                        numBeginIndex = beginPathIndex + 2;
                        numEndIndex = endPathIndex - 1;
                    } else {
                        numBeginIndex = beginPathIndex + 1;
                        numEndIndex = endPathIndex;
                    }
                    int len = numEndIndex - numBeginIndex;
                    if (len <= 0) {
                        throw new UnsupportedOperationException("Path error, array element access must use [n] or n, n is a int value ");
                    }
                    char endCharOfPath = path.charAt(numEndIndex - 1);
                    switch (endCharOfPath) {
                        case '*': {
                            if (len == 1) {
                                compareMode = 2;
                                fetchAllElement = true;
                                matched = true;
                                break;
                            }
                        }
                        case '+': {
                            compareMode = 1;
                        }
                        case '-': {
                            if (compareMode == 0) {
                                compareMode = -1;
                            }
                            --numEndIndex;
                        }
                        default: {
                            if (compareMode == 0) {
                                returnValueIfMathched = true;
                            }
                            targetElementIndex = JSONNode.readArrayIndex(JSONNode.getChars(path), numBeginIndex, numEndIndex - numBeginIndex);
                        }
                    }
                }
                boolean bl = isLastPathLevel = nextPathIndex == -1 || beginPathIndex == path.length() - 1;
            }
        }
        if (isLastPathLevel || !returnValueIfMathched) {
            elementValues = new ArrayList<JSONNode>();
        }
        for (int i = beginIndex; i < toIndex; ++i) {
            boolean isEnd;
            JSONNode value;
            char ch;
            boolean returnListIfMathched = false;
            if (!skipValue && !fetchAllElement) {
                int index = elementIndex++;
                switch (compareMode) {
                    case -1: {
                        matched = index <= targetElementIndex;
                        returnListIfMathched = index == targetElementIndex;
                        break;
                    }
                    case 0: {
                        matched = index == targetElementIndex;
                        break;
                    }
                    case 1: {
                        matched = index >= targetElementIndex;
                        break;
                    }
                    default: {
                        matched = true;
                    }
                }
            }
            while ((ch = buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (ch == ']') {
                if (elementValues != null && elementValues.size() > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + i);
                }
                jsonParseContext.endIndex = i;
                return null;
            }
            boolean isLeafValue = false;
            boolean isSkipValue = !matched || skipValue;
            switch (ch) {
                case '{': {
                    value = JSONNode.parseObjectPathNode(buf, i, toIndex, path, nextPathIndex, isSkipValue, returnValueIfMathched, jsonParseContext);
                    break;
                }
                case '[': {
                    value = JSONNode.parseArrayPathNode(buf, i, toIndex, path, nextPathIndex, isSkipValue, returnValueIfMathched, jsonParseContext);
                    break;
                }
                case '\"': {
                    isLeafValue = true;
                    value = JSONNode.parseStringPathNode(buf, i, toIndex, isSkipValue, jsonParseContext);
                    break;
                }
                case 'n': {
                    isLeafValue = true;
                    value = JSONNode.parseNullPathNode(buf, i, toIndex, jsonParseContext);
                    break;
                }
                case 't': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolTruePathNode(buf, i, toIndex, jsonParseContext);
                    break;
                }
                case 'f': {
                    isLeafValue = true;
                    value = JSONNode.parseBoolFalsePathNode(buf, i, toIndex, jsonParseContext);
                    break;
                }
                default: {
                    isLeafValue = true;
                    value = JSONNode.parseNumberPathNode(buf, i, toIndex, ']', jsonParseContext);
                }
            }
            if (matched && elementValues != null) {
                elementValues.add(value);
            }
            i = jsonParseContext.endIndex;
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, (JSONParseContext)jsonParseContext);
                ch = buf[i];
            }
            if (matched) {
                if (isLeafValue && nextPathIndex > -1) {
                    throw new JSONException(String.format("path '%s' error, '%s' is the last level, The following path '%s' does not exist ", path, path.substring(0, nextPathIndex), path.substring(nextPathIndex)));
                }
                if (isLastPathLevel && jsonParseContext.extract) {
                    jsonParseContext.extractValue(isLeafValue ? value.leafValue : value);
                }
                if (returnIfMatched && returnValueIfMathched) {
                    return value;
                }
                if (returnListIfMathched) {
                    if (isLastPathLevel) {
                        return new JSONNode(elementValues, buf, fromIndex, i + 1, jsonParseContext);
                    }
                    return null;
                }
            }
            boolean bl = isEnd = ch == ']';
            if (ch == ',' || isEnd) {
                if (!isEnd) continue;
                jsonParseContext.endIndex = i;
                if (isLastPathLevel) {
                    return new JSONNode(elementValues, buf, fromIndex, i + 1, jsonParseContext);
                }
                return null;
            }
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", Missing ',' or '}'");
        }
        throw new JSONException("Syntax error, the closing symbol ']' is not found ");
    }

    private static JSONNode parseStringPathNode(char[] buf, int fromIndex, int toIndex, boolean skipValue, JSONNodeContext jsonParseContext) throws Exception {
        if (skipValue) {
            JSONTypeDeserializer.CHAR_SEQUENCE_STRING.skip(null, buf, fromIndex, '\"', (JSONParseContext)jsonParseContext);
            return null;
        }
        String value = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(null, buf, fromIndex, toIndex, '\"', GenericParameterizedType.StringType, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new JSONNode((Serializable)((Object)value), buf, fromIndex, endIndex + 1, 3, jsonParseContext);
    }

    private static JSONNode parseNullPathNode(char[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext) throws Exception {
        JSONTypeDeserializer.NULL.deserialize(null, buf, fromIndex, toIndex, null, null, (JSONParseContext)jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new JSONNode((Serializable)null, buf, fromIndex, endIndex + 1, 6, jsonParseContext);
    }

    private static JSONNode parseBoolTruePathNode(char[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext) throws Exception {
        JSONTypeDeserializer.BOOLEAN.deserializeTrue(buf, fromIndex, toIndex, null, jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new JSONNode(Boolean.valueOf(true), buf, fromIndex, endIndex + 1, 5, jsonParseContext);
    }

    private static JSONNode parseBoolFalsePathNode(char[] buf, int fromIndex, int toIndex, JSONNodeContext jsonParseContext) throws Exception {
        JSONTypeDeserializer.BOOLEAN.deserializeFalse(buf, fromIndex, toIndex, null, jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new JSONNode(Boolean.valueOf(false), buf, fromIndex, endIndex + 1, 5, jsonParseContext);
    }

    private static JSONNode parseNumberPathNode(char[] buf, int fromIndex, int toIndex, char endToken, JSONNodeContext jsonParseContext) throws Exception {
        Number value = JSONTypeDeserializer.NUMBER.deserializeDefault(buf, fromIndex, toIndex, endToken, jsonParseContext);
        int endIndex = jsonParseContext.endIndex;
        return new JSONNode(value, buf, fromIndex, endIndex + 1, 4, jsonParseContext);
    }

    private static JSONNode parse(String source, String path, boolean reverseParseNode, ReadOption ... readOptions) {
        if (source == null) {
            return null;
        }
        source = source.trim();
        try {
            char[] buf = JSONNode.getChars(source);
            JSONNodeContext parseContext = new JSONNodeContext();
            JSONOptions.readOptions(readOptions, parseContext);
            parseContext.reverseParseNode = reverseParseNode;
            JSONNode jsonNode = new JSONNode(buf, 0, buf.length, parseContext);
            if (path == null) {
                return jsonNode;
            }
            return jsonNode.get(path);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            throw new JSONException(throwable.getMessage(), throwable);
        }
    }

    private void init() {
        char start = '\u0000';
        int end = 0;
        while (this.beginIndex < this.endIndex && (start = this.buf[this.beginIndex]) <= ' ') {
            ++this.beginIndex;
        }
        while (this.endIndex > this.beginIndex && (end = this.buf[this.endIndex - 1]) <= 32) {
            --this.endIndex;
        }
        if (start == '{' && end == 125) {
            this.type = 1;
        } else if (start == '[' && end == 93) {
            this.type = 2;
        } else if (start == '\"' && end == 34) {
            this.type = 3;
        } else {
            this.text = new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
            boolean isTrue = this.text.equals("true") || this.text.equals("false");
            if (isTrue) {
                this.type = 5;
                this.leafValue = Boolean.valueOf(isTrue);
            } else if (this.text.equals("null")) {
                this.type = 6;
                this.leafValue = null;
            } else {
                this.type = 4;
            }
        }
    }

    public JSONNode root() {
        return this.root;
    }

    public JSONNode get(String childPath) {
        char[] pathBuf = JSONNode.getChars(childPath.trim());
        return this.get(pathBuf, 0, pathBuf.length);
    }

    private JSONNode get(char[] pathBuf, int beginIndex, int endIndex) {
        if (pathBuf == null || endIndex - beginIndex == 0) {
            return this;
        }
        int beginChar = pathBuf[beginIndex];
        if (beginChar == 47) {
            return this.root.get(pathBuf, beginIndex + 1, endIndex);
        }
        if (this.leaf) {
            return null;
        }
        int splitIndex = -1;
        int hashValue = beginChar;
        for (int i = beginIndex + 1; i < endIndex; ++i) {
            char ch = pathBuf[i];
            if (ch == '/') {
                splitIndex = i;
                break;
            }
            hashValue = hashValue * 31 + ch;
        }
        if (splitIndex == -1) {
            return this.getPathNode(pathBuf, beginIndex, endIndex - beginIndex, hashValue);
        }
        JSONNode childNode = this.getPathNode(pathBuf, beginIndex, splitIndex - beginIndex, hashValue);
        if (childNode != null) {
            return childNode.get(pathBuf, splitIndex + 1, endIndex);
        }
        return null;
    }

    public Collection<Serializable> keyNames() {
        if (this.isArray) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        return this.fieldValues.keySet();
    }

    private JSONNode getPathNode(char[] buf, int offset, int len, int hashCode) {
        if (this.isArray) {
            char ch = buf[offset];
            int digit = JSONNode.digitDecimal(ch);
            int index = -1;
            try {
                if (digit > -1) {
                    index = JSONNode.readArrayIndex(buf, offset, len);
                } else {
                    char endChar = buf[offset + len - 1];
                    if (ch == '[' && endChar == ']') {
                        index = JSONNode.readArrayIndex(buf, offset + 1, len - 2);
                    }
                }
            }
            catch (Throwable throwable) {
                String key = new String(buf, offset, len);
                throw new IllegalArgumentException(" key '" + key + " is mismatch array index ");
            }
            if (index > -1) {
                return this.getElementAt(index);
            }
            String key = new String(buf, offset, len);
            throw new IllegalArgumentException(" key '" + key + " is mismatch array index ");
        }
        String field = this.parseContext.getCacheKey(buf, offset, len, (long)hashCode);
        return this.getFieldNodeAt(field);
    }

    private JSONNode getFieldNodeAt(String field) {
        JSONNode value = null;
        if (this.fieldValues == null) {
            this.fieldValues = new LinkedHashMap<Serializable, JSONNode>(16);
        } else {
            value = this.fieldValues.get(field);
        }
        if (value != null) {
            return value;
        }
        if (this.completed) {
            return null;
        }
        return this.parseFieldNode(field, false);
    }

    private JSONNode getPathNode(String field) {
        if (this.isArray) {
            char[] buf = JSONNode.getChars(field);
            int index = -1;
            try {
                index = buf[0] == '[' && buf[buf.length - 1] == ']' ? JSONNode.readArrayIndex(buf, 1, buf.length - 2) : JSONNode.readArrayIndex(buf, 0, buf.length);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException(" field '" + field + " is mismatch array index ");
            }
            if (index > -1) {
                return this.getElementAt(index);
            }
            throw new IllegalArgumentException(" key '" + field + " is mismatch array index ");
        }
        return this.getFieldNodeAt(field);
    }

    protected static int readArrayIndex(char[] buf, int offset, int len) {
        int i;
        if (len == 0) {
            return -1;
        }
        int value = 0;
        int n = i + len;
        for (i = offset; i < n; ++i) {
            char ch = buf[i];
            int d = JSONNode.digitDecimal(ch);
            if (d < 0) {
                if (ch == ' ') continue;
                throw new NumberFormatException("For input string: \"" + new String(buf, offset, len) + "\"");
            }
            value = value * 10 + d;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONNode parseFieldNode(String fieldName, boolean skipIfUnleaf) {
        if (this.completed) {
            return this.fieldValues.get(fieldName);
        }
        boolean allowComment = this.parseContext.allowComment;
        boolean empty = true;
        for (int i = this.offset + 1; i < this.endIndex; ++i) {
            boolean isClosingSymbol;
            JSONNode value;
            boolean matchedField;
            String key;
            char ch;
            while ((ch = this.buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                ch = this.buf[i];
            }
            int fieldKeyFrom = i;
            if (ch == '\"') {
                key = JSONDefaultParser.parseMapKeyByCache(this.buf, i, this.endIndex, '\"', this.parseContext);
                empty = false;
                i = this.parseContext.endIndex + 1;
            } else {
                if (ch == '}') {
                    if (!empty) {
                        throw new JSONException("Syntax error, the closing symbol '}' is not allowed at pos " + i);
                    }
                    this.offset = i;
                    this.completed = true;
                    return null;
                }
                if (ch == '\'') {
                    if (!this.parseContext.allowSingleQuotes) throw new JSONException("Syntax error, the single quote symbol ' is not allowed at pos " + i);
                    while (i + 1 < this.endIndex && (this.buf[++i] != '\'' || this.buf[i - 1] == '\\')) {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, ++i, false);
                } else if (this.parseContext.allowUnquotedFieldNames) {
                    while (i + 1 < this.endIndex && this.buf[++i] != ':') {
                    }
                    empty = false;
                    key = JSONDefaultParser.parseKeyOfMap(this.buf, fieldKeyFrom, i, true);
                } else {
                    String errorContextTextAt = JSONNode.createErrorContextText(this.buf, i);
                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected '\"' or use option ReadOption.AllowUnquotedFieldNames ");
                }
            }
            while ((ch = this.buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                ch = this.buf[i];
            }
            if (ch != ':') throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            boolean bl = matchedField = fieldName != null && fieldName.equals(key);
            while ((ch = this.buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                ch = this.buf[i];
            }
            try {
                value = this.parseValueNode(i, '}');
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof JSONException)) throw new JSONException(throwable.getMessage(), throwable);
                throw (JSONException)throwable;
            }
            i = this.parseContext.endIndex;
            while ((ch = this.buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                ch = this.buf[i];
            }
            this.offset = i;
            boolean bl2 = isClosingSymbol = ch == '}';
            if (ch != ',' && !isClosingSymbol) throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i);
            this.fieldValues.put((Serializable)((Object)key), value);
            if (isClosingSymbol) {
                this.completed = true;
            }
            if (!matchedField) continue;
            return value;
        }
        return null;
    }

    private JSONNode parseElementNodeAt(int index) {
        boolean allowComment = this.parseContext.allowComment;
        for (int i = this.offset + 1; i < this.endIndex; ++i) {
            boolean isEnd;
            JSONNode value;
            char ch;
            while ((ch = this.buf[i]) <= ' ') {
                ++i;
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                ch = this.buf[i];
            }
            if (ch == ']') {
                if (this.length > 0) {
                    throw new JSONException("Syntax error, not allowed ',' followed by ']', pos " + i);
                }
                this.offset = i;
                this.completed = true;
                return null;
            }
            boolean matchedIndex = index > -1 && index == this.length;
            try {
                value = this.parseValueNode(i, ']');
            }
            catch (Throwable throwable) {
                if (throwable instanceof JSONException) {
                    throw (JSONException)throwable;
                }
                throw new JSONException(throwable.getMessage(), throwable);
            }
            i = this.parseContext.endIndex;
            while ((ch = this.buf[++i]) <= ' ') {
            }
            if (allowComment && ch == '/') {
                i = JSONNode.clearCommentAndWhiteSpaces(this.buf, i + 1, this.endIndex, (JSONParseContext)this.parseContext);
                ch = this.buf[i];
            }
            this.offset = i;
            boolean bl = isEnd = ch == ']';
            if (ch == ',' || isEnd) {
                this.addElementNode(value);
                if (isEnd) {
                    this.completed = true;
                }
                if (!matchedIndex) continue;
                return value;
            }
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + i + ", Missing ',' or '}'");
        }
        return null;
    }

    private void addElementNode(JSONNode value) {
        if (this.elementValues == null) {
            this.elementValues = new JSONNode[16];
        } else if (this.length == this.elementValues.length) {
            JSONNode[] tmp = this.elementValues;
            this.elementValues = new JSONNode[this.length << 1];
            System.arraycopy(tmp, 0, this.elementValues, 0, tmp.length);
        }
        this.elementValues[this.length++] = value;
    }

    private JSONNode parseValueNode(int i, char endChar) throws Exception {
        JSONNode value;
        char ch = this.buf[i];
        switch (ch) {
            case '{': {
                JSONTypeDeserializer.ANY.skip(null, this.buf, i, this.endIndex, '}', (JSONParseContext)this.parseContext);
                int eIndex = this.parseContext.endIndex;
                value = new JSONNode(this.buf, i, eIndex, 1, this.parseContext, this.root);
                break;
            }
            case '[': {
                JSONTypeDeserializer.ANY.skip(null, this.buf, i, this.endIndex, ']', (JSONParseContext)this.parseContext);
                int eIndex = this.parseContext.endIndex;
                value = new JSONNode(this.buf, i, eIndex, 2, this.parseContext, this.root);
                break;
            }
            case '\"': {
                value = JSONNode.parseStringPathNode(this.buf, i, this.endIndex, false, this.parseContext);
                break;
            }
            case 'n': {
                value = JSONNode.parseNullPathNode(this.buf, i, this.endIndex, this.parseContext);
                break;
            }
            case 't': {
                value = JSONNode.parseBoolTruePathNode(this.buf, i, this.endIndex, this.parseContext);
                break;
            }
            case 'f': {
                value = JSONNode.parseBoolFalsePathNode(this.buf, i, this.endIndex, this.parseContext);
                break;
            }
            default: {
                value = JSONNode.parseNumberPathNode(this.buf, i, this.endIndex, endChar, this.parseContext);
            }
        }
        value.parent = this;
        return value;
    }

    public JSONNode getElementAt(int index) {
        if (!this.isArray) {
            throw new UnsupportedOperationException();
        }
        if (this.completed || this.length > index) {
            return this.elementValues[index];
        }
        return this.parseElementNodeAt(index);
    }

    public int getElementCount() {
        if (this.isArray) {
            if (this.completed) {
                return this.length;
            }
            this.parseElementNodeAt(-1);
            return this.length;
        }
        return -1;
    }

    public int getLength() {
        return this.length;
    }

    public JSONNode parent() {
        return this.parent;
    }

    public JSONNode child(String field) {
        if (this.isArray) {
            throw new UnsupportedOperationException();
        }
        return this.fieldValues.get(field);
    }

    public <E> E getPathValue(String childPath, Class<E> clazz) {
        JSONNode jsonNode = this.get(childPath);
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isArray) {
            if (clazz == String.class) {
                return (E)jsonNode.source();
            }
            throw new UnsupportedOperationException("Type is not matched !");
        }
        return jsonNode.getValue(clazz);
    }

    public <E> E getChildValue(String name, Class<E> eClass) {
        JSONNode jsonNode = this.getPathNode(name);
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isArray) {
            if (eClass == String.class) {
                return (E)jsonNode.source();
            }
            throw new UnsupportedOperationException("Type is not matched !");
        }
        return jsonNode.getValue(eClass);
    }

    public String getText() {
        if (this.text == null) {
            if (this.type == 3) {
                this.text = (String)JSONTypeDeserializer.CHAR_SEQUENCE_STRING.deserializeString(null, this.buf, this.beginIndex, this.endIndex, '\"', GenericParameterizedType.StringType, (JSONParseContext)this.parseContext);
                this.leafValue = this.text;
            } else {
                return this.source();
            }
        }
        return this.text;
    }

    public Date toDate(Class<? extends Date> eClass, String pattern) {
        return (Date)JSONNode.parseDateValue(this.beginIndex, this.endIndex, this.buf, pattern, null, eClass == null ? Date.class : eClass);
    }

    public Date toDate(Class<? extends Date> eClass) {
        return (Date)JSONNode.parseDateValue(this.beginIndex, this.endIndex, this.buf, null, null, eClass == null ? Date.class : eClass);
    }

    public String getStringValue() {
        return this.getValue(String.class);
    }

    public int getIntValue() {
        return this.getValue(Integer.class);
    }

    public long getLongValue() {
        return this.getValue(Long.class);
    }

    public double getDoubleValue() {
        return this.getValue(Double.class);
    }

    public Serializable getValue() {
        if (this.leafValue != null) {
            return this.leafValue;
        }
        return (Serializable)this.getValue(null);
    }

    public <E> E getValue(Class<E> eClass) {
        if (this.leaf) {
            if (eClass != null && eClass.isInstance(this.leafValue)) {
                return (E)this.leafValue;
            }
            if (this.type == 6) {
                return null;
            }
            if (eClass == null) {
                if (this.type == 3) {
                    return (E)this.getText();
                }
                String source = this.source();
                if (this.type == 4) {
                    return (E)this.toDefaultNumber(source);
                }
                return (E)source;
            }
            if (eClass == String.class) {
                return (E)this.getText();
            }
            if (eClass == char[].class) {
                return (E)this.getText().toCharArray();
            }
            if (eClass == byte[].class) {
                String text = this.getText();
                if (this.parseContext.byteArrayFromHexString) {
                    return (E)JSONNode.hexString2Bytes(this.buf, this.beginIndex + 1, this.endIndex - this.beginIndex - 2);
                }
                return (E)Base64.getDecoder().decode(text);
            }
            if (Enum.class.isAssignableFrom(eClass)) {
                if (this.type == 3) {
                    Class<E> enumCls = eClass;
                    return Enum.valueOf(enumCls, this.getText());
                }
                throw new JSONException("source [" + this.source() + "] cannot convert to Enum '" + eClass + "");
            }
            String source = this.source();
            if (this.type == 4) {
                if (eClass == Double.TYPE || eClass == Double.class) {
                    return (E)Double.valueOf(source);
                }
                if (eClass == Long.TYPE || eClass == Long.class) {
                    return (E)Long.valueOf(source);
                }
                if (eClass == Float.TYPE || eClass == Float.class) {
                    return (E)Float.valueOf(source);
                }
                if (eClass == Integer.TYPE || eClass == Integer.class) {
                    return (E)Integer.valueOf(source);
                }
                if (eClass == Byte.TYPE || eClass == Byte.class) {
                    return (E)Byte.valueOf(source);
                }
                if (eClass == BigDecimal.class) {
                    return (E)new BigDecimal(source);
                }
                return (E)this.toDefaultNumber(source);
            }
            if (this.type == 5) {
                if (eClass == Boolean.TYPE || eClass == Boolean.class) {
                    return (E)this.leafValue;
                }
            } else if (eClass.isEnum()) {
                Class<E> cls = eClass;
                return Enum.valueOf(cls, source);
            }
            return (E)source;
        }
        if (this.isArray) {
            if (eClass == String.class) {
                return (E)this.getText();
            }
            throw new UnsupportedOperationException(" Please use toList or toArray method instead !");
        }
        if (eClass != null && (eClass.isEnum() || eClass.isPrimitive() || eClass.isArray())) {
            throw new UnsupportedOperationException(" Type is Unsupported for '" + eClass + "'");
        }
        return this.toBean(eClass);
    }

    private Number toDefaultNumber(String source) {
        if (source.indexOf(46) > -1) {
            return Double.valueOf(source);
        }
        return Long.valueOf(source);
    }

    public <E> Map<?, E> toMap(Class<? extends Map> eClass, Class<E> valueCls) {
        return this.toBean(eClass, valueCls);
    }

    public <E> E toBean(Class<E> eClass) {
        return this.toBean(eClass, null);
    }

    private <E> E toBean(Class<E> eClass, Class actualCls) {
        boolean isMapInstance;
        Object instance;
        if (eClass == String.class) {
            return (E)this.source();
        }
        if (this.leaf) {
            throw new UnsupportedOperationException(" NodeValue is a leaf value, please call method getValue width Java basic type param instead !");
        }
        JSONPojoStructure classStructureWrapper = null;
        if (eClass == null || eClass == Map.class || eClass == LinkedHashMap.class) {
            instance = new LinkedHashMap();
            isMapInstance = true;
        } else {
            classStructureWrapper = JSONPojoStructure.get(eClass);
            isMapInstance = classStructureWrapper.isAssignableFromMap();
            try {
                instance = !isMapInstance ? classStructureWrapper.newInstance() : eClass.newInstance();
            }
            catch (Throwable throwable) {
                throw new JSONException("Create instance error.", throwable);
            }
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        for (Serializable key : this.fieldValues.keySet()) {
            Class<?> parameterType;
            JSONNode childNode = this.fieldValues.get(key);
            if (isMapInstance) {
                Map map = (Map)instance;
                List<E> value = childNode.isArray ? childNode.toList(null) : childNode.getValue(actualCls);
                map.put(key, value);
                continue;
            }
            String fieldName = key.toString();
            JSONPojoFieldDeserializer fieldDeserializer = classStructureWrapper.getFieldDeserializer(fieldName);
            SetterInfo setterInfo = fieldDeserializer == null ? null : fieldDeserializer.getSetterInfo();
            if (setterInfo == null) continue;
            Class<?> entityClass = parameterType = setterInfo.getParameterType();
            Class<?> collCls = null;
            Class<?> actualTypeArgumentType = setterInfo.getActualTypeArgument();
            if (actualTypeArgumentType != null) {
                entityClass = actualTypeArgumentType;
                collCls = parameterType;
            }
            Object value = childNode.isArray ? childNode.toCollection(collCls, entityClass) : (Date.class.isAssignableFrom(parameterType) ? JSONNode.parseDateValue(this.beginIndex, this.endIndex, this.buf, fieldDeserializer.getDatePattern(), fieldDeserializer.getDateTimezone(), parameterType) : childNode.getValue(entityClass));
            setterInfo.invoke(instance, value);
        }
        return (E)instance;
    }

    public <E> List<E> toList(Class<E> entityClass) {
        return (List)this.toCollection(ArrayList.class, entityClass);
    }

    public <E> E[] toArray(Class<E> entityClass) {
        return (Object[])this.toCollection(Object[].class, entityClass);
    }

    public Object toCollection(Class<?> collectionCls, Class<?> entityClass) {
        if (!this.completed) {
            this.parseFullNode();
        }
        Class<?> target = entityClass;
        AbstractCollection collection = null;
        boolean isArrayCls = false;
        ArrayList arrayObj = null;
        if (collectionCls == null || collectionCls == ArrayList.class) {
            collection = new ArrayList(this.length);
        } else {
            isArrayCls = collectionCls.isArray();
            if (isArrayCls) {
                arrayObj = Array.newInstance(entityClass, this.length);
            } else if (collectionCls.isInterface()) {
                if (Set.class.isAssignableFrom(collectionCls)) {
                    collection = new LinkedHashSet();
                } else if (List.class.isAssignableFrom(collectionCls)) {
                    collection = new ArrayList();
                }
            } else if (collectionCls == HashSet.class) {
                collection = new HashSet();
            } else if (collectionCls == Vector.class) {
                collection = new Vector();
            }
        }
        for (int i = 0; i < this.length; ++i) {
            JSONNode element = this.elementValues[i];
            List<Object> result = null;
            result = element.isArray ? element.toList(null) : element.getValue(target);
            if (isArrayCls) {
                Array.set(arrayObj, i, result);
                continue;
            }
            collection.add(result);
        }
        return isArrayCls ? arrayObj : collection;
    }

    private void parseFullNode() {
        if (this.isArray) {
            this.parseElementNodeAt(-1);
        } else {
            if (this.fieldValues == null) {
                this.fieldValues = new LinkedHashMap<Serializable, JSONNode>(16);
            }
            this.parseFieldNode(null, false);
        }
    }

    public String source() {
        if (this.leafValue != null && this.type != 3) {
            return String.valueOf(this.leafValue);
        }
        String source = null;
        if (this.type > 3) {
            if (this.text == null) {
                this.text = source = new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
            }
            return this.text;
        }
        return new String(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int compareTo(JSONNode o) {
        Serializable value = this.leafValue;
        Serializable o1 = o.leafValue;
        if (value instanceof Number && o1 instanceof Number) {
            Double v1 = ((Number)value).doubleValue();
            Double v2 = ((Number)o1).doubleValue();
            return v1.compareTo(v2);
        }
        if (value instanceof String && o1 instanceof String) {
            return ((String)((Object)value)).compareTo((String)((Object)o1));
        }
        if (value instanceof Comparable && o1 instanceof Comparable) {
            if (value.getClass() == o1.getClass()) {
                return ((Comparable)((Object)value)).compareTo(o1);
            }
            String v1 = value.toString();
            String v2 = o1.toString();
            return v1.compareTo(v2);
        }
        return 0;
    }

    private void writeTo(StringBuilder stringBuilder) {
        if (!this.changed) {
            this.writeSourceTo(stringBuilder);
            return;
        }
        switch (this.type) {
            case 1: {
                stringBuilder.append('{');
                int len = this.fieldValues.size();
                int i = 0;
                for (Map.Entry<Serializable, JSONNode> entry : this.fieldValues.entrySet()) {
                    String key = entry.getKey().toString();
                    JSONNode value = entry.getValue();
                    stringBuilder.append('\"').append(key).append("\":");
                    value.writeTo(stringBuilder);
                    if (i++ >= len - 1) continue;
                    stringBuilder.append(',');
                }
                stringBuilder.append('}');
                break;
            }
            case 2: {
                stringBuilder.append('[');
                for (int j = 0; j < this.length; ++j) {
                    JSONNode value = this.elementValues[j];
                    value.writeTo(stringBuilder);
                    if (j >= this.length - 1) continue;
                    stringBuilder.append(',');
                }
                stringBuilder.append(']');
                break;
            }
            case 3: {
                stringBuilder.append('\"');
                JSONNode.writeStringTo((String)((Object)this.leafValue), stringBuilder);
                stringBuilder.append('\"');
                break;
            }
            default: {
                stringBuilder.append(this.leafValue);
            }
        }
    }

    private void writeSourceTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.buf, this.beginIndex, this.endIndex - this.beginIndex);
    }

    private static void writeStringTo(String leafValue, StringBuilder content) {
        int len = leafValue.length();
        int beginIndex = 0;
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char ch = leafValue.charAt(i);
            if (ch > '\"' && ch != '\\' || (escapeStr = ESCAPE_VALUES[ch]) == null) continue;
            int length = i - beginIndex;
            if (length > 0) {
                content.append(leafValue, beginIndex, i);
            }
            content.append(escapeStr);
            beginIndex = i + 1;
        }
        content.append(leafValue, beginIndex, len);
    }

    public void setPathValue(String path, Serializable value) {
        JSONNode node = this.get(path);
        if (node != null && node.leaf) {
            node.setLeafValue(value);
        }
    }

    public void removeElementAt(int index) {
        if (!this.isArray) {
            throw new UnsupportedOperationException();
        }
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException(" length: " + this.length + ", to remove index at " + index);
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        int newLen = this.length - 1;
        JSONNode[] newElementNodes = new JSONNode[newLen];
        System.arraycopy(this.elementValues, 0, newElementNodes, 0, index);
        System.arraycopy(this.elementValues, index + 1, newElementNodes, index, newLen - index);
        this.length = newLen;
        this.handleChange();
    }

    public JSONNode removeField(String field) {
        JSONNode removeNode;
        if (this.type != 1) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        if ((removeNode = this.fieldValues.remove(field)) != null) {
            this.handleChange();
        }
        return removeNode;
    }

    public List collect(String childPath) {
        return this.collect(childPath, String.class);
    }

    public List collect(String childPath, Class typeClass) {
        if (!this.isArray) {
            throw new UnsupportedOperationException();
        }
        if (!this.completed) {
            this.parseFullNode();
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.length; ++i) {
            JSONNode jsonNode = this.elementValues[i];
            result.add(jsonNode.getPathValue(childPath, typeClass));
        }
        return result;
    }

    public void setLeafValue(Serializable value) {
        if (value == this.leafValue) {
            return;
        }
        this.leafValue = value;
        this.updateType();
        this.handleChange();
    }

    private void updateType() {
        if (this.leafValue == null) {
            this.type = 6;
        } else if (this.leafValue instanceof Number) {
            this.type = 4;
        } else if (this.leafValue instanceof Boolean) {
            this.type = 5;
        } else if (this.type == 3) {
            this.type = 3;
            this.text = (String)((Object)this.leafValue);
        }
    }

    private void handleChange() {
        if (this.parent != null) {
            this.parent.handleChange();
        }
        this.changed = true;
    }

    public String toJsonString() {
        if (!this.changed) {
            return this.source();
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.writeTo(stringBuilder);
        return stringBuilder.toString();
    }
}

