/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONOptions;

public class JSONParseContext {
    public int endIndex;
    public int endChar;
    public JSONCharArrayWriter writer;
    public boolean byteArrayFromHexString;
    public boolean unknownEnumAsNull;
    public boolean allowSingleQuotes;
    public boolean allowUnquotedFieldNames;
    public boolean allowComment;
    public boolean allowLastEndComma;
    public boolean useDefaultFieldInstance;
    public boolean useBigDecimalAsDefault;
    public boolean useJDKDoubleParser;
    public boolean disableCacheMapKey;
    public boolean unMatchedEmptyAsNull;
    private boolean escape = true;
    private int escapeOffset = -1;
    private String[] strings;
    private double[] doubles;
    private long[] longs;
    private int[] ints;

    public void setContextWriter(JSONCharArrayWriter writer) {
        this.writer = writer;
    }

    public JSONCharArrayWriter getContextWriter() {
        if (this.writer != null) {
            this.writer.clear();
        }
        return this.writer;
    }

    public String[] getContextStrings() {
        if (this.strings == null) {
            this.strings = new String[16];
        }
        return this.strings;
    }

    public double[] getContextDoubles() {
        if (this.doubles == null) {
            this.doubles = new double[16];
        }
        return this.doubles;
    }

    public long[] getContextLongs() {
        if (this.longs == null) {
            this.longs = new long[16];
        }
        return this.longs;
    }

    public int[] getContextInts() {
        if (this.ints == null) {
            this.ints = new int[16];
        }
        return this.ints;
    }

    public final String getCacheKey(char[] buf, int offset, int len, long hashCode) {
        return JSONOptions.getCacheKey(buf, offset, len, hashCode);
    }

    public final String getCacheKey(byte[] bytes, int offset, int len, long hashCode) {
        return JSONOptions.getCacheKey(bytes, offset, len, hashCode);
    }

    public void clear() {
        if (this.writer != null) {
            this.writer.reset();
            this.writer = null;
        }
        this.strings = null;
        this.longs = null;
        this.ints = null;
    }

    public final boolean checkEscapeUseChar(String input, int fromIndex, int endIndex) {
        if (!this.escape || endIndex < this.escapeOffset) {
            return false;
        }
        if (fromIndex > this.escapeOffset) {
            this.escapeOffset = input.indexOf(92, fromIndex);
            boolean bl = this.escape = this.escapeOffset > -1;
            if (!this.escape) {
                return false;
            }
        }
        return endIndex > this.escapeOffset;
    }

    public final boolean checkEscapeUseString(String input, int fromIndex, int endIndex) {
        if (!this.escape || endIndex < this.escapeOffset) {
            return false;
        }
        if (fromIndex > this.escapeOffset) {
            this.escapeOffset = input.indexOf("\\", fromIndex);
            boolean bl = this.escape = this.escapeOffset > -1;
            if (!this.escape) {
                return false;
            }
        }
        return endIndex > this.escapeOffset;
    }

    public final int getEscapeOffset() {
        return this.escapeOffset;
    }
}

