/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.AsciiStringSource;
import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.UTF16ByteArraySource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONNodeContext;
import io.github.wycst.wast.json.JSONOptions;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONPojoFieldDeserializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.options.ReadOption;

public abstract class JSONPojoDeserializer<T>
extends JSONTypeDeserializer {
    protected final JSONPojoStructure pojoStructureWrapper;

    public JSONPojoDeserializer(Class<T> pojoClass) {
        pojoClass.getClass();
        this.pojoStructureWrapper = JSONPojoStructure.get(pojoClass);
        if (this.pojoStructureWrapper == null) {
            throw new UnsupportedOperationException("type not support for " + pojoClass);
        }
    }

    JSONPojoDeserializer(JSONPojoStructure pojoStructureWrapper) {
        this.pojoStructureWrapper = pojoStructureWrapper;
    }

    protected final T deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, char endToken, JSONParseContext jsonParseContext) throws Exception {
        char beginChar = buf[fromIndex];
        if (beginChar == '{') {
            return (T)this.deserializePojo(charSource, buf, fromIndex, toIndex, parameterizedType, entity, endToken, jsonParseContext);
        }
        if (beginChar == 'n') {
            NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            return null;
        }
        if (jsonParseContext.unMatchedEmptyAsNull && beginChar == '\"' && buf[fromIndex + 1] == '\"') {
            jsonParseContext.endIndex = fromIndex + 1;
            return null;
        }
        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Object Type, expected '{' ");
    }

    protected final T deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        byte beginByte = buf[fromIndex];
        switch (beginByte) {
            case 123: {
                return (T)this.deserializePojo(charSource, buf, fromIndex, toIndex, parameterizedType, entity, beginByte, jsonParseContext);
            }
            case 110: {
                JSONPojoDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
                return null;
            }
        }
        if (jsonParseContext.unMatchedEmptyAsNull && beginByte == 34 && buf[fromIndex + 1] == 34) {
            jsonParseContext.endIndex = fromIndex + 1;
            return null;
        }
        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)beginByte + "' for Object Type, expected '{' ");
    }

    protected Object pojo(Object value) {
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object deserializePojo(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, char endToken, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        if (entity == null) {
            entity = this.createPojo();
        }
        boolean empty = true;
        boolean allowComment = jsonParseContext.allowComment;
        int i = fromIndex;
        while (true) {
            JSONTypeDeserializer deserializer;
            GenericParameterizedType valueType;
            Object defaultFieldValue;
            boolean isDeserialize;
            JSONPojoFieldDeserializer fieldDeserializer;
            block52: {
                block53: {
                    block55: {
                        String className;
                        block56: {
                            Class<?> implClass;
                            block54: {
                                block48: {
                                    block50: {
                                        boolean isPrevEscape;
                                        int j;
                                        block51: {
                                            int fieldKeyFrom;
                                            block49: {
                                                char ch1;
                                                if ((ch = buf[++i]) <= ' ') {
                                                    continue;
                                                }
                                                if (allowComment && ch == '/') {
                                                    i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                                    ch = buf[i];
                                                }
                                                fieldKeyFrom = i++;
                                                fieldDeserializer = null;
                                                if (ch != '\"') break block49;
                                                ch = buf[i];
                                                if (ch == '\"') break block50;
                                                long hashValue = ch;
                                                if ((ch = buf[++i]) != '\"' && (ch1 = buf[++i]) != '\"') {
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, ch, ch1);
                                                    if ((ch = buf[++i]) != '\"' && (ch1 = buf[++i]) != '\"') {
                                                        hashValue = this.pojoStructureWrapper.hashChar(hashValue, ch, ch1);
                                                        while ((ch = buf[++i]) != '\"' && (ch1 = buf[++i]) != '\"') {
                                                            hashValue = this.pojoStructureWrapper.hashChar(hashValue, ch, ch1);
                                                        }
                                                    }
                                                }
                                                if (ch != '\"') {
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, ch);
                                                }
                                                if ((fieldDeserializer = this.getFieldDeserializer(buf, ++fieldKeyFrom, i, hashValue)) != null || buf[j = i - 1] != '\\') break block50;
                                                isPrevEscape = true;
                                                break block51;
                                            }
                                            if (ch == '}') {
                                                if (!empty && !jsonParseContext.allowLastEndComma) {
                                                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                                                }
                                                jsonParseContext.endIndex = i;
                                                return this.pojo(entity);
                                            }
                                            if (ch == '\'') {
                                                if (!jsonParseContext.allowSingleQuotes) {
                                                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                                                }
                                                long hashValue = 0L;
                                                while (i + 1 < toIndex && (ch = buf[++i]) != '\'') {
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, ch);
                                                }
                                                fieldDeserializer = this.getFieldDeserializer(buf, ++fieldKeyFrom, i, hashValue);
                                                empty = false;
                                                while ((ch = buf[++i]) <= ' ') {
                                                }
                                                break block48;
                                            } else {
                                                if (!jsonParseContext.allowUnquotedFieldNames) {
                                                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "'\"' is required.");
                                                }
                                                long hashValue = 0L;
                                                while (i + 1 < toIndex && (ch = buf[++i]) != ':') {
                                                    if (ch <= ' ') continue;
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, ch);
                                                }
                                                fieldDeserializer = this.getFieldDeserializer(buf, fieldKeyFrom, i, hashValue);
                                                empty = false;
                                            }
                                            break block48;
                                        }
                                        while (buf[--j] == '\\') {
                                            isPrevEscape = !isPrevEscape;
                                        }
                                        if (isPrevEscape) {
                                            char prev = '\u0000';
                                            while ((ch = buf[++i]) != '\"' || prev == '\\') {
                                                prev = ch;
                                            }
                                        }
                                    }
                                    empty = false;
                                    while ((ch = buf[++i]) <= ' ') {
                                    }
                                }
                                if (allowComment && ch == '/') {
                                    i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                    ch = buf[i];
                                }
                                if (ch != ':') {
                                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', token character ':' is expected.");
                                }
                                while (buf[++i] <= ' ') {
                                }
                                if (allowComment && (ch = buf[i]) == '/') {
                                    i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                }
                                isDeserialize = fieldDeserializer != null;
                                defaultFieldValue = null;
                                valueType = null;
                                deserializer = null;
                                if (!isDeserialize) break block52;
                                valueType = fieldDeserializer.getGenericParameterizedType();
                                deserializer = fieldDeserializer.getDeserializer();
                                if (deserializer != null) break block53;
                                implClass = fieldDeserializer.getImplClass();
                                if (implClass == null) break block54;
                                valueType = valueType.copyAndReplaceActualType(implClass);
                                deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                break block52;
                            }
                            ch = buf[i];
                            if (ch != '{') break block55;
                            className = JSONPojoDeserializer.parseObjectClassName(charSource, buf, i, toIndex, jsonParseContext);
                            if (className != null) break block56;
                            if (jsonParseContext.useDefaultFieldInstance) {
                                defaultFieldValue = fieldDeserializer.getDefaultFieldValue(entity);
                                if (defaultFieldValue != null) {
                                    implClass = defaultFieldValue.getClass();
                                    valueType = valueType.copyAndReplaceActualType(implClass);
                                    deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                }
                                break block52;
                            } else {
                                isDeserialize = false;
                            }
                            break block52;
                        }
                        try {
                            Class<?> cls = JSONPojoDeserializer.getClassByName(className);
                            if (fieldDeserializer.isAvailableImpl(cls)) {
                                Object value;
                                valueType = valueType.copyAndReplaceActualType(cls);
                                deserializer = JSONPojoDeserializer.getTypeDeserializer(cls);
                                JSONPojoDeserializer fieldPojoDeserializer = (JSONPojoDeserializer)deserializer;
                                i = jsonParseContext.endIndex;
                                while ((ch = buf[++i]) <= ' ') {
                                }
                                if (ch == ',') {
                                    value = fieldPojoDeserializer.deserializePojo(charSource, buf, i, toIndex, valueType, null, '}', jsonParseContext);
                                    i = jsonParseContext.endIndex;
                                } else {
                                    if (ch != '}') {
                                        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
                                    }
                                    value = this.pojo(fieldPojoDeserializer.createPojo());
                                }
                                this.setFieldValue(entity, fieldDeserializer, value);
                                while ((ch = buf[++i]) <= ' ') {
                                }
                                if (ch == ',') continue;
                                if (ch == '}') {
                                    jsonParseContext.endIndex = i;
                                    return this.pojo(entity);
                                }
                                String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
                            }
                            isDeserialize = false;
                        }
                        catch (Throwable throwable) {
                            throw new JSONException(throwable.getMessage(), throwable);
                        }
                    }
                    Object value = ANY.deserialize(charSource, buf, i, toIndex, null, null, '}', jsonParseContext);
                    if (fieldDeserializer.isInstance(value)) {
                        this.setFieldValue(entity, fieldDeserializer, value);
                        i = jsonParseContext.endIndex;
                        while ((ch = buf[++i]) <= ' ') {
                        }
                        if (ch == ',') continue;
                        if (ch == '}') {
                            jsonParseContext.endIndex = i;
                            return this.pojo(entity);
                        }
                        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
                    }
                    break block52;
                }
                boolean camouflage = valueType.isCamouflage();
                if (camouflage) {
                    valueType = this.getGenericValueType(parameterizedType, valueType);
                    if (!fieldDeserializer.isCustomDeserialize()) {
                        deserializer = JSONPojoDeserializer.getTypeDeserializer(valueType.getActualType());
                    }
                }
            }
            if (isDeserialize) {
                Object value = deserializer.deserialize(charSource, buf, i, toIndex, valueType, defaultFieldValue, '}', jsonParseContext);
                this.setFieldValue(entity, fieldDeserializer, value);
            } else {
                JSONTypeDeserializer.ANY.skip(charSource, buf, i, toIndex, '}', jsonParseContext);
            }
            i = jsonParseContext.endIndex;
            int endChar = jsonParseContext.endChar;
            if (endChar == 0) {
                while ((ch = buf[++i]) <= ' ') {
                }
            } else {
                ch = (char)endChar;
                jsonParseContext.endChar = 0;
            }
            if (ch != ',') break;
        }
        if (ch == '}') {
            jsonParseContext.endIndex = i;
            return this.pojo(entity);
        }
        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + ch + "', expected ',' or '}'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Object deserializePojo(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object entity, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        byte b;
        if (entity == null) {
            entity = this.createPojo();
        }
        boolean empty = true;
        boolean allowComment = jsonParseContext.allowComment;
        int i = fromIndex;
        while (true) {
            JSONTypeDeserializer deserializer;
            GenericParameterizedType valueType;
            Object defaultFieldValue;
            boolean isDeserialize;
            JSONPojoFieldDeserializer fieldDeserializer;
            block51: {
                block52: {
                    block54: {
                        String className;
                        block55: {
                            Class<?> implClass;
                            block53: {
                                block50: {
                                    block48: {
                                        boolean isPrevEscape;
                                        int j;
                                        block49: {
                                            int fieldKeyFrom;
                                            block47: {
                                                byte b1;
                                                if ((b = buf[++i]) <= 32) {
                                                    continue;
                                                }
                                                if (allowComment && b == 47) {
                                                    i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                                    b = buf[i];
                                                }
                                                fieldKeyFrom = i++;
                                                fieldDeserializer = null;
                                                if (b != 34) break block47;
                                                b = buf[i];
                                                if (b == 34) break block48;
                                                long hashValue = b;
                                                if ((b = buf[++i]) != 34 && (b1 = buf[++i]) != 34) {
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, b, b1);
                                                    if ((b = buf[++i]) != 34 && (b1 = buf[++i]) != 34) {
                                                        hashValue = this.pojoStructureWrapper.hashChar(hashValue, b, b1);
                                                        while ((b = buf[++i]) != 34 && (b1 = buf[++i]) != 34) {
                                                            hashValue = this.pojoStructureWrapper.hashChar(hashValue, b, b1);
                                                        }
                                                    }
                                                }
                                                if (b != 34) {
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, b);
                                                }
                                                if ((fieldDeserializer = this.getFieldDeserializer(buf, ++fieldKeyFrom, i, hashValue)) != null || buf[j = i - 1] != 92) break block48;
                                                isPrevEscape = true;
                                                break block49;
                                            }
                                            if (b == 125) {
                                                if (!empty && !jsonParseContext.allowLastEndComma) {
                                                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the closing symbol '}' is not allowed here.");
                                                }
                                                jsonParseContext.endIndex = i;
                                                return this.pojo(entity);
                                            }
                                            if (b == 39) {
                                                if (!jsonParseContext.allowSingleQuotes) {
                                                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "' the single quote symbol ' is not allowed here.");
                                                }
                                                long hashValue = 0L;
                                                while (i + 1 < toIndex && (b = buf[++i]) != 39) {
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, b);
                                                }
                                                fieldDeserializer = this.getFieldDeserializer(buf, ++fieldKeyFrom, i, hashValue);
                                                empty = false;
                                                ++i;
                                                break block50;
                                            } else if (jsonParseContext.allowUnquotedFieldNames) {
                                                long hashValue = 0L;
                                                while (i + 1 < toIndex && buf[++i] != 58) {
                                                    if (b <= 32) continue;
                                                    hashValue = this.pojoStructureWrapper.hashChar(hashValue, b);
                                                }
                                                fieldDeserializer = this.getFieldDeserializer(buf, fieldKeyFrom, i, hashValue);
                                                empty = false;
                                            }
                                            break block50;
                                        }
                                        while (buf[--j] == 92) {
                                            isPrevEscape = !isPrevEscape;
                                        }
                                        if (isPrevEscape) {
                                            byte prev = 0;
                                            while ((b = buf[++i]) != 34 || prev == 92) {
                                                prev = b;
                                            }
                                        }
                                    }
                                    empty = false;
                                    ++i;
                                }
                                while ((b = buf[i]) <= 32) {
                                    ++i;
                                }
                                if (allowComment && b == 47) {
                                    i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                    b = buf[i];
                                }
                                if (b != 58) {
                                    String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                    throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', token character ':' is expected.");
                                }
                                while (buf[++i] <= 32) {
                                }
                                if (allowComment && (b = buf[i]) == 47) {
                                    i = JSONPojoDeserializer.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
                                }
                                isDeserialize = fieldDeserializer != null;
                                defaultFieldValue = null;
                                valueType = null;
                                deserializer = null;
                                if (!isDeserialize) break block51;
                                valueType = fieldDeserializer.getGenericParameterizedType();
                                deserializer = fieldDeserializer.getDeserializer();
                                if (deserializer != null) break block52;
                                implClass = fieldDeserializer.getImplClass();
                                if (implClass == null) break block53;
                                valueType = valueType.copyAndReplaceActualType(implClass);
                                deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                break block51;
                            }
                            b = buf[i];
                            if (b != 123) break block54;
                            className = JSONPojoDeserializer.parseObjectClassName(charSource, buf, i, toIndex, jsonParseContext);
                            if (className != null) break block55;
                            if (jsonParseContext.useDefaultFieldInstance) {
                                defaultFieldValue = fieldDeserializer.getDefaultFieldValue(entity);
                                if (defaultFieldValue != null) {
                                    implClass = defaultFieldValue.getClass();
                                    valueType = valueType.copyAndReplaceActualType(implClass);
                                    deserializer = JSONPojoDeserializer.getTypeDeserializer(implClass);
                                }
                                break block51;
                            } else {
                                isDeserialize = false;
                            }
                            break block51;
                        }
                        try {
                            Class<?> cls = JSONPojoDeserializer.getClassByName(className);
                            if (fieldDeserializer.isAvailableImpl(cls)) {
                                Object value;
                                valueType = valueType.copyAndReplaceActualType(cls);
                                deserializer = JSONPojoDeserializer.getTypeDeserializer(cls);
                                JSONPojoDeserializer fieldPojoDeserializer = (JSONPojoDeserializer)deserializer;
                                i = jsonParseContext.endIndex;
                                while ((b = buf[++i]) <= 32) {
                                }
                                if (b == 44) {
                                    value = fieldPojoDeserializer.deserializePojo(charSource, buf, i, toIndex, valueType, null, (byte)125, jsonParseContext);
                                    i = jsonParseContext.endIndex;
                                } else {
                                    if (b != 125) {
                                        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
                                    }
                                    value = this.pojo(fieldPojoDeserializer.createPojo());
                                }
                                this.setFieldValue(entity, fieldDeserializer, value);
                                while ((b = buf[++i]) <= 32) {
                                }
                                if (b == 44) continue;
                                if (b == 125) {
                                    jsonParseContext.endIndex = i;
                                    return this.pojo(entity);
                                }
                                String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                                throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
                            }
                            isDeserialize = false;
                        }
                        catch (Throwable throwable) {
                            throw new JSONException(throwable.getMessage(), throwable);
                        }
                    }
                    Object value = ANY.deserialize(charSource, buf, i, toIndex, null, null, (byte)125, jsonParseContext);
                    if (fieldDeserializer.isInstance(value)) {
                        this.setFieldValue(entity, fieldDeserializer, value);
                        i = jsonParseContext.endIndex;
                        while ((b = buf[++i]) <= 32) {
                        }
                        if (b == 44) continue;
                        if (b == 125) {
                            jsonParseContext.endIndex = i;
                            return this.pojo(entity);
                        }
                        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
                        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
                    }
                    break block51;
                }
                boolean camouflage = valueType.isCamouflage();
                if (camouflage) {
                    valueType = this.getGenericValueType(parameterizedType, valueType);
                    if (!fieldDeserializer.isCustomDeserialize()) {
                        deserializer = JSONPojoDeserializer.getTypeDeserializer(valueType.getActualType());
                    }
                }
            }
            if (isDeserialize) {
                Object value = deserializer.deserialize(charSource, buf, i, toIndex, valueType, defaultFieldValue, (byte)125, jsonParseContext);
                this.setFieldValue(entity, fieldDeserializer, value);
            } else {
                JSONTypeDeserializer.ANY.skip(charSource, buf, i, toIndex, (byte)125, jsonParseContext);
            }
            i = jsonParseContext.endIndex;
            int endChar = jsonParseContext.endChar;
            if (endChar == 0) {
                while ((b = buf[++i]) <= 32) {
                }
            } else {
                b = (byte)endChar;
                jsonParseContext.endChar = 0;
            }
            if (b != 44) break;
        }
        if (b == 125) {
            jsonParseContext.endIndex = i;
            return this.pojo(entity);
        }
        String errorContextTextAt = JSONPojoDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected '" + (char)b + "', expected ',' or '}'");
    }

    protected JSONPojoFieldDeserializer getFieldDeserializer(char[] buf, int offset, int endIndex, long hashValue) {
        JSONPojoFieldDeserializer fieldDeserializer = this.pojoStructureWrapper.getFieldDeserializer(buf, offset, endIndex, hashValue);
        return fieldDeserializer;
    }

    protected JSONPojoFieldDeserializer getFieldDeserializer(byte[] buf, int offset, int endIndex, long hashValue) {
        JSONPojoFieldDeserializer fieldDeserializer = this.pojoStructureWrapper.getFieldDeserializer(buf, offset, endIndex, hashValue);
        return fieldDeserializer;
    }

    private GenericParameterizedType getGenericValueType(GenericParameterizedType parameterizedType, GenericParameterizedType valueType) {
        if (parameterizedType != null) {
            Class<?> actualType = parameterizedType.getGenericClass(valueType.getGenericName());
            valueType = GenericParameterizedType.actualType(actualType);
        }
        return valueType;
    }

    public final T deserialize(String json, ReadOption ... options) {
        if (EnvUtils.JDK_9_PLUS) {
            byte coder = UnsafeHelper.getStringCoder(json);
            if (coder == 0) {
                AsciiStringSource charSource = AsciiStringSource.of(json);
                return this.deserialize((CharSource)charSource, charSource.byteArray(), options);
            }
            char[] chars = JSONPojoDeserializer.getChars(json);
            return this.deserialize((CharSource)UTF16ByteArraySource.of(json), chars, options);
        }
        return this.deserialize(JSONPojoDeserializer.getChars(json), options);
    }

    public final T deserialize(char[] buf, ReadOption ... options) {
        return this.deserialize(null, buf, options);
    }

    private T deserialize(CharSource charSource, char[] buf, ReadOption ... options) {
        T entity;
        int fromIndex;
        int toIndex = buf.length;
        char beginChar = '\u0000';
        for (fromIndex = 0; fromIndex < toIndex && (beginChar = buf[fromIndex]) <= ' '; ++fromIndex) {
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= ' ') {
            --toIndex;
        }
        if (beginChar != '{') {
            throw new JSONException("The first non empty character is not '{'");
        }
        JSONNodeContext jsonParseContext = new JSONNodeContext();
        JSONOptions.readOptions(options, jsonParseContext);
        try {
            entity = this.createPojo();
            this.deserializePojo(charSource, buf, fromIndex, toIndex, this.getGenericParameterizedType(), entity, '}', (JSONParseContext)jsonParseContext);
        }
        catch (Throwable throwable) {
            JSONPojoDeserializer.handleCatchException(throwable, buf, toIndex);
            throw new JSONException(throwable.getMessage(), throwable);
        }
        return entity;
    }

    public final T deserialize(byte[] buf, ReadOption ... options) {
        return this.deserialize(null, buf, options);
    }

    private T deserialize(CharSource charSource, byte[] buf, ReadOption ... options) {
        T entity;
        int fromIndex;
        int toIndex = buf.length;
        byte beginByte = 0;
        for (fromIndex = 0; fromIndex < toIndex && (beginByte = buf[fromIndex]) <= 32; ++fromIndex) {
        }
        while (toIndex > fromIndex && buf[toIndex - 1] <= 32) {
            --toIndex;
        }
        if (beginByte != 123) {
            throw new JSONException("The first non empty character is not '{'");
        }
        JSONNodeContext jsonParseContext = new JSONNodeContext();
        JSONOptions.readOptions(options, jsonParseContext);
        try {
            entity = this.createPojo();
            this.deserializePojo(charSource, buf, fromIndex, toIndex, this.getGenericParameterizedType(), entity, (byte)125, (JSONParseContext)jsonParseContext);
        }
        catch (Throwable throwable) {
            JSONPojoDeserializer.handleCatchException(throwable, buf, toIndex);
            throw new JSONException(throwable.getMessage(), throwable);
        }
        return entity;
    }

    protected void setFieldValue(T entity, JSONPojoFieldDeserializer fieldDeserializer, Object value) {
        fieldDeserializer.invoke(entity, value);
    }

    protected T createPojo() throws Exception {
        return (T)this.pojoStructureWrapper.newInstance();
    }

    @Override
    protected final GenericParameterizedType getGenericParameterizedType() {
        return this.pojoStructureWrapper.getGenericType();
    }

    protected final JSONPojoFieldDeserializer getFieldDeserializer(long hashValue) {
        return this.pojoStructureWrapper.getFieldDeserializer(hashValue);
    }

    protected final boolean isCollision() {
        return this.pojoStructureWrapper.isCollision();
    }

    public static class JSONRecordDeserializer<T>
    extends JSONPojoDeserializer {
        JSONRecordDeserializer(JSONPojoStructure objectStructureWrapper) {
            super(objectStructureWrapper);
        }

        protected Object createPojo() throws Exception {
            return this.pojoStructureWrapper.createConstructorArgs();
        }

        protected final void setFieldValue(Object entity, JSONPojoFieldDeserializer fieldDeserializer, Object value) {
            Object[] argValues = (Object[])entity;
            argValues[fieldDeserializer.getIndex()] = value;
        }

        @Override
        protected JSONPojoFieldDeserializer getFieldDeserializer(char[] buf, int offset, int endIndex, long hashValue) {
            if (!this.isCollision()) {
                return this.getFieldDeserializer(hashValue);
            }
            return super.getFieldDeserializer(buf, offset, endIndex, hashValue);
        }

        @Override
        protected JSONPojoFieldDeserializer getFieldDeserializer(byte[] buf, int offset, int endIndex, long hashValue) {
            if (!this.isCollision()) {
                return this.getFieldDeserializer(hashValue);
            }
            return super.getFieldDeserializer(buf, offset, endIndex, hashValue);
        }

        @Override
        protected final Object pojo(Object value) {
            try {
                return this.pojoStructureWrapper.newInstance((Object[])value);
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }
}

