/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.annotations.JsonDeserialize;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.custom.JsonDeserializer;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JSONPojoFieldDeserializer
extends JSONTypeDeserializer {
    private final String name;
    private final SetterInfo setterInfo;
    private final JsonProperty jsonProperty;
    private GenericParameterizedType genericParameterizedType;
    private final ReflectConsts.ClassCategory classCategory;
    private Class<?> implClass;
    private JSONTypeDeserializer deserializer;
    private boolean customDeserialize = false;
    private final String pattern;
    private final String timezone;
    private boolean initialized;
    private static final Map<Class<? extends JsonDeserializer>, JsonDeserializer> customDeserializers = new ConcurrentHashMap<Class<? extends JsonDeserializer>, JsonDeserializer>();

    JSONPojoFieldDeserializer(String name, SetterInfo setterInfo, JsonProperty jsonProperty) {
        if (setterInfo == null) {
            throw new IllegalArgumentException("setterInfo is null");
        }
        this.name = name;
        this.setterInfo = setterInfo;
        this.jsonProperty = jsonProperty;
        this.genericParameterizedType = setterInfo.getGenericParameterizedType();
        Class<?> actualClass = this.genericParameterizedType.getActualType();
        this.classCategory = ReflectConsts.getClassCategory(actualClass);
        String pattern = null;
        String timezone = null;
        if (jsonProperty != null) {
            pattern = jsonProperty.pattern().trim();
            timezone = jsonProperty.timezone().trim();
            if (pattern.length() == 0) {
                pattern = null;
            }
            if (timezone.length() == 0) {
                timezone = null;
            }
        }
        this.pattern = pattern;
        this.timezone = timezone;
    }

    void initDeserializer() {
        if (!this.initialized) {
            boolean unfixedType = false;
            if (this.jsonProperty != null) {
                Class<?> impl = this.jsonProperty.impl();
                if (impl != Object.class && this.isAvailableImpl(impl)) {
                    this.implClass = impl;
                }
                unfixedType = this.jsonProperty.unfixedType();
            }
            if (this.implClass != null) {
                this.deserializer = JSONPojoFieldDeserializer.getTypeDeserializer(this.implClass);
                this.genericParameterizedType = GenericParameterizedType.actualType(this.implClass);
            } else {
                this.deserializer = this.setterInfo.isNonInstanceType() ? (this.genericParameterizedType.getActualType() == Serializable.class ? SERIALIZABLE_DESERIALIZER : null) : (this.genericParameterizedType.getActualClassCategory() == ReflectConsts.ClassCategory.ObjectCategory && unfixedType ? null : this.getDeserializer(this.genericParameterizedType));
            }
            this.initialized = true;
        }
    }

    private JSONTypeDeserializer getDeserializer(GenericParameterizedType genericParameterizedType) {
        JsonDeserialize jsonDeserialize = (JsonDeserialize)this.setterInfo.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null) {
            Class<? extends JsonDeserializer> jsonDeserializerClass = jsonDeserialize.value();
            this.customDeserialize = true;
            try {
                if (jsonDeserialize.singleton()) {
                    JsonDeserializer jsonDeserializer = customDeserializers.get(jsonDeserializerClass);
                    if (jsonDeserializer == null) {
                        jsonDeserializer = jsonDeserializerClass.newInstance();
                        customDeserializers.put(jsonDeserializerClass, jsonDeserializer);
                    }
                    return jsonDeserializer;
                }
                return jsonDeserializerClass.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return JSONTypeDeserializer.getFieldDeserializer(genericParameterizedType, this.jsonProperty);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustomDeserialize() {
        return this.customDeserialize;
    }

    public SetterInfo getSetterInfo() {
        return this.setterInfo;
    }

    @Override
    public GenericParameterizedType getGenericParameterizedType() {
        return this.genericParameterizedType;
    }

    @Override
    protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public JSONTypeDeserializer getDeserializer() {
        return this.deserializer;
    }

    public Object getDefaultFieldValue(Object instance) {
        return this.setterInfo.getDefaultFieldValue(instance);
    }

    public int getIndex() {
        return this.setterInfo.getIndex();
    }

    public void invoke(Object entity, Object value) {
        this.setterInfo.invoke(entity, value);
    }

    public String getDatePattern() {
        return this.pattern;
    }

    public String getDateTimezone() {
        return this.timezone;
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public boolean isAvailableImpl(Class<?> cls) {
        boolean assignableFrom = this.genericParameterizedType.getActualType().isAssignableFrom(cls);
        if (!assignableFrom) {
            return false;
        }
        switch (this.classCategory) {
            case MapCategory: 
            case CollectionCategory: 
            case ObjectCategory: {
                return true;
            }
        }
        return false;
    }

    public boolean isInstance(Object value) {
        return value == null || this.genericParameterizedType.getActualType().isInstance(value);
    }
}

