/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.compiler.JavaSourceObject;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.JSONPojoStructure;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class JSONPojoSerializer<T>
extends JSONTypeSerializer {
    protected final JSONPojoStructure pojoStructure;
    protected final Class<?> pojoClass;
    static final String IMPORT_CODE_TEXT = "import io.github.wycst.wast.json.JSONConfig;\nimport io.github.wycst.wast.json.JSONPojoFieldSerializer;\nimport io.github.wycst.wast.json.JSONPojoStructure;\n\nimport io.github.wycst.wast.json.JSONWriter;\n\n";
    static final AtomicLong SEQ = new AtomicLong(1L);

    protected JSONPojoSerializer(Class<T> pojoClass) {
        this.pojoClass = pojoClass;
        this.pojoStructure = JSONPojoStructure.get(pojoClass);
        this.init();
    }

    protected JSONPojoSerializer(JSONPojoStructure pojoStructure) {
        this.pojoStructure = pojoStructure;
        this.pojoClass = pojoStructure.getSourceClass();
        this.init();
    }

    public void init() {
    }

    public void serializePojoCompact(T entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        boolean writeFullProperty = jsonConfig.isFullProperty();
        boolean writeClassName = jsonConfig.isWriteClassName();
        boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, this.pojoClass, false, indentLevel, jsonConfig);
        JSONPojoFieldSerializer[] fieldSerializers = this.pojoStructure.getFieldSerializers(jsonConfig.isUseFields());
        boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
        boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
        for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
            Object value;
            GetterInfo getterInfo = fieldSerializer.getGetterInfo();
            if (!getterInfo.existField() && skipGetterOfNoExistField || (value = getterInfo.invoke(entity)) == null && !writeFullProperty) continue;
            if (isEmptyFlag) {
                isEmptyFlag = false;
            } else {
                writer.writeJSONToken(',');
            }
            if (value != null) {
                if (unCamelCaseToUnderline) {
                    fieldSerializer.writeJSONFieldName(writer);
                } else {
                    writer.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                }
                JSONTypeSerializer serializer = fieldSerializer.getSerializer();
                serializer.serialize(value, writer, jsonConfig, -1);
                continue;
            }
            if (unCamelCaseToUnderline) {
                fieldSerializer.writeJSONFieldNameWithNull(writer);
                continue;
            }
            writer.append('\"').append(getterInfo.getUnderlineName()).append("\":null");
        }
    }

    public void serializePojoFormatOut(T entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        boolean writeFullProperty = jsonConfig.isFullProperty();
        boolean writeClassName = jsonConfig.isWriteClassName();
        boolean formatOutColonSpace = jsonConfig.isFormatOutColonSpace();
        boolean isEmptyFlag = !this.checkWriteClassName(writeClassName, writer, this.pojoClass, true, indentLevel, jsonConfig);
        JSONPojoFieldSerializer[] fieldSerializers = this.pojoStructure.getFieldSerializers(jsonConfig.isUseFields());
        boolean skipGetterOfNoExistField = jsonConfig.isSkipGetterOfNoneField();
        boolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();
        int indentPlus = indentLevel + 1;
        for (JSONPojoFieldSerializer fieldSerializer : fieldSerializers) {
            Object value;
            GetterInfo getterInfo = fieldSerializer.getGetterInfo();
            if (!getterInfo.existField() && skipGetterOfNoExistField || (value = getterInfo.invoke(entity)) == null && !writeFullProperty) continue;
            if (isEmptyFlag) {
                isEmptyFlag = false;
            } else {
                writer.writeJSONToken(',');
            }
            JSONPojoSerializer.writeFormatOutSymbols(writer, indentPlus, true, jsonConfig);
            if (value != null) {
                if (unCamelCaseToUnderline) {
                    fieldSerializer.writeJSONFieldName(writer);
                } else {
                    writer.append('\"').append(getterInfo.getUnderlineName()).append("\":");
                }
                if (formatOutColonSpace) {
                    writer.writeJSONToken(' ');
                }
                JSONTypeSerializer serializer = fieldSerializer.getSerializer();
                serializer.serialize(value, writer, jsonConfig, indentPlus);
                continue;
            }
            if (unCamelCaseToUnderline) {
                if (formatOutColonSpace) {
                    fieldSerializer.writeJSONFieldName(writer);
                    writer.write(" null");
                    continue;
                }
                fieldSerializer.writeJSONFieldNameWithNull(writer);
                continue;
            }
            writer.writeJSONToken('\"');
            writer.write(getterInfo.getUnderlineName());
            writer.writeJSONToken('\"');
            if (formatOutColonSpace) {
                writer.write(": null");
                continue;
            }
            writer.write(":null");
        }
        if (!isEmptyFlag) {
            JSONPojoSerializer.writeFormatOutSymbols(writer, indentLevel, true, jsonConfig);
        }
    }

    @Override
    protected final void serialize(Object obj, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        Class<?> entityClass = obj.getClass();
        if (entityClass == this.pojoClass) {
            int hashcode = -1;
            if (jsonConfig.isSkipCircularReference()) {
                hashcode = System.identityHashCode(obj);
                if (jsonConfig.getStatus(hashcode) == 0) {
                    writer.write(NULL);
                    return;
                }
                jsonConfig.setStatus(hashcode, 0);
            }
            this.pojoStructure.ensureInitialized();
            writer.writeJSONToken('{');
            boolean formatOut = jsonConfig.isFormatOut();
            Object entity = obj;
            if (formatOut) {
                this.serializePojoFormatOut(entity, writer, jsonConfig, indentLevel);
            } else {
                this.serializePojoCompact(entity, writer, jsonConfig, indentLevel);
            }
            this.writeEndPojo(writer);
            jsonConfig.setStatus(hashcode, -1);
        } else {
            JSONTypeSerializer serializer = JSONPojoSerializer.getTypeSerializer(entityClass);
            serializer.serialize(obj, writer, jsonConfig, indentLevel);
        }
    }

    protected void writeEndPojo(JSONWriter writer) throws IOException {
        writer.write(125);
    }

    protected final void doSerialize(JSONTypeSerializer serializer, Object fieldValue, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {
        serializer.serialize(fieldValue, writer, jsonConfig, indentLevel);
    }

    static JavaSourceObject generateRuntimeJavaCodeSource(JSONPojoStructure jsonPojoStructure) {
        return JSONPojoSerializer.generateJavaCodeSource(jsonPojoStructure, false, true);
    }

    static JavaSourceObject generateJavaCodeSource(JSONPojoStructure jsonPojoStructure, boolean printSource, boolean runtime) {
        Class<?> pojoClass = jsonPojoStructure.getSourceClass();
        String simpleName = pojoClass.getSimpleName();
        String canonicalName = pojoClass.getCanonicalName();
        String genClassName = "__JPS_" + simpleName + "_" + SEQ.getAndIncrement();
        String packageName = pojoClass.getPackage().getName();
        StringBuilder codeBuilder = new StringBuilder(2048);
        codeBuilder.append("package ").append(packageName).append(";\n\n");
        codeBuilder.append(IMPORT_CODE_TEXT);
        if (!runtime) {
            codeBuilder.append("/**\n");
            codeBuilder.append(" * pojo serializer \n");
            codeBuilder.append(" * @Date " + new GregorianDate() + "\n");
            codeBuilder.append(" * @Created by code generator\n");
            codeBuilder.append(" */\n");
        }
        codeBuilder.append("public class ").append(genClassName).append(" extends io.github.wycst.wast.json.JSONPojoSerializer<").append(canonicalName).append("> {\n\n");
        StringBuilder fieldsDefinitionBuilder = new StringBuilder(64);
        StringBuilder fieldSetBuilder = new StringBuilder(64);
        StringBuilder serializePojoCompactBuilder = new StringBuilder(1024);
        serializePojoCompactBuilder.append("\t\tboolean isEmptyFlag = !checkWriteClassName(jsonConfig.isWriteClassName(), writer, pojoClass, false, indentLevel, jsonConfig);\n\t\tboolean unCamelCaseToUnderline = !jsonConfig.isCamelCaseToUnderline();\n\n");
        JSONPojoFieldSerializer[] fieldSerializerUseMethods = jsonPojoStructure.getFieldSerializers(false);
        fieldsDefinitionBuilder.append("\n");
        StringBuilder fieldNameTempBuilder = new StringBuilder();
        boolean appendFieldSerializersFlag = false;
        if (fieldSerializerUseMethods.length > 0) {
            int fieldIndex = 0;
            boolean ensureNotEmptyFlag = false;
            for (JSONPojoFieldSerializer fieldSerializer : fieldSerializerUseMethods) {
                boolean useUnsafe;
                boolean firstFlag = fieldIndex == 0;
                GetterInfo getterInfo = fieldSerializer.getGetterInfo();
                String name = getterInfo.getName();
                String underlineName = getterInfo.getUnderlineName();
                boolean nameEqualUnderlineName = name.equals(underlineName);
                boolean primitive = getterInfo.isPrimitive();
                Class<?> returnType = getterInfo.getReturnType();
                String returnTypeName = returnType.getName().intern();
                boolean accessFlag = getterInfo.isAccess() && Modifier.isPublic(returnType.getModifiers());
                String fieldSerializerName = name + "UseMethodSerializer";
                String valueVar = fieldSerializer.getName();
                byte[] bytes = valueVar.getBytes();
                boolean isFieldNameAscii = bytes.length == valueVar.length();
                long[] longs = null;
                long[] longsWithComma = null;
                int[] ints = null;
                int[] intsWithComma = null;
                int fieldNameTokenLength = 0;
                boolean bl = useUnsafe = runtime && isFieldNameAscii && bytes.length <= 12;
                if (useUnsafe) {
                    fieldNameTempBuilder.setLength(0);
                    fieldNameTempBuilder.append(",\"").append(valueVar).append("\":");
                    fieldNameTokenLength = fieldNameTempBuilder.length();
                    longs = UnsafeHelper.getLongs(fieldNameTempBuilder.substring(1));
                    longsWithComma = UnsafeHelper.getLongs(fieldNameTempBuilder.toString());
                    ints = UnsafeHelper.getInts(fieldNameTempBuilder.substring(1));
                    intsWithComma = UnsafeHelper.getInts(fieldNameTempBuilder.toString());
                }
                if (accessFlag) {
                    serializePojoCompactBuilder.append("\t\t" + returnType.getCanonicalName() + " " + valueVar + " = entity." + getterInfo.generateCode() + ";\n");
                    if (primitive) {
                        boolean isBoolean;
                        boolean bl2 = isBoolean = returnType == Boolean.TYPE;
                        if (firstFlag) {
                            if (isBoolean) {
                                serializePojoCompactBuilder.append("\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t}\n");
                            } else {
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                    serializePojoCompactBuilder.append("\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBuilder.append("\t\t}\n");
                                }
                                if (returnType == Double.TYPE) {
                                    serializePojoCompactBuilder.append("\t\tif(jsonConfig.isWriteDecimalUseToString()) {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(Double.toString(" + valueVar + "));\n");
                                    serializePojoCompactBuilder.append("\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.writeDouble(" + valueVar + ");\n");
                                    serializePojoCompactBuilder.append("\t\t}\n");
                                } else if (returnType == Float.TYPE) {
                                    serializePojoCompactBuilder.append("\t\tif(jsonConfig.isWriteDecimalUseToString()) {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(Float.toString(" + valueVar + "));\n");
                                    serializePojoCompactBuilder.append("\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.writeFloat(" + valueVar + ");\n");
                                    serializePojoCompactBuilder.append("\t\t}\n");
                                } else if (returnType == Long.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Byte.TYPE) {
                                    serializePojoCompactBuilder.append("\t\twriter.writeLong(" + valueVar + ");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                                    serializePojoCompactBuilder.append("\t\twriter.write(" + valueVar + ");\n");
                                    serializePojoCompactBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                                }
                            }
                        } else if (isBoolean) {
                            if (ensureNotEmptyFlag) {
                                serializePojoCompactBuilder.append("\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t}\n");
                            } else {
                                serializePojoCompactBuilder.append("\t\tif(isEmptyFlag) {\n");
                                serializePojoCompactBuilder.append("\t\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t}\n");
                                serializePojoCompactBuilder.append("\t\t} else {\n");
                                serializePojoCompactBuilder.append("\t\t\tif(" + valueVar + ") {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":true\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":false\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t}\n");
                                serializePojoCompactBuilder.append("\t\t}\n");
                            }
                        } else {
                            int len;
                            int i;
                            int total;
                            if (ensureNotEmptyFlag) {
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                        for (i = 0; i < longsWithComma.length; ++i) {
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBuilder.append("\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                    } else {
                                        serializePojoCompactBuilder.append("\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                        for (i = 0; i < longsWithComma.length; ++i) {
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBuilder.append("\t\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                    } else {
                                        serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                    serializePojoCompactBuilder.append("\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBuilder.append("\t\t}\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\tif(isEmptyFlag) {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                        for (i = 0; i < longs.length; ++i) {
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBuilder.append("\t\t\twriter.writeUnsafe(" + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                    } else {
                                        serializePojoCompactBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength - 1;
                                    if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                        for (i = 0; i < longs.length; ++i) {
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeUnsafe(" + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                    } else {
                                        serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                    }
                                    serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t} else {\n");
                                if (nameEqualUnderlineName) {
                                    total = fieldNameTokenLength;
                                    if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                        for (i = 0; i < longsWithComma.length; ++i) {
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBuilder.append("\t\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                    } else {
                                        serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                    total = fieldNameTokenLength;
                                    if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                        for (i = 0; i < longsWithComma.length; ++i) {
                                            len = total > 4 ? 4 : total;
                                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                            total -= 4;
                                        }
                                    } else {
                                        serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                    }
                                    serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                    serializePojoCompactBuilder.append("\t\t\t}\n");
                                }
                                serializePojoCompactBuilder.append("\t\t}\n");
                            }
                            if (returnType == Double.TYPE) {
                                serializePojoCompactBuilder.append("\t\tif(jsonConfig.isWriteDecimalUseToString()) {\n");
                                serializePojoCompactBuilder.append("\t\t\twriter.write(Double.toString(" + valueVar + "));\n");
                                serializePojoCompactBuilder.append("\t\t} else {\n");
                                serializePojoCompactBuilder.append("\t\t\twriter.writeDouble(" + valueVar + ");\n");
                                serializePojoCompactBuilder.append("\t\t}\n");
                            } else if (returnType == Float.TYPE) {
                                serializePojoCompactBuilder.append("\t\tif(jsonConfig.isWriteDecimalUseToString()) {\n");
                                serializePojoCompactBuilder.append("\t\t\twriter.write(Float.toString(" + valueVar + "));\n");
                                serializePojoCompactBuilder.append("\t\t} else {\n");
                                serializePojoCompactBuilder.append("\t\t\twriter.writeFloat(" + valueVar + ");\n");
                                serializePojoCompactBuilder.append("\t\t}\n");
                            } else if (returnType == Long.TYPE || returnType == Integer.TYPE || returnType == Short.TYPE || returnType == Byte.TYPE) {
                                serializePojoCompactBuilder.append("\t\twriter.writeLong(" + valueVar + ");\n");
                            } else if (returnType == Character.TYPE) {
                                serializePojoCompactBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                                serializePojoCompactBuilder.append("\t\twriter.write(" + valueVar + ");\n");
                                serializePojoCompactBuilder.append("\t\twriter.writeJSONToken('\"');\n");
                            }
                        }
                        ensureNotEmptyFlag = true;
                    } else {
                        int len;
                        int i;
                        int total;
                        serializePojoCompactBuilder.append("\t\tif(" + valueVar + " != null) {\n");
                        if (firstFlag) {
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longs.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\twriter.writeUnsafe(" + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longs.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\t\twriter.writeUnsafe(" + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBuilder.append("\t\t\t}\n");
                            }
                            serializePojoCompactBuilder.append("\t\t\tisEmptyFlag = false;\n");
                        } else if (ensureNotEmptyFlag) {
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longsWithComma.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longsWithComma.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t} else {\n");
                                serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBuilder.append("\t\t\t}\n");
                            }
                        } else {
                            serializePojoCompactBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longs.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\t\twriter.writeUnsafe(" + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength - 1;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longs.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeUnsafe(" + longs[i] + "L, " + ints[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                                serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBuilder.append("\t\t\t\t}\n");
                            }
                            serializePojoCompactBuilder.append("\t\t\t} else {\n");
                            if (nameEqualUnderlineName) {
                                total = fieldNameTokenLength;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longsWithComma.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                                total = fieldNameTokenLength;
                                if (useUnsafe && ((total & 3) == 0 || (total & 3) == 3)) {
                                    for (i = 0; i < longsWithComma.length; ++i) {
                                        len = total > 4 ? 4 : total;
                                        serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeUnsafe(" + longsWithComma[i] + "L, " + intsWithComma[i] + ", " + len + ");\n");
                                        total -= 4;
                                    }
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                                }
                                serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                                serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                                serializePojoCompactBuilder.append("\t\t\t\t}\n");
                            }
                            serializePojoCompactBuilder.append("\t\t\t}\n");
                        }
                        boolean useSerializerInvokeFlag = false;
                        if (returnType == String.class) {
                            if (runtime) {
                                if (EnvUtils.JDK_9_PLUS) {
                                    serializePojoCompactBuilder.append("\t\t\twriter.writeJSONStringBytes(" + valueVar + ", (byte[]) getStringValue(" + valueVar + "));\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\twriter.writeJSONChars(getChars(" + valueVar + "));\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\t\twriter.writeJSONString(" + valueVar + ");\n");
                            }
                        } else if (returnType == BigDecimal.class) {
                            serializePojoCompactBuilder.append("\t\t\twriter.write(" + valueVar + ".toString());\n");
                        } else if (returnType == BigInteger.class) {
                            serializePojoCompactBuilder.append("\t\t\twriter.writeBigInteger(" + valueVar + ");\n");
                        } else if (returnType == String[].class) {
                            serializePojoCompactBuilder.append("\t\t\tif (" + valueVar + ".length > 0) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeJSONToken('[');\n");
                            serializePojoCompactBuilder.append("\t\t\t\tString item = " + valueVar + "[0];\n");
                            serializePojoCompactBuilder.append("\t\t\t\tif (item != null) {\n");
                            if (runtime) {
                                if (EnvUtils.JDK_9_PLUS) {
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeJSONStringBytes(item, (byte[]) getStringValue(item));\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeJSONChars(getChars(item));\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeJSONString(item);\n");
                            }
                            serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(NULL);\n");
                            serializePojoCompactBuilder.append("\t\t\t\t}\n");
                            serializePojoCompactBuilder.append("\t\t\t\tfor (int i = 1; i < " + valueVar + ".length; ++i) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\titem = " + valueVar + "[i];\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeJSONToken(',');\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\tif (item != null) {\n");
                            if (runtime) {
                                if (EnvUtils.JDK_9_PLUS) {
                                    serializePojoCompactBuilder.append("\t\t\t\t\t\twriter.writeJSONStringBytes(item, (byte[]) getStringValue(item));\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\t\t\t\twriter.writeJSONChars(getChars(item));\n");
                                }
                            } else {
                                serializePojoCompactBuilder.append("\t\t\t\t\t\twriter.writeJSONString(item);\n");
                            }
                            serializePojoCompactBuilder.append("\t\t\t\t\t} else {\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\t\twriter.write(NULL);\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\t}\n");
                            serializePojoCompactBuilder.append("\t\t\t\t}\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeJSONToken(']');\n");
                            serializePojoCompactBuilder.append("\t\t\t} else {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"[]\");\n");
                            serializePojoCompactBuilder.append("\t\t\t}\n");
                        } else if (returnType == long[].class) {
                            serializePojoCompactBuilder.append("\t\t\tif (" + valueVar + ".length > 0) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeJSONToken('[');\n");
                            serializePojoCompactBuilder.append("\t\t\t\tlong item = " + valueVar + "[0];\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeLong(item);\n");
                            serializePojoCompactBuilder.append("\t\t\t\tfor (int i = 1; i < " + valueVar + ".length; ++i) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\titem = " + valueVar + "[i];\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeJSONToken(',');\n");
                            serializePojoCompactBuilder.append("\t\t\t\t\twriter.writeLong(item);\n");
                            serializePojoCompactBuilder.append("\t\t\t\t}\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeJSONToken(']');\n");
                            serializePojoCompactBuilder.append("\t\t\t} else {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"[]\");\n");
                            serializePojoCompactBuilder.append("\t\t\t}\n");
                        } else if (returnType == UUID.class) {
                            serializePojoCompactBuilder.append("\t\t\twriter.writeUUID(" + valueVar + ");\n");
                        } else if (returnType.isEnum()) {
                            serializePojoCompactBuilder.append("\t\t\tif(jsonConfig.isWriteEnumAsOrdinal()) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeLong(" + valueVar + ".ordinal());\n");
                            serializePojoCompactBuilder.append("\t\t\t} else {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeJSONToken('\"');\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.write(" + valueVar + ".name());\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.writeJSONToken('\"');\n");
                            serializePojoCompactBuilder.append("\t\t\t}\n");
                        } else if (returnTypeName == "java.time.Instant") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBuilder.append("\t\t\twriter.writeJSONInstant(" + valueVar + ".getEpochSecond(), " + valueVar + ".getNano());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBuilder.append("\t\t\twriter.writeJSONTimeWithNano(" + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalDate") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBuilder.append("\t\t\twriter.writeJSONLocalDate(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth());\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.LocalDateTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                serializePojoCompactBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), null);\n");
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else if (returnTypeName == "java.time.ZonedDateTime" || returnTypeName == "java.time.OffsetDateTime") {
                            if (fieldSerializer.getJsonProperty() == null || fieldSerializer.getJsonProperty().pattern().length() == 0) {
                                if (returnTypeName == "java.time.ZonedDateTime") {
                                    serializePojoCompactBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getZone().getId());\n");
                                } else {
                                    serializePojoCompactBuilder.append("\t\t\twriter.writeJSONLocalDateTime(" + valueVar + ".getYear(), " + valueVar + ".getMonthValue(), " + valueVar + ".getDayOfMonth(), " + valueVar + ".getHour(), " + valueVar + ".getMinute(), " + valueVar + ".getSecond(), " + valueVar + ".getNano(), " + valueVar + ".getOffset().getId());\n");
                                }
                            } else {
                                useSerializerInvokeFlag = true;
                            }
                        } else {
                            useSerializerInvokeFlag = true;
                        }
                        if (useSerializerInvokeFlag) {
                            if (!appendFieldSerializersFlag) {
                                appendFieldSerializersFlag = true;
                                fieldSetBuilder.append("\t\tJSONPojoFieldSerializer[] fieldSerializerUseMethods = pojoStructure.getFieldSerializers(false);\n");
                            }
                            fieldsDefinitionBuilder.append("\tfinal JSONPojoFieldSerializer ").append(fieldSerializerName).append(";\n");
                            fieldSetBuilder.append("\t\tthis.").append(fieldSerializerName).append(" = ").append("fieldSerializerUseMethods[").append(fieldIndex).append("];\n");
                            serializePojoCompactBuilder.append("\t\t\tdoSerialize(" + fieldSerializerName + ".getSerializer(), " + valueVar + ", writer, jsonConfig, -1);\n");
                        }
                        serializePojoCompactBuilder.append("\t\t}\n");
                    }
                } else {
                    if (!appendFieldSerializersFlag) {
                        appendFieldSerializersFlag = true;
                        fieldSetBuilder.append("\t\tJSONPojoFieldSerializer[] fieldSerializerUseMethods = pojoStructure.getFieldSerializers(false);\n");
                    }
                    fieldsDefinitionBuilder.append("\tfinal JSONPojoFieldSerializer ").append(fieldSerializerName).append(";\n");
                    fieldSetBuilder.append("\t\tthis.").append(fieldSerializerName).append(" = ").append("fieldSerializerUseMethods[").append(fieldIndex).append("];\n");
                    serializePojoCompactBuilder.append("\t\tObject " + valueVar + " = " + fieldSerializerName + ".invoke(entity);\n");
                    serializePojoCompactBuilder.append("\t\tif(" + valueVar + " != null) {\n");
                    if (firstFlag) {
                        if (nameEqualUnderlineName) {
                            serializePojoCompactBuilder.append("\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                        } else {
                            serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                            serializePojoCompactBuilder.append("\t\t\t} else {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                            serializePojoCompactBuilder.append("\t\t\t}\n");
                        }
                        serializePojoCompactBuilder.append("\t\t\tisEmptyFlag = false;\n");
                    } else if (ensureNotEmptyFlag) {
                        if (nameEqualUnderlineName) {
                            serializePojoCompactBuilder.append("\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                        } else {
                            serializePojoCompactBuilder.append("\t\t\tif (unCamelCaseToUnderline) {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                            serializePojoCompactBuilder.append("\t\t\t} else {\n");
                            serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                            serializePojoCompactBuilder.append("\t\t\t}\n");
                        }
                    } else if (nameEqualUnderlineName) {
                        serializePojoCompactBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                        serializePojoCompactBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                        serializePojoCompactBuilder.append("\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBuilder.append("\t\t\t} else {\n");
                        serializePojoCompactBuilder.append("\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBuilder.append("\t\t\t}\n");
                    } else {
                        serializePojoCompactBuilder.append("\t\t\tif(isEmptyFlag) {\n");
                        serializePojoCompactBuilder.append("\t\t\t\tisEmptyFlag = false;\n");
                        serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                        serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                        serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\"\\\"" + underlineName + "\\\":\");\n");
                        serializePojoCompactBuilder.append("\t\t\t\t}\n");
                        serializePojoCompactBuilder.append("\t\t\t} else {\n");
                        serializePojoCompactBuilder.append("\t\t\t\tif (unCamelCaseToUnderline) {\n");
                        serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + valueVar + "\\\":\");\n");
                        serializePojoCompactBuilder.append("\t\t\t\t} else {\n");
                        serializePojoCompactBuilder.append("\t\t\t\t\twriter.write(\",\\\"" + underlineName + "\\\":\");\n");
                        serializePojoCompactBuilder.append("\t\t\t\t}\n");
                        serializePojoCompactBuilder.append("\t\t\t}\n");
                    }
                    serializePojoCompactBuilder.append("\t\t\tdoSerialize(" + fieldSerializerName + ".getSerializer(), " + valueVar + ", writer, jsonConfig, -1);\n");
                    serializePojoCompactBuilder.append("\t\t}\n");
                }
                serializePojoCompactBuilder.append("\n");
                ++fieldIndex;
            }
        }
        if (!runtime) {
            codeBuilder.append("\tpublic ").append(genClassName).append("() {\n");
            codeBuilder.append("\t\tthis(JSONPojoStructure.get(" + canonicalName + ".class));\n");
            codeBuilder.append("\t}\n\n");
        }
        codeBuilder.append("\tprotected ").append(genClassName).append("(JSONPojoStructure pojoStructure) {\n");
        codeBuilder.append("\t\tsuper(pojoStructure);\n");
        codeBuilder.append((CharSequence)fieldSetBuilder);
        codeBuilder.append("\t}\n");
        codeBuilder.append((CharSequence)fieldsDefinitionBuilder).append("\n");
        codeBuilder.append("\tpublic void serializePojoCompact(").append(canonicalName).append(" entity, JSONWriter writer, JSONConfig jsonConfig, int indentLevel) throws Exception {\n\n");
        codeBuilder.append((CharSequence)serializePojoCompactBuilder);
        codeBuilder.append("\t}\n");
        codeBuilder.append("}\n");
        codeBuilder.append("\n");
        String code = codeBuilder.toString();
        if (printSource) {
            System.out.println(code);
        }
        return new JavaSourceObject(packageName, genClassName, code);
    }

    static JavaSourceObject generateJavaCodeSource(JSONPojoStructure jsonPojoStructure, boolean printJavaSource) {
        return JSONPojoSerializer.generateJavaCodeSource(jsonPojoStructure, printJavaSource, false);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass, boolean printJavaSource) {
        return JSONPojoSerializer.generateJavaCodeSource(pojoClass, printJavaSource, false);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass, boolean printJavaSource, boolean runtime) {
        ReflectConsts.ClassCategory classCategory = ReflectConsts.getClassCategory(pojoClass);
        if (classCategory != ReflectConsts.ClassCategory.ObjectCategory) {
            throw new UnsupportedOperationException(pojoClass + " is not a pojo class");
        }
        JSONPojoStructure jsonPojoStructure = JSONPojoStructure.get(pojoClass);
        if (!jsonPojoStructure.isSupportedJavaBeanConvention()) {
            throw new UnsupportedOperationException(pojoClass + " is not supported for code generator");
        }
        return JSONPojoSerializer.generateJavaCodeSource(jsonPojoStructure, printJavaSource, runtime);
    }

    public static JavaSourceObject generateJavaCodeSource(Class<?> pojoClass) {
        return JSONPojoSerializer.generateJavaCodeSource(pojoClass, false);
    }
}

