/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.json.JSONPojoFieldDeserializer;
import io.github.wycst.wast.json.JSONPojoFieldSerializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.annotations.JsonTypeSetting;
import io.github.wycst.wast.json.util.FixedNameValueMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class JSONPojoStructure {
    private static Map<Class<?>, JSONPojoStructure> objectStructureWarppers = new ConcurrentHashMap();
    private final ClassStructureWrapper classStructureWrapper;
    private ClassStructureWrapper.ClassWrapperType classWrapperType;
    private final GenericParameterizedType genericType;
    private final FixedNameValueMap<JSONPojoFieldDeserializer> fixedFieldDeserializerValueMap;
    private final List<JSONPojoFieldDeserializer> fieldDeserializers;
    private JSONPojoFieldSerializer[] getterMethodSerializers;
    private JSONPojoFieldSerializer[] getterFieldSerializers;
    private final boolean collision;
    private boolean forceUseFields;
    private JsonTypeSetting jsonTypeSetting;
    volatile boolean initialized;
    private final boolean supportedJavaBeanConvention;
    private final boolean enableJIT;

    private JSONPojoStructure(ClassStructureWrapper classStructureWrapper) {
        classStructureWrapper.getClass();
        this.classStructureWrapper = classStructureWrapper;
        this.classWrapperType = classStructureWrapper.getClassWrapperType();
        this.forceUseFields = classStructureWrapper.isForceUseFields();
        this.jsonTypeSetting = classStructureWrapper.getSourceClass().getDeclaredAnnotation(JsonTypeSetting.class);
        List<GetterInfo> getterInfos = classStructureWrapper.getGetterInfos();
        ArrayList<JSONPojoFieldSerializer> fieldSerializers = new ArrayList<JSONPojoFieldSerializer>();
        HashMap<String, JSONPojoFieldSerializer> fieldSerializerHashMap = new HashMap<String, JSONPojoFieldSerializer>();
        for (GetterInfo getterInfo : getterInfos) {
            JsonProperty jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
            String name = getterInfo.getName();
            if (jsonProperty != null) {
                if (!jsonProperty.serialize()) continue;
                String aliasName = jsonProperty.name().trim();
                if (aliasName.length() > 0) {
                    name = aliasName;
                }
            }
            JSONPojoFieldSerializer fieldSerializer = new JSONPojoFieldSerializer(getterInfo, name);
            fieldSerializers.add(fieldSerializer);
            fieldSerializerHashMap.put(name, fieldSerializer);
        }
        this.getterMethodSerializers = fieldSerializers.toArray(new JSONPojoFieldSerializer[fieldSerializers.size()]);
        fieldSerializers.clear();
        List<GetterInfo> getterByFieldInfos = classStructureWrapper.getGetterInfos(true);
        for (GetterInfo getterInfo : getterByFieldInfos) {
            JsonProperty jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
            String name = getterInfo.getName();
            if (jsonProperty != null) {
                if (!jsonProperty.serialize()) continue;
                String aliasName = jsonProperty.name().trim();
                if (aliasName.length() > 0) {
                    name = aliasName;
                }
            }
            JSONPojoFieldSerializer fieldSerializer = new JSONPojoFieldSerializer(getterInfo, name);
            fieldSerializers.add(fieldSerializer);
        }
        this.getterFieldSerializers = fieldSerializers.toArray(new JSONPojoFieldSerializer[fieldSerializers.size()]);
        this.supportedJavaBeanConvention = this.checkJavaBeanConvention(fieldSerializerHashMap);
        this.genericType = GenericParameterizedType.actualType(classStructureWrapper.getSourceClass());
        Set<String> set = classStructureWrapper.setterNames();
        HashMap<String, JSONPojoFieldDeserializer> fieldDeserializerHashMap = new HashMap<String, JSONPojoFieldDeserializer>();
        for (String setterName : set) {
            SetterInfo setterInfo = classStructureWrapper.getSetterInfo(setterName);
            JsonProperty jsonProperty = (JsonProperty)setterInfo.getAnnotation(JsonProperty.class);
            String name = setterName;
            if (jsonProperty != null) {
                if (!jsonProperty.deserialize()) continue;
                String mapperName = jsonProperty.name().trim();
                if (mapperName.length() > 0) {
                    name = mapperName;
                }
            }
            JSONPojoFieldDeserializer fieldDeserializer = new JSONPojoFieldDeserializer(name, setterInfo, jsonProperty);
            fieldDeserializerHashMap.put(name, fieldDeserializer);
        }
        this.fieldDeserializers = new ArrayList(fieldDeserializerHashMap.values());
        this.fixedFieldDeserializerValueMap = FixedNameValueMap.build(fieldDeserializerHashMap);
        this.collision = this.fixedFieldDeserializerValueMap.isCollision() || this.jsonTypeSetting != null && this.jsonTypeSetting.strict();
        this.enableJIT = this.jsonTypeSetting != null && this.jsonTypeSetting.enableJIT();
    }

    private boolean checkJavaBeanConvention(Map<String, JSONPojoFieldSerializer> fieldSerializerHashMap) {
        return !this.classStructureWrapper.isPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInitialized() {
        if (this.initialized) {
            return;
        }
        JSONPojoStructure jSONPojoStructure = this;
        synchronized (jSONPojoStructure) {
            if (this.initialized) {
                return;
            }
            this.initialize();
        }
    }

    void initialize() {
        for (JSONPojoFieldDeserializer fieldDeserializer : this.fieldDeserializers) {
            fieldDeserializer.initDeserializer();
        }
        for (JSONPojoFieldSerializer fieldSerializer : this.getterMethodSerializers) {
            fieldSerializer.initSerializer();
        }
        for (JSONPojoFieldSerializer fieldSerializer : this.getterFieldSerializers) {
            fieldSerializer.initSerializer();
        }
        this.initialized = true;
    }

    public Class<?> getSourceClass() {
        return this.classStructureWrapper.getSourceClass();
    }

    public boolean isRecord() {
        return this.classStructureWrapper.isRecord();
    }

    public boolean isTemporal() {
        return this.classStructureWrapper.isTemporal();
    }

    public int getFieldCount() {
        return this.classStructureWrapper.getFieldCount();
    }

    public ClassStructureWrapper.ClassWrapperType getClassWrapperType() {
        return this.classWrapperType;
    }

    public Object[] createConstructorArgs() {
        return this.classStructureWrapper.createConstructorArgs();
    }

    public JSONPojoFieldDeserializer getFieldDeserializer(char[] buf, int beginIndex, int endIndex, long hashValue) {
        return this.fixedFieldDeserializerValueMap.getValue(buf, beginIndex, endIndex, hashValue);
    }

    public JSONPojoFieldDeserializer getFieldDeserializer(byte[] buf, int beginIndex, int endIndex, long hashValue) {
        return this.fixedFieldDeserializerValueMap.getValue(buf, beginIndex, endIndex, hashValue);
    }

    public JSONPojoFieldDeserializer getFieldDeserializer(String field) {
        return this.fixedFieldDeserializerValueMap.getValue(field);
    }

    public JSONPojoFieldDeserializer getFieldDeserializer(long hashValue) {
        return this.fixedFieldDeserializerValueMap.getValueByHash(hashValue);
    }

    public long hashChar(long rv, int c) {
        return this.fixedFieldDeserializerValueMap.hash(rv, c);
    }

    public long hashChar(long hv, int c1, int c2) {
        return this.fixedFieldDeserializerValueMap.hash(hv, c1, c2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONPojoStructure get(Class<?> pojoClass) {
        if (pojoClass == null) {
            throw new IllegalArgumentException("pojoClass is null");
        }
        JSONPojoStructure objectWrapper = objectStructureWarppers.get(pojoClass);
        if (objectWrapper != null) {
            return objectWrapper;
        }
        Class<?> clazz = pojoClass;
        synchronized (clazz) {
            if (objectStructureWarppers.containsKey(pojoClass)) {
                return objectStructureWarppers.get(pojoClass);
            }
            ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(pojoClass);
            if (classStructureWrapper == null) {
                throw new IllegalArgumentException("pojoClass " + pojoClass + " is not supported !");
            }
            objectWrapper = new JSONPojoStructure(classStructureWrapper);
            objectStructureWarppers.put(pojoClass, objectWrapper);
            objectWrapper.initialize();
        }
        return objectWrapper;
    }

    public Object newInstance() throws Exception {
        return this.classStructureWrapper.newInstance();
    }

    public Object newInstance(Object[] constructorArgs) throws Exception {
        return this.classStructureWrapper.newInstance(constructorArgs);
    }

    public GenericParameterizedType getGenericType() {
        return this.genericType;
    }

    public boolean isCollision() {
        return this.collision;
    }

    public boolean isAssignableFromMap() {
        return this.classStructureWrapper.isAssignableFromMap();
    }

    public JSONPojoFieldSerializer[] getFieldSerializers(boolean useFields) {
        return useFields || this.forceUseFields ? this.getterFieldSerializers : this.getterMethodSerializers;
    }

    public boolean isPrivate() {
        return this.classStructureWrapper.isPrivate();
    }

    public boolean isForceUseFields() {
        return this.forceUseFields;
    }

    public boolean isSupportedJavaBeanConvention() {
        return this.supportedJavaBeanConvention;
    }

    public boolean isSupportedJIT() {
        return this.isSupportedJavaBeanConvention() && this.enableJIT;
    }
}

