/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTypeDeserializer;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import io.github.wycst.wast.json.temporal.TemporalInstantDeserializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateDeserializer;
import io.github.wycst.wast.json.temporal.TemporalLocalDateTimeDeserializer;
import io.github.wycst.wast.json.temporal.TemporalLocalTimeDeserializer;
import io.github.wycst.wast.json.temporal.TemporalOffsetDateTimeDeserializer;
import io.github.wycst.wast.json.temporal.TemporalZonedDateTimeDeserializer;
import java.lang.reflect.InvocationTargetException;

public abstract class JSONTemporalDeserializer
extends JSONTypeDeserializer {
    protected int patternType;
    protected DateTemplate dateTemplate;
    protected static final int[] NANO_OF_SECOND_PADDING = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    protected JSONTemporalDeserializer(TemporalConfig temporalConfig) {
        this.checkClass(temporalConfig.getGenericParameterizedType());
        String pattern = temporalConfig.getDatePattern();
        this.patternType = JSONTemporalDeserializer.getPatternType(pattern);
        if (this.patternType == 0) {
            this.createDefaultTemplate();
        } else {
            this.dateTemplate = new DateTemplate(pattern);
        }
    }

    static JSONTypeDeserializer getTemporalDeserializerInstance(ClassStructureWrapper.ClassWrapperType classWrapperType, GenericParameterizedType genericParameterizedType, JsonProperty property) {
        TemporalConfig temporalConfig = TemporalConfig.of(genericParameterizedType, property);
        switch (classWrapperType) {
            case TemporalLocalDate: {
                return new TemporalLocalDateDeserializer(temporalConfig);
            }
            case TemporalLocalTime: {
                return new TemporalLocalTimeDeserializer(temporalConfig);
            }
            case TemporalLocalDateTime: {
                return new TemporalLocalDateTimeDeserializer(temporalConfig);
            }
            case TemporalZonedDateTime: {
                return new TemporalZonedDateTimeDeserializer(temporalConfig);
            }
            case TemporalOffsetDateTime: {
                return new TemporalOffsetDateTimeDeserializer(temporalConfig);
            }
            case TemporalInstant: {
                return new TemporalInstantDeserializer(temporalConfig);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected void createDefaultTemplate() {
    }

    protected abstract void checkClass(GenericParameterizedType var1);

    @Override
    protected Object deserialize(CharSource charSource, char[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, char endToken, JSONParseContext jsonParseContext) throws Exception {
        char beginChar = buf[fromIndex];
        switch (beginChar) {
            case '\"': 
            case '\'': {
                if (this.patternType == 0) {
                    return this.deserializeDefaultTemporal(buf, fromIndex + 1, beginChar, jsonParseContext);
                }
                CHAR_SEQUENCE_STRING.skip(charSource, buf, fromIndex, beginChar, jsonParseContext);
                int endIndex = jsonParseContext.endIndex;
                try {
                    return this.deserializeTemporal(buf, fromIndex, endIndex, jsonParseContext);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    String source = new String(buf, fromIndex + 1, endIndex - fromIndex - 1);
                    String errorContextTextAt = JSONTemporalDeserializer.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', text '" + source + "' cannot convert to " + parameterizedType.getActualType() + ", exception: " + throwable.getMessage());
                }
            }
            case 'n': {
                return NULL.deserialize(null, buf, fromIndex, toIndex, null, null, jsonParseContext);
            }
        }
        String errorContextTextAt = JSONTemporalDeserializer.createErrorContextText(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Temporal Type, expected '\"' ");
    }

    @Override
    protected Object deserialize(CharSource charSource, byte[] buf, int fromIndex, int toIndex, GenericParameterizedType parameterizedType, Object defaultValue, byte endToken, JSONParseContext jsonParseContext) throws Exception {
        byte beginByte = buf[fromIndex];
        char beginChar = (char)beginByte;
        switch (beginChar) {
            case '\"': 
            case '\'': {
                if (this.patternType == 0) {
                    return this.deserializeDefaultTemporal(buf, fromIndex + 1, beginChar, jsonParseContext);
                }
                CHAR_SEQUENCE_STRING.skip(charSource, buf, fromIndex, (int)beginChar, jsonParseContext);
                int endIndex = jsonParseContext.endIndex;
                try {
                    return this.deserializeTemporal(buf, fromIndex, endIndex, jsonParseContext);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    String source = new String(buf, fromIndex + 1, endIndex - fromIndex - 1);
                    String errorContextTextAt = JSONTemporalDeserializer.createErrorContextText(buf, fromIndex);
                    throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', text '" + source + "' cannot convert to " + parameterizedType.getActualType() + ", exception: " + throwable.getMessage());
                }
            }
            case 'n': {
                return JSONTemporalDeserializer.parseNull(buf, fromIndex, toIndex, jsonParseContext);
            }
        }
        String errorContextTextAt = JSONTemporalDeserializer.createErrorContextText(buf, fromIndex);
        throw new JSONException("Syntax error, at pos " + fromIndex + ", context text by '" + errorContextTextAt + "', unexpected '" + beginChar + "' for Temporal Type, expected '\"' ");
    }

    protected abstract Object deserializeTemporal(char[] var1, int var2, int var3, JSONParseContext var4) throws Exception;

    protected abstract Object deserializeTemporal(byte[] var1, int var2, int var3, JSONParseContext var4) throws Exception;

    protected abstract Object deserializeDefaultTemporal(char[] var1, int var2, char var3, JSONParseContext var4) throws Exception;

    protected abstract Object deserializeDefaultTemporal(byte[] var1, int var2, char var3, JSONParseContext var4) throws Exception;
}

