/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.util.UUID;

class JSONWrapWriter
extends JSONWriter {
    final Writer writer;

    JSONWrapWriter(Writer writer) {
        this.writer = writer;
    }

    public static JSONWrapWriter wrap(Writer writer) {
        return new JSONWrapWriter(writer);
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException();
    }

    @Override
    StringBuffer toStringBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    StringBuilder toStringBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeShortChars(char[] chars, int offset, int len) throws IOException {
        this.write(chars, offset, len);
    }

    @Override
    public void writeLong(long numValue) throws IOException {
        if (numValue == 0L) {
            this.writer.write(48);
            return;
        }
        if (numValue < 0L) {
            if (numValue == Long.MIN_VALUE) {
                this.writer.write("-9223372036854775808");
                return;
            }
            numValue = -numValue;
            this.writer.write(45);
        }
        NumberUtils.writePositiveLong(numValue, this.writer);
    }

    @Override
    public void writeUUID(UUID uuid) throws IOException {
        long mostSigBits = uuid.getMostSignificantBits();
        long leastSigBits = uuid.getLeastSignificantBits();
        this.writer.write(34);
        char[] chars = JSONGeneral.CACHED_CHARS_24.get();
        NumberUtils.writeUUIDMostSignificantBits(mostSigBits, chars, 0);
        this.writer.write(chars, 0, 18);
        NumberUtils.writeUUIDLeastSignificantBits(leastSigBits, chars, 0);
        this.writer.write(chars, 0, 18);
        this.writer.write(34);
    }

    @Override
    public void writeDouble(double numValue) throws IOException {
        char[] chars = JSONGeneral.CACHED_CHARS_24.get();
        int len = NumberUtils.writeDouble(numValue, chars, 0);
        this.writer.write(chars, 0, len);
    }

    @Override
    public void writeFloat(float numValue) throws IOException {
        char[] chars = JSONGeneral.CACHED_CHARS_24.get();
        int len = NumberUtils.writeFloat(numValue, chars, 0);
        this.writer.write(chars, 0, len);
    }

    @Override
    public void writeJSONLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nano, String zoneId) throws IOException {
        int y1 = year / 100;
        int y2 = year - y1 * 100;
        this.writer.write(34);
        this.writer.write(JSONGeneral.DigitTens[y1]);
        this.writer.write(JSONGeneral.DigitOnes[y1]);
        this.writer.write(JSONGeneral.DigitTens[y2]);
        this.writer.write(JSONGeneral.DigitOnes[y2]);
        this.writer.write(45);
        this.writer.write(JSONGeneral.DigitTens[month]);
        this.writer.write(JSONGeneral.DigitOnes[month]);
        this.writer.write(45);
        this.writer.write(JSONGeneral.DigitTens[day]);
        this.writer.write(JSONGeneral.DigitOnes[day]);
        this.writer.write(84);
        this.writer.write(JSONGeneral.DigitTens[hour]);
        this.writer.write(JSONGeneral.DigitOnes[hour]);
        this.writer.write(58);
        this.writer.write(JSONGeneral.DigitTens[minute]);
        this.writer.write(JSONGeneral.DigitOnes[minute]);
        this.writer.write(58);
        this.writer.write(JSONGeneral.DigitTens[second]);
        this.writer.write(JSONGeneral.DigitOnes[second]);
        JSONWrapWriter.writeNano(nano, this.writer);
        this.writeZoneId(zoneId);
        this.writer.write(34);
    }

    @Override
    public void writeJSONLocalDate(int year, int month, int day) throws IOException {
        int y1 = year / 100;
        int y2 = year - y1 * 100;
        char[] chars = JSONGeneral.CACHED_CHARS_DATE_21.get();
        chars[1] = JSONGeneral.DigitTens[y1];
        chars[2] = JSONGeneral.DigitOnes[y1];
        chars[3] = JSONGeneral.DigitTens[y2];
        chars[4] = JSONGeneral.DigitOnes[y2];
        chars[6] = JSONGeneral.DigitTens[month];
        chars[7] = JSONGeneral.DigitOnes[month];
        chars[9] = JSONGeneral.DigitTens[day];
        chars[10] = JSONGeneral.DigitOnes[day];
        this.writer.write(chars, 0, 11);
        this.writer.write(34);
    }

    @Override
    public void writeTime(int hourOfDay, int minute, int second) throws IOException {
        this.writer.write(JSONGeneral.DigitTens[hourOfDay]);
        this.writer.write(JSONGeneral.DigitOnes[hourOfDay]);
        this.writer.write(58);
        this.writer.write(JSONGeneral.DigitTens[minute]);
        this.writer.write(JSONGeneral.DigitOnes[minute]);
        this.writer.write(58);
        this.writer.write(JSONGeneral.DigitTens[second]);
        this.writer.write(JSONGeneral.DigitOnes[second]);
    }

    @Override
    public void writeJSONTimeWithNano(int hourOfDay, int minute, int second, int nano) throws IOException {
        this.writer.write(34);
        this.writer.write(JSONGeneral.DigitTens[hourOfDay]);
        this.writer.write(JSONGeneral.DigitOnes[hourOfDay]);
        this.writer.write(58);
        this.writer.write(JSONGeneral.DigitTens[minute]);
        this.writer.write(JSONGeneral.DigitOnes[minute]);
        this.writer.write(58);
        this.writer.write(JSONGeneral.DigitTens[second]);
        this.writer.write(JSONGeneral.DigitOnes[second]);
        JSONWrapWriter.writeNano(nano, this.writer);
        this.writer.write(34);
    }

    @Override
    public void writeDate(int year, int month, int day, int hourOfDay, int minute, int second) throws IOException {
        int y1 = year / 100;
        int y2 = year - y1 * 100;
        char[] chars = JSONGeneral.CACHED_CHARS_DATE_21.get();
        chars[1] = JSONGeneral.DigitTens[y1];
        chars[2] = JSONGeneral.DigitOnes[y1];
        chars[3] = JSONGeneral.DigitTens[y2];
        chars[4] = JSONGeneral.DigitOnes[y2];
        chars[6] = JSONGeneral.DigitTens[month];
        chars[7] = JSONGeneral.DigitOnes[month];
        chars[9] = JSONGeneral.DigitTens[day];
        chars[10] = JSONGeneral.DigitOnes[day];
        chars[12] = JSONGeneral.DigitTens[hourOfDay];
        chars[13] = JSONGeneral.DigitOnes[hourOfDay];
        chars[15] = JSONGeneral.DigitTens[minute];
        chars[16] = JSONGeneral.DigitOnes[minute];
        chars[18] = JSONGeneral.DigitTens[second];
        chars[19] = JSONGeneral.DigitOnes[second];
        this.writer.write(chars, 1, 20);
    }

    @Override
    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        int increment = (bigInteger.bitLength() / 60 + 1) * 18;
        char[] chars = new char[increment];
        int len = NumberUtils.writeBigInteger(bigInteger, chars, 0);
        this.writer.write(chars, 0, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writer.write(cbuf);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

