/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONByteArrayWriter;
import io.github.wycst.wast.json.JSONCharArrayStreamWriter;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONWrapWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class JSONWriter
extends Writer {
    static final int CACHE_BUFFER_SIZE;
    static final int MAX_CACHE_BUFFER_SIZE;
    static final int AVAILABLE_PROCESSORS;
    static final int SECURITY_UNCHECK_SPACE = 128;
    static final int CACHE_COUNT;
    static final AtomicInteger AUTO_SEQ;
    static ThreadLocal<Integer> THREAD_CACHE_INDEX;

    JSONWriter() {
    }

    static JSONWriter forStringWriter() {
        return new JSONCharArrayWriter();
    }

    static JSONWriter forBytesWriter(Charset charset) {
        return new JSONByteArrayWriter(charset);
    }

    static JSONWriter forStreamWriter(Charset charset) {
        if (EnvUtils.JDK_9_PLUS) {
            return new JSONCharArrayStreamWriter(charset);
        }
        return new JSONByteArrayWriter(charset);
    }

    static JSONWriter wrap(Writer writer) {
        return JSONWrapWriter.wrap(writer);
    }

    public abstract String toString();

    abstract StringBuffer toStringBuffer();

    abstract StringBuilder toStringBuilder();

    protected byte[] toBytes() {
        return this.toBytes(Charset.defaultCharset());
    }

    protected abstract void toOutputStream(OutputStream var1) throws IOException;

    protected byte[] toBytes(Charset charset) {
        return this.toString().getBytes();
    }

    void reset() {
    }

    public void clear() {
    }

    static final void writeNano(int nano, Writer content) throws IOException {
        if (nano > 0) {
            content.write(46);
            int stringSize = NumberUtils.stringSize(nano);
            for (int n = 9 - stringSize; n > 0; --n) {
                content.write(48);
            }
            while (nano % 1000 == 0) {
                nano /= 1000;
            }
            NumberUtils.writePositiveLong(nano, content);
        }
    }

    public final void writeZoneId(String zoneId) throws IOException {
        if (zoneId == null) {
            return;
        }
        if (zoneId.length() > 0) {
            char c = zoneId.charAt(0);
            switch (c) {
                case 'Z': {
                    this.writeJSONToken('Z');
                    break;
                }
                case '+': 
                case '-': {
                    this.write(zoneId);
                    break;
                }
                default: {
                    this.write(91);
                    this.write(zoneId);
                    this.write(93);
                }
            }
        }
    }

    public void writeJSONToken(char c) throws IOException {
        this.write(c);
    }

    public abstract void writeShortChars(char[] var1, int var2, int var3) throws IOException;

    public abstract void writeLong(long var1) throws IOException;

    public abstract void writeUUID(UUID var1) throws IOException;

    public abstract void writeDouble(double var1) throws IOException;

    public abstract void writeFloat(float var1) throws IOException;

    public final void writeJSONInstant(long epochSeconds, int nanos) throws IOException {
        GeneralDate generalDate = new GeneralDate(epochSeconds * 1000L, JSONGeneral.ZERO_TIME_ZONE);
        int year = generalDate.getYear();
        int month = generalDate.getMonth();
        int day = generalDate.getDay();
        int hour = generalDate.getHourOfDay();
        int minute = generalDate.getMinute();
        int second = generalDate.getSecond();
        this.writeJSONLocalDateTime(year, month, day, hour, minute, second, nanos, "Z");
    }

    public abstract void writeJSONLocalDateTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7, String var8) throws IOException;

    public abstract void writeJSONLocalDate(int var1, int var2, int var3) throws IOException;

    public abstract void writeTime(int var1, int var2, int var3) throws IOException;

    public abstract void writeJSONTimeWithNano(int var1, int var2, int var3, int var4) throws IOException;

    public abstract void writeDate(int var1, int var2, int var3, int var4, int var5, int var6) throws IOException;

    public abstract void writeBigInteger(BigInteger var1) throws IOException;

    public final void writeJSONStringKey(String value) throws IOException {
        this.writeJSONString(value);
        this.writeJSONToken(':');
    }

    public void writeJSONChars(char[] chars) throws IOException {
        int beginIndex = 0;
        int len = chars.length;
        this.write(34);
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char ch = chars[i];
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) continue;
            int length = i - beginIndex;
            if (length > 0) {
                this.write(chars, beginIndex, length);
            }
            this.write(escapeStr);
            beginIndex = i + 1;
        }
        int size = len - beginIndex;
        this.write(chars, beginIndex, size);
        this.write(34);
    }

    public final void writeJSONString(String value) throws IOException {
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])UnsafeHelper.getStringValue(value);
            this.writeJSONStringBytes(value, bytes);
        } else {
            this.writeJSONChars(UnsafeHelper.getChars(value));
        }
    }

    public final void writeJSONStringBytes(String value, byte[] bytes) throws IOException {
        if (bytes.length == value.length()) {
            this.writeLatinJSONString(value, bytes);
        } else {
            this.writeUTF16JSONString(value, bytes);
        }
    }

    public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
        int len = bytes.length;
        this.write(34);
        int beginIndex = 0;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            String escapeStr = JSONGeneral.ESCAPE_VALUES[b & 0xFF];
            if (escapeStr == null) continue;
            this.write(value, beginIndex, i - beginIndex);
            this.write(escapeStr);
            beginIndex = i + 1;
        }
        int size = len - beginIndex;
        this.write(value, beginIndex, size);
        this.write(34);
    }

    public void writeUTF16JSONString(String value, byte[] bytes) throws IOException {
        this.write(34);
        int beginIndex = 0;
        int strlen = value.length();
        for (int i = 0; i < strlen; ++i) {
            String escapeStr;
            char b = value.charAt(i);
            if (b > '\"' && b != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[b]) == null) continue;
            this.write(value, beginIndex, i - beginIndex);
            this.write(escapeStr);
            beginIndex = i + 1;
        }
        int size = strlen - beginIndex;
        this.write(value, beginIndex, size);
        this.write(34);
    }

    public void writeFieldString(String value, int offset, int len) throws IOException {
        this.write(value, offset, len);
    }

    public final void writeFieldString(String value) throws IOException {
        this.writeFieldString(value, 0, value.length());
    }

    public void writeUnsafe(long fourChars, int fourBytes, int len) throws IOException {
        char[] chars = new char[4];
        UnsafeHelper.putLong(chars, 0, fourChars);
        this.write(chars, 0, len);
    }

    public void writeUnsafe(long[] fourChars, int[] fourBytes, int totalCount) throws IOException {
        int n = fourChars.length;
        char[] chars = new char[n << 2];
        int offset = 0;
        for (long fourChar : fourChars) {
            UnsafeHelper.putLong(chars, offset, fourChar);
            offset += 4;
        }
        this.write(chars, 0, totalCount);
    }

    static {
        int cacheCount;
        AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
        AUTO_SEQ = new AtomicInteger();
        CACHE_BUFFER_SIZE = EnvUtils.JDK_VERSION >= 1.8f ? 16384 : 4096;
        MAX_CACHE_BUFFER_SIZE = 0x300000;
        int availableProcessors = AVAILABLE_PROCESSORS << 1;
        for (cacheCount = 16; availableProcessors > cacheCount; cacheCount <<= 1) {
        }
        CACHE_COUNT = cacheCount;
        THREAD_CACHE_INDEX = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return AUTO_SEQ.incrementAndGet() & CACHE_COUNT - 1;
            }

            @Override
            public void set(Integer value) {
            }
        };
    }
}

