/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;

public class TemporalInstantSerializer
extends JSONTemporalSerializer {
    public TemporalInstantSerializer(Class<?> temporalClass, JsonProperty property) {
        super(temporalClass, property);
    }

    @Override
    protected void checkClass(Class<?> temporalClass) {
    }

    @Override
    protected void writeTemporalWithTemplate(Object value, JSONWriter writer, JSONConfig jsonConfig) throws Exception {
        long epochMilli = TemporalAloneInvoker.invokeInstantEpochMilli(value);
        GeneralDate date = new GeneralDate(epochMilli, ZERO_TIME_ZONE);
        writer.write(34);
        TemporalInstantSerializer.writeGeneralDate(date, this.dateFormatter, writer);
        writer.write(34);
    }

    @Override
    protected void writeDefault(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
        long epochSeconds = TemporalAloneInvoker.invokeInstantEpochSeconds(value);
        int nano = TemporalAloneInvoker.invokeInstantNano(value);
        writer.writeJSONInstant(epochSeconds, nano);
    }
}

