/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;
import io.github.wycst.wast.json.temporal.TemporalConfig;

public class TemporalLocalDateTimeDeserializer
extends JSONTemporalDeserializer {
    public TemporalLocalDateTimeDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return TemporalAloneInvoker.ofLocalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return TemporalAloneInvoker.ofLocalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000);
    }

    @Override
    protected Object deserializeDefaultTemporal(char[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year = TemporalLocalDateTimeDeserializer.parseInt4(buf, offset);
        int month = TemporalLocalDateTimeDeserializer.parseInt2(buf, offset + 5);
        int day = TemporalLocalDateTimeDeserializer.parseInt2(buf, offset + 8);
        int hour = TemporalLocalDateTimeDeserializer.parseInt2(buf, offset + 11);
        int minute = TemporalLocalDateTimeDeserializer.parseInt2(buf, offset + 14);
        int second = TemporalLocalDateTimeDeserializer.parseInt2(buf, offset + 17);
        int nanoOfSecond = 0;
        char c = buf[offset += 19];
        if (c == '.') {
            int cnt = 9;
            while (TemporalLocalDateTimeDeserializer.isDigit(c = buf[++offset])) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c == endChar) {
            jsonParseContext.endIndex = offset;
            return TemporalAloneInvoker.ofLocalDateTime(year, month, day, hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, offset);
        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', unexpected token '" + c + "', expected '" + endChar + "'");
    }

    @Override
    protected Object deserializeDefaultTemporal(byte[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year = NumberUtils.parseInt4(buf, offset);
        int month = NumberUtils.parseInt2(buf, offset + 5);
        int day = NumberUtils.parseInt2(buf, offset + 8);
        int hour = NumberUtils.parseInt2(buf, offset + 11);
        int minute = NumberUtils.parseInt2(buf, offset + 14);
        int second = NumberUtils.parseInt2(buf, offset + 17);
        int nanoOfSecond = 0;
        byte c = buf[offset += 19];
        if (c == 46) {
            int cnt = 9;
            while (TemporalLocalDateTimeDeserializer.isDigit(c = buf[++offset])) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        if (c == endChar) {
            jsonParseContext.endIndex = offset;
            return TemporalAloneInvoker.ofLocalDateTime(year, month, day, hour, minute, second, nanoOfSecond);
        }
        String errorContextTextAt = TemporalLocalDateTimeDeserializer.createErrorContextText(buf, offset);
        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endChar + "'");
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return TemporalAloneInvoker.parseLocalDateTime(value);
    }
}

