/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;

public class TemporalOffsetDateTimeSerializer
extends JSONTemporalSerializer {
    public TemporalOffsetDateTimeSerializer(Class<?> temporalClass, JsonProperty property) {
        super(temporalClass, property);
    }

    @Override
    protected void checkClass(Class<?> temporalClass) {
    }

    @Override
    protected void writeTemporalWithTemplate(Object value, JSONWriter writer, JSONConfig jsonConfig) throws Exception {
        int year = TemporalAloneInvoker.invokeOffsetDateTimeYear(value);
        int month = TemporalAloneInvoker.invokeOffsetDateTimeMonth(value);
        int day = TemporalAloneInvoker.invokeOffsetDateTimeDay(value);
        int hour = TemporalAloneInvoker.invokeOffsetDateTimeHour(value);
        int minute = TemporalAloneInvoker.invokeOffsetDateTimeMinute(value);
        int second = TemporalAloneInvoker.invokeOffsetDateTimeSecond(value);
        int nano = TemporalAloneInvoker.invokeOffsetDateTimeNano(value);
        int millisecond = nano / 1000000;
        writer.write(34);
        TemporalOffsetDateTimeSerializer.writeDate(year, month, day, hour, minute, second, millisecond, this.dateFormatter, writer);
        String zoneId = TemporalAloneInvoker.invokeOffsetDateTimeZone(value).toString();
        writer.writeZoneId(zoneId);
        writer.write(34);
    }

    @Override
    protected void writeDefault(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
        int year = TemporalAloneInvoker.invokeOffsetDateTimeYear(value);
        int month = TemporalAloneInvoker.invokeOffsetDateTimeMonth(value);
        int day = TemporalAloneInvoker.invokeOffsetDateTimeDay(value);
        int hour = TemporalAloneInvoker.invokeOffsetDateTimeHour(value);
        int minute = TemporalAloneInvoker.invokeOffsetDateTimeMinute(value);
        int second = TemporalAloneInvoker.invokeOffsetDateTimeSecond(value);
        int nano = TemporalAloneInvoker.invokeOffsetDateTimeNano(value);
        writer.writeJSONLocalDateTime(year, month, day, hour, minute, second, nano, TemporalAloneInvoker.invokeOffsetDateTimeZone(value).toString());
    }
}

