/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.temporal.Temporal;

public class TemporalZonedDateTimeDeserializer
extends JSONTemporalDeserializer {
    public TemporalZonedDateTimeDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != '.') {
            if (ch == '+' || ch == '-' || ch == 'Z') {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != '[' || buf[endIndex - 1] != ']') continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        Object zoneObject = zoneId == null ? this.getDefaultZoneId() : TemporalAloneInvoker.ofZoneId(zoneId);
        return this.ofTemporalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        byte ch;
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != 46) {
            if (ch == 43 || ch == 45 || ch == 90) {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != 91 || buf[endIndex - 1] != 93) continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        Object zoneObject = zoneId == null ? this.getDefaultZoneId() : TemporalAloneInvoker.ofZoneId(zoneId);
        return this.ofTemporalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    @Override
    protected Object deserializeDefaultTemporal(char[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year = NumberUtils.parseInt4(buf, offset);
        int month = NumberUtils.parseInt2(buf, offset + 5);
        int day = NumberUtils.parseInt2(buf, offset + 8);
        int hour = NumberUtils.parseInt2(buf, offset + 11);
        int minute = NumberUtils.parseInt2(buf, offset + 14);
        int second = NumberUtils.parseInt2(buf, offset + 17);
        int nanoOfSecond = 0;
        char c = buf[offset += 19];
        if (c == '.') {
            int cnt = 9;
            while (TemporalZonedDateTimeDeserializer.isDigit(c = buf[++offset])) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        Object zoneObject = this.getDefaultZoneId();
        switch (c) {
            case 'Z': 
            case 'z': {
                zoneObject = TemporalAloneInvoker.getZeroZoneId();
                c = buf[++offset];
                break;
            }
            case '+': 
            case '-': {
                int zoneBeginOff = offset;
                while (TemporalZonedDateTimeDeserializer.isDigit(c = buf[++offset]) || c == ':') {
                }
                zoneObject = TemporalAloneInvoker.ofZoneId(new String(buf, offset, offset - zoneBeginOff));
                break;
            }
        }
        if (c == '[') {
            if (this.supportedZoneRegion()) {
                int zoneRegionOff = offset;
                while (buf[++offset] != ']') {
                }
                zoneObject = TemporalAloneInvoker.ofZoneId(new String(buf, zoneRegionOff + 1, offset - zoneRegionOff - 1));
                c = buf[++offset];
            } else {
                while (buf[++offset] != ']') {
                }
                c = buf[++offset];
            }
        }
        if (c == endChar) {
            jsonParseContext.endIndex = offset;
            return this.ofTemporalDateTime(year, month, day, hour, minute, second, nanoOfSecond, zoneObject);
        }
        String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, offset);
        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', unexpected token '" + c + "', expected '" + endChar + "'");
    }

    @Override
    protected Object deserializeDefaultTemporal(byte[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year = NumberUtils.parseInt4(buf, offset);
        int month = NumberUtils.parseInt2(buf, offset + 5);
        int day = NumberUtils.parseInt2(buf, offset + 8);
        int hour = NumberUtils.parseInt2(buf, offset + 11);
        int minute = NumberUtils.parseInt2(buf, offset + 14);
        int second = NumberUtils.parseInt2(buf, offset + 17);
        int nanoOfSecond = 0;
        byte c = buf[offset += 19];
        if (c == 46) {
            int cnt = 9;
            while (TemporalZonedDateTimeDeserializer.isDigit(c = buf[++offset])) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        Object zoneObject = this.getDefaultZoneId();
        switch (c) {
            case 90: 
            case 122: {
                zoneObject = TemporalAloneInvoker.getZeroZoneId();
                c = buf[++offset];
                break;
            }
            case 43: 
            case 45: {
                int zoneBeginOff = offset;
                while (TemporalZonedDateTimeDeserializer.isDigit(c = buf[++offset]) || c == 58) {
                }
                zoneObject = TemporalAloneInvoker.ofZoneId(new String(buf, offset, offset - zoneBeginOff));
                break;
            }
        }
        if (c == 91) {
            if (this.supportedZoneRegion()) {
                int zoneRegionOff = offset;
                while (buf[++offset] != 93) {
                }
                zoneObject = TemporalAloneInvoker.ofZoneId(new String(buf, zoneRegionOff + 1, offset - zoneRegionOff - 1));
                c = buf[++offset];
            } else {
                while (buf[++offset] != 93) {
                }
                c = buf[++offset];
            }
        }
        if (c == endChar) {
            jsonParseContext.endIndex = offset;
            return this.ofTemporalDateTime(year, month, day, hour, minute, second, nanoOfSecond, zoneObject);
        }
        String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, offset);
        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endChar + "'");
    }

    protected boolean supportedZoneRegion() {
        return true;
    }

    protected Object getDefaultZoneId() throws Exception {
        return TemporalAloneInvoker.getDefaultZoneId();
    }

    protected Temporal ofTemporalDateTime(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, Object zone) throws Exception {
        return (Temporal)TemporalAloneInvoker.ofZonedDateTime(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, zone);
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return TemporalAloneInvoker.parseZonedDateTime(value);
    }
}

