/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTemporalSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.temporal.TemporalAloneInvoker;

public class TemporalZonedDateTimeSerializer
extends JSONTemporalSerializer {
    public TemporalZonedDateTimeSerializer(Class<?> temporalClass, JsonProperty property) {
        super(temporalClass, property);
    }

    @Override
    protected void checkClass(Class<?> temporalClass) {
    }

    @Override
    protected void writeTemporalWithTemplate(Object value, JSONWriter writer, JSONConfig jsonConfig) throws Exception {
        int year = TemporalAloneInvoker.invokeZonedDateTimeYear(value);
        int month = TemporalAloneInvoker.invokeZonedDateTimeMonth(value);
        int day = TemporalAloneInvoker.invokeZonedDateTimeDay(value);
        int hour = TemporalAloneInvoker.invokeZonedDateTimeHour(value);
        int minute = TemporalAloneInvoker.invokeZonedDateTimeMinute(value);
        int second = TemporalAloneInvoker.invokeZonedDateTimeSecond(value);
        int nano = TemporalAloneInvoker.invokeZonedDateTimeNano(value);
        int millisecond = nano / 1000000;
        writer.write(34);
        TemporalZonedDateTimeSerializer.writeDate(year, month, day, hour, minute, second, millisecond, this.dateFormatter, writer);
        String zoneId = TemporalAloneInvoker.invokeZonedDateTimeZone(value).toString();
        writer.writeZoneId(zoneId);
        writer.write(34);
    }

    @Override
    protected void writeDefault(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
        int year = TemporalAloneInvoker.invokeZonedDateTimeYear(value);
        int month = TemporalAloneInvoker.invokeZonedDateTimeMonth(value);
        int day = TemporalAloneInvoker.invokeZonedDateTimeDay(value);
        int hour = TemporalAloneInvoker.invokeZonedDateTimeHour(value);
        int minute = TemporalAloneInvoker.invokeZonedDateTimeMinute(value);
        int second = TemporalAloneInvoker.invokeZonedDateTimeSecond(value);
        int nano = TemporalAloneInvoker.invokeZonedDateTimeNano(value);
        writer.writeJSONLocalDateTime(year, month, day, hour, minute, second, nano, TemporalAloneInvoker.invokeZonedDateTimeZone(value).toString());
    }
}

