/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.util;

import java.util.LinkedHashSet;
import java.util.Map;

public class FixedNameValueMap<T> {
    final int capacity;
    final int mask;
    final NameValueEntryNode<T>[] valueEntryNodes;
    int count;
    final int maxCount;
    int primeValue;
    boolean collision;
    static final int[] PRIMES = new int[]{5, 7, 11, 13, 17, 19, 23, 29, 31};

    public static <E> FixedNameValueMap<E> build(Map<String, E> values) {
        int size = values.size();
        BHFixedNameValueMap bhNameValueMap = new BHFixedNameValueMap(size << 1);
        int capacity = bhNameValueMap.capacity;
        NameValueEntryNode[] valueEntryNodes = bhNameValueMap.valueEntryNodes;
        String[] names = values.keySet().toArray(new String[size]);
        long[] hashValues = new long[size];
        int[] remValues = new int[size];
        LinkedHashSet<Integer> remSet = new LinkedHashSet<Integer>();
        for (int bits = 0; bits < 15; ++bits) {
            long hashValue;
            String name;
            int i;
            remSet.clear();
            for (i = 0; i < size; ++i) {
                name = names[i];
                hashValue = FixedNameValueMap.bitHash(name, bits);
                int rem = (int)(hashValue & (long)(capacity - 1));
                hashValues[i] = hashValue;
                remValues[i] = rem;
                remSet.add(rem);
            }
            if (remSet.size() != size) continue;
            for (i = 0; i < size; ++i) {
                name = names[i];
                hashValue = hashValues[i];
                E value = values.get(name);
                valueEntryNodes[remValues[i]] = new NameValueEntryNode<E>(name.toCharArray(), value, hashValue);
            }
            if (bits == 0) {
                return new PHFixedNameValueMap(size, capacity, valueEntryNodes);
            }
            bhNameValueMap.bits = bits;
            bhNameValueMap.count = size;
            return bhNameValueMap;
        }
        FixedNameValueMap<E> dftNameValueMap = new FixedNameValueMap<E>(size << 1);
        LinkedHashSet<Long> hashValueSet = new LinkedHashSet<Long>();
        int primeValue = 5;
        int[] nArray = PRIMES;
        int value = nArray.length;
        for (int i = 0; i < value; ++i) {
            long hashValue;
            String name;
            int i2;
            int prime;
            primeValue = prime = nArray[i];
            hashValueSet.clear();
            remSet.clear();
            for (i2 = 0; i2 < size; ++i2) {
                name = names[i2];
                hashValue = FixedNameValueMap.primeHash(name, prime);
                int rem = (int)(hashValue & (long)(capacity - 1));
                hashValues[i2] = hashValue;
                remValues[i2] = rem;
                hashValueSet.add(hashValue);
                remSet.add(rem);
            }
            if (remSet.size() != size) continue;
            valueEntryNodes = dftNameValueMap.valueEntryNodes;
            dftNameValueMap.primeValue = primeValue;
            for (i2 = 0; i2 < size; ++i2) {
                name = names[i2];
                hashValue = hashValues[i2];
                E value2 = values.get(name);
                valueEntryNodes[remValues[i2]] = new NameValueEntryNode<E>(name.toCharArray(), value2, hashValue);
            }
            return dftNameValueMap;
        }
        dftNameValueMap.collision = hashValueSet.size() < size;
        dftNameValueMap.primeValue = primeValue;
        for (int i = 0; i < size; ++i) {
            String name = names[i];
            long hashValue = hashValues[i];
            E value3 = values.get(name);
            dftNameValueMap.putValue(name, hashValue, value3);
        }
        return dftNameValueMap;
    }

    public FixedNameValueMap(int size) {
        int capacity = FixedNameValueMap.tableSizeFor(size) << 1;
        if (size > 1) {
            capacity = Math.max(capacity, 16);
        }
        this.maxCount = size;
        this.capacity = capacity;
        this.mask = capacity - 1;
        this.valueEntryNodes = new NameValueEntryNode[capacity];
    }

    FixedNameValueMap(int capacity, NameValueEntryNode[] valueEntryNodes) {
        this.maxCount = capacity << 1;
        this.capacity = capacity;
        this.mask = capacity - 1;
        this.valueEntryNodes = valueEntryNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(String name, long keyHash, T value) {
        FixedNameValueMap fixedNameValueMap = this;
        synchronized (fixedNameValueMap) {
            if (this.count >= this.maxCount) {
                return;
            }
            ++this.count;
        }
        char[] keyChars = name.toCharArray();
        int index = (int)(keyHash & (long)this.mask);
        NameValueEntryNode<T> valueEntryNode = new NameValueEntryNode<T>(keyChars, value, keyHash);
        NameValueEntryNode<T> oldEntryNode = this.valueEntryNodes[index];
        this.valueEntryNodes[index] = valueEntryNode;
        if (oldEntryNode != null) {
            valueEntryNode.next = oldEntryNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        FixedNameValueMap fixedNameValueMap = this;
        synchronized (fixedNameValueMap) {
            this.count = 0;
            for (int i = 0; i < this.capacity; ++i) {
                this.valueEntryNodes[i] = null;
            }
        }
    }

    public T getValue(String field) {
        char[] buf = field.toCharArray();
        int hashValue = field.hashCode();
        return this.getValue(buf, 0, buf.length, (long)hashValue);
    }

    public T getValue(char[] buf, int beginIndex, int endIndex, long hashValue) {
        int len = endIndex - beginIndex;
        int index = (int)(hashValue & (long)this.mask);
        NameValueEntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode == null) {
            return null;
        }
        while (!FixedNameValueMap.equalsKey(buf, beginIndex, len, entryNode.key)) {
            entryNode = entryNode.next;
            if (entryNode != null) continue;
            return null;
        }
        return entryNode.value;
    }

    public T getValue(byte[] bytes, int beginIndex, int endIndex, long hashValue) {
        int len = endIndex - beginIndex;
        int index = (int)(hashValue & (long)this.mask);
        NameValueEntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode == null) {
            return null;
        }
        while (!FixedNameValueMap.equalsKey(bytes, beginIndex, len, entryNode.key)) {
            entryNode = entryNode.next;
            if (entryNode != null) continue;
            return null;
        }
        return entryNode.value;
    }

    public final T getValueByHash(long hashValue) {
        int index = (int)(hashValue & (long)this.mask);
        NameValueEntryNode<T> entryNode = this.valueEntryNodes[index];
        if (entryNode != null && entryNode.hash == hashValue) {
            return entryNode.value;
        }
        if (entryNode != null) {
            entryNode = entryNode.next;
            while (entryNode != null) {
                if (entryNode.hash == hashValue) {
                    return entryNode.value;
                }
                entryNode = entryNode.next;
            }
        }
        return null;
    }

    public boolean isCollision() {
        return this.collision;
    }

    public long hash(long hv, int c1, int c2) {
        hv = this.hash(hv, c1);
        return this.hash(hv, c2);
    }

    private static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static boolean equalsKey(char[] buf, int offset, int len, char[] key) {
        if (len != key.length) {
            return false;
        }
        for (int j = 0; j < len; ++j) {
            if (buf[offset++] == key[j]) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsKey(byte[] bytes, int offset, int len, char[] key) {
        if (len != key.length) {
            return false;
        }
        for (int j = 0; j < len; ++j) {
            if (bytes[offset++] == key[j]) continue;
            return false;
        }
        return true;
    }

    public long hash(long rv, int c) {
        return rv * (long)this.primeValue + (long)c;
    }

    static final long bitHash(String name, int bits) {
        long val = 0L;
        for (int i = 0; i < name.length(); ++i) {
            val = (val << bits) + (long)name.charAt(i);
        }
        return val;
    }

    static final long primeHash(String name, int primeValue) {
        long val = 0L;
        for (int i = 0; i < name.length(); ++i) {
            val = val * (long)primeValue + (long)name.charAt(i);
        }
        return val;
    }

    static class PHFixedNameValueMap<E>
    extends FixedNameValueMap {
        public PHFixedNameValueMap(int count, int capacity, NameValueEntryNode[] valueEntryNodes) {
            super(capacity, valueEntryNodes);
            this.count = count;
        }

        @Override
        public final long hash(long rv, int c) {
            return rv + (long)c;
        }

        @Override
        public long hash(long rv, int c1, int c2) {
            return rv + (long)c1 + (long)c2;
        }
    }

    static class BHFixedNameValueMap<E>
    extends FixedNameValueMap {
        private int bits;

        public BHFixedNameValueMap(int size) {
            super(size);
        }

        @Override
        public final long hash(long rv, int c) {
            return (rv << this.bits) + (long)c;
        }
    }

    static class NameValueEntryNode<T> {
        long hash;
        char[] key;
        T value;
        NameValueEntryNode<T> next;

        public NameValueEntryNode(char[] key, T value, long keyHash) {
            this.key = key;
            this.hash = keyHash;
            this.value = value;
        }
    }
}

