/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.yaml;

import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.yaml.YamlJSON;
import io.github.wycst.wast.yaml.YamlLine;
import io.github.wycst.wast.yaml.YamlParseException;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;

public class YamlNode
extends YamlLine {
    private YamlNode root;
    private YamlNode parent;
    private Map<String, YamlNode> fieldNodes;
    private List<YamlNode> children;
    private List<YamlNode> yamlNodes;
    private List<YamlNode> anchorYamlNodes;
    private boolean array;
    private YamlNode reference;

    YamlNode() {
    }

    void buildYamlTree(List<YamlNode> yamlNodes) {
        this.yamlNodes = yamlNodes;
        this.root = this;
        this.anchorYamlNodes = new ArrayList<YamlNode>();
        YamlNode prev = null;
        for (YamlNode yamlNode : yamlNodes) {
            yamlNode.root = this;
            if (prev == null) {
                this.setParent(yamlNode, this);
            } else {
                YamlNode parent;
                int indent = yamlNode.indent;
                int prevIndent = prev.indent;
                if (indent > prevIndent) {
                    if (prev.leaf) {
                        throw new YamlParseException("indent value(" + indent + ") error, The indent value of the leaf node cannot be greater than the indent value(" + prevIndent + ") of the prev node, at lineNum " + (yamlNode.lineNum + 1));
                    }
                    this.setParent(yamlNode, prev);
                } else if (indent == prevIndent) {
                    if (yamlNode.arrayToken && !prev.arrayToken) {
                        if (prev.leaf) {
                            throw new YamlParseException("indent value(" + indent + ") error, The indent value of the leaf node cannot be greater than the indent value(" + prevIndent + ") of the prev node, at lineNum " + yamlNode.lineNum);
                        }
                        this.setParent(yamlNode, prev);
                    } else {
                        parent = prev.parent;
                        this.setParent(yamlNode, parent);
                        if (prev.reference == null) {
                            prev.leaf = true;
                        }
                    }
                } else {
                    parent = prev.parent;
                    if (prev.reference == null) {
                        prev.leaf = true;
                    }
                    while (parent != null) {
                        int parentIndent = parent.indent;
                        if (indent > parentIndent) {
                            throw new RuntimeException("indent value " + indent + " error, the indent should less than or equal to " + parentIndent + ", at lineNum " + (yamlNode.lineNum + 1));
                        }
                        parent = parent.parent;
                        if (indent != parentIndent) continue;
                        break;
                    }
                    if (parent.leaf) {
                        throw new YamlParseException("indent value(" + indent + ") error, The indent value of the leaf node cannot be greater than the indent value(" + prevIndent + ") of the prev node, at lineNum " + yamlNode.lineNum);
                    }
                    this.setParent(yamlNode, parent);
                }
            }
            prev = yamlNode;
            if (yamlNode.anchorKey != null) {
                this.anchorYamlNodes.add(yamlNode);
            }
            if (yamlNode.referenceKey == null) continue;
            yamlNode.reference = this.getReference(this.anchorYamlNodes, yamlNode.referenceKey, yamlNode.lineNum);
            yamlNode.array = yamlNode.reference.array;
            yamlNode.leaf = yamlNode.reference.leaf;
        }
    }

    private YamlNode getReference(List<YamlNode> anchorYamlNodes, String key, int lineNum) {
        int len = anchorYamlNodes.size();
        for (int i = len - 1; i > -1; --i) {
            YamlNode yamlNode = anchorYamlNodes.get(i);
            if (yamlNode.lineNum >= lineNum || !yamlNode.anchorKey.equals(key)) continue;
            return yamlNode;
        }
        throw new YamlParseException("cannot find reference *" + key + " at lineNum " + lineNum);
    }

    private void setParent(YamlNode yamlNode, YamlNode parent) {
        yamlNode.parent = parent;
        if (yamlNode.arrayToken) {
            parent.array = true;
            if (parent.children == null) {
                parent.children = new ArrayList<YamlNode>();
            }
            parent.children.add(yamlNode);
            yamlNode.arrayIndex = parent.children.size() - 1;
        } else {
            String key;
            if (parent.fieldNodes == null) {
                parent.fieldNodes = new LinkedHashMap<String, YamlNode>();
            }
            String field = key = yamlNode.key;
            if (key.startsWith("\"") && key.endsWith("\"")) {
                field = key.substring(1, key.length() - 1);
            }
            parent.fieldNodes.put(field, yamlNode);
        }
    }

    void appendFullKey(StringBuilder builder) {
        if (this.parent != this.root) {
            this.parent.appendFullKey(builder);
            builder.append('.');
        }
        if (this.arrayToken) {
            builder.append('[').append(this.arrayIndex).append(']');
        } else {
            builder.append(this.key);
        }
    }

    public String getFullKey() {
        StringBuilder builder = new StringBuilder();
        this.appendFullKey(builder);
        return builder.toString();
    }

    public Properties toProperties() {
        List<YamlNode> yamlNodes = this.yamlNodes;
        if (this.root != null) {
            yamlNodes = this.root.yamlNodes;
        }
        StringBuilder builder = new StringBuilder();
        Properties properties = new Properties();
        for (YamlNode yamlNode : yamlNodes) {
            if (!yamlNode.leaf) continue;
            builder.setLength(0);
            yamlNode.appendFullKey(builder);
            Object value = yamlNode.getValue();
            properties.setProperty(builder.toString(), value == null ? "" : String.valueOf(value));
        }
        return properties;
    }

    public Map toMap() {
        if (this.array) {
            throw new UnsupportedOperationException("YamlNode is array does not support toMap. Please call toList");
        }
        if (this.fieldNodes == null) {
            return null;
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry<String, YamlNode> entry : this.fieldNodes.entrySet()) {
            String field = entry.getKey();
            YamlNode node = entry.getValue();
            this.putNodeValueOfMap(field, node, map);
        }
        return map;
    }

    private void putNodeValueOfMap(String field, YamlNode node, Map map) {
        if (node.leaf) {
            map.put(field, node.getValue());
        } else {
            String key = node.key;
            YamlNode reference = node.reference;
            if (reference != null) {
                node = reference;
            }
            if (node.array) {
                map.put(field, node.toList());
            } else {
                Map valueMap = node.toMap();
                if ("<<".equals(field) && key.length() == 2) {
                    map.putAll(valueMap);
                } else {
                    map.put(field, valueMap);
                }
            }
        }
    }

    public List toList() {
        if (!this.array) {
            throw new UnsupportedOperationException("Method toList is  does not support . Please call toMap()");
        }
        if (this.children == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (YamlNode yamlNode : this.children) {
            if (yamlNode.leaf) {
                list.add(yamlNode.getValue());
                continue;
            }
            if (yamlNode.array) {
                list.add(yamlNode.toList());
                continue;
            }
            list.add(yamlNode.toMap());
        }
        return list;
    }

    public <T> T toEntity(Class<T> actualType) {
        boolean isMapInstance;
        Object instance;
        if (this.leaf) {
            throw new UnsupportedOperationException(" NodeValue is a leaf value, please call method getValue() instead !");
        }
        if (actualType == null) {
            return (T)this.toMap();
        }
        if (actualType == String.class || actualType.isArray() || actualType.isEnum() || actualType.isPrimitive()) {
            throw new UnsupportedOperationException(" ActualType " + actualType + " is not  supported!");
        }
        ClassStructureWrapper classStructureWrapper = null;
        if (actualType == null || actualType == Map.class || actualType == LinkedHashMap.class) {
            instance = new LinkedHashMap();
            isMapInstance = true;
        } else {
            classStructureWrapper = ClassStructureWrapper.get(actualType);
            isMapInstance = classStructureWrapper.isAssignableFromMap();
            try {
                instance = !isMapInstance ? classStructureWrapper.newInstance() : actualType.newInstance();
            }
            catch (Throwable throwable) {
                throw new YamlParseException(" new instance error ", throwable);
            }
        }
        for (Serializable serializable : this.fieldNodes.keySet()) {
            Class<?> parameterType;
            YamlNode yamlNode = this.fieldNodes.get(serializable);
            if (isMapInstance) {
                Map map = (Map)instance;
                this.putNodeValueOfMap((String)((Object)serializable), yamlNode, map);
                continue;
            }
            String fieldName = serializable.toString();
            SetterInfo setterInfo = classStructureWrapper.getSetterInfo(fieldName);
            if (setterInfo == null) continue;
            Class<?> entityClass = parameterType = setterInfo.getParameterType();
            Class<?> collCls = null;
            Class<?> actualTypeArgumentType = setterInfo.getActualTypeArgument();
            if (actualTypeArgumentType != null) {
                entityClass = actualTypeArgumentType;
                collCls = parameterType;
            }
            Object value = yamlNode.array ? yamlNode.toCollection(collCls, entityClass) : (Date.class.isAssignableFrom(parameterType) ? yamlNode.getDate(parameterType) : yamlNode.getValue(entityClass));
            setterInfo.invoke(instance, value);
        }
        return (T)instance;
    }

    public Date getDate(Class<? extends Date> dateType) {
        if (this.typeOfValue != null && this.typeOfValue instanceof Date) {
            return (Date)this.typeOfValue;
        }
        return this.parseDatetime(String.valueOf(this.value));
    }

    public Object toCollection(Class<?> collectionCls, Class<?> entityClass) {
        if (this.children == null) {
            return null;
        }
        int size = this.children.size();
        Class<?> target = entityClass;
        AbstractCollection collection = null;
        boolean isArrayCls = false;
        Object arrayObj = null;
        if (collectionCls == null || collectionCls == ArrayList.class) {
            collection = new ArrayList();
        } else {
            isArrayCls = collectionCls.isArray();
            if (isArrayCls) {
                arrayObj = Array.newInstance(entityClass, this.children.size());
            } else if (collectionCls.isInterface()) {
                if (Set.class.isAssignableFrom(collectionCls)) {
                    collection = new LinkedHashSet();
                } else if (List.class.isAssignableFrom(collectionCls)) {
                    collection = new ArrayList();
                }
            } else if (collectionCls == HashSet.class) {
                collection = new HashSet();
            } else if (collectionCls == Vector.class) {
                collection = new Vector();
            }
        }
        for (int i = 0; i < size; ++i) {
            YamlNode yamlNode = this.children.get(i);
            Object result = null;
            result = yamlNode.array ? yamlNode.toList() : yamlNode.getValue(target);
            if (isArrayCls) {
                Array.set(arrayObj, i, result);
                continue;
            }
            collection.add(result);
        }
        return isArrayCls ? arrayObj : collection;
    }

    public String getRawValue() {
        return this.value;
    }

    public Object getValue() {
        if (this.reference != null) {
            return this.reference.getValue();
        }
        if (this.typeOfValue != null) {
            return this.typeOfValue;
        }
        if (this.valueType > 0) {
            switch (this.valueType) {
                case 1: 
                case 5: {
                    this.typeOfValue = String.valueOf(this.value);
                    break;
                }
                case 2: {
                    this.typeOfValue = Float.valueOf(Float.parseFloat(this.value));
                    break;
                }
                case 3: {
                    this.typeOfValue = Integer.parseInt(this.value);
                    break;
                }
                case 4: {
                    boolean bool;
                    if (this.value == null) {
                        this.typeOfValue = false;
                        break;
                    }
                    char ch = this.value.charAt(0);
                    int len = this.value.length();
                    if (len == 4 && (ch == 'T' || ch == 't') && this.value.endsWith("rue")) {
                        bool = true;
                    } else if (len == 5 && (ch == 'F' || ch == 'f') && this.value.endsWith("alse")) {
                        bool = false;
                    } else if (this.value.equalsIgnoreCase("ON")) {
                        bool = true;
                    } else if (this.value.equalsIgnoreCase("OFF")) {
                        bool = false;
                    } else if (this.value.equals("1")) {
                        bool = true;
                    } else if (this.value.equals("0")) {
                        bool = false;
                    } else {
                        throw new YamlParseException("value '" + this.value + "' cannot transform to bool type");
                    }
                    this.typeOfValue = bool;
                    break;
                }
                case 6: {
                    this.typeOfValue = this.parseDatetime(this.value);
                }
            }
            return this.typeOfValue;
        }
        return this.value;
    }

    private Date parseDatetime(String value) {
        long time;
        int len;
        char[] buffers = value.toCharArray();
        int to = len = value.length();
        int from = 0;
        String timezoneIdAt = null;
        TimeZone timeZone = null;
        if (len > 23) {
            char ch;
            int j = len - 1;
            while (j > from && (ch = value.charAt(--j)) != '.') {
                if (ch != '+' && ch != '-' && ch != 'Z') continue;
                timezoneIdAt = new String(buffers, j, len - j);
                to = j;
                len = to - from;
                break;
            }
            if (timezoneIdAt != null) {
                timeZone = timezoneIdAt.startsWith("GMT") ? TimeZone.getTimeZone(timezoneIdAt) : TimeZone.getTimeZone("GMT" + timezoneIdAt);
            }
        }
        if ((time = this.autoMatchDate(buffers, from, len, timeZone)) > -1L) {
            return new Timestamp(time);
        }
        return null;
    }

    private long autoMatchDate(char[] buf, int from, int len, TimeZone timeZone) {
        if (len == 19 || len == 21 || len == 22 || len == 23) {
            try {
                int year = YamlNode.parseInt(buf, from + 0, 4, 10);
                int month = YamlNode.parseInt(buf, from + 5, 2, 10);
                int day = YamlNode.parseInt(buf, from + 8, 2, 10);
                int hour = YamlNode.parseInt(buf, from + 11, 2, 10);
                int minute = YamlNode.parseInt(buf, from + 14, 2, 10);
                int second = YamlNode.parseInt(buf, from + 17, 2, 10);
                int millsecond = 0;
                if (len > 20) {
                    millsecond = YamlNode.parseInt(buf, from + 20, len - 20, 10);
                }
                GregorianDate date = new GregorianDate(year, month, day, hour, minute, second, millsecond, timeZone);
                return date.getTime();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1L;
    }

    public <E> Object getValue(Class<E> typeClass) {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        String strValue = String.valueOf(value);
        if (typeClass == null || typeClass == String.class) {
            return strValue;
        }
        if (typeClass == Integer.TYPE || typeClass == Integer.class) {
            return Integer.valueOf(strValue);
        }
        if (typeClass == Long.TYPE || typeClass == Long.class) {
            return Long.valueOf(strValue);
        }
        if (typeClass == Double.TYPE || typeClass == Double.class) {
            return Double.valueOf(strValue);
        }
        if (typeClass == Float.TYPE || typeClass == Float.class) {
            return Float.valueOf(strValue);
        }
        if (typeClass == Byte.TYPE || typeClass == Byte.class) {
            return Byte.valueOf(strValue);
        }
        if (typeClass == BigDecimal.class) {
            return new BigDecimal(strValue);
        }
        if (typeClass == BigInteger.class) {
            return new BigInteger(strValue);
        }
        if (Number.class.isAssignableFrom(typeClass)) {
            if (strValue.indexOf(46) > -1) {
                return Double.valueOf(strValue);
            }
            return Long.valueOf(strValue);
        }
        if (typeClass == Boolean.class || typeClass == Boolean.TYPE) {
            if (strValue.equalsIgnoreCase("true")) {
                return true;
            }
            if (strValue.equalsIgnoreCase("false")) {
                return false;
            }
            throw new IllegalArgumentException(String.format("%s Cannot convert to Boolean value ", strValue));
        }
        if (typeClass == Date.class) {
            return this.parseDatetime(strValue);
        }
        if (Enum.class.isAssignableFrom(typeClass)) {
            Class<E> enumCls = typeClass;
            return Enum.valueOf(enumCls, strValue);
        }
        return null;
    }

    public YamlNode root() {
        return this.root;
    }

    public YamlNode parent() {
        return this.parent;
    }

    public boolean isArray() {
        return this.array;
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeIndent(writer);
        if (this.key != null) {
            writer.write(this.key);
            writer.write(": ");
            if (!this.leaf) {
                this.writeNewLine(writer);
            }
        } else if (!this.leaf && this.arrayIndex > -1) {
            writer.write("- ");
            this.writeNewLine(writer);
        }
        if (this.array) {
            List<YamlNode> children = this.children;
            if (children == null) {
                children = this.reference.children;
            }
            int size = children.size();
            int i = 0;
            for (YamlNode yamlNode : children) {
                yamlNode.writeTo(writer);
                if (++i >= size) continue;
                this.writeNewLine(writer);
            }
        } else if (this.leaf) {
            this.writeLeafValue(writer);
        } else {
            Map<String, YamlNode> fieldNodes = this.fieldNodes;
            if (fieldNodes == null) {
                fieldNodes = this.reference.fieldNodes;
            }
            int size = fieldNodes.size();
            int i = 0;
            for (Map.Entry<String, YamlNode> entry : fieldNodes.entrySet()) {
                YamlNode node = entry.getValue();
                node.writeTo(writer);
                if (++i >= size) continue;
                this.writeNewLine(writer);
            }
        }
    }

    private void writeLeafValue(Writer writer) throws IOException {
        String value;
        this.writeArrayToken(writer);
        this.writeTypeToken(writer);
        Object val = this.getValue();
        if (val instanceof Map || val instanceof List) {
            value = YamlJSON.stringify(val);
        } else {
            value = val.toString();
            if (this.valueType == 1 && !this.textBlock) {
                value = "'" + value + "'";
            }
        }
        if (this.textBlock) {
            this.writeBlockToken(writer);
            this.writeNewLine(writer);
            String[] lines = value.split("\n");
            int len = lines.length;
            int i = 0;
            for (String line : lines) {
                this.writeIndent(writer, this.indent + 1);
                writer.write(line);
                if (++i >= len) continue;
                this.writeNewLine(writer);
            }
        } else {
            writer.write(value);
        }
    }

    public <E> E getPathValue(String childPath, Class<E> clazz) {
        YamlNode yamlNode = this.get(childPath);
        if (yamlNode == null) {
            return null;
        }
        if (yamlNode.leaf) {
            return (E)yamlNode.getValue(clazz);
        }
        return yamlNode.toEntity(clazz);
    }

    public YamlNode get(String childPath) {
        if (childPath == null || (childPath = childPath.trim()).length() == 0) {
            return this;
        }
        if (childPath.startsWith("/")) {
            return this.root.get(childPath.substring(1));
        }
        if (this.leaf) {
            return null;
        }
        int splitIndex = childPath.indexOf(47);
        if (splitIndex == -1) {
            return this.getChildNode(childPath);
        }
        String path = childPath.substring(0, splitIndex).trim();
        YamlNode childNode = this.getChildNode(path);
        if (childNode != null) {
            String nextPath = childPath.substring(splitIndex + 1).trim();
            return childNode.get(nextPath);
        }
        return null;
    }

    private YamlNode getChildNode(String path) {
        YamlNode value = null;
        if (this.array) {
            if (path.startsWith("[") && path.endsWith("]")) {
                int index = Integer.parseInt(path.substring(1, path.length() - 1));
                return this.children.get(index);
            }
            throw new IllegalArgumentException("current JSONNode is an isArray type, path should like []");
        }
        if (this.fieldNodes != null) {
            value = this.fieldNodes.get(path);
        }
        return value;
    }

    public void setPathValue(String path, Serializable value) {
        YamlNode node = this.get(path);
        if (node != null && node.leaf) {
            node.typeOfValue = value;
        }
    }
}

