/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.provider.nacos;

import io.github.wycst.wast.clients.http.definition.HttpClientConfig;
import io.github.wycst.wast.clients.http.provider.CloudServiceProvider;
import io.github.wycst.wast.clients.http.provider.FetchPropertiesCallback;
import io.github.wycst.wast.clients.http.provider.ServerZone;
import io.github.wycst.wast.clients.http.provider.nacos.ServiceInstanceResponse;
import io.github.wycst.wast.clients.http.provider.nacos.ServiceListResponse;
import io.github.wycst.wast.json.JSON;
import io.github.wycst.wast.log.Log;
import io.github.wycst.wast.log.LogFactory;
import io.github.wycst.wast.yaml.YamlDocument;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class NacosServiceProvider
extends CloudServiceProvider {
    private static Log log = LogFactory.getLog(NacosServiceProvider.class);
    public static final String CLOUD_NACOS_SERVER_ADDR_KEY = "cloud.nacos.server_addr";
    public static final String CLOUD_NACOS_USERNAME_KEY = "cloud.nacos.username";
    public static final String CLOUD_NACOS_PASSWORD_KEY = "cloud.nacos.password";
    public static final String CLOUD_NACOS_AUTH_ENABLED_KEY = "cloud.nacos.auth.enabled";
    public static final String CLOUD_NACOS_AUTH_REFRESH_INTERVAL_KEY = "cloud.nacos.auth.tokenRefreshInterval";
    public static final String CLOUD_NACOS_CONFIG_DATA_IDS_KEY = "cloud.nacos.config.dataIds";
    public static final String CLOUD_NACOS_CONFIG_GROUPS_KEY = "cloud.nacos.config.groups";
    public static final String CLOUD_NACOS_CONFIG_TENANTS_KEY = "cloud.nacos.config.tenants";
    public static final String CLOUD_NACOS_INSTANCE_IP_KEY = "cloud.nacos.instance.ip";
    public static final String CLOUD_NACOS_INSTANCE_SERVICE_NAME_KEY = "cloud.nacos.instance.serviceName";
    public static final String CLOUD_NACOS_INSTANCE_SERVICE_PORT_KEY = "cloud.nacos.instance.servicePort";
    public static final String CLOUD_NACOS_INSTANCE_NAMESPACE_ID_KEY = "cloud.nacos.instance.namespaceId";
    public static final String CLOUD_NACOS_INSTANCE_BEAT_METHOD_KEY = "cloud.nacos.instance.beat.method";
    public static final String CLOUD_NACOS_INSTANCE_CHECK_HEALTHY_INTERVAL_KEY = "cloud.nacos.instance.checkHealthyInterval";
    public static final String CLOUD_NACOS_INSTANCE_ENABLE_KEY = "cloud.nacos.instance.enable";
    private String serverAddr;
    private String username;
    private String password;
    private boolean auth;
    private long authRefreshInterval;
    private String accessTokenKeyAndValue;
    private String nacosServerName;
    private String[] dataIds;
    private String[] groups;
    private String[] tenants;
    private int configCount;
    private boolean instanceBeatByRegister;
    private String instanceIp;
    private String instanceServiceName;
    private String instancePort;
    private String instanceNamespaceId;
    private String nacosAuthUrl;
    private String baseNacosInstanceUrl;
    private String baseNacosConfigsUrl;
    private String baseNacosCheckHealthyUrl;
    private String nacosInstanceUrl;
    private String nacosConfigsUrl;
    private String nacosCheckHealthyUrl;

    public NacosServiceProvider(Properties nacosProperties) {
        this(nacosProperties, null);
    }

    public NacosServiceProvider(FetchPropertiesCallback fetchPropertiesCallback) {
        this(null, fetchPropertiesCallback);
    }

    public NacosServiceProvider(Properties nacosProperties, FetchPropertiesCallback fetchPropertiesCallback) {
        super(nacosProperties, fetchPropertiesCallback);
    }

    @Override
    protected void fetchServiceInstanceList() {
        try {
            String accessTokenKeyAndValue = this.accessTokenKeyAndValue == null ? "" : this.accessTokenKeyAndValue;
            String serviceListUrl = String.format("http://%s/nacos/v1/ns/service/list?pageNo=1&pageSize=100000&%s", this.nacosServerName, accessTokenKeyAndValue);
            if (this.instanceNamespaceId != null) {
                serviceListUrl = serviceListUrl + "&namespaceId=" + this.instanceNamespaceId;
            }
            ServiceListResponse serviceListResponse = this.httpClient.get(serviceListUrl, ServiceListResponse.class);
            List<String> doms = serviceListResponse.getDoms();
            this.clearIfNotExist(doms);
            for (String serviceName : doms) {
                String instanceListUrl = String.format("http://%s/nacos/v1/ns/instance/list?serviceName=%s&healthyOnly=true&%s", this.nacosServerName, serviceName, accessTokenKeyAndValue);
                if (this.instanceNamespaceId != null) {
                    instanceListUrl = instanceListUrl + "&namespaceId=" + this.instanceNamespaceId;
                }
                ServiceInstanceResponse serviceInstanceResponse = this.httpClient.get(instanceListUrl, ServiceInstanceResponse.class);
                List<Map> hosts = serviceInstanceResponse.getHosts();
                ArrayList<String> serviceUrls = new ArrayList<String>();
                if (hosts == null || hosts.size() <= 0) continue;
                for (Map host : hosts) {
                    String ip = (String)host.get("ip");
                    Integer port = (Integer)host.get("port");
                    serviceUrls.add(ip + ":" + port);
                }
                ServerZone serverZone = new ServerZone(serviceName, serviceUrls);
                this.registerServer(serverZone);
            }
        }
        catch (Throwable throwable) {
            log.debug("fetchServiceInstanceList error: {}", throwable.getMessage());
        }
    }

    @Override
    protected void doHealthyCheck() {
        try {
            if (!this.status) {
                this.registerInstance();
            } else if (this.instanceBeatByRegister) {
                this.registerInstance();
            } else {
                HashMap<String, String> beatInfo = new HashMap<String, String>();
                beatInfo.put("port", this.instancePort);
                beatInfo.put("ip", this.instanceIp);
                beatInfo.put("serviceName", this.instanceServiceName);
                beatInfo.put("namespaceId", this.instanceNamespaceId);
                beatInfo.put("healthy", "true");
                beatInfo.put("weight", "1.0");
                HttpClientConfig requestConfig = new HttpClientConfig();
                requestConfig.addTextParameter("namespaceId", this.instanceNamespaceId);
                requestConfig.addTextParameter("serviceName", this.instanceServiceName);
                requestConfig.addTextParameter("ephemeral", "false");
                requestConfig.addTextParameter("beat", JSON.toJsonString(beatInfo));
                Map result = this.httpClient.put(this.nacosCheckHealthyUrl, Map.class, requestConfig);
                this.status = result != null && result.containsKey("clientBeatInterval");
                log.debug("healthy check result: {}", result);
            }
        }
        catch (Throwable throwable) {
            this.status = false;
            log.debug("healthy check error: {}", throwable.getMessage());
        }
    }

    @Override
    protected void fetchClientConfig() {
        log.info("configCount {}", this.configCount);
        if (this.configCount > 0 && this.fetchPropertiesCallback != null) {
            for (int i = 0; i < this.configCount; ++i) {
                try {
                    String dataId = this.dataIds[i].trim();
                    boolean isYaml = dataId.toLowerCase().endsWith(".yml") || dataId.toLowerCase().endsWith(".yaml");
                    String configUrl = String.format("%sdataId=%s&group=%s&tenant=%s", this.nacosConfigsUrl, dataId, this.groups[i], this.tenants[i]);
                    log.info("fetch configUrl {}", configUrl);
                    InputStream is = this.httpClient.get(configUrl, InputStream.class);
                    if (isYaml) {
                        Properties properties = YamlDocument.loadProperties(is);
                        this.fetchPropertiesCallback.loadProperties(properties);
                        continue;
                    }
                    this.fetchPropertiesCallback.loadProperties(is);
                    continue;
                }
                catch (Throwable throwable) {
                    log.debug(throwable.getMessage(), new Object[0]);
                }
            }
        }
    }

    @Override
    protected void registerInstance() {
        try {
            HttpClientConfig requestConfig = new HttpClientConfig();
            requestConfig.addTextParameter("port", this.instancePort);
            requestConfig.addTextParameter("ip", this.instanceIp);
            requestConfig.addTextParameter("serviceName", this.instanceServiceName);
            requestConfig.addTextParameter("namespaceId", this.instanceNamespaceId);
            requestConfig.addTextParameter("healthy", "true");
            requestConfig.addTextParameter("weight", "1.0");
            requestConfig.addTextParameter("metadata", "{}");
            String result = this.httpClient.post(this.nacosInstanceUrl, String.class, requestConfig);
            log.debug("result {}", result);
            this.status = "OK".equalsIgnoreCase(result);
        }
        catch (Throwable throwable) {
            log.debug("nacos register fail - {}", this.nacosInstanceUrl);
            log.debug(throwable.getMessage(), new Object[0]);
        }
    }

    @Override
    protected void initBase() {
        this.serverAddr = this.getProperty(CLOUD_NACOS_SERVER_ADDR_KEY);
        if (this.serverAddr == null) {
            log.info("nacos config '{}' is required ", CLOUD_NACOS_SERVER_ADDR_KEY);
            return;
        }
        this.enableClient = true;
        log.info("nacos serverAddr {}", this.serverAddr);
        this.username = this.getProperty(CLOUD_NACOS_USERNAME_KEY);
        this.password = this.getProperty(CLOUD_NACOS_PASSWORD_KEY);
        this.auth = "true".equals(this.getProperty(CLOUD_NACOS_AUTH_ENABLED_KEY));
        if (this.serverAddr.indexOf(",") == -1) {
            this.nacosAuthUrl = String.format("http://%s/nacos/v1/auth/login", this.serverAddr);
            this.nacosInstanceUrl = String.format("http://%s/nacos/v1/ns/instance", this.serverAddr);
            this.nacosCheckHealthyUrl = String.format("http://%s/nacos/v1/ns/instance/beat", this.serverAddr);
            this.nacosConfigsUrl = String.format("http://%s/nacos/v1/cs/configs?", this.serverAddr);
            this.nacosServerName = this.serverAddr;
        } else {
            String[] servers = this.serverAddr.split(",");
            this.nacosServerName = "nacos-cluster";
            ServerZone serverZone = new ServerZone(this.nacosServerName, servers, true);
            this.setHttpClientServiceProvider();
            this.registerServer(serverZone);
            this.nacosAuthUrl = String.format("http://%s/nacos/v1/auth/login", this.nacosServerName);
            this.nacosInstanceUrl = String.format("http://%s/nacos/v1/ns/instance", this.nacosServerName);
            this.nacosCheckHealthyUrl = String.format("http://%s/nacos/v1/ns/instance/beat", this.nacosServerName);
            this.nacosConfigsUrl = String.format("http://%s/nacos/v1/cs/configs?", this.nacosServerName);
        }
        this.baseNacosInstanceUrl = this.nacosInstanceUrl;
        this.baseNacosCheckHealthyUrl = this.nacosCheckHealthyUrl;
        this.baseNacosConfigsUrl = this.nacosConfigsUrl;
        log.info("cloud.nacos.auth.enabled {}", this.auth);
        if (this.auth) {
            try {
                String authRefreshInterval = this.getProperty(CLOUD_NACOS_AUTH_REFRESH_INTERVAL_KEY);
                this.authRefreshInterval = Long.parseLong(authRefreshInterval.trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.handleNacosAccessToken();
            if (this.authRefreshInterval > 0L) {
                log.info("cloud.nacos.auth.refreshInterval {}", this.authRefreshInterval);
                this.tokenRefreshScheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        NacosServiceProvider.this.handleNacosAccessToken();
                    }
                }, this.authRefreshInterval, this.authRefreshInterval, TimeUnit.SECONDS);
            }
        }
        this.initConfigParams();
    }

    void handleNacosAccessToken() {
        HttpClientConfig clientConfig = new HttpClientConfig();
        clientConfig.addTextParameter("username", this.username);
        clientConfig.addTextParameter("password", this.password);
        String accessTokenKeyAndValue = "";
        try {
            Map map = this.httpClient.post(this.nacosAuthUrl, Map.class, clientConfig);
            if (map != null && map.containsKey("accessToken")) {
                String accessToken = map.get("accessToken").toString();
                accessTokenKeyAndValue = "accessToken=" + accessToken;
                this.nacosInstanceUrl = this.baseNacosInstanceUrl + "?" + accessTokenKeyAndValue;
                this.nacosCheckHealthyUrl = this.baseNacosCheckHealthyUrl + "?" + accessTokenKeyAndValue;
                this.nacosConfigsUrl = this.baseNacosConfigsUrl + accessTokenKeyAndValue + "&";
            } else {
                log.warn("Failed to get Nacos accessToken ", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.accessTokenKeyAndValue = accessTokenKeyAndValue;
    }

    @Override
    protected void initInstanceConfig() {
        this.instanceIp = this.getProperty(CLOUD_NACOS_INSTANCE_IP_KEY);
        this.instanceServiceName = this.getProperty(CLOUD_NACOS_INSTANCE_SERVICE_NAME_KEY);
        this.instancePort = this.getProperty(CLOUD_NACOS_INSTANCE_SERVICE_PORT_KEY);
        if (this.instancePort == null) {
            this.instancePort = this.getProperty("server.port");
        }
        this.instanceNamespaceId = this.getProperty(CLOUD_NACOS_INSTANCE_NAMESPACE_ID_KEY);
        this.instanceBeatByRegister = this.getProperty(CLOUD_NACOS_INSTANCE_BEAT_METHOD_KEY) != null;
        String instanceCheckHealthyInterval = this.getProperty(CLOUD_NACOS_INSTANCE_CHECK_HEALTHY_INTERVAL_KEY);
        try {
            this.instanceCheckHealthyInterval = Long.parseLong(instanceCheckHealthyInterval.trim());
        }
        catch (Throwable throwable) {
            this.instanceCheckHealthyInterval = 30L;
        }
        if (this.instanceIp != null && this.instancePort != null && this.instanceServiceName != null) {
            String enable = this.getProperty(CLOUD_NACOS_INSTANCE_ENABLE_KEY);
            this.instanceEnable = enable != null && !"false".equals(enable);
        } else {
            log.warn("The instance cannot be registered because the ip, port, or serviceName is empty.", new Object[0]);
        }
    }

    private void initConfigParams() {
        try {
            String dataIds = this.getProperty(CLOUD_NACOS_CONFIG_DATA_IDS_KEY);
            String groups = this.getProperty(CLOUD_NACOS_CONFIG_GROUPS_KEY);
            String tenants = this.getProperty(CLOUD_NACOS_CONFIG_TENANTS_KEY);
            this.dataIds = dataIds == null ? new String[]{} : dataIds.trim().split(",");
            this.groups = groups == null ? new String[]{} : groups.trim().split(",");
            this.tenants = tenants == null ? new String[]{} : tenants.trim().split(",");
            this.configCount = Math.min(this.dataIds.length, Math.min(this.groups.length, this.tenants.length));
        }
        catch (Throwable throwable) {
            log.debug("initBase config error: {}", throwable.getMessage());
        }
    }
}

