/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.MemoryOptimizerUtils;

public final class AsciiStringSource
implements CharSource {
    private final String input;
    private final byte[] bytes;

    public AsciiStringSource(String input, byte[] bytes) {
        this.bytes = bytes;
        this.input = input;
    }

    public static AsciiStringSource of(String input, byte[] bytes) {
        return new AsciiStringSource(input, bytes);
    }

    public static AsciiStringSource of(String input) {
        byte[] bytes = (byte[])UnsafeHelper.getStringValue(input);
        return new AsciiStringSource(input, bytes);
    }

    public static AsciiStringSource of(byte[] bytes) {
        String input = UnsafeHelper.getAsciiString(bytes);
        return new AsciiStringSource(input, bytes);
    }

    @Override
    public byte[] byteArray() {
        return this.bytes;
    }

    @Override
    public String input() {
        return this.input;
    }

    @Override
    public int indexOf(int ch, int beginIndex) {
        return this.input.indexOf(ch, beginIndex);
    }

    @Override
    public String substring(int beginIndex, int endIndex) {
        return UnsafeHelper.getAsciiString(MemoryOptimizerUtils.copyOfRange(this.bytes, beginIndex, endIndex - beginIndex));
    }
}

