/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.utils.NumberUtils;
import java.io.Serializable;
import java.util.TimeZone;

public class GregorianDate
extends GeneralDate
implements Serializable,
Comparable<GregorianDate> {
    protected int dayOfWeek;
    protected int weekOfMonth;
    protected int weekOfYear;

    public GregorianDate() {
        this(System.currentTimeMillis());
    }

    public GregorianDate(long timeMills) {
        this(timeMills, (TimeZone)null);
    }

    public GregorianDate(TimeZone timeZone) {
        this(System.currentTimeMillis(), timeZone);
    }

    public GregorianDate(long timeMills, TimeZone timeZone) {
        super(timeZone);
        this.setTime(timeMills);
    }

    public GregorianDate(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0, null);
    }

    public GregorianDate(int year, int month, int day, int hour, int minute, int second, int millsecond) {
        this(year, month, day, hour, minute, second, millsecond, null);
    }

    public GregorianDate(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        super(timeZone);
        this.set(year, month, day, hour, minute, second, millisecond, timeZone);
    }

    public static GregorianDate parse(String dateStr) {
        GeneralDate generalDate = GregorianDate.parseGeneralDate(dateStr, null);
        return new GregorianDate(generalDate.year, generalDate.month, generalDate.dayOfMonth, generalDate.hourOfDay, generalDate.minute, generalDate.second, 0);
    }

    public static GregorianDate parse(String dateStr, String template) {
        if (template == null) {
            return GregorianDate.parse(dateStr);
        }
        char[] dateBuf = dateStr.toCharArray();
        return GregorianDate.parse(dateBuf, 0, dateBuf.length, template);
    }

    public static GregorianDate parse(char[] buf, int offset, int len, String template) {
        DateTemplate dateTemplate = new DateTemplate(template);
        return GregorianDate.parse(buf, offset, len, dateTemplate);
    }

    public static GregorianDate parse(char[] buf, int offset, int len, DateTemplate dateTemplate) {
        dateTemplate.getClass();
        return dateTemplate.parse(buf, offset, len);
    }

    public GregorianDate add(int type, int count) {
        switch (type) {
            case 1: {
                this.year += count;
                this.updateTime();
                break;
            }
            case 2: {
                this.month += count;
                this.updateTime();
                break;
            }
            case 3: {
                long timeMills = this.timeMills + (long)count * 24L * 3600L * 1000L;
                this.setTime(timeMills);
                break;
            }
        }
        return this;
    }

    public long interval(GregorianDate target) {
        return target.getTime() - this.timeMills;
    }

    public long intervalDays(GregorianDate target) {
        return (target.getTime() - this.timeMills) / 86400000L;
    }

    public long intervalHours(GregorianDate target) {
        return (target.getTime() - this.timeMills) / 3600000L;
    }

    public GregorianDate set(int year, int month, int day) {
        return this.set(year, month, day, this.hourOfDay, this.minute, this.second, this.millisecond, null);
    }

    public GregorianDate set(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return this.set(year, month, day, hour, minute, second, millisecond, null);
    }

    public GregorianDate set(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        this.ofTimeZone(timeZone);
        this.year = year;
        this.month = month;
        this.dayOfMonth = day;
        this.hourOfDay = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
        this.updateTime();
        return this;
    }

    @Override
    protected void updateTime() {
        super.updateTime();
        int dayOfWeek = (int)((5L + this.currentDays - 719164L - 1L) % 7L + 1L);
        if (dayOfWeek <= 0) {
            dayOfWeek += 7;
        }
        this.dayOfWeek = dayOfWeek;
        int n = this.weekOfYear = this.daysOfYear % 7 == 0 ? this.daysOfYear / 7 : this.daysOfYear / 7 + 1;
        if (!this.validate()) {
            this.setTime(this.timeMills, true);
        }
        this.weekOfMonth = this.dayOfMonth % 7 == 0 ? this.dayOfMonth / 7 : this.dayOfMonth / 7 + 1;
        this.afterDateChange();
    }

    protected void afterDateChange() {
    }

    private boolean validate() {
        if (this.month < 1 || this.month > 12 || this.dayOfMonth < 1 || this.dayOfMonth > 31 || this.hourOfDay < 0 || this.hourOfDay > 23 || this.minute < 0 || this.minute > 59 || this.second < 0 || this.second > 59 || this.millisecond < 0 || this.millisecond > 999) {
            return false;
        }
        if (this.month == 4 || this.month == 6 || this.month == 9 || this.month == 11) {
            if (this.dayOfMonth == 31) {
                return false;
            }
        } else if (this.month == 2) {
            if (this.dayOfMonth > 29) {
                return false;
            }
            if (!this.leapYear && this.dayOfMonth == 29) {
                return false;
            }
        }
        return true;
    }

    public GregorianDate setYear(int year) {
        if (this.year == year) {
            return this;
        }
        this.year = year;
        this.updateTime();
        return this;
    }

    public GregorianDate setMonth(int month) {
        if (this.month == month) {
            return this;
        }
        this.month = month;
        this.updateTime();
        return this;
    }

    public GregorianDate setDay(int day) {
        if (this.dayOfMonth == day) {
            return this;
        }
        this.dayOfMonth = day;
        this.updateTime();
        return this;
    }

    public GregorianDate setHourOfDay(int hourOfDay) {
        if (this.hourOfDay == hourOfDay) {
            return this;
        }
        this.hourOfDay = hourOfDay;
        this.updateTime();
        return this;
    }

    public GregorianDate setMinute(int minute) {
        if (this.minute == minute) {
            return this;
        }
        this.minute = minute;
        this.updateTime();
        return this;
    }

    public GregorianDate setSecond(int second) {
        if (this.second == second) {
            return this;
        }
        this.second = second;
        this.updateTime();
        return this;
    }

    public GregorianDate setMillisecond(int millisecond) {
        if (this.millisecond == millisecond) {
            return this;
        }
        this.millisecond = millisecond;
        this.updateTime();
        return this;
    }

    public int getDaysOfYear() {
        return this.daysOfYear;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public boolean isLeapYear() {
        return this.leapYear;
    }

    @Override
    public void setTime(long timeMills, boolean reset) {
        if (this.timeMills == timeMills && !reset) {
            return;
        }
        super.setTime(timeMills, reset);
        int dayOfWeek = (int)((5L + this.currentDays - 719164L - 1L) % 7L + 1L);
        if (dayOfWeek <= 0) {
            dayOfWeek += 7;
        }
        this.dayOfWeek = dayOfWeek;
        this.weekOfMonth = this.dayOfMonth % 7 == 0 ? this.dayOfMonth / 7 : this.dayOfMonth / 7 + 1;
        this.weekOfYear = this.daysOfYear % 7 == 0 ? this.daysOfYear / 7 : this.daysOfYear / 7 + 1;
        this.afterDateChange();
    }

    public void setTime(long timeMills) {
        this.setTime(timeMills, false);
    }

    public static boolean isSameDay(long sourceTimemills, long targetTimeMills) {
        return (sourceTimemills + 62135769600000L + GregorianDate.getDefaultOffset()) / 86400000L == (targetTimeMills + 62135769600000L + GregorianDate.getDefaultOffset()) / 86400000L;
    }

    public String toString() {
        return this.format();
    }

    public String toDateString() {
        return this.year + "-" + this.month + "-" + this.dayOfMonth + " " + this.hourOfDay + ":" + this.minute + ":" + this.second + "." + this.millisecond;
    }

    public String format() {
        return this.format('-', ':');
    }

    public String format(char dateSyntax, char timeSyntax) {
        char[] buf = new char[25];
        int offset = 0;
        int year = this.year;
        if (year < 0) {
            buf[offset++] = 45;
            year = -year;
        }
        offset = year < 10000 ? (offset += NumberUtils.writeFourDigits(year, buf, offset)) : (offset += NumberUtils.writePositiveLong((long)year, buf, offset));
        offset += NumberUtils.writeTwoDigitsAndPreSuffix(this.month, dateSyntax, dateSyntax, buf, offset);
        offset += NumberUtils.writeTwoDigits(this.dayOfMonth, buf, offset);
        offset += NumberUtils.writeTwoDigitsAndPreSuffix(this.hourOfDay, ' ', timeSyntax, buf, offset);
        offset += NumberUtils.writeTwoDigits(this.minute, buf, offset);
        buf[offset++] = timeSyntax;
        offset += NumberUtils.writeTwoDigits(this.second, buf, offset);
        return new String(buf, 0, offset);
    }

    public String format(String template) {
        if (template == null) {
            return this.format();
        }
        StringBuilder writer = new StringBuilder();
        this.formatTo(template, writer);
        return writer.toString();
    }

    public void formatTo(String template, Appendable appendable) {
        DateTemplate.formatTo(this.year, this.month, this.dayOfMonth, this.hourOfDay, this.minute, this.second, this.millisecond, this.dayOfWeek, this.daysOfYear, this.weekOfMonth, this.weekOfYear, this.timeZone, template, appendable);
    }

    public void formatTo(String template, Appendable appendable, boolean escapeQuot) {
        DateTemplate.formatTo(this.year, this.month, this.dayOfMonth, this.hourOfDay, this.minute, this.second, this.millisecond, this.dayOfWeek, this.daysOfYear, this.weekOfMonth, this.weekOfYear, this.timeZone, template, appendable, escapeQuot);
    }

    @Override
    public int compareTo(GregorianDate o) {
        if (this.timeMills == o.timeMills) {
            return 0;
        }
        return this.timeMills > o.timeMills ? 1 : -1;
    }
}

