/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.GregorianDate;
import java.util.TimeZone;

public class LunarDate
extends GregorianDate {
    private int lunarYear;
    private int lunarMonth;
    private int lunarDay;
    private boolean leapMonth;
    private int stemsYearIndex;
    private int branchesYearIndex;
    private int stemsMonthIndex;
    private int branchesMonthIndex;
    private int stemsDayIndex;
    private int branchesDayIndex;
    public static StemsBranchesType stemsBranchesType = StemsBranchesType.SpringFestival;
    private String zodiac;
    private String constellation;
    private int solarTerms;
    private static final String[] LUNAR_MONTHS = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u51ac\u6708", "\u814a\u6708"};
    private static final String[] SOLAR_TERMS = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    private static final String[] LUNAR_DAYS = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    private static final String[] HEAVENLY_STEMS = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] EARTHLY_BRANCHES = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] CHINESE_ZODIAC = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final int[] CONSTELLATIONS_OFFSETS = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] TWELVE_CONSTELLATIONS = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
    public static final long[] LUNAR_DATA = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    public static final long LUNAR_DATA_TIME_BEGIN;
    public static final long LUNAR_DATA_TIME_END;
    private static final int[] DAYS_COUNT_OF_YEAR;
    private static final int[][] DAYS_COUNT_OF_MONTHS;
    private static final int[] LEAP_MONTH_INDEXOF_YEARS;
    private static final int[] SPRING_FESTIVAL_DAY_INDEXS;
    private static final long[] SOLAR_TERMS_2019;
    private boolean disableAutoUpdate;

    public LunarDate() {
    }

    public LunarDate(GregorianDate date) {
        this.fromDate(date);
    }

    private void fromDate(GregorianDate date) {
        this.year = date.year;
        this.month = date.month;
        this.dayOfMonth = date.dayOfMonth;
        this.daysOfYear = date.daysOfYear;
        this.hourOfDay = date.hourOfDay;
        this.minute = date.minute;
        this.second = date.second;
        this.millisecond = date.millisecond;
        this.leapYear = date.leapYear;
        this.timeMills = date.timeMills;
        this.currentOffset = date.currentOffset;
        this.compute();
    }

    public LunarDate(int year, int month, int day) {
        this(year, month, day, null);
    }

    public LunarDate(int year, int month, int day, TimeZone timeZone) {
        this(year, month, day, 0, 0, 0, timeZone);
    }

    public LunarDate(int year, int month, int day, int hour, int minute, int second, TimeZone timeZone) {
        super(year, month, day, hour, minute, second, 0, null);
    }

    public LunarDate(int year, int month, int day, int hour, int minute, int second) {
        this(year, month, day, hour, minute, second, null);
    }

    private static int[] getMonthTypeArr(long monthTypes) {
        String monthTypesStr = Long.toBinaryString(monthTypes);
        int[] monthTypeArr = new int[12];
        int len = monthTypesStr.length();
        int i = 12 - len;
        for (int j = 0; j < len; ++j) {
            monthTypeArr[i] = monthTypesStr.charAt(j) == '0' ? 0 : 1;
            ++i;
        }
        return monthTypeArr;
    }

    private void compute() {
        block9: {
            int year = this.getYear();
            int daysOfYear = this.getDaysOfYear();
            if (this.timeMills >= LUNAR_DATA_TIME_BEGIN && this.timeMills < LUNAR_DATA_TIME_END) {
                int leapCount = (year - 1) / 4 - (year - 1) / 100 + (year - 1) / 400 - 460;
                int days = (year - 1900) * 365 + leapCount + daysOfYear - 1;
                days -= 30;
                int total = 0;
                for (int i = 0; i < 150; ++i) {
                    int daysCountOfYear = DAYS_COUNT_OF_YEAR[i];
                    if (total + daysCountOfYear > days) {
                        this.lunarYear = i + 1900;
                        int[] monthDays = DAYS_COUNT_OF_MONTHS[i];
                        for (int j = 0; j < monthDays.length; ++j) {
                            int daysOfMonth = monthDays[j];
                            if ((total += daysOfMonth) <= days) continue;
                            int day = daysOfMonth - (total - days) + 1;
                            int leapMonthIndex = LEAP_MONTH_INDEXOF_YEARS[i];
                            if (leapMonthIndex == 0 || j < leapMonthIndex) {
                                this.lunarMonth = j + 1;
                            } else {
                                this.lunarMonth = j;
                                if (j == leapMonthIndex) {
                                    this.leapMonth = true;
                                }
                            }
                            this.lunarDay = day;
                            break block9;
                        }
                        break;
                    }
                    total += daysCountOfYear;
                }
            } else {
                int index = ((year - 1900) % 19 + 19) % 19;
                int springFestivalDayIndex = SPRING_FESTIVAL_DAY_INDEXS[index];
                this.lunarYear = daysOfYear < springFestivalDayIndex ? year - 1 : year;
                this.monthLocationAt(index + 19, year - this.lunarYear);
            }
        }
        this.initStemsBranches();
        int constellationIndex = this.month - 1;
        int offset = CONSTELLATIONS_OFFSETS[constellationIndex];
        if (this.dayOfMonth < offset) {
            constellationIndex += 11;
        }
        this.constellation = TWELVE_CONSTELLATIONS[constellationIndex % 12];
    }

    private void monthLocationAt(int yearIndex, int offset) {
        int leapCount = (yearIndex - 1) / 4;
        int beginYear = this.year;
        int endYear = beginYear + yearIndex;
        int daysOfYear = this.daysOfYear;
        if ((endYear & 3) == 0) {
            if (daysOfYear > 59) {
                ++daysOfYear;
            }
        } else if (this.isLeapYear() && daysOfYear > 60) {
            --daysOfYear;
        }
        int days = yearIndex * 365 + leapCount + daysOfYear - 1;
        days -= 30;
        int actualIndex = yearIndex - offset;
        for (int i = 0; i < actualIndex; ++i) {
            days -= DAYS_COUNT_OF_YEAR[i];
        }
        int[] monthDays = DAYS_COUNT_OF_MONTHS[actualIndex];
        for (int i = 0; i < monthDays.length; ++i) {
            int daysOfMonth = monthDays[i];
            if (days <= daysOfMonth - 1) {
                if (days <= 0 || days >= daysOfMonth - 1) break;
                int leapMonthIndex = LEAP_MONTH_INDEXOF_YEARS[actualIndex];
                if (leapMonthIndex == 0 || i < leapMonthIndex) {
                    this.lunarMonth = i + 1;
                    break;
                }
                this.lunarMonth = i;
                if (this.lunarMonth != leapMonthIndex) break;
                this.leapMonth = true;
                break;
            }
            days -= daysOfMonth;
        }
    }

    private void initStemsBranches() {
        this.clear();
        int years = this.year - 4;
        this.stemsYearIndex = (years % 10 + 10) % 10;
        this.branchesYearIndex = (years % 12 + 12) % 12;
        boolean isPrevStemsBranches = false;
        if (stemsBranchesType == null || stemsBranchesType == StemsBranchesType.SpringFestival) {
            isPrevStemsBranches = this.lunarYear < this.year;
        } else {
            int solarTermsIndex = 2;
            long solarTermsTimemills = SOLAR_TERMS_2019[solarTermsIndex] + (long)(this.year - 2019) * 31556925216L;
            if (LunarDate.isSameDay(solarTermsTimemills, this.timeMills)) {
                this.solarTerms = 2;
            } else {
                boolean bl = isPrevStemsBranches = this.timeMills < solarTermsTimemills;
            }
        }
        if (isPrevStemsBranches) {
            this.stemsYearIndex = this.stemsYearIndex == 0 ? 9 : this.stemsYearIndex - 1;
            this.branchesYearIndex = this.branchesYearIndex == 0 ? 11 : this.branchesYearIndex - 1;
        }
        int months = (this.year - 1900) * 12 + this.month - 1;
        this.stemsMonthIndex = (months % 10 + 3 + 10) % 10;
        this.branchesMonthIndex = (months % 12 + 1 + 12) % 12;
        int solarTermsType = 3;
        if (this.month == 2) {
            if (this.dayOfMonth < 3) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 5) {
                solarTermsType = 2;
            }
        } else if (this.month == 3) {
            if (this.dayOfMonth < 5) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 7) {
                solarTermsType = 2;
            }
        } else if (this.month == 4) {
            if (this.dayOfMonth < 4) {
                solarTermsType = 1;
            } else if (this.dayOfMonth > 6) {
                solarTermsType = 2;
            }
        } else if (this.month == 5) {
            if (this.dayOfMonth < 5) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 7) {
                solarTermsType = 2;
            }
        } else if (this.month == 6) {
            if (this.dayOfMonth < 5) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 7) {
                solarTermsType = 2;
            }
        } else if (this.month == 7) {
            if (this.dayOfMonth < 6) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 8) {
                solarTermsType = 2;
            }
        } else if (this.month == 8) {
            if (this.dayOfMonth < 7) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 9) {
                solarTermsType = 2;
            }
        } else if (this.month == 9) {
            if (this.dayOfMonth < 7) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 9) {
                solarTermsType = 2;
            }
        } else if (this.month == 10) {
            if (this.dayOfMonth < 8) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 9) {
                solarTermsType = 2;
            }
        } else if (this.month == 11) {
            if (this.dayOfMonth < 7) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 8) {
                solarTermsType = 2;
            }
        } else if (this.month == 12) {
            if (this.dayOfMonth < 6) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 8) {
                solarTermsType = 2;
            }
        } else if (this.month == 1) {
            if (this.dayOfMonth < 5) {
                solarTermsType = 1;
            } else if (this.dayOfMonth >= 7) {
                solarTermsType = 2;
            }
        }
        if (solarTermsType == 1) {
            this.stemsMonthIndex = this.stemsMonthIndex == 0 ? 9 : this.stemsMonthIndex - 1;
            this.branchesMonthIndex = this.branchesMonthIndex == 0 ? 11 : this.branchesMonthIndex - 1;
        } else if (solarTermsType == 3) {
            int solarTermsIndex = (this.month - 1) * 2;
            long solarTermsTimemills = SOLAR_TERMS_2019[solarTermsIndex] + (long)(this.year - 2019) * 31556925216L;
            if (LunarDate.isSameDay(solarTermsTimemills, this.timeMills)) {
                this.solarTerms = this.month;
            }
            if (solarTermsTimemills > this.timeMills) {
                this.stemsMonthIndex = this.stemsMonthIndex == 0 ? 9 : this.stemsMonthIndex - 1;
                this.branchesMonthIndex = this.branchesMonthIndex == 0 ? 11 : this.branchesMonthIndex - 1;
            }
        }
        int leapCount = (this.year - 1) / 4 - (this.year - 1) / 100 + (this.year - 1) / 400 - 460;
        int days = (this.year - 1900) * 365 + leapCount + this.daysOfYear - 1;
        this.stemsDayIndex = (days % 10 + 10) % 10;
        this.branchesDayIndex = (days % 12 + 22) % 12;
        this.zodiac = CHINESE_ZODIAC[this.branchesYearIndex];
    }

    private void clear() {
        this.solarTerms = 0;
    }

    public void locationTo(int lunarYear, int lunarMonth, int lunarDay) {
        if (lunarYear >= 1900 && lunarYear < 2050) {
            int yearIndex = lunarYear - 1900;
            int days = 0;
            for (int i = 0; i < yearIndex; ++i) {
                days += DAYS_COUNT_OF_YEAR[i];
            }
            int[] daysCountOfMonth = DAYS_COUNT_OF_MONTHS[yearIndex];
            for (int i = 0; i < daysCountOfMonth.length; ++i) {
                if (i < lunarMonth - 1) {
                    days += daysCountOfMonth[i];
                    continue;
                }
                days += lunarDay - 1;
                break;
            }
            this.disableAutoUpdate = true;
            this.set(1900, 1, 31).add(3, days);
            this.compute();
            this.disableAutoUpdate = false;
        } else {
            int index = ((lunarYear - 1900) % 19 + 19) % 19;
            int springFestivalDayIndex = SPRING_FESTIVAL_DAY_INDEXS[index];
            int year = lunarYear;
            this.locationTo(index + 19 + 1900, lunarMonth, lunarDay);
            int daysOfYear = this.getDaysOfYear();
            if (daysOfYear < springFestivalDayIndex) {
                ++year;
            }
            this.set(year, this.month, this.dayOfMonth);
            if (this.lunarYear == lunarYear && this.lunarMonth == lunarMonth) {
                this.dayOfMonth = 0;
            } else {
                this.dayOfMonth = 0;
                this.month = 0;
            }
        }
    }

    @Override
    protected void afterDateChange() {
        if (!this.disableAutoUpdate) {
            this.compute();
        }
    }

    @Override
    public String toString() {
        StringBuilder writer = new StringBuilder();
        writer.append(super.toString());
        writer.append(' ');
        if (this.lunarYear > 0) {
            writer.append("\u519c\u5386").append(this.lunarYear).append('\u5e74');
            if (this.lunarMonth > 0) {
                if (this.leapMonth) {
                    writer.append('\u95f0');
                }
                writer.append(LUNAR_MONTHS[this.lunarMonth - 1]);
            }
            if (this.lunarDay > 0) {
                writer.append(LUNAR_DAYS[this.lunarDay - 1]).append(" ");
            }
        }
        writer.append(" ");
        writer.append(HEAVENLY_STEMS[this.stemsYearIndex]).append(EARTHLY_BRANCHES[this.branchesYearIndex]).append('\u5e74').append("\uff08").append(this.zodiac).append('\u5e74').append("\uff09").append(HEAVENLY_STEMS[this.stemsMonthIndex]).append(EARTHLY_BRANCHES[this.branchesMonthIndex]).append('\u6708').append(HEAVENLY_STEMS[this.stemsDayIndex]).append(EARTHLY_BRANCHES[this.branchesDayIndex]).append('\u65e5').append(' ');
        if (this.solarTerms > 0) {
            writer.append(" ").append(SOLAR_TERMS[(this.solarTerms - 1) * 2]).append(" ");
        }
        writer.append(this.constellation).append(" ");
        return writer.toString();
    }

    public int getLunarYear() {
        return this.lunarYear;
    }

    public int getLunarMonth() {
        return this.lunarMonth;
    }

    public int getLunarDay() {
        return this.lunarDay;
    }

    public boolean isLeap() {
        return this.leapMonth;
    }

    public int getStemsYearIndex() {
        return this.stemsYearIndex;
    }

    public int getBranchesYearIndex() {
        return this.branchesYearIndex;
    }

    public int getStemsMonthIndex() {
        return this.stemsMonthIndex;
    }

    public int getBranchesMonthIndex() {
        return this.branchesMonthIndex;
    }

    public int getStemsDayIndex() {
        return this.stemsDayIndex;
    }

    public int getBranchesDayIndex() {
        return this.branchesDayIndex;
    }

    public String getZodiac() {
        return this.zodiac;
    }

    public String getConstellation() {
        return this.constellation;
    }

    public int getSolarTerms() {
        return this.solarTerms;
    }

    public static void main(String[] args) {
        System.out.println(new LunarDate().add(3, 0));
    }

    static {
        DAYS_COUNT_OF_YEAR = new int[LUNAR_DATA.length];
        DAYS_COUNT_OF_MONTHS = new int[LUNAR_DATA.length][];
        LEAP_MONTH_INDEXOF_YEARS = new int[LUNAR_DATA.length];
        SPRING_FESTIVAL_DAY_INDEXS = new int[19];
        SOLAR_TERMS_2019 = new long[24];
        for (int i = 0; i < LUNAR_DATA.length; ++i) {
            long lunarOfYear = LUNAR_DATA[i];
            long leapMonth = lunarOfYear & 0xFL;
            long leapType = lunarOfYear >> 16;
            long monthTypes = (lunarOfYear & 0xFFF0L) >> 4;
            int[] monthTypeArr = LunarDate.getMonthTypeArr(monthTypes);
            int[] daysOfMonth = new int[leapMonth > 0L ? 13 : 12];
            int daysOfYear = 0;
            for (int j = 0; j < 12; ++j) {
                int days = monthTypeArr[j] == 1 ? 30 : 29;
                daysOfYear += days;
                if (leapMonth > 0L) {
                    daysOfMonth[(long)j > leapMonth - 1L ? j + 1 : j] = days;
                    continue;
                }
                daysOfMonth[j] = days;
            }
            if (leapMonth > 0L) {
                int days = leapType == 0L ? 29 : 30;
                daysOfYear += days;
                daysOfMonth[(int)leapMonth] = days;
            }
            LunarDate.LEAP_MONTH_INDEXOF_YEARS[i] = (int)leapMonth;
            LunarDate.DAYS_COUNT_OF_YEAR[i] = daysOfYear;
            LunarDate.DAYS_COUNT_OF_MONTHS[i] = daysOfMonth;
        }
        LunarDate.SPRING_FESTIVAL_DAY_INDEXS[0] = 31;
        GregorianDate date = new GregorianDate(1900, 1, 31);
        for (int next = 0; next < 18; ++next) {
            int days = DAYS_COUNT_OF_YEAR[next];
            date.add(3, days);
            LunarDate.SPRING_FESTIVAL_DAY_INDEXS[next + 1] = date.getDaysOfYear();
        }
        LunarDate.SOLAR_TERMS_2019[0] = date.set(2019, 1, 5, 23, 38, 57, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[1] = date.set(2019, 1, 20, 16, 59, 32, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[2] = date.set(2019, 2, 4, 11, 14, 19, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[3] = date.set(2019, 2, 19, 7, 3, 56, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[4] = date.set(2019, 3, 6, 5, 9, 44, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[5] = date.set(2019, 3, 21, 5, 38, 25, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[6] = date.set(2019, 4, 5, 9, 51, 26, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[7] = date.set(2019, 4, 20, 16, 55, 15, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[8] = date.set(2019, 5, 6, 3, 2, 45, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[9] = date.set(2019, 5, 21, 15, 59, 6, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[10] = date.set(2019, 6, 6, 7, 6, 23, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[11] = date.set(2019, 6, 21, 23, 54, 14, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[12] = date.set(2019, 7, 7, 17, 20, 30, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[13] = date.set(2019, 7, 23, 10, 50, 21, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[14] = date.set(2019, 8, 8, 3, 13, 2, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[15] = date.set(2019, 8, 23, 18, 1, 58, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[16] = date.set(2019, 9, 8, 6, 16, 51, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[17] = date.set(2019, 9, 23, 15, 50, 7, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[18] = date.set(2019, 10, 8, 22, 5, 37, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[19] = date.set(2019, 10, 24, 1, 19, 42, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[20] = date.set(2019, 11, 8, 1, 24, 20, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[21] = date.set(2019, 11, 22, 22, 58, 53, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[22] = date.set(2019, 12, 7, 18, 18, 26, 0).getTime();
        LunarDate.SOLAR_TERMS_2019[23] = date.set(2019, 12, 22, 12, 19, 23, 0).getTime();
        LUNAR_DATA_TIME_BEGIN = date.set(1900, 1, 31, 0, 0, 0, 0).getTime();
        LUNAR_DATA_TIME_END = date.set(2050, 1, 23, 0, 0, 0, 0).getTime();
    }

    public static enum StemsBranchesType {
        SpringFestival,
        BeginningOFSpring;

    }
}

