/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.EvaluateEnvironment;
import io.github.wycst.wast.common.expression.EvaluatorContext;
import io.github.wycst.wast.common.expression.ExprEvaluator;
import io.github.wycst.wast.common.expression.ExprParserContext;
import io.github.wycst.wast.common.expression.Expression;
import io.github.wycst.wast.common.expression.ExpressionException;
import io.github.wycst.wast.common.expression.invoker.ChainVariableInvoker;
import io.github.wycst.wast.common.expression.invoker.Invoker;
import io.github.wycst.wast.common.expression.invoker.VariableInvoker;
import io.github.wycst.wast.common.expression.invoker.VariableUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ExprParser
extends Expression {
    public static final int GROUP_TOKEN_OPS = 1;
    public static final int GROUP_TOKEN_VALUE = 2;
    public static final int RESET_TOKEN = 0;
    public static final int OPS_TOKEN = 1;
    public static final int IDENTIFIER_TOKEN = 2;
    public static final int NUM_TOKEN = 3;
    public static final int BRACKET_TOKEN = 4;
    public static final int BRACKET_END_TOKEN = 6;
    public static final int STR_TOKEN = 7;
    public static final int ARR_TOKEN = 8;
    public static final int FUN_TOKEN = 9;
    public static final int NEGATE_TOKEN = 10;
    public static final int NOT_TOKEN = 11;
    static final int MAX_OPTIMIZE_COUNT = 2049;
    private String exprSource;
    private char[] sourceChars;
    private int offset;
    private int count;
    private int readIndex;
    private String errorMsg;
    private Map<String, VariableInvoker> invokes;
    private Map<String, VariableInvoker> tailInvokes;
    protected Invoker chainInvoker;
    protected Invoker chainValues;
    protected int variableCount;
    private int prevTokenType;
    private int tokenType;
    private int opsType;
    private int opsLevel;
    private int bracketCount;
    private int evaluatorCount;
    private ExprEvaluator exprEvaluator = this.createExprEvaluator();
    private ExprParserContext exprParserContext = new ExprParserContext();
    private final AtomicInteger cntForCompress = new AtomicInteger(0);
    private boolean compressed = false;
    private static ThreadLocal<List<String>> localVariableKeys = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    public ExprParser(String exprSource) {
        this.init(exprSource);
        this.parse();
    }

    ExprParser(char[] buffers, int offset, int count) {
        this.init(buffers, offset, count);
        this.parse();
    }

    protected ExprParser() {
    }

    protected ExprParser global() {
        return this;
    }

    protected Map<String, VariableInvoker> getInvokes() {
        return this.invokes;
    }

    protected Map<String, VariableInvoker> getTailInvokes() {
        return this.tailInvokes;
    }

    protected ExprEvaluator createExprEvaluator() {
        return new ExprEvaluator();
    }

    protected String getSource() {
        return this.exprSource;
    }

    public int length() {
        return this.count;
    }

    protected ExprEvaluator getEvaluator() {
        return this.exprEvaluator;
    }

    protected void init(String exprSource) {
        this.exprSource = exprSource;
        this.count = exprSource.length();
        this.sourceChars = ExprParser.getChars(exprSource);
    }

    protected void init(char[] buffers, int offset, int count) {
        this.sourceChars = buffers;
        this.offset = offset;
        this.count = count;
    }

    protected void parse() {
        this.parseEvaluator();
        this.displacement(this.exprEvaluator);
        this.merge();
        this.compressVariables();
        this.checkOptimizeRequired();
    }

    private void checkOptimizeRequired() {
        if (this.evaluatorCount > 2049) {
            this.optimize();
        }
    }

    private void parseEvaluator() {
        this.exprParserContext.setContext(this.exprEvaluator, false, false);
        do {
            this.parseNext(this.exprParserContext);
            ++this.evaluatorCount;
        } while (this.readable());
    }

    private void merge() {
        if (this.exprEvaluator.evalType == 0) {
            this.exprEvaluator = this.exprEvaluator.left;
        } else {
            this.mergeLast(this.exprEvaluator);
        }
    }

    private void mergeLast(ExprEvaluator root) {
        ExprEvaluator rr = root.right;
        if (rr != null && rr.evalType == 0 && rr.left != null) {
            root.right = rr.left;
        }
    }

    private void displacement(ExprEvaluator exprEvaluator) {
        this.displacementChain(exprEvaluator);
        this.displacementChain(exprEvaluator);
    }

    private void displacementChain(ExprEvaluator exprEvaluator) {
        this.exprParserContext.exprEvaluator = exprEvaluator;
        do {
            this.displacementSplit(this.exprParserContext);
        } while (this.exprParserContext.exprEvaluator != null);
    }

    private void displacementSplit(ExprParserContext exprParserContext) {
        ExprEvaluator exprEvaluator = exprParserContext.exprEvaluator;
        if (exprEvaluator == null) {
            return;
        }
        int opsType = exprEvaluator.opsType;
        int level = exprEvaluator.level;
        int evalType = exprEvaluator.getEvalType();
        ExprEvaluator left = exprEvaluator.getLeft();
        ExprEvaluator right = exprEvaluator.getRight();
        if (right == null) {
            exprParserContext.exprEvaluator = null;
            return;
        }
        if (level == 700) {
            this.displacement(right);
            exprParserContext.exprEvaluator = null;
            return;
        }
        int rLevel = right.level;
        if (rLevel <= 0) {
            exprParserContext.exprEvaluator = null;
            return;
        }
        if (level > rLevel) {
            this.mergeRight(right, level);
            rLevel = right.level;
        }
        int rEvalType = right.getEvalType();
        ExprEvaluator rLeft = right.getLeft();
        ExprEvaluator rRight = right.getRight();
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.setEvalType(evalType);
            newLeft.setOperator(opsType, level);
            newLeft.setNegate(exprEvaluator.negate);
            newLeft.setLogicalNot(exprEvaluator.logicalNot);
            newLeft.setLeft(left);
            newLeft.setRight(rLeft);
            exprEvaluator.setOperator(right.opsType, rLevel);
            exprEvaluator.setNegate(right.isNegate());
            exprEvaluator.setLogicalNot(right.logicalNot);
            exprEvaluator.setEvalType(rEvalType);
            exprEvaluator.setLeft(newLeft);
            exprEvaluator.setRight(rRight);
            exprParserContext.exprEvaluator = exprEvaluator;
        } else {
            if (rLevel == 1) {
                this.displacement(right.getRight().getLeft());
            }
            exprParserContext.exprEvaluator = right;
        }
    }

    private void mergeRight(ExprEvaluator exprEvaluator, int targetLevel) {
        if (exprEvaluator == null) {
            return;
        }
        int evalType = exprEvaluator.getEvalType();
        int level = exprEvaluator.level;
        if (level >= targetLevel) {
            return;
        }
        ExprEvaluator left = exprEvaluator.getLeft();
        ExprEvaluator right = exprEvaluator.getRight();
        if (right == null) {
            return;
        }
        if (level == 700) {
            this.displacement(right);
            return;
        }
        int rLevel = right.level;
        if (rLevel <= 0) {
            return;
        }
        int rEvalType = right.getEvalType();
        ExprEvaluator rLeft = right.getLeft();
        ExprEvaluator rRight = right.getRight();
        if (level <= rLevel) {
            ExprEvaluator newLeft = this.createExprEvaluator();
            newLeft.setEvalType(evalType);
            newLeft.setOperator(exprEvaluator.opsType, exprEvaluator.level);
            newLeft.setNegate(exprEvaluator.negate);
            newLeft.setLogicalNot(exprEvaluator.logicalNot);
            newLeft.setLeft(left);
            newLeft.setRight(rLeft);
            exprEvaluator.setOperator(right.opsType, right.level);
            exprEvaluator.setNegate(right.negate);
            exprEvaluator.setLogicalNot(right.logicalNot);
            exprEvaluator.setEvalType(rEvalType);
            exprEvaluator.setLeft(newLeft);
            exprEvaluator.setRight(rRight);
            this.mergeRight(exprEvaluator, targetLevel);
        }
    }

    protected void compressVariables() {
        if (this.tailInvokes != null) {
            this.chainInvoker = ChainVariableInvoker.build(this.tailInvokes);
            this.chainValues = ChainVariableInvoker.build(this.invokes, true);
            this.variableCount = this.invokes.size();
            this.tailInvokes.clear();
            this.invokes.clear();
            this.tailInvokes = null;
            this.invokes = null;
        }
    }

    private void parseOpsToken(ExprParserContext exprParserContext) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        evaluator.setEvalType(1);
        ExprEvaluator right = this.createExprEvaluator();
        if (this.opsType == 12) {
            evaluator.setOperator(11, 100);
            negate = true;
        } else {
            evaluator.setOperator(this.opsType, this.opsLevel);
        }
        evaluator.setRight(right);
        exprParserContext.setContext(right, negate, logicalNot);
    }

    private void parseVarToken(ExprParserContext exprParserContext, char startChar, String identifierValue, List<String> variableKeys) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        switch (startChar) {
            case 't': {
                if (!"true".equals(identifierValue)) break;
                ExprEvaluator.ExprEvaluatorConstantImpl left = new ExprEvaluator.ExprEvaluatorConstantImpl(!logicalNot);
                left.setEvalType(-1);
                evaluator.setLeft(left);
                exprParserContext.setContext(evaluator, false, false);
                return;
            }
            case 'f': {
                if (!"false".equals(identifierValue)) break;
                ExprEvaluator.ExprEvaluatorConstantImpl left = new ExprEvaluator.ExprEvaluatorConstantImpl(logicalNot);
                left.setEvalType(-1);
                evaluator.setLeft(left);
                exprParserContext.setContext(evaluator, false, false);
                return;
            }
            case 'n': {
                if (!"null".equals(identifierValue)) break;
                ExprEvaluator.ExprEvaluatorConstantImpl left = new ExprEvaluator.ExprEvaluatorConstantImpl(null);
                left.setEvalType(-1);
                evaluator.setLeft(left);
                exprParserContext.setContext(evaluator, false, false);
                return;
            }
        }
        this.checkInitializedInvokes();
        ExprEvaluator.ExprEvaluatorVariableImpl left = new ExprEvaluator.ExprEvaluatorVariableImpl();
        left.setEvalType(6);
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setVariableInvoker(identifierValue == null ? VariableUtils.build(variableKeys, this.getInvokes(), this.getTailInvokes()) : VariableUtils.buildRoot(identifierValue, this.getInvokes(), this.getTailInvokes()));
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    void checkInitializedInvokes() {
        if (this.invokes == null) {
            this.invokes = new HashMap<String, VariableInvoker>();
            this.tailInvokes = new HashMap<String, VariableInvoker>();
        }
    }

    private void parseNumToken(ExprParserContext exprParserContext, Number numberValue) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        ExprEvaluator.ExprEvaluatorConstantImpl left = new ExprEvaluator.ExprEvaluatorConstantImpl(numberValue);
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    private void parseBracketToken(ExprParserContext exprParserContext) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        evaluator.setOperator(this.opsType, this.opsLevel);
        evaluator.setNegate(negate);
        evaluator.setLogicalNot(logicalNot);
        ExprEvaluator child = this.createExprEvaluator();
        ExprParserContext bracketParserContext = new ExprParserContext(child, false, false);
        do {
            this.parseNext(bracketParserContext);
        } while (this.readable() && !bracketParserContext.endFlag);
        if (!bracketParserContext.endFlag) {
            String errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ",Expression[... " + errorMessage + " ...], missing closing symbol')'");
        }
        this.displacementChain(child);
        this.mergeLast(child);
        ExprEvaluator right = this.createExprEvaluator();
        evaluator.setEvalType(5);
        evaluator.setRight(right);
        right.setLeft(child);
        exprParserContext.setContext(right, false, false);
    }

    private void parseStrToken(ExprParserContext exprParserContext, String strValue) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator.ExprEvaluatorConstantImpl left = new ExprEvaluator.ExprEvaluatorConstantImpl(strValue);
        left.setEvalType(7);
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    private void parseArrToken(ExprParserContext exprParserContext, String arrStr) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator left = this.createExprEvaluator();
        left.setEvalType(8);
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setArrayValue(arrStr);
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    private void parseFunToken(ExprParserContext exprParserContext, String functionName, String args) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        ExprEvaluator.ExprEvaluatorFunctionImpl left = new ExprEvaluator.ExprEvaluatorFunctionImpl();
        left.setEvalType(9);
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setFunction(functionName, args, this.global());
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    private void parseMethodToken(ExprParserContext exprParserContext, List<String> variableKeys, String methodName, String args) {
        ExprEvaluator evaluator = exprParserContext.exprEvaluator;
        boolean negate = exprParserContext.negate;
        boolean logicalNot = exprParserContext.logicalNot;
        this.checkInitializedInvokes();
        ExprEvaluator.ExprEvaluatorMethodImpl left = new ExprEvaluator.ExprEvaluatorMethodImpl();
        left.setEvalType(9);
        left.setNegate(negate);
        left.setLogicalNot(logicalNot);
        left.setMethod(VariableUtils.build(variableKeys, this.getInvokes(), this.getTailInvokes()), methodName, args, this.global());
        evaluator.setLeft(left);
        exprParserContext.setContext(evaluator, false, false);
    }

    private void parseNegateToken(ExprParserContext exprParserContext) {
        boolean negate = exprParserContext.negate;
        exprParserContext.negate = !negate;
    }

    private void parseNotToken(ExprParserContext exprParserContext) {
        boolean logicalNot = exprParserContext.logicalNot;
        exprParserContext.logicalNot = !logicalNot;
    }

    private static List<String> getLocalVariableKeys() {
        List<String> keys = localVariableKeys.get();
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void parseNext(ExprParserContext exprParserContext) {
        block120: {
            block123: {
                block121: {
                    block125: {
                        block124: {
                            block122: {
                                this.resetToken();
                                while (this.readable() && this.isWhitespace(this.read())) {
                                    ++this.readIndex;
                                }
                                if (!this.readable()) {
                                    return;
                                }
                                currentChar = this.read();
                                opsSymbolIndex = -1;
                                isMinusSymbol = false;
                                if ((this.isDigit(currentChar) || (isMinusSymbol = currentChar == '-')) && this.getTokenTypeGroup(this.prevTokenType) != 2) {
                                    cnt = 0;
                                    readIndex = ++this.readIndex;
                                    numberRadix = 10;
                                    firstDigitChar = '\u0000';
                                    secondeDigitChar = '\u0000';
                                    if (isMinusSymbol) {
                                        if (readIndex + 1 < this.length()) {
                                            firstDigitChar = this.read(readIndex++);
                                            secondeDigitChar = this.read(readIndex++);
                                        }
                                    } else {
                                        firstDigitChar = currentChar;
                                        if (readIndex < this.length()) {
                                            secondeDigitChar = this.read(readIndex++);
                                        }
                                    }
                                    decimalValPlain = 0L;
                                    valInitSet = false;
                                    hexOrOctVal = 0L;
                                    if (firstDigitChar == '0') {
                                        if (secondeDigitChar == 'x' || secondeDigitChar == 'X') {
                                            numberRadix = 16;
                                            this.readIndex = readIndex;
                                            ++cnt;
                                            while (this.readable() && (val = ExprParser.digit(currentChar = this.read(), 16)) != -1) {
                                                hexOrOctVal = hexOrOctVal << 4 | (long)val;
                                                ++this.readIndex;
                                                ++cnt;
                                            }
                                            if (currentChar == 'l' || currentChar == 'L') {
                                                ++this.readIndex;
                                            }
                                        } else if (Character.isDigit(secondeDigitChar)) {
                                            numberRadix = 8;
                                            this.readIndex = readIndex;
                                            hexOrOctVal = ExprParser.digit(secondeDigitChar, 8);
                                            ++cnt;
                                            while (this.readable() && (val = ExprParser.digit(currentChar = this.read(), 8)) != -1) {
                                                hexOrOctVal = hexOrOctVal << 3 | (long)val;
                                                ++this.readIndex;
                                                ++cnt;
                                            }
                                            switch (currentChar) {
                                                case '.': 
                                                case 'D': 
                                                case 'E': 
                                                case 'F': 
                                                case 'd': 
                                                case 'e': 
                                                case 'f': {
                                                    numberRadix = 10;
                                                    decimalValPlain = Integer.parseInt(Long.toString(hexOrOctVal, 8));
                                                    valInitSet = true;
                                                    break;
                                                }
                                                case 'L': 
                                                case 'l': {
                                                    ++this.readIndex;
                                                }
                                            }
                                        }
                                    }
                                    value = 0.0;
                                    mode = 0;
                                    specifySuffix = 0;
                                    expValue = 0;
                                    expNegative = false;
                                    decimalCount = 0;
                                    if (numberRadix == 10) {
                                        if (!isMinusSymbol && !valInitSet) {
                                            ++cnt;
                                            decimalValPlain = currentChar - 48;
                                        }
                                        while (this.readable() && this.isDigit(currentChar = this.read())) {
                                            decimalValPlain = decimalValPlain * 10L + (long)(currentChar - 48);
                                            ++this.readIndex;
                                            ++cnt;
                                        }
                                        if (currentChar == '.') {
                                            ++this.readIndex;
                                            mode = 1;
                                            while (this.readable() && this.isDigit(currentChar = this.read())) {
                                                decimalValPlain = decimalValPlain * 10L + (long)currentChar - 48L;
                                                ++decimalCount;
                                                ++cnt;
                                                ++this.readIndex;
                                            }
                                        }
                                        if (currentChar == 'E' || currentChar == 'e') {
                                            mode = 2;
                                            ++this.readIndex;
                                            currentChar = this.read();
                                            expNegative = currentChar == '-';
                                            if (expNegative || currentChar == '+') {
                                                ++this.readIndex;
                                                currentChar = this.read();
                                            }
                                            if (this.isDigit(currentChar)) {
                                                expValue = currentChar - 48;
                                                ++this.readIndex;
                                                while (this.readable() && this.isDigit(currentChar = this.read())) {
                                                    expValue = (expValue << 3) + (expValue << 1) + currentChar - 48;
                                                    ++this.readIndex;
                                                }
                                            }
                                        }
                                        switch (currentChar) {
                                            case 'L': 
                                            case 'l': {
                                                specifySuffix = 1;
                                                ++this.readIndex;
                                                break;
                                            }
                                            case 'F': 
                                            case 'f': {
                                                specifySuffix = 2;
                                                ++this.readIndex;
                                                break;
                                            }
                                            case 'D': 
                                            case 'd': {
                                                specifySuffix = 3;
                                                ++this.readIndex;
                                            }
                                        }
                                        value = decimalValPlain;
                                    } else {
                                        value = hexOrOctVal;
                                    }
                                    if (cnt == 0 && isMinusSymbol) {
                                        switch (this.prevTokenType) {
                                            case 0: 
                                            case 1: 
                                            case 4: {
                                                this.tokenType = 10;
                                                this.checkTokenSyntaxError();
                                                this.parseNegateToken(exprParserContext);
                                                return;
                                            }
                                        }
                                        this.tokenType = 1;
                                        this.opsType = 12;
                                        this.opsLevel = 100;
                                        this.checkTokenSyntaxError();
                                        this.parseOpsToken(exprParserContext);
                                        return;
                                    }
                                    this.tokenType = 3;
                                    if (exprParserContext.negate ^ isMinusSymbol) {
                                        value = -value;
                                    }
                                    if (mode == 0) {
                                        numberValue /* !! */  = specifySuffix == 0 ? (value >= -9.223372036854776E18 && value <= 9.223372036854776E18 ? Long.valueOf((long)value) : Double.valueOf(value)) : (specifySuffix == 1 ? Long.valueOf((long)value) : (specifySuffix == 2 ? Float.valueOf((float)value) : Double.valueOf(value)));
                                    } else {
                                        v0 = expValue = expNegative != false ? -expValue - decimalCount : expValue - decimalCount;
                                        if (expValue > 0) {
                                            powValue = NumberUtils.getDecimalPowerValue(expValue);
                                            value *= powValue;
                                        } else if (expValue < 0) {
                                            powValue = NumberUtils.getDecimalPowerValue(-expValue);
                                            value /= powValue;
                                        }
                                        numberValue /* !! */  = specifySuffix == 0 ? Double.valueOf(value) : (specifySuffix == 1 ? Long.valueOf((long)value) : (specifySuffix == 2 ? Float.valueOf((float)value) : Double.valueOf(value)));
                                    }
                                    this.checkTokenSyntaxError();
                                    this.parseNumToken(exprParserContext, numberValue /* !! */ );
                                    return;
                                }
                                if (this.prevTokenType == 1 || (opsSymbolIndex = this.getOpsSymbolIndex(currentChar)) <= -1) break block120;
                                firstMatchChar = currentChar;
                                ++this.readIndex;
                                this.tokenType = 1;
                                if (!this.readable() || this.isWhitespace(currentChar = this.read())) break block121;
                                if (currentChar != '*' || opsSymbolIndex != 1) break block122;
                                this.opsType = 4;
                                this.opsLevel = 9;
                                ++this.readIndex;
                                break block123;
                            }
                            if (opsSymbolIndex != 31) break block124;
                            if (currentChar == '&') {
                                ++this.readIndex;
                                this.opsType = 61;
                                this.opsLevel = 600;
                            } else {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                            break block123;
                        }
                        if (opsSymbolIndex != 33) break block125;
                        if (currentChar == '|') {
                            ++this.readIndex;
                            this.opsType = 62;
                            this.opsLevel = 600;
                        } else {
                            this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                            this.throwOperationNotSupported();
                        }
                        break block123;
                    }
                    if (opsSymbolIndex != 43) ** GOTO lbl192
                    if (currentChar == '=') {
                        ++this.readIndex;
                        this.opsType = 56;
                        this.opsLevel = 500;
                    } else {
                        if (currentChar == '!') {
                            this.tokenType = 11;
                            this.checkTokenSyntaxError();
                            this.parseNotToken(exprParserContext);
                            return;
                        }
                        if (this.getOpsSymbolIndex(currentChar) > -1) {
                            this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                            this.throwOperationNotSupported();
                        }
                        this.tokenType = 11;
                        this.checkTokenSyntaxError();
                        this.parseNotToken(exprParserContext);
                        return;
lbl192:
                        // 1 sources

                        if (opsSymbolIndex == 51) {
                            if (currentChar == '>') {
                                ++this.readIndex;
                                this.opsType = 21;
                                this.opsLevel = 200;
                            } else if (currentChar == '=') {
                                ++this.readIndex;
                                this.opsType = 54;
                                this.opsLevel = 500;
                            } else if (this.getOpsSymbolIndex(currentChar) > -1) {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                        } else if (opsSymbolIndex == 52) {
                            if (currentChar == '<') {
                                ++this.readIndex;
                                this.opsType = 22;
                                this.opsLevel = 200;
                            } else if (currentChar == '=') {
                                ++this.readIndex;
                                this.opsType = 55;
                                this.opsLevel = 500;
                            } else if (this.getOpsSymbolIndex(currentChar) > -1) {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                        } else if (opsSymbolIndex == 53) {
                            if (currentChar == '=') {
                                ++this.readIndex;
                                this.opsType = 53;
                                this.opsLevel = 500;
                            } else {
                                this.errorMsg = String.valueOf(firstMatchChar) + currentChar;
                                this.throwOperationNotSupported();
                            }
                        }
                    }
                    break block123;
                }
                if (opsSymbolIndex == 53) {
                    this.errorMsg = String.valueOf(firstMatchChar);
                    this.throwOperationNotSupported();
                }
            }
            this.checkTokenSyntaxError();
            this.parseOpsToken(exprParserContext);
            return;
        }
        if (this.isBracketSymbol(currentChar)) {
            this.opsType = 5;
            this.opsLevel = 1;
            ++this.readIndex;
            if (currentChar == '(') {
                this.tokenType = 4;
                ++this.bracketCount;
                this.checkBeforeBracketTokenSyntaxError();
                this.parseBracketToken(exprParserContext);
                return;
            }
            --this.bracketCount;
            this.tokenType = 6;
            if (this.bracketCount < 0) {
                this.errorMsg = ")";
                this.throwOperationNotSupported();
            }
            this.checkBeforeBracketEndTokenSyntaxError();
            exprParserContext.endFlag = true;
            return;
        }
        if (this.isIdentifierStart(currentChar)) {
            start = this.readIndex++;
            startChar = currentChar;
            localOffset = start;
            variableKeys = ExprParser.getLocalVariableKeys();
            try {
                while (this.readable() && this.isVariableAppend(currentChar = this.read())) {
                    if (currentChar == '.') {
                        if (this.readIndex == localOffset) {
                            errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                            throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ...],token ''' is duplicate or conflict with [] ");
                        }
                        variableKeys.add(new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset));
                        localOffset = ++this.readIndex;
                        continue;
                    }
                    if (currentChar == '[') {
                        if (this.readIndex == localOffset) {
                            errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                            throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ...],token '[' is duplicate or conflict with '.' ");
                        }
                        variableKeys.add(new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset));
                        localOffset = ++this.readIndex;
                        cnt = 1;
                        stringKey = true;
                        while (this.readable()) {
                            currentChar = this.read();
                            if (currentChar <= ' ') {
                                ++this.readIndex;
                                continue;
                            }
                            if (currentChar == '\'') {
                                this.scanString();
                                ++this.readIndex;
                                while (this.readable() && (currentChar = this.read()) <= ' ') {
                                    ++this.readIndex;
                                }
                                if (currentChar != ']' || cnt != 1) continue;
                                break;
                            }
                            stringKey = false;
                            if (currentChar == ']') {
                                --cnt;
                            } else if (currentChar == '[') {
                                ++cnt;
                            }
                            if (cnt == 0) break;
                            ++this.readIndex;
                        }
                        if (currentChar != ']') {
                            errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                            throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ...],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'['\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 ']'");
                        }
                        if (stringKey) {
                            et = this.readIndex + this.offset;
                            for (st = localOffset + this.offset; st < et && this.sourceChars[st] <= ' '; ++st) {
                            }
                            while (st < et && this.sourceChars[et - 1] <= ' ') {
                                --et;
                            }
                            variableKeys.add(new String(this.sourceChars, st + 1, et - st - 2));
                        } else {
                            chars = new char[this.readIndex - localOffset + 2];
                            chars[0] = 40;
                            chars[chars.length - 1] = 41;
                            System.arraycopy(this.sourceChars, localOffset + this.offset, chars, 1, chars.length - 2);
                            variableKeys.add(new String(chars));
                        }
                        localOffset = ++this.readIndex;
                        continue;
                    }
                    ++this.readIndex;
                }
                identifierValue = new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset);
                v1 = oneLevelAccess = localOffset == start;
                if (currentChar == '(') {
                    localOffset = ++this.readIndex;
                    bracketCount = 1;
                    while (this.readable()) {
                        currentChar = this.read();
                        if (currentChar == '\'') {
                            this.scanString();
                            ++this.readIndex;
                            continue;
                        }
                        ++this.readIndex;
                        if (currentChar == ')') {
                            --bracketCount;
                        } else if (currentChar == '(') {
                            ++bracketCount;
                        }
                        if (bracketCount != 0) continue;
                    }
                    if (currentChar != ')') {
                        errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                        throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ",Expression[... " + errorMessage + " ...], end token ')' not found !");
                    }
                    args = new String(this.sourceChars, localOffset + this.offset, this.readIndex - localOffset - 1);
                    if (oneLevelAccess) {
                        this.tokenType = 9;
                        this.checkTokenSyntaxError();
                        this.parseFunToken(exprParserContext, identifierValue, args);
                    } else {
                        this.tokenType = 9;
                        this.checkTokenSyntaxError();
                        this.parseMethodToken(exprParserContext, variableKeys, identifierValue, args);
                    }
                } else {
                    if (localOffset > start && this.readIndex > localOffset) {
                        variableKeys.add(identifierValue);
                    }
                    this.tokenType = 2;
                    this.checkTokenSyntaxError();
                    this.parseVarToken(exprParserContext, startChar, oneLevelAccess != false ? identifierValue : null, variableKeys);
                }
            }
            finally {
                variableKeys.clear();
            }
            return;
        }
        if (currentChar == '!') {
            ++this.readIndex;
            this.tokenType = 11;
            this.parseNotToken(exprParserContext);
            return;
        }
        if (currentChar == '\'') {
            start = ++this.readIndex;
            this.scanString();
            this.tokenType = 7;
            this.checkTokenSyntaxError();
            this.parseStrToken(exprParserContext, new String(this.sourceChars, this.offset + start, this.readIndex - start));
            ++this.readIndex;
            return;
        }
        if (currentChar == '{') {
            start = ++this.readIndex;
            while (this.readable() && (currentChar = this.read()) != '}') {
                ++this.readIndex;
                if (this.readIndex < this.length()) continue;
            }
            if (currentChar != '}') {
                errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ...],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'{'\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 '}'");
            }
            this.tokenType = 8;
            this.checkTokenSyntaxError();
            this.parseArrToken(exprParserContext, new String(this.sourceChars, start + this.offset, this.readIndex - start));
            ++this.readIndex;
            return;
        }
        if (currentChar == '@') {
            ++this.readIndex;
            start = this.readIndex++;
            if (this.readable() && !Character.isJavaIdentifierStart(currentChar = this.read())) {
                errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ...], unexpected function start char  : '" + currentChar + "'");
            }
            while (this.readable() && this.isIdentifierAppend(currentChar = this.read())) {
                ++this.readIndex;
                if (this.readIndex < this.length()) continue;
            }
            while (this.readable() && this.isWhitespace(currentChar = this.read())) {
                ++this.readIndex;
            }
            if (currentChar != '(') {
                readSource = new String(this.exprSource.substring(0, this.readIndex));
                throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", source: '" + readSource + "' function start symbol '(' not found !");
            }
            functionName = new String(this.sourceChars, start + this.offset, this.readIndex - start);
            start = ++this.readIndex;
            bracketCount = 1;
            while (this.readable()) {
                currentChar = this.read();
                if (currentChar == '\'') {
                    this.scanString();
                    ++this.readIndex;
                    continue;
                }
                ++this.readIndex;
                if (currentChar == ')') {
                    --bracketCount;
                } else if (currentChar == '(') {
                    ++bracketCount;
                }
                if (bracketCount != 0) continue;
            }
            args = new String(this.sourceChars, start + this.offset, this.readIndex - start - 1);
            this.tokenType = 9;
            this.checkTokenSyntaxError();
            this.parseFunToken(exprParserContext, functionName, args);
            return;
        }
        errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
        throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ...], \u8868\u8fbe\u5f0f\u4e2d\u672a\u9884\u671f\u51fa\u73b0\u7684token\u5b57\u7b26 '" + currentChar + "'");
    }

    private void scanString() {
        int currentChar = 0;
        ++this.readIndex;
        int prevCh = 0;
        while (this.readable()) {
            char c = this.read();
            currentChar = c;
            if (c == '\'' && prevCh != 92) break;
            ++this.readIndex;
            prevCh = currentChar;
        }
        if (currentChar != 39 || prevCh == 92) {
            String errorMessage = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", Expression[... " + errorMessage + " ...],\u672a\u627e\u5230\u4e0e\u5f00\u59cb\u5b57\u7b26'''\u76f8\u5339\u914d\u7684\u7ed3\u675f\u5b57\u7b26 '''");
        }
    }

    private boolean readable() {
        return this.readIndex < this.count;
    }

    private char read() {
        return this.sourceChars[this.offset + this.readIndex];
    }

    private char read(int index) {
        return this.sourceChars[this.offset + index];
    }

    private void checkIfBuiltInKeywords(String varValue) {
        if (varValue == null) {
            return;
        }
        int length = varValue.length();
        if (length == 2) {
            char charFir = varValue.charAt(0);
            char charSec = varValue.charAt(1);
            if (charFir == 'i' && charSec == 'n' || charFir == 'I' && charSec == 'N') {
                this.opsType = 63;
                this.opsLevel = 600;
                this.tokenType = 1;
            }
        } else if (length == 3 && varValue.indexOf("out") == 0) {
            this.opsType = 64;
            this.opsLevel = 600;
            this.tokenType = 1;
        }
    }

    private int getTokenTypeGroup(int tokenType) {
        switch (tokenType) {
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    private void checkTokenSyntaxError() {
        int groupValue;
        int preGroupValue = this.getTokenTypeGroup(this.prevTokenType);
        if (preGroupValue == (groupValue = this.getTokenTypeGroup(this.tokenType))) {
            if (preGroupValue == 1) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", duplicate operation type: '" + this.errorMsg + "', Expression[" + readSource + "]");
            }
            if (preGroupValue == 2) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", missing operation symbol: '" + this.errorMsg + "', Expression[" + readSource + "]");
            }
        } else {
            if (groupValue == 2 && this.prevTokenType == 6) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", unexpected symbol : '" + this.errorMsg + "', Expression[" + readSource + "]");
            }
            if (groupValue == 1 && this.prevTokenType == 4) {
                String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
                throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", unexpected symbol : '" + this.errorMsg + "', Expression[" + readSource + "]");
            }
        }
    }

    private void checkBeforeBracketEndTokenSyntaxError() {
        int preGroupValue = this.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 4 || preGroupValue == 1) {
            String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ",unexpected symbol : '" + this.errorMsg + "', Expression[" + readSource + "]");
        }
    }

    private void checkBeforeBracketTokenSyntaxError() {
        int preGroupValue = this.getTokenTypeGroup(this.prevTokenType);
        if (this.prevTokenType == 6 && preGroupValue == 2) {
            String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
            throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ",unexpected symbol : '" + this.errorMsg + "', Expression[" + readSource + "]");
        }
    }

    private void throwOperationNotSupported() {
        String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
        throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", unexpected symbol '" + this.errorMsg + "', Expression[" + readSource + "]");
    }

    private void throwNumberFormatException(int start) {
        String numberSource = new String(this.sourceChars, this.offset + start, this.readIndex - start);
        String readSource = ExprParser.createErrorContextText(this.sourceChars, this.readIndex);
        throw new ExpressionException("Expression syntax error, pos: " + this.readIndex + ", invalid number text '" + numberSource + "', Expression[" + readSource + "]");
    }

    private boolean isWhitespace(char c) {
        return c <= ' ';
    }

    protected boolean isIdentifierStart(char c) {
        return c == '_' || c == '$' || Character.isLetter(c);
    }

    protected boolean isIdentifierAppend(char c) {
        return c == '_' || c == '$' || c == '.' || Character.isLetter(c) || this.isDigit(c);
    }

    protected boolean isVariableAppend(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        if (c <= ' ') {
            return false;
        }
        return c == '.' || c == '_' || c == '$' || this.isDigit(c) || c == '[';
    }

    private static int digit(char c, int numberRadix) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
        }
        if (numberRadix == 16) {
            if (c >= 'a' && c <= 'f') {
                return c - 87;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 55;
            }
        }
        return -1;
    }

    private boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private boolean isAvailableDigit(char c, int numberRadix) {
        if (numberRadix == 10) {
            switch (c) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'L': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'l': {
                    return true;
                }
            }
            return false;
        }
        if (numberRadix == 16) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }
        return c >= '0' && c <= '7';
    }

    private void resetToken() {
        this.prevTokenType = this.tokenType;
        this.tokenType = 0;
        this.opsType = 0;
        this.opsLevel = 0;
    }

    private int getOpsSymbolIndex(char c) {
        switch (c) {
            case '*': {
                this.opsType = 1;
                this.opsLevel = 10;
                return this.opsType;
            }
            case '/': {
                this.opsType = 2;
                this.opsLevel = 10;
                return this.opsType;
            }
            case '%': {
                this.opsType = 3;
                this.opsLevel = 10;
                return this.opsType;
            }
            case '+': {
                this.opsType = 11;
                this.opsLevel = 100;
                return this.opsType;
            }
            case '-': {
                this.opsType = 12;
                this.opsLevel = 100;
                return this.opsType;
            }
            case '&': {
                this.opsType = 31;
                this.opsLevel = 300;
                return this.opsType;
            }
            case '^': {
                this.opsType = 32;
                this.opsLevel = 301;
                return this.opsType;
            }
            case '|': {
                this.opsType = 33;
                this.opsLevel = 302;
                return this.opsType;
            }
            case '!': {
                this.opsType = 43;
                return this.opsType;
            }
            case '>': {
                this.opsType = 51;
                this.opsLevel = 500;
                return this.opsType;
            }
            case '<': {
                this.opsType = 52;
                this.opsLevel = 500;
                return this.opsType;
            }
            case '=': {
                this.opsType = 53;
                this.opsLevel = 500;
                return this.opsType;
            }
            case ':': {
                this.opsType = 70;
                this.opsLevel = 700;
                return this.opsType;
            }
            case '?': {
                this.opsType = 71;
                this.opsLevel = 701;
                return this.opsType;
            }
        }
        return -1;
    }

    private boolean isBracketSymbol(char c) {
        return c == '(' || c == ')';
    }

    @Override
    public Object evaluate() {
        return this.exprEvaluator.evaluate(EvaluatorContext.Empty, EvaluateEnvironment.DefaultEnvironment);
    }

    @Override
    public Object evaluate(Object context) {
        if (context instanceof EvaluateEnvironment) {
            return this.evaluate((EvaluateEnvironment)context);
        }
        if (context instanceof Map) {
            return this.evaluate((Map)context);
        }
        return this.evaluate(context, EvaluateEnvironment.DefaultEnvironment);
    }

    @Override
    public Object evaluate(Map context) {
        EvaluateEnvironment defaultEnvironment = EvaluateEnvironment.DefaultEnvironment;
        EvaluatorContext evaluatorContext = defaultEnvironment.createEvaluateContext(context, this.chainInvoker);
        return this.doEvaluate(evaluatorContext, defaultEnvironment);
    }

    @Override
    public Object evaluate(EvaluateEnvironment evaluateEnvironment) {
        if (evaluateEnvironment == null) {
            return this.exprEvaluator.evaluate(EvaluatorContext.Empty, EvaluateEnvironment.DefaultEnvironment);
        }
        EvaluatorContext evaluatorContext = evaluateEnvironment.createEvaluateContext(this.chainInvoker, this.variableCount);
        return this.doEvaluate(evaluatorContext, evaluateEnvironment);
    }

    Object evaluate(Object context, EvaluateEnvironment evaluateEnvironment) {
        EvaluatorContext evaluatorContext = evaluateEnvironment.createEvaluateContext(context, this.chainInvoker);
        return this.doEvaluate(evaluatorContext, evaluateEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doEvaluate(EvaluatorContext evaluatorContext, EvaluateEnvironment evaluateEnvironment) {
        try {
            Object result = this.exprEvaluator.evaluate(evaluatorContext, evaluateEnvironment);
            if (!this.compressed && this.cntForCompress.getAndIncrement() == 1) {
                this.compressEvaluator();
            }
            Object object = result;
            return object;
        }
        finally {
            this.clearContextVariables(evaluatorContext);
        }
    }

    void clearContextVariables(EvaluatorContext evaluatorContext) {
        evaluatorContext.clearContextVariables(this.chainValues);
    }

    protected void compressEvaluator() {
        this.exprEvaluator = this.compressEvaluator(this.exprEvaluator);
        this.compressed = true;
    }

    private ExprEvaluator compressEvaluator(ExprEvaluator exprEvaluator) {
        if (exprEvaluator.isStatic) {
            if (exprEvaluator instanceof ExprEvaluator.ExprEvaluatorConstantImpl) {
                return exprEvaluator;
            }
            return new ExprEvaluator.ExprEvaluatorConstantImpl(exprEvaluator.result);
        }
        if (exprEvaluator instanceof ExprEvaluator.ExprEvaluatorStackSplitImpl) {
            ExprEvaluator.ExprEvaluatorStackSplitImpl stackSplit = (ExprEvaluator.ExprEvaluatorStackSplitImpl)exprEvaluator;
            stackSplit.front = this.compressEvaluator(stackSplit.front);
            stackSplit.left = this.compressEvaluator(stackSplit.left);
            return stackSplit;
        }
        if (exprEvaluator instanceof ExprEvaluator.ExprEvaluatorContextValueHolderImpl) {
            return exprEvaluator;
        }
        ExprEvaluator left = exprEvaluator.left;
        ExprEvaluator right = exprEvaluator.right;
        int evalType = exprEvaluator.getEvalType();
        if (evalType == 0) {
            return this.compressEvaluator(left);
        }
        if (evalType == 1) {
            left = this.compressEvaluator(left);
            if (right == null) {
                return left;
            }
            right = this.compressEvaluator(right);
            int opsType = exprEvaluator.opsType;
            if (opsType == 71) {
                return ExprEvaluator.ExprEvaluatorTernaryImpl.of(exprEvaluator.update(left, right));
            }
            switch (opsType) {
                case 1: {
                    return ExprEvaluator.ExprEvaluatorMultiplyImpl.of(exprEvaluator.update(left, right));
                }
                case 2: {
                    return ExprEvaluator.ExprEvaluatorDivisionImpl.of(exprEvaluator.update(left, right));
                }
                case 3: {
                    return ExprEvaluator.ExprEvaluatorModulusImpl.of(exprEvaluator.update(left, right));
                }
                case 4: {
                    return ExprEvaluator.ExprEvaluatorPowerImpl.of(exprEvaluator.update(left, right));
                }
                case 11: {
                    return ExprEvaluator.ExprEvaluatorPlusImpl.of(exprEvaluator.update(left, right));
                }
                case 12: {
                    return ExprEvaluator.ExprEvaluatorMinusImpl.of(exprEvaluator.update(left, right));
                }
                case 21: {
                    return ExprEvaluator.ExprEvaluatorBitRightImpl.of(exprEvaluator.update(left, right));
                }
                case 22: {
                    return ExprEvaluator.ExprEvaluatorBitLeftImpl.of(exprEvaluator.update(left, right));
                }
                case 31: {
                    return ExprEvaluator.ExprEvaluatorBitAndImpl.of(exprEvaluator.update(left, right));
                }
                case 32: {
                    return ExprEvaluator.ExprEvaluatorBitXorImpl.of(exprEvaluator.update(left, right));
                }
                case 33: {
                    return ExprEvaluator.ExprEvaluatorBitOrImpl.of(exprEvaluator.update(left, right));
                }
                case 51: {
                    return ExprEvaluator.ExprEvaluatorGtImpl.of(exprEvaluator.update(left, right));
                }
                case 52: {
                    return ExprEvaluator.ExprEvaluatorLtImpl.of(exprEvaluator.update(left, right));
                }
                case 53: {
                    return ExprEvaluator.ExprEvaluatorEqualImpl.of(exprEvaluator.update(left, right));
                }
                case 54: {
                    return ExprEvaluator.ExprEvaluatorGEImpl.of(exprEvaluator.update(left, right));
                }
                case 55: {
                    return ExprEvaluator.ExprEvaluatorLEImpl.of(exprEvaluator.update(left, right));
                }
                case 56: {
                    return ExprEvaluator.ExprEvaluatorNEImpl.of(exprEvaluator.update(left, right));
                }
                case 61: {
                    return ExprEvaluator.ExprEvaluatorLogicalAndImpl.of(exprEvaluator.update(left, right));
                }
                case 62: {
                    return ExprEvaluator.ExprEvaluatorLogicalOrImpl.of(exprEvaluator.update(left, right));
                }
                case 63: {
                    return ExprEvaluator.ExprEvaluatorInImpl.of(exprEvaluator.update(left, right));
                }
                case 64: {
                    return ExprEvaluator.ExprEvaluatorOutImpl.of(exprEvaluator.update(left, right));
                }
            }
            return exprEvaluator.update(left, right);
        }
        if (evalType == 5) {
            return ExprEvaluator.ExprEvaluatorBracketImpl.of(exprEvaluator.update(left, this.compressEvaluator(right)));
        }
        if (evalType == 6) {
            return ((ExprEvaluator.ExprEvaluatorVariableImpl)exprEvaluator).internKey();
        }
        if (evalType == 9) {
            return exprEvaluator;
        }
        return left == null ? null : this.compressEvaluator(left);
    }

    protected static String createErrorContextText(char[] buf, int at) {
        try {
            int len = buf.length;
            char[] text = new char[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(buf, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(buf, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public void optimize() {
        this.exprEvaluator = this.exprEvaluator.optimize();
    }
}

