/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.idgenerate.providers;

import io.github.wycst.wast.common.idgenerate.entity.IdInfo;
import io.github.wycst.wast.common.idgenerate.providers.IdGenerator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

class SnowflakeIdGeneratorProvider
extends IdGenerator {
    private int bitType;
    private int generateLen;
    private final long beginTimeMillis = 1569859200787L;
    private long beginTime;
    private long instanceBitLen;
    private long maxInstance;
    private long sequenceBits;
    private long sequenceMask;
    private final long instance;
    private long sequence = 0L;
    private long lastTime = -1L;
    private long timeLeftShiftBits;
    private long instanceLeftShiftBits;
    private long maxWaitTimeMills = 200L;

    public SnowflakeIdGeneratorProvider() {
        this(0, 0);
    }

    public SnowflakeIdGeneratorProvider(int bitType, int instance) {
        this.init(bitType);
        if ((long)instance > this.maxInstance || instance < 0) {
            throw new IllegalArgumentException(String.format("instance value can't be greater than %d or less than 0", instance));
        }
        this.instance = instance;
    }

    public SnowflakeIdGeneratorProvider(int bitType, boolean autoDiscoverInstance) {
        this.init(bitType);
        this.instance = this.handleAutoDiscoverInstance();
    }

    private int handleAutoDiscoverInstance() {
        int instance = -1;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostIP = addr.getHostAddress();
            int nSplitIndex = hostIP.lastIndexOf(46);
            int mSplitIndex = hostIP.lastIndexOf(46, nSplitIndex - 1);
            int n = Integer.parseInt(hostIP.substring(nSplitIndex + 1));
            int m = Integer.parseInt(hostIP.substring(mSplitIndex + 1, nSplitIndex));
            if (m < 5) {
                instance = (m - 1) * (1 << (int)(this.instanceBitLen - 2L)) + n;
            } else {
                String hostName = addr.getHostName().trim();
                if (hostName.matches(".*[-]\\d\\d?")) {
                    int splitIndex = hostName.lastIndexOf(45);
                    int insTmp = Integer.parseInt(hostName.substring(splitIndex + 1));
                    instance = (long)instance <= this.maxInstance ? insTmp : insTmp % (int)(this.maxInstance + 1L);
                } else {
                    char ch = hostName.charAt(hostName.length() - 1);
                    int insTmp = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789$_".indexOf(ch);
                    if (insTmp > -1) {
                        instance = insTmp;
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (instance == -1) {
            instance = 0;
        }
        return instance;
    }

    private void init(int bitType) {
        this.bitType = bitType;
        if (bitType == 0) {
            this.generateLen = 64;
            this.instanceBitLen = 10L;
            this.sequenceBits = 12L;
        } else {
            this.generateLen = 53;
            this.instanceBitLen = 10L;
            this.sequenceBits = 14L;
        }
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
        this.maxInstance = 2 << (int)(this.instanceBitLen - 1L);
        this.timeLeftShiftBits = this.instanceBitLen + this.sequenceBits;
        this.instanceLeftShiftBits = this.sequenceBits;
        this.beginTime = this.getTime(1569859200787L);
    }

    @Override
    public synchronized long generateId() {
        long currentTime = this.getTime(System.currentTimeMillis());
        long instance = this.instance;
        if (currentTime < this.lastTime) {
            long slowTimeMills;
            long slowTime = this.lastTime - currentTime;
            long l = slowTimeMills = this.bitType == 0 ? slowTime : slowTime * 1000L;
            if (slowTimeMills < this.maxWaitTimeMills) {
                try {
                    Thread.sleep(slowTimeMills);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                instance = this.maxInstance;
            }
            currentTime = this.lastTime;
        }
        if (currentTime == this.lastTime) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                currentTime = this.nextUnitTime(this.lastTime);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTime = currentTime;
        return currentTime - this.beginTime << (int)this.timeLeftShiftBits | instance << (int)this.instanceLeftShiftBits | this.sequence;
    }

    private long getTime(long timeMillis) {
        return this.bitType == 0 ? timeMillis : timeMillis / 1000L;
    }

    private long nextUnitTime(long lastTime) {
        long time = this.getTime(System.currentTimeMillis());
        while (time <= lastTime) {
            time = this.getTime(System.currentTimeMillis());
        }
        return time;
    }

    @Override
    public IdInfo expId(long id) {
        IdInfo idInfo = new IdInfo();
        long time = id >> (int)this.timeLeftShiftBits;
        long timestamp = time * (long)(this.bitType == 0 ? 1 : 1000) + 1569859200787L;
        long instance = (id >> (int)this.instanceLeftShiftBits) % (long)(1 << (int)this.instanceBitLen);
        long sequence = id % (long)(1 << (int)this.sequenceBits);
        idInfo.setOffsetTime(time);
        idInfo.setTimestamp(timestamp);
        idInfo.setGenerateTime(new Date(timestamp));
        idInfo.setInstance(instance);
        idInfo.setSequence(sequence);
        idInfo.setBit(this.generateLen);
        return idInfo;
    }

    @Override
    public IdInfo expId(String hexId) {
        return this.expId(Long.parseLong(hexId, 16));
    }
}

