/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.exceptions.InvokeReflectException;
import io.github.wycst.wast.common.reflect.GetterInfo;
import java.lang.reflect.Method;

final class GetterMethodInfo
extends GetterInfo {
    private final Method method;

    GetterMethodInfo(Method method) {
        this.method = method;
    }

    @Override
    public Object invokeObjectValue(Object target) {
        try {
            return this.method.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new InvokeReflectException(e);
        }
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public boolean isAccess() {
        return true;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public String generateCode() {
        return this.method.getName() + "()";
    }
}

