/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

public class SetterInfo {
    private Field field;
    long fieldOffset = -1L;
    private String name;
    private Class<?> parameterType;
    private Class<?> actualTypeArgument;
    private int index;
    private GenericParameterizedType genericParameterizedType;
    private boolean nonInstanceType;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private Boolean existDefault;
    private boolean fieldDisabled;

    public static SetterInfo fromField(Field field) {
        boolean primitive = field.getType().isPrimitive();
        SetterInfo setterInfo = primitive ? new PrimitiveSetterInfo() : new SetterInfo();
        setterInfo.setField(field);
        return setterInfo;
    }

    public void invoke(Object target, Object value) {
        UnsafeHelper.putObjectValue(target, this.fieldOffset, value);
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
    }

    public Class<?> getActualTypeArgument() {
        return this.actualTypeArgument;
    }

    void setActualTypeArgument(Class<?> actualTypeArgument) {
        this.actualTypeArgument = actualTypeArgument;
    }

    public boolean isNonInstanceType() {
        return this.nonInstanceType;
    }

    void setNonInstanceType(boolean nonInstanceType) {
        this.nonInstanceType = nonInstanceType;
    }

    Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return this.annotations;
    }

    void setAnnotations(Map<Class<? extends Annotation>, Annotation> annotations) {
        this.annotations = annotations;
    }

    void setField(Field field) {
        this.field = field;
        try {
            this.fieldOffset = UnsafeHelper.objectFieldOffset(field);
        }
        catch (Throwable throwable) {
            this.fieldOffset = -1L;
        }
    }

    public GenericParameterizedType getGenericParameterizedType() {
        return this.genericParameterizedType;
    }

    void setGenericParameterizedType(GenericParameterizedType genericParameterizedType) {
        this.genericParameterizedType = genericParameterizedType;
    }

    public Object getDefaultFieldValue(Object instance) {
        try {
            if (this.existDefault == Boolean.FALSE) {
                return null;
            }
            Object fieldValue = this.getFieldValue(instance);
            this.existDefault = fieldValue != null;
            if (fieldValue != null) {
                return fieldValue;
            }
        }
        catch (Exception e) {
            this.existDefault = Boolean.FALSE;
        }
        return null;
    }

    Object getFieldValue(Object instance) {
        return UnsafeHelper.getObjectValue(instance, this.fieldOffset);
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotations.get(annotationType);
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    void setFieldDisabled(boolean disabled) {
        this.fieldDisabled = disabled;
    }

    public boolean isFieldDisabled() {
        return this.fieldDisabled;
    }

    static final class PrimitiveSetterInfo
    extends SetterInfo {
        private ReflectConsts.PrimitiveType primitiveType;

        PrimitiveSetterInfo() {
        }

        @Override
        public void invoke(Object target, Object value) {
            this.primitiveType.put(target, this.fieldOffset, value);
        }

        @Override
        Object getFieldValue(Object instance) {
            return this.primitiveType.get(instance, this.fieldOffset);
        }

        @Override
        void setField(Field field) {
            super.setField(field);
            this.primitiveType = ReflectConsts.PrimitiveType.typeOf(field.getType());
        }
    }
}

