/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.utils.EnvUtils;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import sun.misc.Unsafe;

public final class UnsafeHelper {
    public static final Unsafe UNSAFE;
    public static final long STRING_VALUE_OFFSET;
    public static final long STRING_CODER_OFFSET;
    public static final long DEFAULT_TIME_ZONE_OFFSET;
    public static final long BIGINTEGER_MAG_OFFSET;
    public static final long ARRAYLIST_ELEMENT_DATA_OFFSET;
    public static final long ARRAYLIST_SIZE_OFFSET;
    public static final long OVERRIDE_OFFSET;
    public static final long INT64_MASK_7_BITS = 0xFFFFFFFFFFFFFFL;
    public static final long INT64_MASK_6_BITS = 0xFFFFFFFFFFFFL;
    public static final long INT64_MASK_5_BITS = 0xFFFFFFFFFFL;
    public static final int INT32_MASK_3_BITS = 0xFFFFFF;
    public static final long CHAR_ARRAY_OFFSET;
    public static final long BYTE_ARRAY_OFFSET;
    public static final long BAO_BUF_OFFSET;
    public static final long BAO_COUNT_OFFSET;

    public static Object getStaticFieldValue(String targetClass, String fieldName) {
        try {
            Class<?> target = Class.forName(targetClass);
            Field field = target.getDeclaredField(fieldName);
            long offset = UNSAFE.staticFieldOffset(field);
            return UNSAFE.getObject(target, offset);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static char[] getChars(String string) {
        if (STRING_CODER_OFFSET > -1L) {
            return string.toCharArray();
        }
        string.getClass();
        return (char[])UnsafeHelper.getObjectValue(string, STRING_VALUE_OFFSET);
    }

    public static long getStringCoderOffset() {
        return STRING_CODER_OFFSET;
    }

    public static long getDeclaredFieldOffset(Class<?> targetClass, String fieldName) {
        try {
            Field field = targetClass.getDeclaredField(fieldName);
            return UnsafeHelper.objectFieldOffset(field);
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public static Object getStringValue(String source) {
        source.getClass();
        return UnsafeHelper.getObjectValue(source, STRING_VALUE_OFFSET);
    }

    public static byte getStringCoder(String source) {
        source.getClass();
        if (STRING_CODER_OFFSET > -1L) {
            return UNSAFE.getByte(source, STRING_CODER_OFFSET);
        }
        throw new UnsupportedOperationException();
    }

    public static String getString(char[] buf) {
        if (STRING_CODER_OFFSET == -1L) {
            buf.getClass();
            String result = new String();
            UnsafeHelper.putObjectValue(result, STRING_VALUE_OFFSET, buf);
            return result;
        }
        return new String(buf);
    }

    public static String getAsciiString(byte[] bytes) {
        if (STRING_CODER_OFFSET > -1L) {
            String result = null;
            try {
                result = (String)UNSAFE.allocateInstance(String.class);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            UnsafeHelper.putObjectValue(result, STRING_VALUE_OFFSET, bytes);
            return result;
        }
        return new String(bytes);
    }

    public static String getUTF16String(byte[] utf16Bytes) {
        if (STRING_CODER_OFFSET > -1L) {
            utf16Bytes.getClass();
            String result = null;
            try {
                result = (String)UNSAFE.allocateInstance(String.class);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            UNSAFE.putObject(result, STRING_VALUE_OFFSET, utf16Bytes);
            UNSAFE.putByte(result, STRING_CODER_OFFSET, (byte)1);
            return result;
        }
        throw new UnsupportedOperationException();
    }

    public static int[] getMag(BigInteger value) {
        if (BIGINTEGER_MAG_OFFSET > -1L) {
            value.getClass();
            return (int[])UNSAFE.getObject(value, BIGINTEGER_MAG_OFFSET);
        }
        throw new UnsupportedOperationException();
    }

    public static Object[] getArrayListData(ArrayList value) {
        if (ARRAYLIST_ELEMENT_DATA_OFFSET > -1L) {
            value.getClass();
            return (Object[])UNSAFE.getObject(value, ARRAYLIST_ELEMENT_DATA_OFFSET);
        }
        return value.toArray();
    }

    public static ArrayList fromArrayListData(Object[] elementData, int len) {
        ArrayList<Object> arrayList = new ArrayList<Object>(len);
        elementData.getClass();
        if (ARRAYLIST_ELEMENT_DATA_OFFSET > -1L && len > -1) {
            UNSAFE.putObject(arrayList, ARRAYLIST_ELEMENT_DATA_OFFSET, elementData);
            UNSAFE.putInt(arrayList, ARRAYLIST_SIZE_OFFSET, len);
        } else {
            for (int i = 0; i < len; ++i) {
                arrayList.add(elementData[i]);
            }
        }
        return arrayList;
    }

    public static void copyMemory(char[] chars, int cOff, byte[] bytes, int bOff, int cLen) {
        int arrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayBaseOffset;
        int arrayIndexScale = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayIndexScale;
        int targetArrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveByte.arrayBaseOffset;
        int targetIndexScale = ReflectConsts.PrimitiveType.PrimitiveByte.arrayIndexScale;
        UNSAFE.copyMemory(chars, arrayBaseOffset + arrayIndexScale * cOff, bytes, targetArrayBaseOffset + targetIndexScale * bOff, cLen * arrayIndexScale);
    }

    public static void copyMemory(byte[] bytes, int bOff, char[] chars, int cOff, int bLen) {
        int arrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveByte.arrayBaseOffset;
        int arrayIndexScale = ReflectConsts.PrimitiveType.PrimitiveByte.arrayIndexScale;
        int targetArrayBaseOffset = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayBaseOffset;
        int targetIndexScale = ReflectConsts.PrimitiveType.PrimitiveCharacter.arrayIndexScale;
        UNSAFE.copyMemory(bytes, arrayBaseOffset + arrayIndexScale * bOff, chars, targetArrayBaseOffset + targetIndexScale * cOff, bLen * arrayIndexScale);
    }

    public static Object toArray(Collection collection, Class<?> componentType) {
        collection.getClass();
        componentType.getClass();
        Object array = Array.newInstance(componentType, collection.size());
        int k = 0;
        if (UNSAFE != null) {
            ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
            if (primitiveType != null) {
                int base = primitiveType.arrayBaseOffset;
                int scale = primitiveType.arrayIndexScale;
                for (Object obj : collection) {
                    long valueOffset = base + scale * k++;
                    primitiveType.put(array, valueOffset, obj);
                }
            } else {
                Object[] objects = (Object[])array;
                for (Object obj : collection) {
                    objects[k++] = obj;
                }
            }
        } else {
            for (Object obj : collection) {
                Array.set(array, k++, obj);
            }
        }
        return array;
    }

    public static Object arrayValueAt(Object arr, int index) {
        if (UNSAFE != null) {
            if (index == -1) {
                throw new ArrayIndexOutOfBoundsException(-1);
            }
            Class<?> arrCls = arr.getClass();
            if (!arrCls.isArray()) {
                throw new UnsupportedOperationException("Non array object do not support get value by index");
            }
            Class<?> componentType = arrCls.getComponentType();
            ReflectConsts.PrimitiveType primitiveType = ReflectConsts.PrimitiveType.typeOf(componentType);
            if (primitiveType != null) {
                int base = primitiveType.arrayBaseOffset;
                int scale = primitiveType.arrayIndexScale;
                long valueOffset = base + scale * index;
                return primitiveType.get(arr, valueOffset);
            }
            Object[] objects = (Object[])arr;
            return objects[index];
        }
        return Array.get(arr, index);
    }

    public static TimeZone getDefaultTimeZone() {
        if (DEFAULT_TIME_ZONE_OFFSET > -1L) {
            try {
                TimeZone timeZone = (TimeZone)UNSAFE.getObject(TimeZone.class, DEFAULT_TIME_ZONE_OFFSET);
                if (timeZone != null) {
                    return timeZone;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return TimeZone.getDefault();
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static boolean equals(byte[] a, int aOffset, byte[] b, int bOffset, int len, long remValueForBytes) {
        if (len >= 8) {
            do {
                long lb;
                long la;
                if ((la = UnsafeHelper.getLong(a, aOffset)) != (lb = UnsafeHelper.getLong(b, bOffset))) {
                    return false;
                }
                aOffset += 8;
                bOffset += 8;
            } while ((len -= 8) >= 8);
            if (len == 0) {
                return true;
            }
            int padd = 8 - len;
            return UnsafeHelper.getLong(a, aOffset -= padd) == UnsafeHelper.getLong(b, bOffset -= padd);
        }
        if (len >= 4) {
            int lb;
            int la = UnsafeHelper.getInt(a, aOffset);
            if (la != (lb = UnsafeHelper.getInt(b, bOffset))) {
                return false;
            }
            int v = len - 4;
            if (v == 0) {
                return true;
            }
            return UnsafeHelper.getInt(a, aOffset += v) == UnsafeHelper.getInt(b, bOffset += v);
        }
        switch (len) {
            case 1: {
                return (long)a[aOffset] == remValueForBytes;
            }
            case 2: {
                return (long)UnsafeHelper.getShort(a, aOffset) == remValueForBytes;
            }
        }
        return a[aOffset++] == b[bOffset] && (long)UnsafeHelper.getShort(a, aOffset) == remValueForBytes;
    }

    public static boolean equals(char[] a, int aOffset, char[] b, int bOffset, int len, long remValueForChars) {
        if (len >= 4) {
            do {
                long lb;
                long la;
                if ((la = UnsafeHelper.getLong(a, aOffset)) != (lb = UnsafeHelper.getLong(b, bOffset))) {
                    return false;
                }
                aOffset += 4;
                bOffset += 4;
            } while ((len -= 4) >= 4);
            if (len == 0) {
                return true;
            }
            int v = 4 - len;
            return UnsafeHelper.getLong(a, aOffset -= v) == UnsafeHelper.getLong(b, bOffset -= v);
        }
        switch (len) {
            case 1: {
                return (long)a[aOffset] == remValueForChars;
            }
            case 2: {
                return (long)UnsafeHelper.getInt(a, aOffset) == remValueForChars;
            }
        }
        return a[aOffset++] == b[bOffset] && (long)UnsafeHelper.getInt(a, aOffset) == remValueForChars;
    }

    public static int getInt(char[] buf, int offset) {
        return UNSAFE.getInt(buf, CHAR_ARRAY_OFFSET + (long)(offset << 1));
    }

    public static long getLong(char[] buf, int offset) {
        return UNSAFE.getLong(buf, CHAR_ARRAY_OFFSET + (long)(offset << 1));
    }

    public static int putLong(char[] buf, int offset, long value) {
        buf.getClass();
        long off = CHAR_ARRAY_OFFSET + (long)(offset << 1);
        UNSAFE.putLong(buf, off, value);
        return 4;
    }

    public static int putLong(byte[] buf, int offset, long value) {
        buf.getClass();
        long off = BYTE_ARRAY_OFFSET + (long)offset;
        UNSAFE.putLong(buf, off, value);
        return 8;
    }

    public static int putInt(char[] buf, int offset, int value) {
        buf.getClass();
        long off = CHAR_ARRAY_OFFSET + (long)(offset << 1);
        UNSAFE.putInt(buf, off, value);
        return 2;
    }

    public static short getShort(byte[] buf, int offset) {
        return UNSAFE.getShort(buf, BYTE_ARRAY_OFFSET + (long)offset);
    }

    public static int getInt(byte[] buf, int offset) {
        return UNSAFE.getInt(buf, BYTE_ARRAY_OFFSET + (long)offset);
    }

    public static long getLong(byte[] buf, int offset) {
        return UNSAFE.getLong(buf, BYTE_ARRAY_OFFSET + (long)offset);
    }

    public static long getUnsafeLong(byte[] buf, int offset, int len) {
        int remSize = buf.length - offset;
        if (remSize > 8) {
            switch (len) {
                case 1: {
                    return buf[offset];
                }
                case 2: {
                    return UNSAFE.getShort(buf, BYTE_ARRAY_OFFSET + (long)offset);
                }
                case 3: {
                    int val = UNSAFE.getInt(buf, BYTE_ARRAY_OFFSET + (long)offset);
                    return EnvUtils.BIG_ENDIAN ? (long)(val >> 8) : (long)(val & 0xFFFFFF);
                }
                case 4: {
                    return UNSAFE.getInt(buf, BYTE_ARRAY_OFFSET + (long)offset);
                }
                case 5: {
                    long val = UNSAFE.getLong(buf, BYTE_ARRAY_OFFSET + (long)offset);
                    return EnvUtils.BIG_ENDIAN ? val >> 24 : val & 0xFFFFFFFFFFL;
                }
                case 6: {
                    long val = UNSAFE.getLong(buf, BYTE_ARRAY_OFFSET + (long)offset);
                    return EnvUtils.BIG_ENDIAN ? val >> 16 : val & 0xFFFFFFFFFFFFL;
                }
                case 7: {
                    long val = UNSAFE.getLong(buf, BYTE_ARRAY_OFFSET + (long)offset);
                    return EnvUtils.BIG_ENDIAN ? val >> 8 : val & 0xFFFFFFFFFFFFFFL;
                }
            }
            return UNSAFE.getLong(buf, BYTE_ARRAY_OFFSET + (long)offset);
        }
        long val = 0L;
        if (offset + len > buf.length) {
            len = buf.length - offset;
        }
        for (int i = 0; i < len; ++i) {
            long b = buf[i + offset];
            if (EnvUtils.BIG_ENDIAN) {
                val = val << 8 | b;
                continue;
            }
            val |= b << (i << 3);
        }
        return val;
    }

    public static long getUnsafeLong(char[] buf, int offset, int len) {
        int remSize = buf.length - offset;
        if (remSize > 4) {
            switch (len) {
                case 1: {
                    return buf[offset];
                }
                case 2: {
                    return UNSAFE.getInt(buf, CHAR_ARRAY_OFFSET + (long)offset);
                }
                case 3: {
                    long val = UNSAFE.getLong(buf, CHAR_ARRAY_OFFSET + (long)offset);
                    return EnvUtils.BIG_ENDIAN ? val >> 16 : val & 0xFFFFFFFFFFFFL;
                }
            }
            return UNSAFE.getLong(buf, CHAR_ARRAY_OFFSET + (long)offset);
        }
        long val = 0L;
        if (offset + len > buf.length) {
            len = buf.length - offset;
        }
        for (int i = 0; i < len; ++i) {
            long b = buf[i + offset];
            if (EnvUtils.BIG_ENDIAN) {
                val = val << 16 | b;
                continue;
            }
            val |= b << (i << 4);
        }
        return val;
    }

    public static int putInt(byte[] buf, int offset, int value) {
        buf.getClass();
        long off = BYTE_ARRAY_OFFSET + (long)offset;
        UNSAFE.putInt(buf, off, value);
        return 4;
    }

    public static int putShort(byte[] buf, int offset, short value) {
        buf.getClass();
        long off = BYTE_ARRAY_OFFSET + (long)offset;
        UNSAFE.putShort(buf, off, value);
        return 2;
    }

    public static long[] getLongs(String value) {
        char[] chars = UnsafeHelper.getChars(value);
        int strLength = chars.length;
        int l = strLength >> 2;
        int rem = strLength & 3;
        if (rem > 0) {
            ++l;
        }
        char[] buf = new char[l << 2];
        value.getChars(0, strLength, buf, 0);
        long[] results = new long[l];
        int offset = 0;
        for (int i = 0; i < l; ++i) {
            results[i] = UnsafeHelper.getLong(buf, offset);
            offset += 4;
        }
        return results;
    }

    public static int[] getInts(String value) {
        byte[] bytes = value.getBytes();
        int byteLen = bytes.length;
        int l = byteLen >> 2;
        int rem = byteLen & 3;
        if (rem > 0) {
            ++l;
        }
        byte[] buf = new byte[l << 2];
        System.arraycopy(bytes, 0, buf, 0, byteLen);
        int[] results = new int[l];
        int offset = 0;
        for (int i = 0; i < l; ++i) {
            results[i] = UnsafeHelper.getInt(buf, offset);
            offset += 4;
        }
        return results;
    }

    public static void writeLongsToChars(long[] longs, char[] chars, int offset) {
        for (long l : longs) {
            UnsafeHelper.putLong(chars, offset, l);
            offset += 4;
        }
    }

    public static void writeIntsToBytes(int[] ints, byte[] bytes, int offset) {
        for (int val : ints) {
            UnsafeHelper.putInt(bytes, offset, val);
            offset += 4;
        }
    }

    static long objectFieldOffset(Field field) {
        if (UNSAFE != null) {
            return UNSAFE.objectFieldOffset(field);
        }
        return -1L;
    }

    static void putObjectValue(Object target, long fieldOffset, Object value) {
        target.getClass();
        UNSAFE.putObject(target, fieldOffset, value);
    }

    static Object getObjectValue(Object target, long fieldOffset) {
        target.getClass();
        return UNSAFE.getObject(target, fieldOffset);
    }

    public static Object newInstance(Class<?> targetClass) {
        try {
            return targetClass.newInstance();
        }
        catch (Throwable throwable) {
            try {
                targetClass.getClass();
                return UNSAFE.allocateInstance(targetClass);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean setAccessible(AccessibleObject accessibleObject) {
        if (OVERRIDE_OFFSET > -1L) {
            UNSAFE.putBoolean(accessibleObject, OVERRIDE_OFFSET, true);
            return true;
        }
        return false;
    }

    public static void setAccessibleList(AccessibleObject ... accessibleList) {
        for (AccessibleObject accessibleObject : accessibleList) {
            UnsafeHelper.setAccessible(accessibleObject);
        }
    }

    static int arrayBaseOffset(Class arrayCls) {
        if (UNSAFE != null) {
            return UNSAFE.arrayBaseOffset(arrayCls);
        }
        return -1;
    }

    static int arrayIndexScale(Class arrayCls) {
        if (UNSAFE != null) {
            return UNSAFE.arrayIndexScale(arrayCls);
        }
        return -1;
    }

    static {
        Field theUnsafeField = null;
        try {
            theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
        }
        catch (NoSuchFieldException exception) {
            theUnsafeField = null;
        }
        Unsafe instance = null;
        if (theUnsafeField != null) {
            try {
                instance = (Unsafe)theUnsafeField.get(null);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        UNSAFE = instance;
        CHAR_ARRAY_OFFSET = UnsafeHelper.arrayBaseOffset(char[].class);
        BYTE_ARRAY_OFFSET = UnsafeHelper.arrayBaseOffset(byte[].class);
        BAO_BUF_OFFSET = UnsafeHelper.getDeclaredFieldOffset(ByteArrayOutputStream.class, "buf");
        BAO_COUNT_OFFSET = UnsafeHelper.getDeclaredFieldOffset(ByteArrayOutputStream.class, "count");
        long valueOffset = -1L;
        long coderOffset = -1L;
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueOffset = UnsafeHelper.objectFieldOffset(valueField);
            Object emptyValue = UnsafeHelper.getObjectValue("", valueOffset);
            if (!char[].class.isInstance(emptyValue)) {
                Field coderField = String.class.getDeclaredField("coder");
                coderOffset = UnsafeHelper.objectFieldOffset(coderField);
            }
        }
        catch (Exception emptyValue) {
            // empty catch block
        }
        STRING_VALUE_OFFSET = valueOffset;
        STRING_CODER_OFFSET = coderOffset;
        long defaultTimeZoneOff = -1L;
        try {
            Field timeZoneField = TimeZone.class.getDeclaredField("defaultTimeZone");
            defaultTimeZoneOff = UNSAFE.staticFieldOffset(timeZoneField);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DEFAULT_TIME_ZONE_OFFSET = defaultTimeZoneOff;
        long magOffset = -1L;
        try {
            Field magField = BigInteger.class.getDeclaredField("mag");
            magOffset = UnsafeHelper.objectFieldOffset(magField);
        }
        catch (Exception magField) {
            // empty catch block
        }
        BIGINTEGER_MAG_OFFSET = magOffset;
        long elementDataOffset = -1L;
        long sizeOffset = -1L;
        try {
            Field elementDataField = ArrayList.class.getDeclaredField("elementData");
            elementDataOffset = UnsafeHelper.objectFieldOffset(elementDataField);
        }
        catch (Exception elementDataField) {
            // empty catch block
        }
        try {
            Field sizeField = ArrayList.class.getDeclaredField("size");
            sizeOffset = UnsafeHelper.objectFieldOffset(sizeField);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (elementDataOffset == -1L || sizeOffset == -1L) {
            elementDataOffset = -1L;
            sizeOffset = -1L;
        }
        ARRAYLIST_ELEMENT_DATA_OFFSET = elementDataOffset;
        ARRAYLIST_SIZE_OFFSET = sizeOffset;
        long overrideOffset = 12L;
        try {
            Field overrideField = AccessibleObject.class.getDeclaredField("override");
            overrideOffset = UnsafeHelper.objectFieldOffset(overrideField);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        OVERRIDE_OFFSET = overrideOffset;
    }
}

