/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.template;

import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import java.util.Map;

public abstract class TemplateClass {
    private final StringBuilder buffer = new StringBuilder();

    protected final TemplateClass print(Object text) {
        this.buffer.append(text);
        return this;
    }

    protected final TemplateClass println() {
        this.buffer.append("\r\n");
        return this;
    }

    protected final TemplateClass println(Object text) {
        this.buffer.append(text).append("\r\n");
        return this;
    }

    protected final TemplateClass println(String text, Map<String, Object> context) {
        return this.println(StringUtils.replaceGroupRegex(text, context, true));
    }

    protected final Iterable<Object> getContextIterable(Map<String, Object> context, String key) {
        return ObjectUtils.getIterable(context, key);
    }

    protected final Object getContextValue(Object target, String key) {
        return ObjectUtils.get(target, key);
    }

    protected final Object getContextValue(Object target, String key, Object defaultValue) {
        Object value = ObjectUtils.get(target, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected synchronized String render(Map<String, Object> context) {
        this.buffer.setLength(0);
        this.renderTemplate(context);
        return this.getTemplate();
    }

    protected abstract void renderTemplate(Map<String, Object> var1);

    private String getTemplate() {
        return this.buffer.toString();
    }
}

