/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.utils.CollectionUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassUtils {
    public static void loadJars(String lib) {
        File jarLib = new File(lib);
        if (jarLib.exists() && jarLib.isDirectory()) {
            for (File file : jarLib.listFiles()) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".jar")) continue;
                try {
                    ClassUtils.loadJar(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void loadJar(File jarFile) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException {
        if (!jarFile.exists()) {
            System.out.println(jarFile.getAbsolutePath() + " is not exist ");
            return;
        }
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method _addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        _addURL.setAccessible(true);
        _addURL.invoke((Object)loader, jarFile.toURI().toURL());
    }

    public static void loadJar(String jarFileName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, MalformedURLException {
        ClassUtils.loadJar(new File(jarFileName));
    }

    public static Set<Class<?>> getClassesFromJar(File jarFile) {
        return ClassUtils.getClassesFromJar(jarFile, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> getClassesFromJar(File jarFile, Class<?> parentClass) {
        LinkedHashSet classes = new LinkedHashSet();
        JarFile jar = null;
        try {
            ClassUtils.loadJar(jarFile);
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> entry = jar.entries();
            while (entry.hasMoreElements()) {
                String className;
                Class<?> clazz;
                JarEntry jarEntry = entry.nextElement();
                String jarEntryName = jarEntry.getName();
                if (jarEntryName.charAt(0) == '/') {
                    jarEntryName = jarEntryName.substring(1);
                }
                if (jarEntry.isDirectory() || !jarEntryName.endsWith(".class") || (clazz = ClassUtils.loadClass((className = jarEntryName.substring(0, jarEntryName.length() - 6)).replace("/", "."))) == null || parentClass == clazz || !parentClass.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }

    public static Set<Class<?>> getClassesFromJar(String jarFile) {
        return ClassUtils.getClassesFromJar(new File(jarFile));
    }

    public static Set<Class<?>> getClasses(String packageName, Class<?> parentClass) {
        return ClassUtils.getClasses(packageName, parentClass, true);
    }

    public static Set<Class<?>> getClasses(String packageName, Class<?> parentClass, boolean scanJar) {
        LinkedHashSet classes = new LinkedHashSet();
        String pkgDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> urls = ClassUtils.class.getClassLoader().getResources(pkgDirName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassUtils.findClasses(packageName, filePath, classes, parentClass);
                    continue;
                }
                if (!scanJar || !"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                ClassUtils.findClasses(packageName, jar, classes, parentClass);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static Set<Class<?>> getClassesOfAnnotationType(String packageName, Class<?> parentClass, Class<?> annotationType, boolean isFilterInterface, boolean scanJar) {
        LinkedHashSet classes = new LinkedHashSet();
        String pkgDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> urls = ClassUtils.class.getClassLoader().getResources(pkgDirName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassUtils.findClasses(packageName, filePath, classes, parentClass, annotationType, isFilterInterface);
                    continue;
                }
                if (!scanJar || !"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                ClassUtils.findClasses(packageName, jar, classes, parentClass, annotationType, isFilterInterface);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static Set<Class<?>> getClasses(String packageName) {
        return ClassUtils.getClasses(packageName, Object.class);
    }

    public static Set<Class<?>> getClasses(String packageName, boolean scanJar) {
        return ClassUtils.getClasses(packageName, Object.class, scanJar);
    }

    public static Set<Class<?>> getClassesOfClassPath(Class<?> parentCls) {
        return ClassUtils.getClasses("", parentCls, false);
    }

    public static Set<Class<?>> getClassesOfClassPath(Class<?> parentCls, Class<?> annotationType, boolean isFilterInterface, boolean scanJar) {
        return ClassUtils.getClassesOfAnnotationType("", parentCls, annotationType, isFilterInterface, scanJar);
    }

    public static Set<Class<?>> findClasses(String[] packages, Class<?> parentCls, Class<? extends Annotation> annotationType, boolean isFilterInterface) {
        LinkedHashSet clsSet = new LinkedHashSet();
        if (CollectionUtils.isEmpty(packages)) {
            clsSet.addAll(ClassUtils.getClassesOfClassPath(parentCls, annotationType, isFilterInterface, false));
        } else {
            for (String scanPckage : packages) {
                clsSet.addAll(ClassUtils.getClassesOfAnnotationType(scanPckage, parentCls, annotationType, isFilterInterface, true));
            }
        }
        return clsSet;
    }

    private static void findClasses(String packageName, String packagePath, Set<Class<?>> classes, Class<?> parentClass, Class annotationType, boolean isFilterInterface) {
        File packageDir = new File(packagePath);
        if (!packageDir.exists() || !packageDir.isDirectory()) {
            return;
        }
        String classSuf = ".class";
        File[] files = packageDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".class");
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            boolean validated;
            if (file.isDirectory()) {
                String pckName = null;
                pckName = packageName.equals("") ? file.getName() : packageName + "." + file.getName();
                ClassUtils.findClasses(pckName, packagePath.endsWith("/") ? packagePath + file.getName() : packagePath + "/" + file.getName(), classes, parentClass, annotationType, isFilterInterface);
                continue;
            }
            String className = file.getName();
            className = className.substring(0, className.length() - ".class".length());
            Class<?> clazz = ClassUtils.loadClass(packageName + "." + className);
            if (clazz == null || parentClass == clazz || !parentClass.isAssignableFrom(clazz) || !(validated = ClassUtils.validate(clazz, annotationType, isFilterInterface))) continue;
            classes.add(clazz);
        }
    }

    private static void findClasses(String packageName, String packagePath, Set<Class<?>> classes, Class<?> parentClass) {
        ClassUtils.findClasses(packageName, packagePath, classes, parentClass, null, false);
    }

    private static void findClasses(String packageName, JarFile jar, Set<Class<?>> classes, Class<?> parentClass, Class annotationType, boolean isFilterInterface) {
        String packageDir = packageName.replace(".", "/");
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            boolean validated;
            String className;
            Class<?> clazz;
            JarEntry jarEntry = entries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (jarEntryName.charAt(0) == '/') {
                jarEntryName = jarEntryName.substring(1);
            }
            String classSuf = ".class";
            if (jarEntry.isDirectory() || !jarEntryName.startsWith(packageDir) || !jarEntryName.endsWith(classSuf) || (clazz = ClassUtils.loadClass((className = jarEntryName.substring(0, jarEntryName.length() - classSuf.length())).replace("/", "."))) == null || parentClass == clazz || !parentClass.isAssignableFrom(clazz) || !(validated = ClassUtils.validate(clazz, annotationType, isFilterInterface))) continue;
            classes.add(clazz);
        }
    }

    private static boolean validate(Class<?> clazz, Class annotationType, boolean isFilterInterface) {
        try {
            if (isFilterInterface && !clazz.isInterface()) {
                return false;
            }
            if (annotationType != null) {
                Object annotation = clazz.getAnnotation(annotationType);
                if (annotation != null) {
                    return true;
                }
                Annotation[] annotations = clazz.getDeclaredAnnotations();
                if (annotations != null) {
                    for (Annotation anno : annotations) {
                        if (anno.annotationType().getAnnotation(annotationType) == null) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void findClasses(String packageName, JarFile jar, Set<Class<?>> classes, Class<?> parentClass) {
        ClassUtils.findClasses(packageName, jar, classes, parentClass, null, false);
    }

    private static Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

