/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

public final class MemoryOptimizerUtils {
    static final LengthOptimizer[] SIZE_INSTANCES = new LengthOptimizer[]{MemoryOptimizerUtils.s0(), MemoryOptimizerUtils.s1(), MemoryOptimizerUtils.s2(), MemoryOptimizerUtils.s3(), MemoryOptimizerUtils.s4(), MemoryOptimizerUtils.s5(), MemoryOptimizerUtils.s6(), MemoryOptimizerUtils.s7(), MemoryOptimizerUtils.s8(), MemoryOptimizerUtils.s9(), MemoryOptimizerUtils.s10(), MemoryOptimizerUtils.s11(), MemoryOptimizerUtils.s12(), MemoryOptimizerUtils.s13(), MemoryOptimizerUtils.s14(), MemoryOptimizerUtils.s15(), MemoryOptimizerUtils.s16(), MemoryOptimizerUtils.s17(), MemoryOptimizerUtils.s18(), MemoryOptimizerUtils.s19(), MemoryOptimizerUtils.s20()};
    static final int SIZE_LEN = SIZE_INSTANCES.length;

    private MemoryOptimizerUtils() {
    }

    @Deprecated
    public static void arraycopy(byte[] source, int sOff, byte[] target, int tOff, int len) {
        if (len < SIZE_LEN) {
            SIZE_INSTANCES[len].copyTo(source, sOff, target, tOff, len);
        } else {
            System.arraycopy(source, sOff, target, tOff, len);
        }
    }

    @Deprecated
    public static void arraycopy(char[] source, int sOff, char[] target, int tOff, int len) {
        if (len < SIZE_LEN) {
            SIZE_INSTANCES[len].copyTo(source, sOff, target, tOff, len);
        } else {
            System.arraycopy(source, sOff, target, tOff, len);
        }
    }

    public static char[] copyOfRange(char[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        char[] chars = new char[len];
        System.arraycopy(buf, offset, chars, 0, len);
        return chars;
    }

    public static byte[] copyOfRange(byte[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        byte[] bytes = new byte[len];
        System.arraycopy(buf, offset, bytes, 0, len);
        return bytes;
    }

    public static String[] copyOfRange(String[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        String[] result = new String[len];
        System.arraycopy(buf, offset, result, 0, len);
        return result;
    }

    public static double[] copyOfRange(double[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        double[] result = new double[len];
        System.arraycopy(buf, offset, result, 0, len);
        return result;
    }

    public static long[] copyOfRange(long[] buf, int offset, int len) {
        if (len < SIZE_LEN) {
            return SIZE_INSTANCES[len].copy(buf, offset, len);
        }
        long[] result = new long[len];
        System.arraycopy(buf, offset, result, 0, len);
        return result;
    }

    static LengthOptimizer s0() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[0];
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[0];
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[0];
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[0];
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[0];
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
            }
        };
    }

    static LengthOptimizer s1() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s2() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s3() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s4() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s5() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s6() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s7() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s8() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s9() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s10() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s11() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s12() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s13() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s14() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s15() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s16() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s17() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s18() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s19() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    static LengthOptimizer s20() {
        return new LengthOptimizer(){

            @Override
            public char[] copy(char[] buf, int offset, int len) {
                return new char[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public byte[] copy(byte[] buf, int offset, int len) {
                return new byte[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public String[] copy(String[] buf, int offset, int len) {
                return new String[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public double[] copy(double[] buf, int offset, int len) {
                return new double[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public long[] copy(long[] buf, int offset, int len) {
                return new long[]{buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset++], buf[offset]};
            }

            @Override
            public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }

            @Override
            public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff++] = source[sOff++];
                target[tOff] = source[sOff];
            }
        };
    }

    public static class LengthOptimizer {
        public String[] copy(String[] buf, int offset, int len) {
            String[] result = new String[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public double[] copy(double[] buf, int offset, int len) {
            double[] result = new double[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public long[] copy(long[] buf, int offset, int len) {
            long[] result = new long[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public char[] copy(char[] buf, int offset, int len) {
            char[] result = new char[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public byte[] copy(byte[] buf, int offset, int len) {
            byte[] result = new byte[len];
            System.arraycopy(buf, offset, result, 0, len);
            return result;
        }

        public void copyTo(byte[] source, int sOff, byte[] target, int tOff, int len) {
            System.arraycopy(source, sOff, target, tOff, len);
        }

        public void copyTo(char[] source, int sOff, char[] target, int tOff, int len) {
            System.arraycopy(source, sOff, target, tOff, len);
        }
    }
}

