/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.ED;
import io.github.wycst.wast.common.utils.ED5;
import io.github.wycst.wast.common.utils.EF;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.Scientific;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public final class NumberUtils {
    static final double[] POSITIVE_DECIMAL_POWER = new double[325];
    static final double[] NEGATIVE_DECIMAL_POWER = new double[325];
    static final char[][] POSITIVE_DECIMAL_POWER_CHARS = new char[325][];
    static final char[][] NEGATIVE_DECIMAL_POWER_CHARS = new char[325][];
    static final long[] POW10_LONG_VALUES = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, Long.MAX_VALUE};
    static final long[] POW10_OPPOSITE_VALUES = new long[]{0x6666666666666667L, 5902958103587056518L, 4722366482869645214L, 7555786372591432342L, 6044629098073145874L, 4835703278458516699L, 7737125245533626719L, 6189700196426901375L, 4951760157141521100L, 7922816251426433760L, 6338253001141147008L, 5070602400912917606L, 8112963841460668170L, 6490371073168534536L, 5192296858534827629L, 8307674973655724206L, 6646139978924579365L, 5316911983139663492L, 0x4000000000000001L};
    static final byte[] POW10_OPPOSITE_RB = new byte[]{2, 5, 8, 12, 15, 18, 22, 25, 28, 32, 35, 38, 42, 45, 48, 52, 55, 58, 61};
    static final BigInteger BI_TO_DECIMAL_BASE = BigInteger.valueOf(1000000000L);
    static final BigInteger BI_MAX_VALUE_FOR_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final int[] HEX_DIGITS_INT32 = new int[256];
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final long[] FOUR_DIGITS_64_BITS = new long[10000];
    static final int[] FOUR_DIGITS_32_BITS = new int[10000];
    static final int[] TWO_DIGITS_32_BITS = new int[100];
    static final short[] TWO_DIGITS_16_BITS = new short[100];
    static final long[] POW5_LONG_VALUES = new long[27];
    static final BigInteger[] POW5_BI_VALUES = new BigInteger[343];
    static final ThreadLocal<char[]> THREAD_LOCAL_CHARS = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[24];
        }
    };
    static final int MOD_DOUBLE_EXP = 4095;
    static final int MOD_FLOAT_EXP = 511;
    static final long MOD_DOUBLE_MANTISSA = 0xFFFFFFFFFFFFFL;
    static final int MOD_FLOAT_MANTISSA = 0x7FFFFF;
    static final long MASK_32_BITS = 0xFFFFFFFFL;

    public static char[] copyDigitOnes() {
        return Arrays.copyOf(DigitOnes, DigitOnes.length);
    }

    public static char[] copyDigitTens() {
        return Arrays.copyOf(DigitTens, DigitTens.length);
    }

    public static double getDecimalPowerValue(int expValue) {
        if (expValue < POSITIVE_DECIMAL_POWER.length) {
            return POSITIVE_DECIMAL_POWER[expValue];
        }
        return Math.pow(10.0, expValue);
    }

    public static double getNegativeDecimalPowerValue(int expValue) {
        int index = -expValue;
        if (index < NEGATIVE_DECIMAL_POWER.length) {
            return NEGATIVE_DECIMAL_POWER[index];
        }
        return Math.pow(10.0, expValue);
    }

    public static int stringSize(long value) {
        int i = 1;
        if (value < 0L) {
            ++i;
            value = -value;
        }
        for (long val : POW10_LONG_VALUES) {
            if (value < val) {
                return i;
            }
            ++i;
        }
        return 19;
    }

    public static int digitDecimal(int ch) {
        switch (ch) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return ch - 48;
            }
        }
        return -1;
    }

    public static int parseIntWithin5(char[] buf, int fromIndex, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                return NumberUtils.parseInt1(buf, fromIndex);
            }
            case 2: {
                return NumberUtils.parseInt2(buf, fromIndex);
            }
            case 3: {
                return NumberUtils.parseInt3(buf, fromIndex);
            }
            case 4: {
                return NumberUtils.parseInt4(buf, fromIndex);
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, n) + "\"");
    }

    public static int parseIntWithin5(byte[] bytes, int fromIndex, int n) throws NumberFormatException {
        switch (n) {
            case 1: {
                return NumberUtils.parseInt1(bytes[fromIndex]);
            }
            case 2: {
                return NumberUtils.parseInt2(bytes[fromIndex++], (int)bytes[fromIndex]);
            }
            case 3: {
                return NumberUtils.parseInt3(bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex]);
            }
            case 4: {
                return NumberUtils.parseInt4(bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex++], bytes[fromIndex]);
            }
        }
        throw new NumberFormatException("For input string: \"" + new String(bytes, fromIndex, n) + "\"");
    }

    public static int parseInt4(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt4(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf[fromIndex++], buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt4(int c1, int c2, int c3, int c4) {
        int v4;
        int v3;
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2)) | (v3 = NumberUtils.digitDecimal(c3)) | (v4 = NumberUtils.digitDecimal(c4))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2, (char)c3, (char)c4}) + "\"");
        }
        return v1 * 1000 + v2 * 100 + v3 * 10 + v4;
    }

    public static int parseInt3(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt3(buf[fromIndex++], buf[fromIndex++], buf[fromIndex]);
    }

    public static int parseInt3(int c1, int c2, int c3) throws NumberFormatException {
        int v3;
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2)) | (v3 = NumberUtils.digitDecimal(c3))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2, (char)c3}) + "\"");
        }
        return v1 * 100 + v2 * 10 + v3;
    }

    public static int parseInt2(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static int parseInt2(byte[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf[fromIndex++], (int)buf[fromIndex]);
    }

    public static int parseInt2(int c1, int c2) throws NumberFormatException {
        int v2;
        int v1 = NumberUtils.digitDecimal(c1);
        if ((v1 | (v2 = NumberUtils.digitDecimal(c2))) == -1) {
            throw new NumberFormatException("For input string: \"" + new String(new char[]{(char)c1, (char)c2}) + "\"");
        }
        return v1 * 10 + v2;
    }

    public static int parseInt1(char[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static int parseInt1(byte[] buf, int fromIndex) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(buf[fromIndex]);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + new String(buf, fromIndex, 1) + "\"");
        }
        return v1;
    }

    public static int parseInt1(int ch) throws NumberFormatException {
        int v1 = NumberUtils.digitDecimal(ch);
        if (v1 == -1) {
            throw new NumberFormatException("For input string: \"" + ch + "\"");
        }
        return v1;
    }

    public static String toHexString16(long value) {
        char[] chars = new char[16];
        for (int i = 15; i > -1; --i) {
            int val = (int)(value & 0xFL);
            chars[i] = HEX_DIGITS[val];
            value >>= 4;
        }
        return new String(chars);
    }

    public static int writeUUIDMostSignificantBits(long mostSigBits, char[] buf, int offset) {
        long v4;
        long v3;
        long v2;
        long v1;
        int b1 = (int)(mostSigBits >>> 56 & 0xFFL);
        int b2 = (int)(mostSigBits >>> 48 & 0xFFL);
        int b3 = (int)(mostSigBits >>> 40 & 0xFFL);
        int b4 = (int)(mostSigBits >>> 32 & 0xFFL);
        int b5 = (int)(mostSigBits >>> 24 & 0xFFL);
        int b6 = (int)(mostSigBits >>> 16 & 0xFFL);
        int b7 = (int)(mostSigBits >>> 8 & 0xFFL);
        int b8 = (int)(mostSigBits & 0xFFL);
        if (EnvUtils.BIG_ENDIAN) {
            v1 = (long)HEX_DIGITS_INT32[b1] << 32 | (long)HEX_DIGITS_INT32[b2];
            v2 = (long)HEX_DIGITS_INT32[b3] << 32 | (long)HEX_DIGITS_INT32[b4];
            v3 = (long)HEX_DIGITS_INT32[b5] << 32 | (long)HEX_DIGITS_INT32[b6];
            v4 = (long)HEX_DIGITS_INT32[b7] << 32 | (long)HEX_DIGITS_INT32[b8];
        } else {
            v1 = (long)HEX_DIGITS_INT32[b2] << 32 | (long)HEX_DIGITS_INT32[b1];
            v2 = (long)HEX_DIGITS_INT32[b4] << 32 | (long)HEX_DIGITS_INT32[b3];
            v3 = (long)HEX_DIGITS_INT32[b6] << 32 | (long)HEX_DIGITS_INT32[b5];
            v4 = (long)HEX_DIGITS_INT32[b8] << 32 | (long)HEX_DIGITS_INT32[b7];
        }
        UnsafeHelper.putLong(buf, offset, v1);
        UnsafeHelper.putLong(buf, offset += 4, v2);
        offset += 4;
        buf[offset++] = 45;
        UnsafeHelper.putLong(buf, offset, v3);
        offset += 4;
        buf[offset++] = 45;
        UnsafeHelper.putLong(buf, offset, v4);
        return 18;
    }

    public static int writeUUIDLeastSignificantBits(long leastSigBits, char[] buf, int offset) {
        long v4;
        long v3;
        long v2;
        long v1;
        int b1 = (int)(leastSigBits >>> 56 & 0xFFL);
        int b2 = (int)(leastSigBits >>> 48 & 0xFFL);
        int b3 = (int)(leastSigBits >>> 40 & 0xFFL);
        int b4 = (int)(leastSigBits >>> 32 & 0xFFL);
        int b5 = (int)(leastSigBits >>> 24 & 0xFFL);
        int b6 = (int)(leastSigBits >>> 16 & 0xFFL);
        int b7 = (int)(leastSigBits >>> 8 & 0xFFL);
        int b8 = (int)(leastSigBits & 0xFFL);
        if (EnvUtils.BIG_ENDIAN) {
            v1 = (long)HEX_DIGITS_INT32[b1] << 32 | (long)HEX_DIGITS_INT32[b2];
            v2 = (long)HEX_DIGITS_INT32[b3] << 32 | (long)HEX_DIGITS_INT32[b4];
            v3 = (long)HEX_DIGITS_INT32[b5] << 32 | (long)HEX_DIGITS_INT32[b6];
            v4 = (long)HEX_DIGITS_INT32[b7] << 32 | (long)HEX_DIGITS_INT32[b8];
        } else {
            v1 = (long)HEX_DIGITS_INT32[b2] << 32 | (long)HEX_DIGITS_INT32[b1];
            v2 = (long)HEX_DIGITS_INT32[b4] << 32 | (long)HEX_DIGITS_INT32[b3];
            v3 = (long)HEX_DIGITS_INT32[b6] << 32 | (long)HEX_DIGITS_INT32[b5];
            v4 = (long)HEX_DIGITS_INT32[b8] << 32 | (long)HEX_DIGITS_INT32[b7];
        }
        buf[offset++] = 45;
        UnsafeHelper.putLong(buf, offset, v1);
        offset += 4;
        buf[offset++] = 45;
        UnsafeHelper.putLong(buf, offset, v2);
        UnsafeHelper.putLong(buf, offset += 4, v3);
        UnsafeHelper.putLong(buf, offset += 4, v4);
        return 18;
    }

    public static int writeUUIDMostSignificantBits(long mostSigBits, byte[] buf, int offset) {
        int val;
        int i;
        int index = offset + 18;
        for (i = 3; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 3; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 7; i > -1; --i) {
            val = (int)(mostSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            mostSigBits >>= 4;
        }
        return 18;
    }

    public static int writeUUIDLeastSignificantBits(long leastSigBits, byte[] buf, int offset) {
        int val;
        int i;
        buf[offset] = 45;
        int index = offset + 18;
        for (i = 11; i > -1; --i) {
            val = (int)(leastSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            leastSigBits >>= 4;
        }
        buf[--index] = 45;
        for (i = 3; i > -1; --i) {
            val = (int)(leastSigBits & 0xFL);
            buf[--index] = (byte)HEX_DIGITS[val];
            leastSigBits >>= 4;
        }
        return 18;
    }

    public static double scientificToIEEEDouble(long val, int scale) {
        long e2;
        boolean oddFlag;
        int mask;
        int sr;
        if (val <= 0L) {
            if (val == Long.MIN_VALUE) {
                val = Long.MAX_VALUE;
            } else {
                return 0.0;
            }
        }
        int leadingZeros = Long.numberOfLeadingZeros(val);
        double dv = val;
        if (scale <= 0) {
            int mmask;
            int mask2;
            int sr2;
            if (scale == 0) {
                return dv;
            }
            int e10 = -scale;
            if (e10 > 308) {
                return Double.POSITIVE_INFINITY;
            }
            if ((long)dv == val && e10 < 23) {
                return dv * POSITIVE_DECIMAL_POWER[e10];
            }
            BigInteger multiplier = POW5_BI_VALUES[e10];
            ED5 ed5 = ED5.ED5_A[e10];
            long left = val << leadingZeros - 1;
            long h = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(left, ed5.y);
            if (h >= 0x2000000000000000L) {
                sr2 = 9;
                mask2 = 255;
                mmask = 511;
            } else {
                sr2 = 8;
                mask2 = 127;
                mmask = 255;
            }
            if (e10 < POW5_LONG_VALUES.length) {
                boolean plus;
                long mantissa0 = h >>> sr2;
                long e22 = e10 - leadingZeros + multiplier.bitLength() + sr2 + 1077;
                long mod = h & (long)mmask;
                boolean bl = plus = mod > (long)(mask2 + 1) || mod == (long)(mask2 + 1) && ((mantissa0 & 1L) == 1L || left * ed5.y != 0L);
                if (plus && ++mantissa0 == 0x20000000000000L) {
                    mantissa0 = 0x10000000000000L;
                    ++e22;
                }
                long bits = e22 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
                return Double.longBitsToDouble(bits);
            }
            if ((h & (long)mask2) != (long)mask2 || (h >> sr2 - 1 & 1L) == 1L) {
                return NumberUtils.longBitsToIntegerDouble(h, e10 - leadingZeros + ed5.dfb + sr2 + 1140, sr2);
            }
            long l = left * ed5.y;
            if (!NumberUtils.checkLowCarry(l, left, ed5.f + 1L)) {
                return NumberUtils.longBitsToIntegerDouble(h, e10 - leadingZeros + ed5.dfb + sr2 + 1140, sr2);
            }
            if (NumberUtils.checkLowCarry(l, left, ed5.f)) {
                return NumberUtils.longBitsToIntegerDouble(h + 1L, e10 - leadingZeros + ed5.dfb + sr2 + 1140, sr2);
            }
            int e52 = e10 - leadingZeros + ed5.dfb + sr2 + 65;
            if (e52 >= 972) {
                return Double.POSITIVE_INFINITY;
            }
            long mantissa0 = h >>> sr2;
            long rightSum = (mantissa0 << 1) + 1L;
            int sb = 1 - e52 + e10;
            long diff = BigInteger.valueOf(val).multiply(multiplier).compareTo(BigInteger.valueOf(rightSum).shiftLeft(-sb));
            if ((diff > 0L || diff == 0L && (mantissa0 & 1L) == 1L) && ++mantissa0 == 0x20000000000000L) {
                mantissa0 >>= 1;
                ++e52;
            }
            long e23 = e52 + 1075;
            long bits = e23 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
            return Double.longBitsToDouble(bits);
        }
        if (scale > 342) {
            return 0.0;
        }
        if ((long)dv == val && scale < 23) {
            return dv / POSITIVE_DECIMAL_POWER[scale];
        }
        ED5 ed5 = ED5.ED5_A[scale];
        long left = val << leadingZeros - 1;
        long h = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(left, ed5.oy);
        if (h >= 0x2000000000000000L) {
            sr = 9;
            mask = 255;
        } else {
            sr = 8;
            mask = 127;
        }
        if ((h & (long)mask) != (long)mask || (h >> sr - 1 & 1L) == 1L) {
            return NumberUtils.longBitsToDecimalDouble(h, 33 - scale - ed5.ob - leadingZeros + sr, sr);
        }
        long l = left * ed5.oy;
        int e52 = 33 - scale - ed5.ob - leadingZeros + sr;
        if (!NumberUtils.checkLowCarry(l, left, ed5.of + 1L)) {
            return NumberUtils.longBitsToDecimalDouble(h, e52, sr);
        }
        if (NumberUtils.checkLowCarry(l, left, ed5.of)) {
            return NumberUtils.longBitsToDecimalDouble(h + 1L, e52, sr);
        }
        if (scale < POW5_LONG_VALUES.length) {
            long diff;
            long p5sv = POW5_LONG_VALUES[scale];
            long mantissa0 = h >>> sr;
            long e24 = e52 + 1075;
            long bits = e24 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
            double dv0 = Double.longBitsToDouble(bits);
            int sb = 1 - scale - e52;
            long l2 = diff = sb > 0 ? (val << sb) - (mantissa0 << 1) * p5sv - p5sv : val - (mantissa0 << 1 - sb) * p5sv - (p5sv << -sb);
            if (diff > 0L || diff == 0L && (mantissa0 & 1L) == 1L) {
                return Double.longBitsToDouble(bits + 1L);
            }
            return dv0;
        }
        BigInteger divisor = POW5_BI_VALUES[scale];
        long mantissa0 = h >>> sr;
        boolean bl = oddFlag = (mantissa0 & 1L) == 1L;
        if (e52 < -1074) {
            e2 = 0L;
            if ((sr += -1074 - e52) >= 62) {
                return 0.0;
            }
        } else {
            e2 = e52 + 1075;
        }
        long rightSum = (mantissa0 << 1) + 1L;
        int sb = 1 - e52 - scale;
        long diff = BigInteger.valueOf(val).shiftLeft(sb).compareTo(divisor.multiply(BigInteger.valueOf(rightSum)));
        if ((diff > 0L || diff == 0L && oddFlag) && ++mantissa0 == 0x20000000000000L) {
            mantissa0 >>= 1;
            ++e2;
        }
        long bits = e2 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    private static boolean checkLowCarry(long l, long x, long y32) {
        long h1 = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y32);
        long l1 = x * y32;
        long carry = (h1 << 32) + (l1 >>> 32);
        long l2 = l + carry;
        return (l | carry) < 0L && ((l & carry) < 0L || l2 >= 0L);
    }

    static double longBitsToDecimalDouble(long l62, int e52, int sr) {
        long mantissa0;
        long e2;
        if (e52 < -1074) {
            e2 = 0L;
            if ((sr += -1074 - e52) >= 62) {
                return 0.0;
            }
            mantissa0 = (l62 >> sr - 1) + 1L >> 1;
        } else {
            e2 = e52 + 1075;
            mantissa0 = (l62 >>> sr - 1) + 1L >> 1;
            if (mantissa0 == 0x20000000000000L) {
                mantissa0 >>= 1;
                ++e2;
            }
        }
        long bits = e2 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    static double longBitsToIntegerDouble(long l62, long e2, int sr) {
        if (e2 >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        long mantissa0 = (l62 >>> sr - 1) + 1L >> 1;
        if (mantissa0 == 0x20000000000000L) {
            mantissa0 = 0x10000000000000L;
            ++e2;
        }
        long bits = e2 << 52 | mantissa0 & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    public static float scientificToIEEEFloat(long val, int scale) {
        float val0;
        if (val <= 0L) {
            return 0.0f;
        }
        float fv = val;
        if (scale <= 0) {
            if (scale == 0) {
                return fv;
            }
            int e10 = -scale;
            if (e10 > 38) {
                return Float.POSITIVE_INFINITY;
            }
            double dv = (double)val * NumberUtils.getDecimalPowerValue(e10);
            val0 = (float)dv;
        } else {
            if (scale > 63) {
                return 0.0f;
            }
            double dv = (double)val / NumberUtils.getDecimalPowerValue(scale);
            val0 = (float)dv;
        }
        return val0;
    }

    static long multiplyHighAndShift(long x, long y, int shift) {
        long H = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y);
        if (shift >= 64) {
            int sr = shift - 64;
            return H >>> sr;
        }
        long L = x * y;
        return H << 64 - shift | L >>> shift;
    }

    static long multiplyHighAndShift(long x, long y, long y32, int s) {
        int sr = s - 64;
        long H = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y);
        long L = x * y;
        long H1 = EnvUtils.JDK_AGENT_INSTANCE.multiplyHighKaratsuba(x, y32);
        long L1 = x * y32;
        long carry = (H1 << 32) + (L1 >>> 32);
        long L2 = L + carry;
        if ((L | carry) < 0L && ((L & carry) < 0L || L2 >= 0L)) {
            ++H;
        }
        L = L2;
        if (sr >= 0) {
            return H >>> sr;
        }
        return H << -sr | L >>> s;
    }

    static Scientific doubleToScientific(double doubleValue) {
        long output;
        long rawOutput;
        long d4;
        long d3;
        long d2;
        int adl;
        int e10;
        int e52;
        boolean flagForDown;
        long bits = Double.doubleToRawLongBits(doubleValue);
        int e2 = (int)(bits >> 52) & 0xFFF;
        long mantissa0 = bits & 0xFFFFFFFFFFFFFL;
        boolean bl = flagForDown = mantissa0 > 0L;
        if (e2 > 0) {
            if (e2 == 2047) {
                return Scientific.SCIENTIFIC_NULL;
            }
            mantissa0 = 0x10000000000000L | mantissa0;
            e52 = e2 - 1075;
        } else {
            int lz52 = Long.numberOfLeadingZeros(mantissa0) - 11;
            mantissa0 <<= lz52;
            e52 = -1074 - lz52;
        }
        boolean tflag = true;
        boolean accurate = false;
        if (e52 >= 0) {
            ED d = ED.E2_D_A[e52];
            e10 = d.e10;
            adl = d.adl;
            d2 = d.d2;
            d3 = d.d3;
            d4 = d.d4;
            if (d.b && mantissa0 >= d.bv) {
                if (mantissa0 > d.bv) {
                    ++e10;
                    ++adl;
                } else if (doubleValue == POSITIVE_DECIMAL_POWER[e10 + 1]) {
                    return new Scientific(e10 + 1, true);
                }
            }
            int o5 = d.o5;
            int sb = e52 + o5;
            if (o5 < 0) {
                ED5 d5 = ED5.ED5_A[-o5];
                int rb = sb - 10 - d5.ob;
                rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 << 10, d5.oy, d5.of, 32 - rb);
                accurate = o5 == -1 && sb < 11;
            } else {
                rawOutput = mantissa0 * POW5_LONG_VALUES[o5] << sb;
                accurate = true;
            }
        } else {
            int o5;
            int sb;
            int e5 = -e52;
            ED d = ED.E5_D_A[e5];
            e10 = d.e10;
            adl = d.adl;
            d2 = d.d2;
            d3 = d.d3;
            d4 = d.d4;
            if (d.b && mantissa0 >= d.bv) {
                if (mantissa0 > d.bv) {
                    ++e10;
                    ++adl;
                } else {
                    if (e10 >= -1 && doubleValue == POSITIVE_DECIMAL_POWER[e10 + 1]) {
                        return new Scientific(e10 + 1, true);
                    }
                    if (e10 < -1 && doubleValue == NEGATIVE_DECIMAL_POWER[-e10 - 1]) {
                        return new Scientific(e10 + 1, true);
                    }
                }
            }
            if ((sb = (o5 = d.o5) + e52) < 0) {
                if (o5 < POW5_LONG_VALUES.length) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0, POW5_LONG_VALUES[o5], -sb);
                } else if (o5 < POW5_LONG_VALUES.length + 4) {
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 * POW5_LONG_VALUES[o5 - POW5_LONG_VALUES.length + 1], POW5_LONG_VALUES[POW5_LONG_VALUES.length - 1], -sb);
                } else {
                    ED5 ed5 = ED5.ED5_A[o5];
                    rawOutput = NumberUtils.multiplyHighAndShift(mantissa0 << 10, ed5.y, ed5.f, -(ed5.dfb + sb) + 10);
                }
            } else {
                rawOutput = POW5_LONG_VALUES[o5] * mantissa0 << sb;
            }
        }
        if (accurate) {
            rawOutput /= 10L;
            if (adl == 16) {
                --adl;
                long rem = rawOutput % 10L;
                rawOutput = rawOutput / 10L + (long)(rem >= 5L ? 1 : 0);
            }
            return new Scientific(rawOutput, adl + 2, e10);
        }
        if (rawOutput < 0L) {
            rawOutput = (rawOutput >>> 1) / 5L;
            tflag = false;
        }
        if (tflag) {
            long div = rawOutput / 1000L;
            long rem = rawOutput - div * 1000L;
            long remUp = 10001L - rem * 10L << 1;
            boolean up = remUp <= d4;
            if (up || rem + 1L << (flagForDown ? 1 : 2) <= d3) {
                output = div + (long)(up ? 1 : 0);
                --adl;
            } else if (flagForDown) {
                rem = rawOutput - (div = rawOutput / 100L) * 100L;
                output = div + (long)(rem >= 50L ? 1 : 0);
            } else {
                rem = rawOutput - (div = rawOutput / 10L) * 10L;
                output = div + (long)(rem >= 5L ? 1 : 0);
                ++adl;
            }
        } else {
            long rem = rawOutput % 100L;
            long remUp = 101L - rem << 1;
            boolean up = remUp <= d2;
            if (up || rem + 1L << (flagForDown ? 1 : 2) <= d2) {
                output = rawOutput / 100L + (long)(up ? 1 : 0);
                --adl;
            } else if (flagForDown) {
                output = rawOutput / 10L + (long)(rem % 10L >= 5L ? 1 : 0);
            } else {
                output = rawOutput;
                ++adl;
            }
        }
        return new Scientific(output, adl + 1, e10);
    }

    static Scientific floatToScientific(float floatValue) {
        long output;
        boolean up;
        long d4;
        int adl;
        int e10;
        int e23;
        boolean nonZeroFlag;
        int bits = Float.floatToRawIntBits(floatValue);
        int e2 = bits >> 23 & 0x1FF;
        int mantissa0 = bits & 0x7FFFFF;
        boolean bl = nonZeroFlag = mantissa0 > 0;
        if (e2 > 0) {
            mantissa0 = 0x800000 | mantissa0;
            e23 = e2 - 150;
        } else {
            int l = Integer.numberOfLeadingZeros(mantissa0) - 8;
            mantissa0 <<= l;
            e23 = -149 - l;
        }
        if (e23 >= 0) {
            ED d = EF.E2_F_A[e23];
            e10 = d.e10;
            adl = d.adl;
            d4 = d.d4;
            if (d.b && (long)mantissa0 > d.bv) {
                ++e10;
                ++adl;
            }
        } else {
            int e5 = -e23;
            ED d = EF.E5_F_A[e5];
            e10 = d.e10;
            adl = d.adl;
            d4 = d.d4;
            if (d.b && (long)mantissa0 > d.bv) {
                ++e10;
                ++adl;
            }
        }
        int rn = adl + 5 - e10;
        double dv = floatValue;
        long rawOutput = rn >= 0 ? (long)(dv * NumberUtils.getDecimalPowerValue(rn)) : (long)(dv / NumberUtils.getDecimalPowerValue(-rn));
        long div = rawOutput / 1000000L;
        long rem = rawOutput - div * 1000000L;
        long remUp = 1000001L - rem << 1;
        boolean bl2 = up = remUp <= d4;
        if (up || rem + 1L << (nonZeroFlag ? 1 : 2) <= d4) {
            output = div + (long)(up ? 1 : 0);
            if (up && POW10_LONG_VALUES[--adl] == output) {
                ++e10;
                output = 1L;
                adl = 0;
            }
        } else if (nonZeroFlag) {
            output = rawOutput / 100000L + (long)(rem % 100000L >= 50000L ? 1 : 0);
        } else {
            output = rawOutput / 10000L + (long)(rem % 10000L >= 5000L ? 1 : 0);
            ++adl;
        }
        return new Scientific(output, adl + 1, e10);
    }

    public static int writeDouble(double doubleValue, char[] buf, int off) {
        boolean sign;
        int beginIndex = off;
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            buf[off++] = 45;
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            long output = (long)doubleValue;
            int numLength = NumberUtils.stringSize(output);
            return NumberUtils.writeDecimal(output, numLength, numLength - 1, buf, beginIndex, off);
        }
        Scientific scientific = NumberUtils.doubleToScientific(doubleValue);
        int e10 = scientific.e10;
        if (!scientific.b) {
            return NumberUtils.writeDecimal(scientific.output, scientific.count, e10, buf, beginIndex, off);
        }
        if (scientific == Scientific.SCIENTIFIC_NULL) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (e10 >= 0) {
            char[] chars = POSITIVE_DECIMAL_POWER_CHARS[e10];
            System.arraycopy(chars, 0, buf, off, chars.length);
            return (off += chars.length) - beginIndex;
        }
        char[] chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10];
        System.arraycopy(chars, 0, buf, off, chars.length);
        return (off += chars.length) - beginIndex;
    }

    public static int writeFloat(float floatValue, char[] buf, int off) {
        boolean sign;
        int beginIndex = off;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        Scientific scientific = NumberUtils.floatToScientific(floatValue);
        return NumberUtils.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, beginIndex, off);
    }

    private static int writeDecimal(long value, int digitCnt, int e10, char[] buf, int beginIndex, int off) {
        boolean useScientific;
        if ((value & 1L) == 0L && value % 5L == 0L) {
            while (value % 100L == 0L) {
                value /= 100L;
                if ((digitCnt -= 2) != 1) continue;
            }
            if ((value & 1L) == 0L && value % 5L == 0L && value > 0L) {
                --digitCnt;
                value /= 10L;
            }
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off++] = (char)(value + 48L);
                buf[off++] = 46;
                buf[off++] = 48;
            } else {
                int pos = digitCnt - 2;
                long tl = POW10_LONG_VALUES[pos];
                int fd = (int)(value / tl);
                buf[off++] = (char)(fd + 48);
                buf[off++] = 46;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = e10 / 100;
                buf[off++] = (char)(n + 48);
                buf[off++] = DigitTens[e10 -= n * 100];
                buf[off++] = DigitOnes[e10];
            } else {
                if (e10 > 9) {
                    buf[off++] = DigitTens[e10];
                }
                buf[off++] = DigitOnes[e10];
            }
        } else if (e10 < 0) {
            buf[off++] = 48;
            buf[off++] = 46;
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                buf[off++] = 48;
                buf[off++] = 48;
            }
            off += NumberUtils.writePositiveLong(value, buf, off);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = POW10_LONG_VALUES[pos];
                int pointBefore = (int)(value / tl);
                off += NumberUtils.writePositiveLong((long)pointBefore, buf, off);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            } else {
                off += NumberUtils.writePositiveLong(value, buf, off);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                buf[off++] = 46;
                buf[off++] = 48;
            }
        }
        return off - beginIndex;
    }

    public static int writeDouble(double doubleValue, byte[] buf, int off) {
        char[] chars;
        boolean sign;
        int beginIndex = off;
        if (doubleValue == 0.0) {
            long bits = Double.doubleToLongBits(doubleValue);
            if (bits == Long.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = doubleValue < 0.0;
        if (sign) {
            buf[off++] = 45;
            doubleValue = -doubleValue;
        }
        if (doubleValue == (double)((long)doubleValue)) {
            long output = (long)doubleValue;
            int numLength = NumberUtils.stringSize(output);
            return NumberUtils.writeDecimal(output, numLength, numLength - 1, buf, beginIndex, off);
        }
        Scientific scientific = NumberUtils.doubleToScientific(doubleValue);
        int e10 = scientific.e10;
        if (!scientific.b) {
            return NumberUtils.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, beginIndex, off);
        }
        if (scientific == Scientific.SCIENTIFIC_NULL) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (e10 >= 0) {
            char[] chars2;
            for (char c : chars2 = POSITIVE_DECIMAL_POWER_CHARS[e10]) {
                buf[off++] = (byte)c;
            }
            return off - beginIndex;
        }
        for (char c : chars = NEGATIVE_DECIMAL_POWER_CHARS[-e10]) {
            buf[off++] = (byte)c;
        }
        return off - beginIndex;
    }

    public static int writeFloat(float floatValue, byte[] buf, int off) {
        boolean sign;
        int beginIndex = off;
        if (Float.isNaN(floatValue) || floatValue == Float.POSITIVE_INFINITY || floatValue == Float.NEGATIVE_INFINITY) {
            buf[off++] = 110;
            buf[off++] = 117;
            buf[off++] = 108;
            buf[off++] = 108;
            return off - beginIndex;
        }
        if (floatValue == 0.0f) {
            int bits = Float.floatToIntBits(floatValue);
            if (bits == Integer.MIN_VALUE) {
                buf[off++] = 45;
            }
            buf[off++] = 48;
            buf[off++] = 46;
            buf[off++] = 48;
            return off - beginIndex;
        }
        boolean bl = sign = floatValue < 0.0f;
        if (sign) {
            buf[off++] = 45;
            floatValue = -floatValue;
        }
        Scientific scientific = NumberUtils.floatToScientific(floatValue);
        return NumberUtils.writeDecimal(scientific.output, scientific.count, scientific.e10, buf, beginIndex, off);
    }

    private static int writeDecimal(long value, int digitCnt, int e10, byte[] buf, int beginIndex, int off) {
        boolean useScientific;
        if ((value & 1L) == 0L && value % 5L == 0L) {
            while (value % 100L == 0L) {
                value /= 100L;
                if ((digitCnt -= 2) != 1) continue;
            }
            if ((value & 1L) == 0L && value % 5L == 0L && value > 0L) {
                --digitCnt;
                value /= 10L;
            }
        }
        boolean bl = useScientific = e10 < -3 || e10 >= 7;
        if (useScientific) {
            if (digitCnt == 1) {
                buf[off++] = (byte)(value + 48L);
                buf[off++] = 46;
                buf[off++] = 48;
            } else {
                int pos = digitCnt - 2;
                long tl = POW10_LONG_VALUES[pos];
                int fd = (int)(value / tl);
                buf[off++] = (byte)(fd + 48);
                buf[off++] = 46;
                long pointAfter = value - (long)fd * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            }
            buf[off++] = 69;
            if (e10 < 0) {
                buf[off++] = 45;
                e10 = -e10;
            }
            if (e10 > 99) {
                int n = e10 / 100;
                buf[off++] = (byte)(n + 48);
                buf[off++] = (byte)DigitTens[e10 -= n * 100];
                buf[off++] = (byte)DigitOnes[e10];
            } else {
                if (e10 > 9) {
                    buf[off++] = (byte)DigitTens[e10];
                }
                buf[off++] = (byte)DigitOnes[e10];
            }
        } else if (e10 < 0) {
            buf[off++] = 48;
            buf[off++] = 46;
            if (e10 == -2) {
                buf[off++] = 48;
            } else if (e10 == -3) {
                buf[off++] = 48;
                buf[off++] = 48;
            }
            off += NumberUtils.writePositiveLong(value, buf, off);
        } else {
            int decimalPointPos = digitCnt - 1 - e10;
            if (decimalPointPos > 0) {
                int pos = decimalPointPos - 1;
                long tl = POW10_LONG_VALUES[pos];
                int pointBefore = (int)(value / tl);
                off += NumberUtils.writePositiveLong((long)pointBefore, buf, off);
                buf[off++] = 46;
                long pointAfter = value - (long)pointBefore * tl;
                while (--pos > -1 && pointAfter < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong(pointAfter, buf, off);
            } else {
                off += NumberUtils.writePositiveLong(value, buf, off);
                int zeroCnt = -decimalPointPos;
                if (zeroCnt > 0) {
                    for (int i = 0; i < zeroCnt; ++i) {
                        buf[off++] = 48;
                    }
                }
                buf[off++] = 46;
                buf[off++] = 48;
            }
        }
        return off - beginIndex;
    }

    public static int writeBigInteger(BigInteger val, char[] chars, int off) {
        int beginIndex = off;
        if (val.signum() == -1) {
            chars[off++] = 45;
            val = val.negate();
        }
        if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
            long value = val.longValue();
            off += NumberUtils.writePositiveLong(value, chars, off);
            return off - beginIndex;
        }
        int bigLength = val.bitLength();
        int[] values = new int[bigLength / 31];
        int len = 0;
        while (true) {
            BigInteger[] bigIntegers = val.divideAndRemainder(BI_TO_DECIMAL_BASE);
            int rem = bigIntegers[1].intValue();
            val = bigIntegers[0];
            if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
                long headNum = val.longValue();
                off += NumberUtils.writePositiveLong(headNum, chars, off);
                int pos = 8;
                while (--pos > -1 && (long)rem < POW10_LONG_VALUES[pos]) {
                    chars[off++] = 48;
                }
                off += NumberUtils.writePositiveLong((long)rem, chars, off);
                for (int j = len - 1; j > -1; --j) {
                    int value = values[j];
                    pos = 8;
                    while (--pos > -1 && (long)value < POW10_LONG_VALUES[pos]) {
                        chars[off++] = 48;
                    }
                    off += NumberUtils.writePositiveLong((long)value, chars, off);
                }
                return off - beginIndex;
            }
            values[len++] = rem;
        }
    }

    public static int writeBigInteger(BigInteger val, byte[] buf, int off) {
        int beginIndex = off;
        if (val.signum() == -1) {
            buf[off++] = 45;
            val = val.negate();
        }
        if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
            long value = val.longValue();
            off += NumberUtils.writePositiveLong(value, buf, off);
            return off - beginIndex;
        }
        int bigLength = val.bitLength();
        int[] values = new int[bigLength / 31];
        int len = 0;
        while (true) {
            BigInteger[] bigIntegers = val.divideAndRemainder(BI_TO_DECIMAL_BASE);
            int rem = bigIntegers[1].intValue();
            val = bigIntegers[0];
            if (val.compareTo(BI_MAX_VALUE_FOR_LONG) < 1) {
                long headNum = val.longValue();
                off += NumberUtils.writePositiveLong(headNum, buf, off);
                int pos = 8;
                while (--pos > -1 && (long)rem < POW10_LONG_VALUES[pos]) {
                    buf[off++] = 48;
                }
                off += NumberUtils.writePositiveLong((long)rem, buf, off);
                for (int j = len - 1; j > -1; --j) {
                    int value = values[j];
                    pos = 8;
                    while (--pos > -1 && (long)value < POW10_LONG_VALUES[pos]) {
                        buf[off++] = 48;
                    }
                    off += NumberUtils.writePositiveLong((long)value, buf, off);
                }
                return off - beginIndex;
            }
            values[len++] = rem;
        }
    }

    public static void writePositiveLong(long val, Appendable appendable) throws IOException {
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            return;
        }
        long numValue = val;
        val = numValue / 100L;
        int v1 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v2 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v3 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v4 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v5 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v6 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v7 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v7]);
            appendable.append(DigitOnes[v7]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v8 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v8]);
            appendable.append(DigitOnes[v8]);
            appendable.append(DigitTens[v7]);
            appendable.append(DigitOnes[v7]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
            return;
        }
        numValue = val;
        val = numValue / 100L;
        int v9 = (int)(numValue - val * 100L);
        if (val < 100L) {
            int v = (int)val;
            if (v > 9) {
                appendable.append(DigitTens[v]);
            }
            appendable.append(DigitOnes[v]);
            appendable.append(DigitTens[v9]);
            appendable.append(DigitOnes[v9]);
            appendable.append(DigitTens[v8]);
            appendable.append(DigitOnes[v8]);
            appendable.append(DigitTens[v7]);
            appendable.append(DigitOnes[v7]);
            appendable.append(DigitTens[v6]);
            appendable.append(DigitOnes[v6]);
            appendable.append(DigitTens[v5]);
            appendable.append(DigitOnes[v5]);
            appendable.append(DigitTens[v4]);
            appendable.append(DigitOnes[v4]);
            appendable.append(DigitTens[v3]);
            appendable.append(DigitOnes[v3]);
            appendable.append(DigitTens[v2]);
            appendable.append(DigitOnes[v2]);
            appendable.append(DigitTens[v1]);
            appendable.append(DigitOnes[v1]);
        }
    }

    static int writeThreeDigits(int val, char[] chars, int off) {
        if (val < 10) {
            chars[off] = DigitOnes[val];
            return 1;
        }
        if (val < 100) {
            UnsafeHelper.putInt(chars, off, TWO_DIGITS_32_BITS[val]);
            return 2;
        }
        int v = val / 100;
        int v1 = val - v * 100;
        chars[off++] = DigitOnes[v];
        UnsafeHelper.putInt(chars, off, TWO_DIGITS_32_BITS[v1]);
        return 3;
    }

    static int writeThreeDigits(int val, byte[] buf, int off) {
        if (val < 10) {
            buf[off] = (byte)DigitOnes[val];
            return 1;
        }
        if (val < 100) {
            UnsafeHelper.putShort(buf, off, TWO_DIGITS_16_BITS[val]);
            return 2;
        }
        int v = val / 100;
        int v1 = val - v * 100;
        buf[off++] = (byte)DigitOnes[v];
        UnsafeHelper.putShort(buf, off, TWO_DIGITS_16_BITS[v1]);
        return 3;
    }

    public static int writeFourDigits(int val, char[] chars, int off) {
        UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[val]);
        return 4;
    }

    public static int writeFourDigits(int val, byte[] buf, int off) {
        UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[val]);
        return 4;
    }

    public static int writeTwoDigits(int val, char[] chars, int off) {
        UnsafeHelper.putInt(chars, off, TWO_DIGITS_32_BITS[val]);
        return 2;
    }

    public static int writeTwoDigits(int val, byte[] buf, int off) {
        UnsafeHelper.putShort(buf, off, TWO_DIGITS_16_BITS[val]);
        return 2;
    }

    public static int writeFourDigits(int val, char roundChar, char[] chars, int off) {
        long longVal = (long)roundChar << 48 | (long)TWO_DIGITS_32_BITS[val] << 16 | (long)roundChar;
        UnsafeHelper.putLong(chars, off, longVal);
        return 4;
    }

    public static int writeTwoDigitsAndPreSuffix(int val, char pre, char suff, char[] chars, int off) {
        long longVal = EnvUtils.BIG_ENDIAN ? (long)pre << 48 | (long)TWO_DIGITS_32_BITS[val] << 16 | (long)suff : (long)suff << 48 | (long)TWO_DIGITS_32_BITS[val] << 16 | (long)pre;
        UnsafeHelper.putLong(chars, off, longVal);
        return 4;
    }

    public static int writeTwoDigitsAndPreSuffix(int val, char pre, char suff, byte[] buf, int off) {
        int intVal = EnvUtils.BIG_ENDIAN ? pre << 24 | TWO_DIGITS_16_BITS[val] << 8 | suff : suff << 24 | TWO_DIGITS_16_BITS[val] << 8 | pre;
        UnsafeHelper.putInt(buf, off, intVal);
        return 4;
    }

    public static int writeFourDigits(int val, byte roundByte, byte[] buf, int off) {
        int intVal = roundByte << 24 | TWO_DIGITS_16_BITS[val] << 8 | roundByte;
        UnsafeHelper.putInt(buf, off, intVal);
        return 4;
    }

    public static int writePositiveLong(long val, char[] chars, int off) {
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                return NumberUtils.writeThreeDigits(v, chars, off);
            }
            return UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]);
        }
        int beginIndex = off;
        long numValue = val;
        val = numValue / 10000L;
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v3]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
            off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v4 = (int)(numValue - val * 10000L);
        int v = (int)val;
        off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, chars, off)) : (off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v]));
        off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v4]);
        off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v3]);
        off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v2]);
        off += UnsafeHelper.putLong(chars, off, FOUR_DIGITS_64_BITS[v1]);
        return off - beginIndex;
    }

    public static int writePositiveLong(long val, byte[] buf, int off) {
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                return NumberUtils.writeThreeDigits(v, buf, off);
            }
            return UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]);
        }
        int beginIndex = off;
        long numValue = val;
        val = numValue / 10000L;
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v2]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v3]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v2]);
            off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
            return off - beginIndex;
        }
        numValue = val;
        val = numValue / 10000L;
        int v4 = (int)(numValue - val * 10000L);
        int v = (int)val;
        off = v < 1000 ? (off += NumberUtils.writeThreeDigits(v, buf, off)) : (off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v]));
        off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v4]);
        off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v3]);
        off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v2]);
        off += UnsafeHelper.putInt(buf, off, FOUR_DIGITS_32_BITS[v1]);
        return off - beginIndex;
    }

    public static int hex(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return c - 48;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return c - 97 + 10;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return c - 65 + 10;
            }
        }
        throw new IllegalArgumentException("invalid hex char " + (char)c);
    }

    public static String toString(double val) {
        if (Double.isNaN(val)) {
            return "NaN";
        }
        if (val == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (val == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        char[] chars = THREAD_LOCAL_CHARS.get();
        return new String(chars, 0, NumberUtils.writeDouble(val, chars, 0));
    }

    public static String toString(float val) {
        char[] chars = THREAD_LOCAL_CHARS.get();
        return new String(chars, 0, NumberUtils.writeFloat(val, chars, 0));
    }

    static {
        int len = POSITIVE_DECIMAL_POWER.length;
        for (int i = 0; i < len; ++i) {
            String positive = "1.0E" + i;
            String negative = "1.0E-" + i;
            NumberUtils.POSITIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E" + i);
            NumberUtils.NEGATIVE_DECIMAL_POWER[i] = Double.valueOf("1.0E-" + i);
            NumberUtils.POSITIVE_DECIMAL_POWER_CHARS[i] = positive.toCharArray();
            NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS[i] = negative.toCharArray();
        }
        NumberUtils.NEGATIVE_DECIMAL_POWER[NumberUtils.NEGATIVE_DECIMAL_POWER.length - 1] = Double.MIN_VALUE;
        NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS[NumberUtils.NEGATIVE_DECIMAL_POWER_CHARS.length - 1] = "4.9E-324".toCharArray();
        long val = 1L;
        for (int i = 0; i < POW5_LONG_VALUES.length; ++i) {
            NumberUtils.POW5_LONG_VALUES[i] = val;
            val *= 5L;
        }
        BigInteger five = BigInteger.valueOf(5L);
        NumberUtils.POW5_BI_VALUES[0] = BigInteger.ONE;
        for (int i = 1; i < POW5_BI_VALUES.length; ++i) {
            BigInteger pow5Value;
            NumberUtils.POW5_BI_VALUES[i] = pow5Value = five.pow(i);
        }
        for (long d1 = 0L; d1 < 10L; ++d1) {
            for (long d2 = 0L; d2 < 10L; ++d2) {
                int intVal32;
                long intVal64;
                if (EnvUtils.BIG_ENDIAN) {
                    intVal64 = d1 + 48L << 16 | d2 + 48L;
                    intVal32 = (int)d1 + 48 << 8 | (int)d2 + 48;
                } else {
                    intVal64 = d2 + 48L << 16 | d1 + 48L;
                    intVal32 = (int)d2 + 48 << 8 | (int)d1 + 48;
                }
                int k = (int)(d1 * 10L + d2);
                NumberUtils.TWO_DIGITS_32_BITS[k] = (int)intVal64;
                NumberUtils.TWO_DIGITS_16_BITS[k] = (short)intVal32;
                for (long d3 = 0L; d3 < 10L; ++d3) {
                    for (long d4 = 0L; d4 < 10L; ++d4) {
                        int int32;
                        long int64;
                        if (EnvUtils.BIG_ENDIAN) {
                            int64 = intVal64 << 32 | d3 + 48L << 16 | d4 + 48L;
                            int32 = intVal32 << 16 | (int)d3 + 48 << 8 | (int)d4 + 48;
                        } else {
                            int64 = d4 + 48L << 48 | d3 + 48L << 32 | intVal64;
                            int32 = (int)d4 + 48 << 24 | (int)d3 + 48 << 16 | intVal32;
                        }
                        int index = (int)(d1 * 1000L + d2 * 100L + d3 * 10L + d4);
                        NumberUtils.FOUR_DIGITS_64_BITS[index] = int64;
                        NumberUtils.FOUR_DIGITS_32_BITS[index] = int32;
                    }
                }
            }
        }
        for (int b = 0; b < 256; ++b) {
            int b1 = b >> 4;
            int b2 = b & 0xF;
            NumberUtils.HEX_DIGITS_INT32[b] = EnvUtils.BIG_ENDIAN ? HEX_DIGITS[b1] << 16 | HEX_DIGITS[b2] : HEX_DIGITS[b2] << 16 | HEX_DIGITS[b1];
        }
    }
}

