/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.transaction;

import io.github.wycst.wast.common.annotation.AnnotationAspect;
import io.github.wycst.wast.common.annotation.AnnotationHandler;
import io.github.wycst.wast.jdbc.annotations.EnableTransaction;
import io.github.wycst.wast.jdbc.annotations.Transaction;
import io.github.wycst.wast.jdbc.connection.ConnectionWraperUtils;
import io.github.wycst.wast.jdbc.transaction.TransactionPoint;
import io.github.wycst.wast.jdbc.transaction.TransactionStatus;
import io.github.wycst.wast.jdbc.transaction.TransactionType;
import io.github.wycst.wast.jdbc.transaction.TransactionUtils;
import java.lang.annotation.Annotation;
import java.sql.SQLException;

@AnnotationAspect(aspectType=Transaction.class, enableControlType=EnableTransaction.class)
public class TransactionAnnotationHandler
implements AnnotationHandler<Transaction, TransactionPoint> {
    @Override
    public TransactionPoint beforeAnnotationHandle(Transaction annotation) {
        TransactionPoint transactionPoint = null;
        TransactionPoint currentTransactionPoint = TransactionUtils.currentTransactionPoint();
        TransactionType transactionType = annotation.value();
        if (currentTransactionPoint == null) {
            if (transactionType == TransactionType.NONE) {
                TransactionUtils.setTransactionActive(false);
                return null;
            }
            this.doReset();
            currentTransactionPoint = new TransactionPoint();
            currentTransactionPoint.setTop(true);
            currentTransactionPoint.setTransactionActive(true);
            TransactionUtils.bindTransactionPoint(currentTransactionPoint);
            transactionPoint = currentTransactionPoint;
            TransactionUtils.setTransactionActive(true);
        } else {
            boolean independent;
            boolean bl = independent = transactionType == TransactionType.NEW;
            if (independent) {
                transactionPoint = new TransactionPoint();
                transactionPoint.setParent(currentTransactionPoint);
                transactionPoint.setIndependent(true);
                transactionPoint.setTransactionActive(true);
                currentTransactionPoint.getConnectionWrapers().clear();
                currentTransactionPoint.getConnectionWrapers().putAll(ConnectionWraperUtils.getCurrentConnectionWrapers());
                ConnectionWraperUtils.reBindAll(null);
                TransactionUtils.setTransactionActive(true);
                TransactionUtils.bindTransactionPoint(transactionPoint);
            } else if (transactionType == TransactionType.NONE) {
                transactionPoint = new TransactionPoint();
                transactionPoint.setParent(currentTransactionPoint);
                currentTransactionPoint.getConnectionWrapers().clear();
                currentTransactionPoint.getConnectionWrapers().putAll(ConnectionWraperUtils.getCurrentConnectionWrapers());
                ConnectionWraperUtils.reBindAll(null);
                TransactionUtils.bindTransactionPoint(transactionPoint);
                TransactionUtils.setTransactionActive(false);
            } else {
                TransactionUtils.setTransactionActive(true);
            }
        }
        return transactionPoint;
    }

    @Override
    public void afterWithResult(Annotation annotation, TransactionPoint transactionPoint, Throwable err) {
        if (err != null) {
            TransactionPoint currentTransactionPoint = TransactionUtils.currentTransactionPoint();
            currentTransactionPoint.getTransactionStatus().setStatus(1);
            currentTransactionPoint.getTransactionStatus().addNestedException(err);
        }
        if (transactionPoint == null) {
            return;
        }
        if (transactionPoint.isTop()) {
            try {
                TransactionStatus currentTransactionStatus = transactionPoint.getTransactionStatus();
                this.handlerAllTransactions(currentTransactionStatus);
                this.doReset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            TransactionPoint parent;
            boolean independent = transactionPoint.isIndependent();
            if (independent) {
                try {
                    TransactionStatus currentTransactionStatus = transactionPoint.getTransactionStatus();
                    this.handlerAllTransactions(currentTransactionStatus);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((parent = transactionPoint.getParent()) != null) {
                TransactionUtils.bindTransactionPoint(parent);
                ConnectionWraperUtils.reBindAll(parent.getConnectionWrapers());
                TransactionUtils.setTransactionActive(parent.isTransactionActive());
            }
        }
    }

    private void handlerAllTransactions(TransactionStatus currentTransactionStatus) throws SQLException {
        if (currentTransactionStatus.getStatus() == 0) {
            ConnectionWraperUtils.commitAll();
        } else {
            ConnectionWraperUtils.rollbackAll();
        }
    }

    private void doReset() {
        TransactionUtils.doReset();
        ConnectionWraperUtils.doReset();
    }
}

