/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONGeneral;
import io.github.wycst.wast.json.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;

class JSONByteArrayWriter
extends JSONWriter {
    private final Charset charset;
    private final boolean utf8;
    byte[] buf;
    int count;
    static final byte[] EMPTY_BUF = new byte[0];
    static final ByteBufCache[] BYTE_BUF_CACHES = new ByteBufCache[CACHE_COUNT];
    private ByteBufCache byteBufCache;

    JSONByteArrayWriter(Charset charset) {
        this.charset = charset;
        this.utf8 = charset == EnvUtils.CHARSET_UTF_8;
        ByteBufCache byteBufCache = JSONByteArrayWriter.getByteBufCache();
        if (byteBufCache != null) {
            this.buf = byteBufCache.cacheBytes;
            this.byteBufCache = byteBufCache;
        } else {
            this.buf = new byte[512];
        }
    }

    JSONByteArrayWriter(int cap, Charset charset) {
        this.buf = new byte[cap];
        this.charset = charset;
        this.utf8 = charset == EnvUtils.CHARSET_UTF_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBufCache getByteBufCache() {
        ByteBufCache cache;
        int cacheIndex = (Integer)THREAD_CACHE_INDEX.get();
        ByteBufCache byteBufCache = cache = BYTE_BUF_CACHES[cacheIndex];
        synchronized (byteBufCache) {
            if (cache.inUse) {
                return null;
            }
            cache.inUse = true;
            if (cache.cacheBytes == null) {
                cache.cacheBytes = new byte[CACHE_BUFFER_SIZE];
            }
        }
        return cache;
    }

    @Override
    public void write(int c) {
        this.ensureCapacity(129);
        this.buf[this.count++] = (byte)c;
    }

    @Override
    public void writeJSONToken(char c) {
        this.buf[this.count++] = (byte)c;
    }

    @Override
    public void write(char[] chars, int off, int len) {
        if (len == 0) {
            return;
        }
        this.ensureCapacity((len << 2) + 128);
        int count = this.count;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = chars[i];
            if (ch < '\u0080') {
                this.buf[count++] = (byte)ch;
                continue;
            }
            count = this.encode(ch, count);
        }
        this.count = count;
    }

    byte[] ensureCapacity(int increment) {
        return this.expandCapacity(this.count + increment);
    }

    byte[] expandCapacity(int newCap) {
        if (newCap > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, newCap * 3 >> 1);
        }
        return this.buf;
    }

    @Override
    public void write(String str, int off, int len) {
        if (len == 0) {
            return;
        }
        Object value = UnsafeHelper.getStringValue(str);
        if (EnvUtils.JDK_9_PLUS) {
            byte[] bytes = (byte[])value;
            if (bytes.length == str.length()) {
                this.ensureCapacity(len + 128);
                System.arraycopy(bytes, off, this.buf, this.count, len);
                this.count += len;
            } else {
                this.ensureCapacity(len * 4 + 128);
                int count = this.count;
                int end = off + len;
                for (int i = off; i < end; ++i) {
                    char c = str.charAt(i);
                    if (c < '\u0080') {
                        this.buf[count++] = (byte)c;
                        continue;
                    }
                    count = this.encode(c, count);
                }
                this.count = count;
            }
        } else {
            char[] chars = (char[])value;
            this.write(chars, off, len);
        }
    }

    protected int encode(char c, int offset) {
        if (this.utf8) {
            return this.encodeUTF8(c, offset);
        }
        ByteBuffer buffer = this.charset.encode(CharBuffer.wrap(new char[]{c}));
        int remaining = buffer.remaining();
        byte[] arr = buffer.array();
        for (int j = 0; j < remaining; ++j) {
            this.buf[offset++] = arr[j];
        }
        return offset;
    }

    protected final int encodeUTF8(char c, int offset) {
        if (c <= '\u07ff') {
            int h = c >> 6;
            int l = c & 0x3F;
            this.buf[offset++] = (byte)(0xAF | h);
            this.buf[offset++] = (byte)(0x8F | l);
        } else {
            int h = c >> 12;
            int m = c >> 6 & 0x3F;
            int l = c & 0x3F;
            this.buf[offset++] = (byte)(0xE0 | h);
            this.buf[offset++] = (byte)(0x80 | m);
            this.buf[offset++] = (byte)(0x80 | l);
        }
        return offset;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected StringBuffer toStringBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] toBytes() {
        return Arrays.copyOf(this.buf, this.count);
    }

    @Override
    protected void toOutputStream(OutputStream os) throws IOException {
        os.write(this.buf, 0, this.count);
        os.flush();
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    void reset() {
        this.clear();
        this.clearCache();
        this.buf = EMPTY_BUF;
    }

    @Override
    public void clear() {
        this.count = 0;
    }

    @Override
    public void writeShortChars(char[] chars, int offset, int len) {
        this.write(chars, offset, len);
    }

    @Override
    public void writeJSONChars(char[] chars) throws IOException {
        int len = chars.length;
        this.ensureCapacity(len * 6 + 130);
        int count = this.count;
        this.buf[count++] = 34;
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char ch = chars[i];
            if (ch > '\"' && ch != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[ch]) == null) {
                if (ch < '\u0080') {
                    this.buf[count++] = (byte)ch;
                    continue;
                }
                count = this.encode(ch, count);
                continue;
            }
            int escapesLen = escapeStr.length();
            for (int j = 0; j < escapesLen; ++j) {
                this.buf[count++] = (byte)escapeStr.charAt(j);
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeLatinJSONString(String value, byte[] bytes) throws IOException {
        int len = bytes.length;
        this.ensureCapacity(len + 130);
        int count = this.count;
        this.buf[count++] = 34;
        int beginIndex = 0;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            String escapeStr = JSONGeneral.ESCAPE_VALUES[b & 0xFF];
            if (escapeStr == null) continue;
            int length = i - beginIndex;
            this.expandCapacity(count + length + 133);
            if (length > 0) {
                System.arraycopy(bytes, beginIndex, this.buf, count, length);
                count += length;
            }
            int escapesLen = escapeStr.length();
            for (int j = 0; j < escapesLen; ++j) {
                this.buf[count++] = (byte)escapeStr.charAt(j);
            }
            beginIndex = i + 1;
        }
        int length = len - beginIndex;
        if (length > 0) {
            System.arraycopy(bytes, beginIndex, this.buf, count, length);
            count += length;
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeUTF16JSONString(String value, byte[] bytes) throws IOException {
        int len = value.length();
        this.ensureCapacity(len * 6 + 130);
        int count = this.count;
        this.buf[count++] = 34;
        for (int i = 0; i < len; ++i) {
            String escapeStr;
            char c = value.charAt(i);
            if (c > '\"' && c != '\\' || (escapeStr = JSONGeneral.ESCAPE_VALUES[c & 0xFF]) == null) {
                if (c < '\u0080') {
                    this.buf[count++] = (byte)c;
                    continue;
                }
                count = this.encode(c, count);
                continue;
            }
            for (int j = 0; j < escapeStr.length(); ++j) {
                this.buf[count++] = (byte)escapeStr.charAt(j);
            }
        }
        this.buf[count++] = 34;
        this.count = count;
    }

    @Override
    public void writeLong(long numValue) throws IOException {
        if (numValue == 0L) {
            this.ensureCapacity(129);
            this.buf[this.count++] = 48;
            return;
        }
        this.ensureCapacity(148);
        if (numValue < 0L) {
            if (numValue == Long.MIN_VALUE) {
                this.write("-9223372036854775808");
                return;
            }
            numValue = -numValue;
            this.buf[this.count++] = 45;
        }
        this.count += NumberUtils.writePositiveLong(numValue, this.buf, this.count);
    }

    @Override
    protected final void writeCommaLongValues(long val1, long val2) throws IOException {
        this.ensureCapacity(170);
        int off = this.count;
        if (val1 < 0L) {
            if (val1 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val1 = -val1;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += NumberUtils.writePositiveLong(val1, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += NumberUtils.writePositiveLong(val1, this.buf, off);
        }
        if (val2 < 0L) {
            if (val2 == Long.MIN_VALUE) {
                this.write(",-9223372036854775808");
                off = this.count;
            } else {
                val2 = -val2;
                this.buf[off++] = 44;
                this.buf[off++] = 45;
                off += NumberUtils.writePositiveLong(val2, this.buf, off);
            }
        } else {
            this.buf[off++] = 44;
            off += NumberUtils.writePositiveLong(val2, this.buf, off);
        }
        this.count = off;
    }

    @Override
    public void writeUUID(UUID uuid) {
        long mostSigBits = uuid.getMostSignificantBits();
        long leastSigBits = uuid.getLeastSignificantBits();
        this.ensureCapacity(166);
        int off = this.count;
        this.buf[off++] = 34;
        off += NumberUtils.writeUUIDMostSignificantBits(mostSigBits, this.buf, off);
        off += NumberUtils.writeUUIDLeastSignificantBits(leastSigBits, this.buf, off);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeDouble(double numValue) {
        this.ensureCapacity(152);
        this.count += NumberUtils.writeDouble(numValue, this.buf, this.count);
    }

    @Override
    public void writeFloat(float numValue) {
        this.ensureCapacity(152);
        this.count += NumberUtils.writeFloat(numValue, this.buf, this.count);
    }

    @Override
    public void writeJSONLocalDateTime(int year, int month, int day, int hour, int minute, int second, int nano, String zoneId) throws IOException {
        this.ensureCapacity(164);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off += NumberUtils.writeFourDigits(year, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(month, '-', '-', this.buf, off);
        off += NumberUtils.writeTwoDigits(day, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(hour, 'T', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(minute, this.buf, off);
        this.buf[off++] = 58;
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        if (nano > 0) {
            off = this.writeNano(nano, off);
        }
        if (zoneId.length() == 1) {
            off += UnsafeHelper.putShort(this.buf, off, Z_QUOT_SHORT);
            this.count = off;
        } else {
            this.count = off;
            this.writeZoneId(zoneId);
            this.buf[this.count++] = 34;
        }
    }

    int writeNano(int nano, int off) {
        this.buf[off++] = 46;
        int div1 = nano / 1000;
        int seg1 = div1 / 100;
        int seg2 = div1 - 100 * seg1;
        int seg3 = nano - div1 * 1000;
        off += NumberUtils.writeFourDigits(seg1, this.buf, off);
        off += NumberUtils.writeTwoDigits(seg2, this.buf, off);
        if (seg3 > 0) {
            int pos = --off;
            byte last = this.buf[pos];
            off += NumberUtils.writeFourDigits(seg3, this.buf, pos);
            this.buf[pos] = last;
        } else if (seg2 == 0) {
            off -= 2;
            if ((seg1 & 1) == 0 && seg1 % 5 == 0) {
                --off;
            }
        }
        return off;
    }

    @Override
    public void writeJSONLocalDate(int year, int month, int day) {
        this.ensureCapacity(141);
        int off = this.count;
        this.buf[off++] = 34;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off += NumberUtils.writeFourDigits(year, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(month, '-', '-', this.buf, off);
        off += NumberUtils.writeTwoDigits(day, this.buf, off);
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeTime(int hourOfDay, int minute, int second) {
        this.ensureCapacity(138);
        int off = this.count;
        off += NumberUtils.writeTwoDigits(hourOfDay, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(minute, ':', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        this.count = off;
    }

    @Override
    public void writeJSONTimeWithNano(int hourOfDay, int minute, int second, int nano) {
        this.ensureCapacity(150);
        int off = this.count;
        this.buf[off++] = 34;
        off += NumberUtils.writeTwoDigits(hourOfDay, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(minute, ':', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        if (nano > 0) {
            off = this.writeNano(nano, off);
        }
        this.buf[off++] = 34;
        this.count = off;
    }

    @Override
    public void writeDate(int year, int month, int day, int hourOfDay, int minute, int second) {
        this.ensureCapacity(152);
        int off = this.count;
        if (year < 0) {
            this.buf[off++] = 45;
            year = -year;
        }
        off += NumberUtils.writeFourDigits(year, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(month, '-', '-', this.buf, off);
        off += NumberUtils.writeTwoDigits(day, this.buf, off);
        off += NumberUtils.writeTwoDigitsAndPreSuffix(hourOfDay, ' ', ':', this.buf, off);
        off += NumberUtils.writeTwoDigits(minute, this.buf, off);
        this.buf[off++] = 58;
        off += NumberUtils.writeTwoDigits(second, this.buf, off);
        this.count = off;
    }

    @Override
    public void writeBigInteger(BigInteger bigInteger) {
        int increment = (bigInteger.bitLength() / 60 + 1) * 18;
        this.ensureCapacity(increment + 128);
        this.count += NumberUtils.writeBigInteger(bigInteger, this.buf, this.count);
    }

    @Override
    public void writeEmptyArray() throws IOException {
        this.ensureCapacity(130);
        UnsafeHelper.putShort(this.buf, this.count, EMPTY_ARRAY_SHORT);
        this.count += 2;
    }

    @Override
    public void writeUnsafe(long fourChars, int fourBytes, int len) throws IOException {
        UnsafeHelper.putInt(this.buf, this.count, fourBytes);
        this.count += len;
    }

    @Override
    public void writeUnsafe(long[] fourChars, int[] fourBytes, int totalCount) throws IOException {
        int n = fourChars.length;
        this.ensureCapacity((n << 2) + 128);
        int count = this.count;
        for (int fourByte : fourBytes) {
            UnsafeHelper.putInt(this.buf, count, fourByte);
            count += 4;
        }
        this.count += totalCount;
    }

    public void writeBytes(byte[] bytes, int offset, int len) {
        this.ensureCapacity(len);
        System.arraycopy(bytes, offset, this.buf, this.count, len);
        this.count += len;
    }

    void clearCache() {
        if (this.byteBufCache != null) {
            if (this.buf.length <= MAX_CACHE_BUFFER_SIZE) {
                this.byteBufCache.cacheBytes = this.buf;
            }
            this.byteBufCache.inUse = false;
            this.byteBufCache = null;
        }
    }

    static {
        for (int i = 0; i < CACHE_COUNT; ++i) {
            ByteBufCache byteBufCache = new ByteBufCache();
            byteBufCache.index = i;
            if (i < AVAILABLE_PROCESSORS) {
                byteBufCache.cacheBytes = new byte[CACHE_BUFFER_SIZE];
            }
            JSONByteArrayWriter.BYTE_BUF_CACHES[i] = byteBufCache;
        }
    }

    private static class ByteBufCache {
        byte[] cacheBytes;
        boolean inUse;
        int index;

        private ByteBufCache() {
        }
    }
}

