/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.DateTemplate;
import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONCharArrayWriter;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONImplInstCreator;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.util.FixedNameValueMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

class JSONGeneral {
    static final char[] FORMAT_OUT_SYMBOL_TABS;
    static final char[] FORMAT_OUT_SYMBOL_SPACES;
    protected static final char[] NULL;
    protected static final char[] EMPTY_ARRAY;
    protected static final char[] EMPTY_OBJECT;
    protected static final int TRUE_INT;
    protected static final long TRUE_LONG;
    protected static final int ALSE_INT;
    protected static final long ALSE_LONG;
    protected static final byte ZERO = 0;
    protected static final byte COMMA = 44;
    protected static final byte DOUBLE_QUOTATION = 34;
    protected static final byte COLON_SIGN = 58;
    protected static final byte END_ARRAY = 93;
    protected static final byte END_OBJECT = 125;
    protected static final byte WHITE_SPACE = 32;
    protected static final byte ESCAPE = 92;
    static final int TYPE_BIGDECIMAL = 1;
    static final int TYPE_BIGINTEGER = 2;
    static final int TYPE_FLOAT = 3;
    static final int TYPE_DOUBLE = 4;
    static final String[] ESCAPE_VALUES;
    static final byte[] ESCAPE_FLAGS;
    static final String[] MONTH_ABBR;
    static final char[] DigitOnes;
    static final char[] DigitTens;
    static final int[] ESCAPE_CHARS;
    private static FixedNameValueMap<String> KEY_32_TABLE;
    private static FixedNameValueMap<String> KEY_EIGHT_BYTES_TABLE;
    public static final int DIRECT_READ_BUFFER_SIZE = 8192;
    static final Map<String, TimeZone> GMT_TIME_ZONE_MAP;
    public static final TimeZone ZERO_TIME_ZONE;
    static final ThreadLocal<char[]> CACHED_CHARS_24;
    static final ThreadLocal<char[]> CACHED_CHARS_DATE_21;
    static final ThreadLocal<double[]> DOUBLE_ARRAY_TL;
    static final ThreadLocal<long[]> LONG_ARRAY_TL;
    static final ThreadLocal<int[]> INT_ARRAY_TL;
    static final long[] EMPTY_LONGS;
    static final int[] EMPTY_INTS;
    static final double[] EMPTY_DOUBLES;
    static final String[] EMPTY_STRINGS;
    private static final Map<Class<?>, JSONImplInstCreator> DEFAULT_IMPL_INST_CREATOR_MAP;
    protected static final int COLLECTION_ARRAYLIST_TYPE = 1;
    protected static final int COLLECTION_HASHSET_TYPE = 2;
    protected static final int COLLECTION_OTHER_TYPE = 3;

    JSONGeneral() {
    }

    public static String toEscapeString(int ch) {
        return String.format("\\u%04x", ch);
    }

    public static final <T> void registerImplCreator(Class<? extends T> parentClass, JSONImplInstCreator<T> creator) {
        DEFAULT_IMPL_INST_CREATOR_MAP.put(parentClass, creator);
    }

    static final JSONImplInstCreator getJSONImplInstCreator(Class<?> targetClass) {
        return DEFAULT_IMPL_INST_CREATOR_MAP.get(targetClass);
    }

    static final String getCacheKey(char[] buf, int offset, int len, long hashCode) {
        if (len > 32) {
            return new String(buf, offset, len);
        }
        String value = KEY_32_TABLE.getValue(buf, offset, offset + len, hashCode);
        if (value == null) {
            value = new String(buf, offset, len);
            KEY_32_TABLE.putValue(value, hashCode, value);
        }
        return value;
    }

    static final String getCacheKey(byte[] bytes, int offset, int len, long hashCode) {
        if (len > 32) {
            return new String(bytes, offset, len);
        }
        String value = KEY_32_TABLE.getValueByHash(hashCode);
        if (value == null) {
            value = new String(bytes, offset, len);
            KEY_32_TABLE.putValue(value, hashCode, value);
        }
        return value;
    }

    static final String getCacheEightCharsKey(char[] buf, int offset, int len, long hashCode) {
        String value = KEY_EIGHT_BYTES_TABLE.getValueByHash(hashCode);
        if (value == null) {
            value = new String(buf, offset, len);
            KEY_EIGHT_BYTES_TABLE.putExactHashValue(hashCode, value);
        }
        return value;
    }

    static final String getCacheEightBytesKey(byte[] bytes, int offset, int len, long hashCode) {
        String value = KEY_EIGHT_BYTES_TABLE.getValueByHash(hashCode);
        if (value == null) {
            value = new String(bytes, offset, len);
            KEY_EIGHT_BYTES_TABLE.putExactHashValue(hashCode, value);
        }
        return value;
    }

    protected static double getDecimalPowerValue(int expValue) {
        return NumberUtils.getDecimalPowerValue(expValue);
    }

    protected static final int parseInt2(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt2(buf, fromIndex);
    }

    protected static final int parseInt4(char[] buf, int fromIndex) throws NumberFormatException {
        return NumberUtils.parseInt4(buf, fromIndex);
    }

    protected static final int escapeNext(char[] buf, char next, int i, int beginIndex, JSONCharArrayWriter writer, JSONParseContext jsonParseContext) {
        if (i > beginIndex) {
            writer.write(buf, beginIndex, i - beginIndex);
        }
        if (next < ESCAPE_CHARS.length) {
            int escapeChar = ESCAPE_CHARS[next];
            if (escapeChar > -1) {
                writer.write((char)escapeChar);
                beginIndex = ++i + 1;
            } else {
                int c = JSONGeneral.hex4(buf, i + 2);
                writer.write((char)c);
                i += 4;
                beginIndex = ++i + 1;
            }
        } else {
            writer.write(next);
            beginIndex = ++i + 1;
        }
        jsonParseContext.endIndex = i;
        return beginIndex;
    }

    static final int escape(byte[] bytes, byte next, int i, int beginIndex, JSONCharArrayWriter writer, JSONParseContext jsonParseContext) {
        switch (next) {
            case 34: 
            case 39: {
                if (i > beginIndex) {
                    writer.writeBytes(bytes, beginIndex, i - beginIndex + 1);
                    writer.setCharAt(writer.size() - 1, (char)next);
                } else {
                    writer.write((char)next);
                }
                beginIndex = ++i + 1;
                break;
            }
            case 110: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\n');
                beginIndex = ++i + 1;
                break;
            }
            case 114: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\r');
                beginIndex = ++i + 1;
                break;
            }
            case 116: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\t');
                beginIndex = ++i + 1;
                break;
            }
            case 98: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\b');
                beginIndex = ++i + 1;
                break;
            }
            case 102: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, '\f');
                beginIndex = ++i + 1;
                break;
            }
            case 117: {
                int c;
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                int j = i + 2;
                try {
                    int c1 = JSONGeneral.hex(bytes[j++]);
                    int c2 = JSONGeneral.hex(bytes[j++]);
                    int c3 = JSONGeneral.hex(bytes[j++]);
                    int c4 = JSONGeneral.hex(bytes[j++]);
                    c = c1 << 12 | c2 << 8 | c3 << 4 | c4;
                }
                catch (Throwable throwable) {
                    String errorContextTextAt = JSONGeneral.createErrorContextText(bytes, i + 1);
                    throw new JSONException("Syntax error, from pos " + (i + 1) + ", context text by '" + errorContextTextAt + "', " + throwable.getMessage());
                }
                writer.setCharAt(writer.size() - 1, (char)c);
                i += 4;
                beginIndex = ++i + 1;
                break;
            }
            default: {
                int len = i - beginIndex;
                writer.writeBytes(bytes, beginIndex, len + 1);
                writer.setCharAt(writer.size() - 1, (char)next);
                beginIndex = ++i + 1;
            }
        }
        jsonParseContext.endIndex = i;
        return beginIndex;
    }

    static final int escapeAscii(String source, byte[] bytes, byte next, int i, int beginIndex, JSONCharArrayWriter writer, JSONParseContext jsonParseContext) {
        if (i > beginIndex) {
            writer.write(source, beginIndex, i - beginIndex);
        }
        if (next == 117) {
            int c;
            int j = i + 2;
            try {
                int c1 = JSONGeneral.hex(bytes[j++]);
                int c2 = JSONGeneral.hex(bytes[j++]);
                int c3 = JSONGeneral.hex(bytes[j++]);
                int c4 = JSONGeneral.hex(bytes[j]);
                c = c1 << 12 | c2 << 8 | c3 << 4 | c4;
            }
            catch (Throwable throwable) {
                String errorContextTextAt = JSONGeneral.createErrorContextText(bytes, i + 1);
                throw new JSONException("Syntax error, from pos " + (i + 1) + ", context text by '" + errorContextTextAt + "', " + throwable.getMessage());
            }
            writer.write((char)c);
            i += 4;
            beginIndex = ++i + 1;
        } else if (next < ESCAPE_CHARS.length) {
            writer.write((char)ESCAPE_CHARS[next & 0xFF]);
            beginIndex = ++i + 1;
        } else {
            writer.write((char)next);
            beginIndex = ++i + 1;
        }
        jsonParseContext.endIndex = i;
        return beginIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String parseEscapeString(String str) {
        str.getClass();
        int beginIndex = str.indexOf(92);
        if (beginIndex == -1) {
            return str;
        }
        JSONParseContext jsonParseContext = new JSONParseContext();
        JSONCharArrayWriter writer = JSONGeneral.getContextWriter(jsonParseContext);
        try {
            char[] chars = JSONGeneral.getChars(str);
            char next = chars[beginIndex + 1];
            beginIndex = JSONGeneral.escapeNext(chars, next, beginIndex, 0, writer, jsonParseContext);
            int max = chars.length;
            for (int i = beginIndex + 1; i < max; ++i) {
                if (chars[i] != '\\') continue;
                next = chars[i + 1];
                beginIndex = JSONGeneral.escapeNext(chars, next, i, beginIndex, writer, jsonParseContext);
                i = jsonParseContext.endIndex;
            }
            writer.write(chars, beginIndex, max - beginIndex);
            String string = writer.toString();
            return string;
        }
        finally {
            jsonParseContext.clear();
        }
    }

    protected static final int hex4(int i1, int i2, int i3, int i4) {
        return JSONGeneral.hex(i1) << 12 | JSONGeneral.hex(i2) << 8 | JSONGeneral.hex(i3) << 4 | JSONGeneral.hex(i4);
    }

    protected static int hex(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return c - 48;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return c - 97 + 10;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return c - 65 + 10;
            }
        }
        throw new IllegalArgumentException("invalid character: '" + (char)c + "', expected character in '0123456789abcdef(ABCDEF)'");
    }

    protected static int hex4(char[] buf, int fromIndex) {
        int j = fromIndex;
        try {
            int c1 = JSONGeneral.hex(buf[j++]);
            int c2 = JSONGeneral.hex(buf[j++]);
            int c3 = JSONGeneral.hex(buf[j++]);
            int c4 = JSONGeneral.hex(buf[j++]);
            return c1 << 12 | c2 << 8 | c3 << 4 | c4;
        }
        catch (Throwable throwable) {
            String errorContextTextAt = JSONGeneral.createErrorContextText(buf, j - 1);
            throw new JSONException("Syntax error, from pos " + fromIndex + ", context text by '" + errorContextTextAt + "', " + throwable.getMessage());
        }
    }

    protected static int digitDecimal(int ch) {
        return NumberUtils.digitDecimal(ch);
    }

    protected static final boolean isDigit(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    static final java.util.Date matchDate(char[] buf, int from, int to, String timezone, Class<? extends java.util.Date> dateCls) {
        int len = to - from;
        String timezoneIdAt = timezone;
        if (len > 19) {
            char ch;
            int j = to;
            while (j > from && (ch = buf[--j]) != '.' && ch != ' ') {
                if (ch != '+' && ch != '-' && ch != 'Z') continue;
                timezoneIdAt = new String(buf, j, to - j);
                to = j;
                len = to - from;
                break;
            }
        }
        switch (len) {
            case 8: {
                int month;
                int year3;
                try {
                    if (dateCls != null && Time.class.isAssignableFrom(dateCls)) {
                        int hour = JSONGeneral.parseInt2(buf, from);
                        int minute = JSONGeneral.parseInt2(buf, from + 3);
                        int second = JSONGeneral.parseInt2(buf, from + 6);
                        return JSONGeneral.parseDate(1970, 1, 1, hour, minute, second, 0, timezoneIdAt, dateCls);
                    }
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year2) {
                    return null;
                }
            }
            case 10: {
                int month;
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year3) {
                    return null;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int month;
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 4);
                    int day = JSONGeneral.parseInt2(buf, from + 6);
                    int hour = JSONGeneral.parseInt2(buf, from + 8);
                    int minute = JSONGeneral.parseInt2(buf, from + 10);
                    int second = JSONGeneral.parseInt2(buf, from + 12);
                    int millsecond = 0;
                    if (len > 14) {
                        millsecond = NumberUtils.parseIntWithin5(buf, from + 14, len - 14);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                int month;
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from);
                    month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    int millsecond = 0;
                    if (len > 20) {
                        millsecond = NumberUtils.parseIntWithin5(buf, from + 20, len - 20);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 28: {
                int year3;
                try {
                    year3 = JSONGeneral.parseInt4(buf, from + 24);
                    String monthAbbr = new String(buf, from + 4, 3);
                    int month = JSONGeneral.getMonthAbbrIndex(monthAbbr) + 1;
                    int day = JSONGeneral.parseInt2(buf, from + 8);
                    int hour = JSONGeneral.parseInt2(buf, from + 11);
                    int minute = JSONGeneral.parseInt2(buf, from + 14);
                    int second = JSONGeneral.parseInt2(buf, from + 17);
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
        return null;
    }

    protected static Object parseDateValueOfString(char[] buf, int from, int to, String pattern, int patternType, DateTemplate dateTemplate, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        String timezoneIdAt = timezone;
        try {
            switch (patternType) {
                case 1: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 6);
                    int day = JSONGeneral.parseInt2(buf, from + 9);
                    int hour = JSONGeneral.parseInt2(buf, from + 12);
                    int minute = JSONGeneral.parseInt2(buf, from + 15);
                    int second = JSONGeneral.parseInt2(buf, from + 18);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 2: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 6);
                    int day = JSONGeneral.parseInt2(buf, from + 9);
                    return JSONGeneral.parseDate(year, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                case 3: {
                    int year = JSONGeneral.parseInt4(buf, from + 1);
                    int month = JSONGeneral.parseInt2(buf, from + 5);
                    int day = JSONGeneral.parseInt2(buf, from + 7);
                    int hour = JSONGeneral.parseInt2(buf, from + 9);
                    int minute = JSONGeneral.parseInt2(buf, from + 11);
                    int second = JSONGeneral.parseInt2(buf, from + 13);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 4: {
                    TimeZone timeZone = JSONGeneral.getTimeZone(timezoneIdAt);
                    long time = dateTemplate.parseTime(buf, from + 1, to - from - 2, timeZone);
                    return JSONGeneral.parseDate(time, dateCls);
                }
            }
            return JSONGeneral.matchDate(buf, from + 1, to - 1, timezone, dateCls);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            String dateSource = new String(buf, from + 1, to - from - 2);
            if (patternType > 0) {
                throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch date pattern '" + pattern + "'");
            }
            throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch any date format.");
        }
    }

    static final java.util.Date matchDate(byte[] buf, int from, int to, String timezone, Class<? extends java.util.Date> dateCls) {
        int len = to - from;
        String timezoneIdAt = timezone;
        if (len > 19) {
            byte ch;
            int j = to;
            while (j > from && (ch = buf[--j]) != 46 && ch != 32) {
                if (ch != 43 && ch != 45 && ch != 90) continue;
                timezoneIdAt = new String(buf, j, to - j);
                to = j;
                len = to - from;
                break;
            }
        }
        switch (len) {
            case 8: {
                int month;
                int year3;
                try {
                    if (dateCls != null && Time.class.isAssignableFrom(dateCls)) {
                        int hour = NumberUtils.parseInt2(buf, from);
                        int minute = NumberUtils.parseInt2(buf, from + 3);
                        int second = NumberUtils.parseInt2(buf, from + 6);
                        return JSONGeneral.parseDate(1970, 1, 1, hour, minute, second, 0, timezoneIdAt, dateCls);
                    }
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 4);
                    int day = NumberUtils.parseInt2(buf, from + 6);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year2) {
                    return null;
                }
            }
            case 10: {
                int month;
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 5);
                    int day = NumberUtils.parseInt2(buf, from + 8);
                    return JSONGeneral.parseDate(year3, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable year3) {
                    return null;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int month;
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 4);
                    int day = NumberUtils.parseInt2(buf, from + 6);
                    int hour = NumberUtils.parseInt2(buf, from + 8);
                    int minute = NumberUtils.parseInt2(buf, from + 10);
                    int second = NumberUtils.parseInt2(buf, from + 12);
                    int millsecond = 0;
                    if (len > 14) {
                        millsecond = NumberUtils.parseIntWithin5(buf, from + 14, len - 14);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                int month;
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from);
                    month = NumberUtils.parseInt2(buf, from + 5);
                    int day = NumberUtils.parseInt2(buf, from + 8);
                    int hour = NumberUtils.parseInt2(buf, from + 11);
                    int minute = NumberUtils.parseInt2(buf, from + 14);
                    int second = NumberUtils.parseInt2(buf, from + 17);
                    int millsecond = 0;
                    if (len > 20) {
                        millsecond = NumberUtils.parseIntWithin5(buf, from + 20, len - 20);
                    }
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, millsecond, timezoneIdAt, dateCls);
                }
                catch (Throwable year) {
                    return null;
                }
            }
            case 28: {
                int year3;
                try {
                    year3 = NumberUtils.parseInt4(buf, from + 24);
                    String monthAbbr = new String(buf, from + 4, 3);
                    int month = JSONGeneral.getMonthAbbrIndex(monthAbbr) + 1;
                    int day = NumberUtils.parseInt2(buf, from + 8);
                    int hour = NumberUtils.parseInt2(buf, from + 11);
                    int minute = NumberUtils.parseInt2(buf, from + 14);
                    int second = NumberUtils.parseInt2(buf, from + 17);
                    return JSONGeneral.parseDate(year3, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
        return null;
    }

    protected static Object parseDateValueOfString(byte[] bytes, int from, int to, String pattern, int patternType, DateTemplate dateTemplate, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        String timezoneIdAt = timezone;
        try {
            switch (patternType) {
                case 0: {
                    return JSONGeneral.matchDate(bytes, from + 1, to - 1, timezone, dateCls);
                }
                case 1: {
                    int year = NumberUtils.parseInt4(bytes, from + 1);
                    int month = NumberUtils.parseInt2(bytes, from + 6);
                    int day = NumberUtils.parseInt2(bytes, from + 9);
                    int hour = NumberUtils.parseInt2(bytes, from + 12);
                    int minute = NumberUtils.parseInt2(bytes, from + 15);
                    int second = NumberUtils.parseInt2(bytes, from + 18);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
                case 2: {
                    int year = NumberUtils.parseInt4(bytes, from + 1);
                    int month = NumberUtils.parseInt2(bytes, from + 6);
                    int day = NumberUtils.parseInt2(bytes, from + 9);
                    return JSONGeneral.parseDate(year, month, day, 0, 0, 0, 0, timezoneIdAt, dateCls);
                }
                case 3: {
                    int year = NumberUtils.parseInt4(bytes, from + 1);
                    int month = NumberUtils.parseInt2(bytes, from + 5);
                    int day = NumberUtils.parseInt2(bytes, from + 7);
                    int hour = NumberUtils.parseInt2(bytes, from + 9);
                    int minute = NumberUtils.parseInt2(bytes, from + 11);
                    int second = NumberUtils.parseInt2(bytes, from + 13);
                    return JSONGeneral.parseDate(year, month, day, hour, minute, second, 0, timezoneIdAt, dateCls);
                }
            }
            TimeZone timeZone = JSONGeneral.getTimeZone(timezoneIdAt);
            long time = dateTemplate.parseTime(bytes, from + 1, to - from - 2, timeZone);
            return JSONGeneral.parseDate(time, dateCls);
        }
        catch (Throwable throwable) {
            if (throwable instanceof JSONException) {
                throw (JSONException)throwable;
            }
            String dateSource = new String(bytes, from + 1, to - from - 2);
            if (patternType > 0) {
                throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch date pattern '" + pattern + "'");
            }
            throw new JSONException("Syntax error, at pos " + realFrom + ", dateStr " + dateSource + " mismatch any date format.");
        }
    }

    protected static Object parseDateValue(int from, int to, char[] buf, String pattern, String timezone, Class<? extends java.util.Date> dateCls) {
        int realFrom = from;
        int realTo = to;
        int start = 34;
        while (from < to && (start = buf[from]) <= 32) {
            ++from;
        }
        int end = 34;
        while (to > from && (end = buf[to - 1]) <= 32) {
            --to;
        }
        if (start == 34 && end == 34) {
            return JSONGeneral.parseDateValueOfString(buf, from, to, pattern, pattern == null ? 0 : 4, pattern == null ? null : new DateTemplate(pattern), timezone, dateCls);
        }
        try {
            long timestamp = Long.parseLong(new String(buf, from, to - from));
            return JSONGeneral.parseDate(timestamp, dateCls);
        }
        catch (Exception e) {
            String timestampStr = new String(buf, from, to - from);
            throw new JSONException("fromIndex " + realFrom + ", toIndex " + realTo + " str " + timestampStr + " error !");
        }
    }

    protected static final int clearCommentAndWhiteSpaces(char[] buf, int beginIndex, int toIndex, JSONParseContext jsonParseContext) {
        int i = beginIndex;
        if (i >= toIndex) {
            throw new JSONException("Syntax error, unexpected '/', position " + (beginIndex - 1));
        }
        char ch = buf[beginIndex];
        if (ch == '/') {
            while (i < toIndex && buf[i] != '\n') {
                ++i;
            }
            ch = '\u0000';
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            }
        } else if (ch == '*') {
            char prev = '\u0000';
            boolean matched = false;
            while (i + 1 < toIndex) {
                if ((ch = buf[++i]) == '/' && prev == '*') {
                    matched = true;
                    break;
                }
                prev = ch;
            }
            if (!matched) {
                throw new JSONException("Syntax error, not found the close comment '*/' util the end ");
            }
            ch = '\u0000';
            while (i + 1 < toIndex && (ch = buf[++i]) <= ' ') {
            }
            if (ch == '/') {
                i = JSONGeneral.clearCommentAndWhiteSpaces(buf, i + 1, toIndex, jsonParseContext);
            }
        } else {
            throw new JSONException("Syntax error, unexpected '" + ch + "', position " + beginIndex);
        }
        return i;
    }

    protected static int clearCommentAndWhiteSpaces(byte[] bytes, int beginIndex, int toIndex, JSONParseContext jsonParseContext) {
        int i = beginIndex;
        if (i >= toIndex) {
            throw new JSONException("Syntax error, unexpected '/', position " + (beginIndex - 1));
        }
        byte b = bytes[beginIndex];
        if (b == 47) {
            while (i < toIndex && bytes[i] != 10) {
                ++i;
            }
            b = 0;
            while (i + 1 < toIndex && (b = bytes[++i]) <= 32) {
            }
            if (b == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
            }
        } else if (b == 42) {
            byte prev = 0;
            boolean matched = false;
            while (i + 1 < toIndex) {
                if ((b = bytes[++i]) == 47 && prev == 42) {
                    matched = true;
                    break;
                }
                prev = b;
            }
            if (!matched) {
                throw new JSONException("Syntax error, not found the close comment '*/' util the end ");
            }
            b = 0;
            while (i + 1 < toIndex && (b = bytes[++i]) <= 32) {
            }
            if (b == 47) {
                i = JSONGeneral.clearCommentAndWhiteSpaces(bytes, i + 1, toIndex, jsonParseContext);
            }
        } else {
            throw new JSONException("Syntax error, unexpected '" + (char)b + "', position " + beginIndex);
        }
        return i;
    }

    protected static final void writeFormatOutSymbols(JSONWriter content, int level, boolean formatOut, JSONConfig jsonConfig) throws IOException {
        block8: {
            if (!formatOut || level <= -1) break block8;
            boolean formatIndentUseSpace = jsonConfig.isFormatIndentUseSpace();
            if (formatIndentUseSpace) {
                int totalSpaceNum;
                content.write(10);
                if (level == 0) {
                    return;
                }
                int symbolSpaceNum = FORMAT_OUT_SYMBOL_SPACES.length;
                for (totalSpaceNum = level * jsonConfig.getFormatIndentSpaceNum(); totalSpaceNum >= symbolSpaceNum; totalSpaceNum -= symbolSpaceNum) {
                    content.write(FORMAT_OUT_SYMBOL_SPACES);
                }
                while (totalSpaceNum-- > 0) {
                    content.write(32);
                }
            } else {
                char[] symbol = FORMAT_OUT_SYMBOL_TABS;
                int symbolLen = 11;
                if (symbolLen - 1 > level) {
                    content.write(symbol, 0, level + 1);
                } else {
                    content.write(symbol);
                    int appendTabLen = level - symbolLen + 1;
                    while (appendTabLen-- > 0) {
                        content.write(9);
                    }
                }
            }
        }
    }

    private static int getMonthAbbrIndex(String monthAbbr) {
        int len = MONTH_ABBR.length;
        for (int i = 0; i < len; ++i) {
            if (!MONTH_ABBR[i].equals(monthAbbr)) continue;
            return i;
        }
        return -1;
    }

    private static java.util.Date parseDate(int year, int month, int day, int hour, int minute, int second, int millsecond, String timeZoneId, Class<? extends java.util.Date> dateCls) {
        TimeZone timeZone = JSONGeneral.getTimeZone(timeZoneId);
        long timeInMillis = GregorianDate.getTime(year, month, day, hour, minute, second, millsecond, timeZone);
        return JSONGeneral.parseDate(timeInMillis, dateCls);
    }

    static TimeZone getTimeZone(String timeZoneId) {
        if (timeZoneId != null && timeZoneId.trim().length() > 0) {
            TimeZone timeZone;
            if (GMT_TIME_ZONE_MAP.containsKey(timeZoneId)) {
                timeZone = GMT_TIME_ZONE_MAP.get(timeZoneId);
            } else {
                timeZone = timeZoneId.startsWith("GMT") ? TimeZone.getTimeZone(timeZoneId) : TimeZone.getTimeZone("GMT" + timeZoneId);
                if (timeZone != null && timeZone.getRawOffset() != 0) {
                    GMT_TIME_ZONE_MAP.put(timeZoneId, timeZone);
                }
            }
            return timeZone;
        }
        return UnsafeHelper.getDefaultTimeZone();
    }

    protected static java.util.Date parseDate(long timeInMillis, Class<? extends java.util.Date> dateCls) {
        if (dateCls == java.util.Date.class) {
            return new java.util.Date(timeInMillis);
        }
        if (dateCls == Date.class) {
            return new Date(timeInMillis);
        }
        if (dateCls == Timestamp.class) {
            return new Timestamp(timeInMillis);
        }
        try {
            Constructor<? extends java.util.Date> constructor = dateCls.getConstructor(Long.TYPE);
            UnsafeHelper.setAccessible(constructor);
            return constructor.newInstance(timeInMillis);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static final Serializable parseKeyOfMap(char[] buf, int from, int to, boolean isUnquotedFieldName) {
        if (isUnquotedFieldName) {
            while (from < to && buf[from] <= ' ') {
                ++from;
            }
            while (to > from && buf[to - 1] <= ' ') {
                --to;
            }
            int count = to - from;
            if (count == 4) {
                if (buf[from] == 'n' && buf[from + 1] == 'u' && buf[from + 2] == 'l' && buf[from + 3] == 'l') {
                    return null;
                }
                if (buf[from] == 't' && buf[from + 1] == 'r' && buf[from + 2] == 'u' && buf[from + 3] == 'e') {
                    return Boolean.valueOf(true);
                }
            }
            if (count == 5 && buf[from] == 'f' && buf[from + 1] == 'a' && buf[from + 2] == 'l' && buf[from + 3] == 's' && buf[from + 4] == 'e') {
                return Boolean.valueOf(false);
            }
            boolean numberFlag = true;
            int pointFlag = 0;
            for (int i = from; i < to; ++i) {
                char c = buf[i];
                if (c == '.') {
                    ++pointFlag;
                    continue;
                }
                if (i == from && c == '-' || JSONGeneral.isDigit(c)) continue;
                numberFlag = false;
                break;
            }
            String result = new String(buf, from, count);
            if (numberFlag && pointFlag <= 1) {
                if (pointFlag == 1) {
                    return Double.valueOf(Double.parseDouble(result));
                }
                long val = Long.parseLong(result);
                if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                    return Integer.valueOf((int)val);
                }
                return Long.valueOf(val);
            }
            return result;
        }
        int len = to - from - 2;
        return new String(buf, from + 1, len);
    }

    static final Serializable parseKeyOfMap(byte[] buf, int from, int to, boolean isUnquotedFieldName) {
        if (isUnquotedFieldName) {
            while (from < to && buf[from] <= 32) {
                ++from;
            }
            while (to > from && buf[to - 1] <= 32) {
                --to;
            }
            int count = to - from;
            if (count == 4) {
                if (buf[from] == 110 && buf[from + 1] == 117 && buf[from + 2] == 108 && buf[from + 3] == 108) {
                    return null;
                }
                if (buf[from] == 116 && buf[from + 1] == 114 && buf[from + 2] == 117 && buf[from + 3] == 101) {
                    return Boolean.valueOf(true);
                }
            }
            if (count == 5 && buf[from] == 102 && buf[from + 1] == 97 && buf[from + 2] == 108 && buf[from + 3] == 115 && buf[from + 4] == 101) {
                return Boolean.valueOf(false);
            }
            boolean numberFlag = true;
            int pointFlag = 0;
            for (int i = from; i < to; ++i) {
                byte c = buf[i];
                if (c == 46) {
                    ++pointFlag;
                    continue;
                }
                if (i == from && c == 45 || JSONGeneral.isDigit(c)) continue;
                numberFlag = false;
                break;
            }
            String result = new String(buf, from, count);
            if (numberFlag && pointFlag <= 1) {
                if (pointFlag == 1) {
                    return Double.valueOf(Double.parseDouble(result));
                }
                long val = Long.parseLong(result);
                if (val <= Integer.MAX_VALUE && val >= Integer.MIN_VALUE) {
                    return Integer.valueOf((int)val);
                }
                return Long.valueOf(val);
            }
            return result;
        }
        int len = to - from - 2;
        return new String(buf, from + 1, len);
    }

    protected static String printHexString(byte[] b, char splitChar) {
        StringBuilder returnValue = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            returnValue.append(hex.toUpperCase());
            if (splitChar <= '\u0000') continue;
            returnValue.append(splitChar);
        }
        return returnValue.toString();
    }

    protected static byte[] hexString2Bytes(char[] chars, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase(chars[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        byte[] buffer = new byte[byteLength];
        System.arraycopy(bytes, 0, buffer, 0, byteLength);
        return buffer;
    }

    protected static byte[] hexString2Bytes(byte[] buf, int offset, int len) {
        byte[] bytes = new byte[len / 2];
        int byteLength = 0;
        int b = -1;
        int count = offset + len;
        for (int i = offset; i < count; ++i) {
            int numIndex;
            char ch = Character.toUpperCase((char)buf[i]);
            int n = numIndex = ch > '9' ? ch - 55 : ch - 48;
            if (numIndex < 0 || numIndex >= 16) continue;
            if (b == -1) {
                b = numIndex << 4;
                continue;
            }
            bytes[byteLength++] = (byte)(b += numIndex);
            b = -1;
        }
        if (byteLength == bytes.length) {
            return bytes;
        }
        byte[] buffer = new byte[byteLength];
        System.arraycopy(bytes, 0, buffer, 0, byteLength);
        return buffer;
    }

    protected static char[] readInputStream(InputStream is, int maxLen) throws IOException {
        try {
            char[] buf = new char[maxLen];
            InputStreamReader streamReader = new InputStreamReader(is);
            int len = streamReader.read(buf);
            streamReader.close();
            if (len != maxLen) {
                char[] tmp = new char[len];
                System.arraycopy(buf, 0, tmp, 0, len);
                buf = tmp;
            }
            char[] cArray = buf;
            return cArray;
        }
        catch (RuntimeException rx) {
            throw rx;
        }
        finally {
            is.close();
        }
    }

    protected static void handleCatchException(Throwable ex, char[] buf, int toIndex) {
        if (ex instanceof IndexOutOfBoundsException) {
            String errorContextTextAt = JSONGeneral.createErrorContextText(buf, toIndex);
            throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.", ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }

    protected static void handleCatchException(Throwable ex, byte[] bytes, int toIndex) {
        if (ex instanceof IndexOutOfBoundsException) {
            String errorContextTextAt = JSONGeneral.createErrorContextText(bytes, toIndex);
            throw new JSONException("Syntax error, context text by '" + errorContextTextAt + "', JSON format error, and the end token may be missing, such as '\"' or ', ' or '}' or ']'.", ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }

    protected static int getPatternType(String pattern) {
        if (pattern != null) {
            if (pattern.equalsIgnoreCase("yyyy-MM-dd HH:mm:ss") || pattern.equalsIgnoreCase("yyyy/MM/dd HH:mm:ss") || pattern.equalsIgnoreCase("yyyy-MM-ddTHH:mm:ss")) {
                return 1;
            }
            if (pattern.equalsIgnoreCase("yyyy-MM-dd") || pattern.equalsIgnoreCase("yyyy/MM/dd")) {
                return 2;
            }
            if (pattern.equalsIgnoreCase("yyyyMMddHHmmss")) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    protected static Object collectionToArray(Collection<Object> collection, Class<?> componentType) {
        return UnsafeHelper.toArray(collection, componentType);
    }

    protected static final int getCollectionType(Class<?> actualType) {
        if (actualType == List.class || actualType == ArrayList.class || actualType.isAssignableFrom(ArrayList.class)) {
            return 1;
        }
        if (actualType == Set.class || actualType == HashSet.class || actualType.isAssignableFrom(HashSet.class)) {
            return 2;
        }
        return 3;
    }

    protected static final Collection createCollectionInstance(Class<?> collectionCls) {
        if (collectionCls.isInterface()) {
            if (collectionCls == List.class || collectionCls == Collection.class) {
                return new ArrayList();
            }
            if (collectionCls == Set.class) {
                return new HashSet();
            }
            throw new UnsupportedOperationException("Unsupported for collection type '" + collectionCls + "', Please specify an implementation class");
        }
        if (collectionCls == ArrayList.class || collectionCls == Object.class) {
            return new HashSet();
        }
        if (collectionCls == HashSet.class) {
            return new HashSet();
        }
        if (collectionCls == Vector.class) {
            return new Vector();
        }
        try {
            return (Collection)collectionCls.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("create Collection instance error, class " + collectionCls);
        }
    }

    static Map createMapInstance(GenericParameterizedType genericParameterizedType) {
        Class<?> mapCls = genericParameterizedType.getActualType();
        Map map = JSONGeneral.createCommonMapInstance(mapCls);
        if (map != null) {
            return map;
        }
        JSONImplInstCreator implInstCreator = JSONGeneral.getJSONImplInstCreator(mapCls);
        if (implInstCreator != null) {
            return (Map)implInstCreator.create(genericParameterizedType);
        }
        try {
            return (Map)UnsafeHelper.newInstance(mapCls);
        }
        catch (Exception e) {
            throw new JSONException("create map error for " + mapCls);
        }
    }

    static Map createMapInstance(Class<? extends Map> mapCls) {
        Map map = JSONGeneral.createCommonMapInstance(mapCls);
        if (map != null) {
            return map;
        }
        try {
            return (Map)UnsafeHelper.newInstance(mapCls);
        }
        catch (Exception e) {
            throw new JSONException("create map error for " + mapCls);
        }
    }

    static Map createCommonMapInstance(Class<? extends Map> mapCls) {
        if (mapCls == Map.class || mapCls == null || mapCls == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (mapCls == HashMap.class) {
            return new HashMap();
        }
        if (mapCls == Hashtable.class) {
            return new Hashtable();
        }
        if (mapCls == AbstractMap.class) {
            return new LinkedHashMap();
        }
        if (mapCls == TreeMap.class || mapCls == SortedMap.class) {
            return new TreeMap();
        }
        return null;
    }

    protected static String createErrorContextText(char[] buf, int at) {
        try {
            int len = buf.length;
            char[] text = new char[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(buf, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(buf, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    protected static String createErrorContextText(byte[] bytes, int at) {
        try {
            int len = bytes.length;
            byte[] text = new byte[40];
            int begin = Math.max(at - 18, 0);
            int count = at - begin;
            System.arraycopy(bytes, begin, text, 0, count);
            text[count++] = 94;
            int end = Math.min(len, at + 18);
            System.arraycopy(bytes, at, text, count, end - at);
            return new String(text, 0, count += end - at);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    protected static final JSONCharArrayWriter getContextWriter(JSONParseContext jsonParseContext) {
        JSONCharArrayWriter jsonWriter = jsonParseContext.getContextWriter();
        if (jsonWriter == null) {
            jsonWriter = new JSONCharArrayWriter();
            jsonParseContext.setContextWriter(jsonWriter);
        }
        return jsonWriter;
    }

    protected static final char[] getChars(String value) {
        return UnsafeHelper.getChars(value);
    }

    protected static final Object getStringValue(String value) {
        return UnsafeHelper.getStringValue(value);
    }

    static {
        String[] availableIDs;
        int i;
        FORMAT_OUT_SYMBOL_TABS = "\n\t\t\t\t\t\t\t\t\t\t".toCharArray();
        FORMAT_OUT_SYMBOL_SPACES = new char[32];
        Arrays.fill(FORMAT_OUT_SYMBOL_SPACES, ' ');
        NULL = new char[]{'n', 'u', 'l', 'l'};
        EMPTY_ARRAY = new char[]{'[', ']'};
        EMPTY_OBJECT = new char[]{'{', '}'};
        TRUE_INT = UnsafeHelper.getInt(new byte[]{116, 114, 117, 101}, 0);
        TRUE_LONG = UnsafeHelper.getLong(new char[]{'t', 'r', 'u', 'e'}, 0);
        ALSE_INT = UnsafeHelper.getInt(new byte[]{97, 108, 115, 101}, 0);
        ALSE_LONG = UnsafeHelper.getLong(new char[]{'a', 'l', 's', 'e'}, 0);
        ESCAPE_VALUES = new String[256];
        ESCAPE_FLAGS = new byte[256];
        MONTH_ABBR = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        DigitOnes = NumberUtils.copyDigitOnes();
        DigitTens = NumberUtils.copyDigitTens();
        ESCAPE_CHARS = new int[160];
        KEY_32_TABLE = new FixedNameValueMap(4096);
        KEY_EIGHT_BYTES_TABLE = new FixedNameValueMap(2048);
        for (i = 0; i < 160; ++i) {
            JSONGeneral.ESCAPE_CHARS[i] = i;
        }
        JSONGeneral.ESCAPE_CHARS[110] = 10;
        JSONGeneral.ESCAPE_CHARS[114] = 13;
        JSONGeneral.ESCAPE_CHARS[116] = 9;
        JSONGeneral.ESCAPE_CHARS[98] = 8;
        JSONGeneral.ESCAPE_CHARS[102] = 12;
        JSONGeneral.ESCAPE_CHARS[117] = -1;
        GMT_TIME_ZONE_MAP = new ConcurrentHashMap<String, TimeZone>();
        ZERO_TIME_ZONE = TimeZone.getTimeZone("GMT+00:00");
        CACHED_CHARS_24 = new ThreadLocal<char[]>(){

            @Override
            protected char[] initialValue() {
                return new char[24];
            }
        };
        CACHED_CHARS_DATE_21 = new ThreadLocal<char[]>(){

            @Override
            protected char[] initialValue() {
                char[] chars = new char[21];
                chars[20] = 34;
                chars[0] = 34;
                chars[8] = 45;
                chars[5] = 45;
                chars[11] = 32;
                chars[17] = 58;
                chars[14] = 58;
                return chars;
            }
        };
        DOUBLE_ARRAY_TL = new ThreadLocal<double[]>(){

            @Override
            protected double[] initialValue() {
                return new double[32];
            }
        };
        LONG_ARRAY_TL = new ThreadLocal<long[]>(){

            @Override
            protected long[] initialValue() {
                return new long[32];
            }
        };
        INT_ARRAY_TL = new ThreadLocal<int[]>(){

            @Override
            protected int[] initialValue() {
                return new int[32];
            }
        };
        EMPTY_LONGS = new long[0];
        EMPTY_INTS = new int[0];
        EMPTY_DOUBLES = new double[0];
        EMPTY_STRINGS = new String[0];
        DEFAULT_IMPL_INST_CREATOR_MAP = new HashMap();
        for (i = 0; i < ESCAPE_VALUES.length; ++i) {
            switch (i) {
                case 10: {
                    JSONGeneral.ESCAPE_VALUES[i] = "\\n";
                    break;
                }
                case 9: {
                    JSONGeneral.ESCAPE_VALUES[i] = "\\t";
                    break;
                }
                case 13: {
                    JSONGeneral.ESCAPE_VALUES[i] = "\\r";
                    break;
                }
                case 8: {
                    JSONGeneral.ESCAPE_VALUES[i] = "\\b";
                    break;
                }
                case 12: {
                    JSONGeneral.ESCAPE_VALUES[i] = "\\f";
                    break;
                }
                case 34: {
                    JSONGeneral.ESCAPE_VALUES[i] = "\\\"";
                    break;
                }
                case 92: {
                    JSONGeneral.ESCAPE_VALUES[i] = "\\\\";
                    break;
                }
                default: {
                    if (i >= 32) break;
                    JSONGeneral.ESCAPE_VALUES[i] = JSONGeneral.toEscapeString(i);
                }
            }
            if (i >= 32 && i != 34 && i != 92) continue;
            JSONGeneral.ESCAPE_FLAGS[i] = 1;
        }
        for (String availableID : availableIDs = TimeZone.getAvailableIDs()) {
            GMT_TIME_ZONE_MAP.put(availableID, TimeZone.getTimeZone(availableID));
        }
        TimeZone timeZone = ZERO_TIME_ZONE;
        GMT_TIME_ZONE_MAP.put("GMT+00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("+00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("-00:00", timeZone);
        GMT_TIME_ZONE_MAP.put("+0", timeZone);
        GMT_TIME_ZONE_MAP.put("-0", timeZone);
        timeZone = TimeZone.getTimeZone("GMT+08:00");
        GMT_TIME_ZONE_MAP.put("+08:00", timeZone);
        GMT_TIME_ZONE_MAP.put("GMT+08:00", timeZone);
        JSONGeneral.registerImplCreator(EnumSet.class, new JSONImplInstCreator<EnumSet>(){

            @Override
            public EnumSet create(GenericParameterizedType<EnumSet> parameterizedType) {
                Class<?> actualType = parameterizedType.getValueType().getActualType();
                return EnumSet.noneOf(actualType);
            }
        });
        JSONGeneral.registerImplCreator(EnumMap.class, new JSONImplInstCreator<EnumMap>(){

            @Override
            public EnumMap create(GenericParameterizedType<EnumMap> parameterizedType) {
                Class<?> mapKeyClass = parameterizedType.getMapKeyClass();
                return new EnumMap(mapKeyClass);
            }
        });
    }
}

