/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.reflect.GetterInfo;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.EnvUtils;
import io.github.wycst.wast.json.JSONConfig;
import io.github.wycst.wast.json.JSONTypeSerializer;
import io.github.wycst.wast.json.JSONWriter;
import io.github.wycst.wast.json.annotations.JsonProperty;
import io.github.wycst.wast.json.annotations.JsonSerialize;
import io.github.wycst.wast.json.custom.JsonSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JSONPojoFieldSerializer
extends JSONTypeSerializer {
    private final GetterInfo getterInfo;
    private final JsonProperty jsonProperty;
    final String name;
    private final ReflectConsts.ClassCategory classCategory;
    private JSONTypeSerializer serializer;
    private char[] fieldNameTokenChars;
    private String fieldNameToken;
    private int fieldNameTokenOffset;
    private long[] fieldNameTokenLongs;
    private int[] fieldNameTokenInts;
    private static final Map<Class<? extends JsonSerializer>, JsonSerializer> customSerializers = new HashMap<Class<? extends JsonSerializer>, JsonSerializer>();

    JSONPojoFieldSerializer(GetterInfo getterInfo, String name) {
        JsonProperty jsonProperty;
        this.getterInfo = getterInfo;
        this.classCategory = getterInfo.getClassCategory();
        this.name = name;
        this.jsonProperty = jsonProperty = (JsonProperty)getterInfo.getAnnotation(JsonProperty.class);
        this.setFieldNameToken();
    }

    void initSerializer() {
        if (this.serializer == null) {
            this.serializer = this.createSerializer();
        }
    }

    private JSONTypeSerializer createSerializer() {
        Class<?> returnType;
        JsonSerialize jsonSerialize = (JsonSerialize)this.getterInfo.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null) {
            Class<? extends JsonSerializer> jsonSerializerClass = jsonSerialize.value();
            try {
                if (jsonSerialize.singleton()) {
                    JsonSerializer jsonSerializer = customSerializers.get(jsonSerializerClass);
                    if (jsonSerializer == null) {
                        jsonSerializer = jsonSerializerClass.newInstance();
                        customSerializers.put(jsonSerializerClass, jsonSerializer);
                    }
                    return jsonSerializer;
                }
                return jsonSerializerClass.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if ((returnType = this.getterInfo.getReturnType()) == String.class) {
            return CHAR_SEQUENCE_STRING;
        }
        if (this.classCategory == ReflectConsts.ClassCategory.NumberCategory) {
            return JSONTypeSerializer.getTypeSerializer(returnType);
        }
        return JSONTypeSerializer.getFieldTypeSerializer(this.classCategory, returnType, this.jsonProperty);
    }

    private void setFieldNameToken() {
        int len = this.name.length();
        this.fieldNameTokenChars = new char[len + 7];
        int i = 0;
        this.fieldNameTokenChars[i++] = 34;
        this.name.getChars(0, len, this.fieldNameTokenChars, i);
        this.fieldNameTokenChars[len + 1] = 34;
        this.fieldNameTokenChars[len + 2] = 58;
        this.fieldNameTokenOffset = len + 3;
        this.fieldNameTokenChars[len + 3] = 110;
        this.fieldNameTokenChars[len + 4] = 117;
        this.fieldNameTokenChars[len + 5] = 108;
        this.fieldNameTokenChars[len + 6] = 108;
        if (EnvUtils.JDK_9_PLUS) {
            this.fieldNameToken = new String(this.fieldNameTokenChars);
        }
        if (this.name.getBytes().length == len) {
            String stringForUnsafe = new String(this.fieldNameTokenChars, 0, this.fieldNameTokenOffset);
            this.fieldNameTokenLongs = UnsafeHelper.getLongs(stringForUnsafe);
            this.fieldNameTokenInts = UnsafeHelper.getInts(stringForUnsafe);
        }
    }

    public GetterInfo getGetterInfo() {
        return this.getterInfo;
    }

    public Object invoke(Object pojo) {
        return this.getterInfo.invoke(pojo);
    }

    public void writeJSONFieldName(JSONWriter writer) throws IOException {
        if (this.fieldNameTokenLongs != null) {
            writer.writeUnsafe(this.fieldNameTokenLongs, this.fieldNameTokenInts, this.fieldNameTokenOffset);
        } else if (this.fieldNameToken != null) {
            writer.writeFieldString(this.fieldNameToken, 0, this.fieldNameTokenOffset);
        } else {
            writer.writeShortChars(this.fieldNameTokenChars, 0, this.fieldNameTokenOffset);
        }
    }

    public void writeJSONFieldNameWithNull(JSONWriter writer) throws IOException {
        if (this.fieldNameToken != null) {
            writer.write(this.fieldNameToken, 0, this.fieldNameTokenChars.length);
        } else {
            writer.writeShortChars(this.fieldNameTokenChars, 0, this.fieldNameTokenChars.length);
        }
    }

    public JSONTypeSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    protected void serialize(Object value, JSONWriter writer, JSONConfig jsonConfig, int indent) throws Exception {
    }

    public String getName() {
        return this.name;
    }

    public JsonProperty getJsonProperty() {
        return this.jsonProperty;
    }
}

