/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json;

import io.github.wycst.wast.common.beans.CharSource;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.util.FixedNameValueMap;
import java.util.Map;

class JSONValueMatcher<T> {
    protected final FixedNameValueMap<T> valueMapForChars;
    protected final FixedNameValueMap<T> valueMapForBytes;

    JSONValueMatcher(FixedNameValueMap valueMapForChars, FixedNameValueMap valueMapForBytes) {
        this.valueMapForChars = valueMapForChars;
        this.valueMapForBytes = valueMapForBytes;
    }

    public T matchValue(CharSource source, char[] buf, int offset, int endToken, JSONParseContext parseContext) {
        int i = offset;
        T result = null;
        char ch = buf[i];
        if (ch != endToken) {
            char ch1;
            long hashValue = ch;
            if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                hashValue = this.valueMapForChars.hash(hashValue, ch, ch1);
                if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                    hashValue = this.valueMapForChars.hash(hashValue, ch, ch1);
                    while ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                        hashValue = this.valueMapForChars.hash(hashValue, ch, ch1);
                    }
                }
            }
            if (ch != endToken) {
                hashValue = this.valueMapForChars.hash(hashValue, ch);
            }
            result = this.valueMapForChars.getValue(buf, offset, i, hashValue);
        }
        parseContext.endIndex = i;
        return result;
    }

    public T matchValue(CharSource source, byte[] buf, int offset, int endToken, JSONParseContext parseContext) {
        int i = offset;
        T result = null;
        byte b = buf[i];
        if (b != endToken) {
            byte b1;
            long hashValue = b;
            if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                hashValue = this.valueMapForBytes.hash(hashValue, b, b1);
                if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                    hashValue = this.valueMapForBytes.hash(hashValue, b, b1);
                    while ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                        hashValue = this.valueMapForBytes.hash(hashValue, b, b1);
                    }
                }
            }
            if (b != endToken) {
                hashValue = this.valueMapForBytes.hash(hashValue, b);
            }
            result = this.valueMapForBytes.getValue(buf, offset, i, hashValue);
        }
        parseContext.endIndex = i;
        return result;
    }

    public final long hash(long r, int v) {
        return this.valueMapForChars.hash(r, v);
    }

    public final long hash(long r, int v1, int v2) {
        return this.valueMapForChars.hash(r, v1, v2);
    }

    protected T getValue(char[] buf, int beginIndex, int endIndex, long hashValue) {
        return this.valueMapForChars.getValue(buf, beginIndex, endIndex, hashValue);
    }

    protected T getValue(byte[] buf, int beginIndex, int endIndex, long hashValue) {
        return this.valueMapForBytes.getValue(buf, beginIndex, endIndex, hashValue);
    }

    public final T getValue(String fieldName) {
        return this.valueMapForChars.getValue(fieldName);
    }

    static <T> JSONValueMatcher<T> build(FixedNameValueMap valueMapForChars, FixedNameValueMap valueMapForBytes) {
        return new JSONValueMatcher<T>(valueMapForChars, valueMapForBytes);
    }

    public static <T> JSONValueMatcher<T> build(Map<String, T> originalMap) {
        int valueSize = originalMap.size();
        String[] names = originalMap.keySet().toArray(new String[valueSize]);
        FixedNameValueMap<T> valueMapForChars = FixedNameValueMap.build(originalMap);
        boolean isAsciiKeys = JSONValueMatcher.checkAsciiKeys(names);
        if (isAsciiKeys) {
            if (valueMapForChars.isPlusHash()) {
                return new JSONPlusHashValueQuickMatcher<T>(valueMapForChars);
            }
            if (valueMapForChars.isBitHash()) {
                return new JSONBitHashValueQuickMatcher<T>(valueMapForChars, valueMapForChars.getBits());
            }
            if (!valueMapForChars.isCollision()) {
                return new JSONPrimeHashValueQuickMatcher<T>(valueMapForChars, valueMapForChars.getPrimeValue());
            }
        }
        FixedNameValueMap<T> valueMapForBytes = isAsciiKeys ? valueMapForChars : FixedNameValueMap.build(originalMap, true);
        return JSONValueMatcher.build(valueMapForChars, valueMapForBytes);
    }

    private static boolean checkAsciiKeys(String[] keys) {
        for (String key : keys) {
            int keyLength = key.length();
            for (int i = 0; i < keyLength; ++i) {
                if (key.charAt(i) < '\u0080') continue;
                return false;
            }
        }
        return true;
    }

    static class JSONPrimeHashValueQuickMatcher<T>
    extends JSONValueMatcher<T> {
        private final int primeValue;
        private final int primeSquare;

        public <T> JSONPrimeHashValueQuickMatcher(FixedNameValueMap<T> valueMap, int primeValue) {
            super(valueMap, valueMap);
            this.primeValue = primeValue;
            this.primeSquare = primeValue * primeValue;
        }

        @Override
        public final T matchValue(CharSource source, char[] buf, int offset, int endToken, JSONParseContext parseContext) {
            int i = offset;
            T result = null;
            char ch = buf[i];
            if (ch != endToken) {
                char ch1;
                long hashValue = ch;
                if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                    hashValue = hashValue * (long)this.primeSquare + (long)(ch * this.primeValue) + (long)ch1;
                    if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                        hashValue = hashValue * (long)this.primeSquare + (long)(ch * this.primeValue) + (long)ch1;
                        while ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                            hashValue = hashValue * (long)this.primeSquare + (long)(ch * this.primeValue) + (long)ch1;
                        }
                    }
                }
                if (ch != endToken) {
                    hashValue = hashValue * (long)this.primeValue + (long)ch;
                }
                result = parseContext.strictMode ? this.valueMapForChars.getValue(buf, offset, i, hashValue) : this.valueMapForChars.getValueByHash(hashValue);
            }
            parseContext.endIndex = i;
            return result;
        }

        @Override
        public final T matchValue(CharSource source, byte[] buf, int offset, int endToken, JSONParseContext parseContext) {
            int i = offset;
            T result = null;
            byte b = buf[i];
            if (b != endToken) {
                byte b1;
                long hashValue = b;
                if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                    hashValue = hashValue * (long)this.primeSquare + (long)(b * this.primeValue) + (long)b1;
                    if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                        hashValue = hashValue * (long)this.primeSquare + (long)(b * this.primeValue) + (long)b1;
                        while ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                            hashValue = hashValue * (long)this.primeSquare + (long)(b * this.primeValue) + (long)b1;
                        }
                    }
                }
                if (b != endToken) {
                    hashValue = hashValue * (long)this.primeValue + (long)b;
                }
                result = parseContext.strictMode ? this.valueMapForBytes.getValue(buf, offset, i, hashValue) : this.valueMapForBytes.getValueByHash(hashValue);
            }
            parseContext.endIndex = i;
            return result;
        }
    }

    static class JSONBitHashValueQuickMatcher<T>
    extends JSONValueMatcher<T> {
        private final int bits;
        private final int bitsTwice;

        public <T> JSONBitHashValueQuickMatcher(FixedNameValueMap<T> valueMap, int bits) {
            super(valueMap, valueMap);
            this.bits = bits;
            this.bitsTwice = bits << 1;
        }

        @Override
        public final T matchValue(CharSource source, char[] buf, int offset, int endToken, JSONParseContext parseContext) {
            int i = offset;
            T result = null;
            char ch = buf[i];
            if (ch != endToken) {
                char ch1;
                long hashValue = ch;
                if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                    hashValue = (hashValue << this.bitsTwice) + (long)(ch << this.bits) + (long)ch1;
                    if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                        hashValue = (hashValue << this.bitsTwice) + (long)(ch << this.bits) + (long)ch1;
                        while ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                            hashValue = (hashValue << this.bitsTwice) + (long)(ch << this.bits) + (long)ch1;
                        }
                    }
                }
                if (ch != endToken) {
                    hashValue = (hashValue << this.bits) + (long)ch;
                }
                result = parseContext.strictMode ? this.valueMapForChars.getValue(buf, offset, i, hashValue) : this.valueMapForChars.getValueByHash(hashValue);
            }
            parseContext.endIndex = i;
            return result;
        }

        @Override
        public final T matchValue(CharSource source, byte[] buf, int offset, int endToken, JSONParseContext parseContext) {
            int i = offset;
            T result = null;
            byte b = buf[i];
            if (b != endToken) {
                byte b1;
                long hashValue = b;
                if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                    hashValue = (hashValue << this.bitsTwice) + (long)(b << this.bits) + (long)b1;
                    if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                        hashValue = (hashValue << this.bitsTwice) + (long)(b << this.bits) + (long)b1;
                        while ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                            hashValue = (hashValue << this.bitsTwice) + (long)(b << this.bits) + (long)b1;
                        }
                    }
                }
                if (b != endToken) {
                    hashValue = (hashValue << this.bits) + (long)b;
                }
                result = parseContext.strictMode ? this.valueMapForBytes.getValue(buf, offset, i, hashValue) : this.valueMapForBytes.getValueByHash(hashValue);
            }
            parseContext.endIndex = i;
            return result;
        }
    }

    static class JSONPlusHashValueQuickMatcher<T>
    extends JSONValueMatcher<T> {
        public <T> JSONPlusHashValueQuickMatcher(FixedNameValueMap<T> valueMapForChars) {
            super(valueMapForChars, valueMapForChars);
        }

        @Override
        public final T matchValue(CharSource source, char[] buf, int offset, int endToken, JSONParseContext parseContext) {
            int i = offset;
            T result = null;
            char ch = buf[i];
            if (ch != endToken) {
                char ch1;
                long hashValue = ch;
                if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                    hashValue += (long)(ch + ch1);
                    if ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                        hashValue += (long)(ch + ch1);
                        while ((ch = buf[++i]) != endToken && (ch1 = buf[++i]) != endToken) {
                            hashValue += (long)(ch + ch1);
                        }
                    }
                }
                if (ch != endToken) {
                    hashValue += (long)ch;
                }
                result = parseContext.strictMode ? this.valueMapForChars.getValue(buf, offset, i, hashValue) : this.valueMapForChars.getValueByHash(hashValue);
            }
            parseContext.endIndex = i;
            return result;
        }

        @Override
        public final T matchValue(CharSource source, byte[] buf, int offset, int endToken, JSONParseContext parseContext) {
            int i = offset;
            T result = null;
            byte b = buf[i];
            if (b != endToken) {
                byte b1;
                long hashValue = b;
                if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                    hashValue += (long)(b + b1);
                    if ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                        hashValue += (long)(b + b1);
                        while ((b = buf[++i]) != endToken && (b1 = buf[++i]) != endToken) {
                            hashValue += (long)(b + b1);
                        }
                    }
                }
                if (b != endToken) {
                    hashValue += (long)b;
                }
                result = parseContext.strictMode ? this.valueMapForBytes.getValue(buf, offset, i, hashValue) : this.valueMapForBytes.getValueByHash(hashValue);
            }
            parseContext.endIndex = i;
            return result;
        }
    }
}

