/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.LocalDate;

public class TemporalLocalDateDeserializer
extends JSONTemporalDeserializer {
    public TemporalLocalDateDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalDate.of(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay());
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        return LocalDate.of(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay());
    }

    @Override
    protected Object deserializeDefaultTemporal(char[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year = NumberUtils.parseInt4(buf, offset);
        int month = NumberUtils.parseInt2(buf, offset + 5);
        int day = NumberUtils.parseInt2(buf, offset + 8);
        if (buf[offset += 10] == endChar) {
            jsonParseContext.endIndex = offset;
            return LocalDate.of(year, month, day);
        }
        String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, offset);
        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', unexpected token '" + buf[offset] + "', expected '" + endChar + "'");
    }

    @Override
    protected Object deserializeDefaultTemporal(byte[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year;
        byte b4;
        byte b3;
        byte b2;
        int i = offset;
        byte b1 = buf[i];
        if (TemporalLocalDateDeserializer.isDigit(b1) && TemporalLocalDateDeserializer.isDigit(b2 = buf[++i]) && TemporalLocalDateDeserializer.isDigit(b3 = buf[++i]) && TemporalLocalDateDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
        } else if (b1 == 45 && TemporalLocalDateDeserializer.isDigit(b1 = buf[++i]) && TemporalLocalDateDeserializer.isDigit(b2 = buf[++i]) && TemporalLocalDateDeserializer.isDigit(b3 = buf[++i]) && TemporalLocalDateDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
            year = -year;
        } else {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, offset);
            throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        ++i;
        b1 = buf[++i];
        if (!TemporalLocalDateDeserializer.isDigit(b1)) {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, offset);
            throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        int month = b1 - 48;
        b1 = buf[++i];
        if (TemporalLocalDateDeserializer.isDigit(b1)) {
            month = (month << 3) + (month << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalLocalDateDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, offset);
            throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        int day = b1 - 48;
        b1 = buf[++i];
        if (TemporalLocalDateDeserializer.isDigit(b1)) {
            day = (day << 3) + (day << 1) + b1 - 48;
            b1 = buf[++i];
        }
        if (b1 == endChar) {
            jsonParseContext.endIndex = i;
            return LocalDate.of(year, month, day);
        }
        String errorContextTextAt = TemporalLocalDateDeserializer.createErrorContextText(buf, offset);
        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)buf[offset] + "', expected '" + endChar + "'");
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return LocalDate.parse(value);
    }
}

