/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.json.temporal;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.NumberUtils;
import io.github.wycst.wast.json.JSONParseContext;
import io.github.wycst.wast.json.JSONTemporalDeserializer;
import io.github.wycst.wast.json.exceptions.JSONException;
import io.github.wycst.wast.json.temporal.TemporalConfig;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class TemporalZonedDateTimeDeserializer
extends JSONTemporalDeserializer {
    private static TimeZone defaultTimezone = UnsafeHelper.getDefaultTimeZone();
    private static ZoneId defaultZoneId = defaultTimezone.toZoneId();
    static final ZoneId ZERO = ZoneId.of("Z");
    static final ZoneOffset DEFAULT_ZONE_OFFSET = (ZoneOffset)ZERO;
    private static Map<String, ZoneId> zoneIdMap = new ConcurrentHashMap<String, ZoneId>();

    public static Object defaultZoneId() throws Exception {
        TimeZone timeZone = UnsafeHelper.getDefaultTimeZone();
        if (timeZone == defaultTimezone) {
            return defaultZoneId;
        }
        defaultTimezone = timeZone;
        defaultZoneId = defaultTimezone.toZoneId();
        return defaultZoneId;
    }

    public static ZoneId ofZoneId(String zoneId) throws Exception {
        ZoneId value = zoneIdMap.get(zoneId);
        if (value == null) {
            value = ZoneId.of(zoneId);
            zoneIdMap.put(zoneId, value);
        }
        return value;
    }

    public TemporalZonedDateTimeDeserializer(TemporalConfig temporalConfig) {
        super(temporalConfig);
    }

    @Override
    protected void checkClass(GenericParameterizedType genericParameterizedType) {
    }

    @Override
    protected Object deserializeTemporal(char[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        char ch;
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != '.') {
            if (ch == '+' || ch == '-' || ch == 'Z') {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != '[' || buf[endIndex - 1] != ']') continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        Object zoneObject = zoneId == null ? this.getDefaultZoneId() : TemporalZonedDateTimeDeserializer.ofZoneId(zoneId);
        return this.ofTemporalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    @Override
    protected Object deserializeTemporal(byte[] buf, int fromIndex, int endIndex, JSONParseContext jsonParseContext) throws Exception {
        byte ch;
        String zoneId = null;
        int j = endIndex;
        while (j > fromIndex + 20 && (ch = buf[--j]) != 46) {
            if (ch == 43 || ch == 45 || ch == 90) {
                zoneId = new String(buf, j, endIndex - j);
                endIndex = j;
                break;
            }
            if (ch != 91 || buf[endIndex - 1] != 93) continue;
            zoneId = new String(buf, j + 1, endIndex - j - 2);
            endIndex = j;
            break;
        }
        GeneralDate generalDate = this.dateTemplate.parseGeneralDate(buf, fromIndex + 1, endIndex - fromIndex - 1, ZERO_TIME_ZONE);
        Object zoneObject = zoneId == null ? this.getDefaultZoneId() : TemporalZonedDateTimeDeserializer.ofZoneId(zoneId);
        return this.ofTemporalDateTime(generalDate.getYear(), generalDate.getMonth(), generalDate.getDay(), generalDate.getHourOfDay(), generalDate.getMinute(), generalDate.getSecond(), generalDate.getMillisecond() * 1000000, zoneObject);
    }

    @Override
    protected Object deserializeDefaultTemporal(char[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year = NumberUtils.parseInt4(buf, offset);
        int month = NumberUtils.parseInt2(buf, offset + 5);
        int day = NumberUtils.parseInt2(buf, offset + 8);
        int hour = NumberUtils.parseInt2(buf, offset + 11);
        int minute = NumberUtils.parseInt2(buf, offset + 14);
        int second = NumberUtils.parseInt2(buf, offset + 17);
        int nanoOfSecond = 0;
        char c = buf[offset += 19];
        if (c == '.') {
            int cnt = 9;
            while (TemporalZonedDateTimeDeserializer.isDigit(c = buf[++offset])) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        Object zoneObject = this.getDefaultZoneId();
        switch (c) {
            case 'Z': 
            case 'z': {
                zoneObject = ZERO;
                c = buf[++offset];
                break;
            }
            case '+': 
            case '-': {
                int zoneBeginOff = offset;
                while (TemporalZonedDateTimeDeserializer.isDigit(c = buf[++offset]) || c == ':') {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, offset, offset - zoneBeginOff));
                break;
            }
        }
        if (c == '[') {
            if (this.supportedZoneRegion()) {
                int zoneRegionOff = offset;
                while (buf[++offset] != ']') {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, zoneRegionOff + 1, offset - zoneRegionOff - 1));
                c = buf[++offset];
            } else {
                while (buf[++offset] != ']') {
                }
                c = buf[++offset];
            }
        }
        if (c == endChar) {
            jsonParseContext.endIndex = offset;
            return this.ofTemporalDateTime(year, month, day, hour, minute, second, nanoOfSecond, zoneObject);
        }
        String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, offset);
        throw new JSONException("Syntax error, at pos " + offset + ", context text by '" + errorContextTextAt + "', unexpected token '" + c + "', expected '" + endChar + "'");
    }

    @Override
    protected Object deserializeDefaultTemporal(byte[] buf, int offset, char endChar, JSONParseContext jsonParseContext) throws Exception {
        int year;
        byte b4;
        byte b3;
        byte b2;
        int i = offset;
        byte b1 = buf[i];
        if (TemporalZonedDateTimeDeserializer.isDigit(b1) && TemporalZonedDateTimeDeserializer.isDigit(b2 = buf[++i]) && TemporalZonedDateTimeDeserializer.isDigit(b3 = buf[++i]) && TemporalZonedDateTimeDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
        } else if (b1 == 45 && TemporalZonedDateTimeDeserializer.isDigit(b1 = buf[++i]) && TemporalZonedDateTimeDeserializer.isDigit(b2 = buf[++i]) && TemporalZonedDateTimeDeserializer.isDigit(b3 = buf[++i]) && TemporalZonedDateTimeDeserializer.isDigit(b4 = buf[++i])) {
            year = b1 * 1000 + b2 * 100 + b3 * 10 + b4 - 53328;
            year = -year;
        } else {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', year field error ");
        }
        ++i;
        b1 = buf[++i];
        if (!TemporalZonedDateTimeDeserializer.isDigit(b1)) {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', month field error ");
        }
        int month = b1 - 48;
        b1 = buf[++i];
        if (TemporalZonedDateTimeDeserializer.isDigit(b1)) {
            month = (month << 3) + (month << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalZonedDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', day field error ");
        }
        int day = b1 - 48;
        b1 = buf[++i];
        if (TemporalZonedDateTimeDeserializer.isDigit(b1)) {
            day = (day << 3) + (day << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalZonedDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', hour field error ");
        }
        int hour = b1 - 48;
        b1 = buf[++i];
        if (TemporalZonedDateTimeDeserializer.isDigit(b1)) {
            hour = (hour << 3) + (hour << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalZonedDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', minute field error ");
        }
        int minute = b1 - 48;
        b1 = buf[++i];
        if (TemporalZonedDateTimeDeserializer.isDigit(b1)) {
            minute = (minute << 3) + (minute << 1) + b1 - 48;
        }
        ++i;
        if (!TemporalZonedDateTimeDeserializer.isDigit(b1 = buf[++i])) {
            String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
            throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', second field error ");
        }
        int second = b1 - 48;
        b1 = buf[++i];
        if (TemporalZonedDateTimeDeserializer.isDigit(b1)) {
            second = (second << 3) + (second << 1) + b1 - 48;
            b1 = buf[++i];
        }
        int nanoOfSecond = 0;
        byte c = b1;
        if (c == 46) {
            boolean isDigitFlag;
            int cnt = 9;
            while ((isDigitFlag = TemporalZonedDateTimeDeserializer.isDigit(c = buf[++i])) && TemporalZonedDateTimeDeserializer.isDigit(b1 = buf[++i])) {
                cnt -= 2;
                nanoOfSecond = nanoOfSecond * 100 + c * 10 + b1 - 528;
            }
            if (isDigitFlag) {
                nanoOfSecond = (nanoOfSecond << 3) + (nanoOfSecond << 1) + c - 48;
                c = b1;
                --cnt;
            }
            if (cnt > 0) {
                nanoOfSecond *= NANO_OF_SECOND_PADDING[cnt];
            }
        }
        Object zoneObject = this.getDefaultZoneId();
        switch (c) {
            case 90: 
            case 122: {
                zoneObject = ZERO;
                c = buf[++i];
                break;
            }
            case 43: 
            case 45: {
                int zoneBeginOff = i;
                while (TemporalZonedDateTimeDeserializer.isDigit(c = buf[++i]) || c == 58) {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, i, i - zoneBeginOff));
                break;
            }
        }
        if (c == 91) {
            if (this.supportedZoneRegion()) {
                int zoneRegionOff = i;
                while (buf[++i] != 93) {
                }
                zoneObject = TemporalZonedDateTimeDeserializer.ofZoneId(new String(buf, zoneRegionOff + 1, i - zoneRegionOff - 1));
                c = buf[++i];
            } else {
                while (buf[++i] != 93) {
                }
                c = buf[++i];
            }
        }
        if (c == endChar) {
            jsonParseContext.endIndex = i;
            return this.ofTemporalDateTime(year, month, day, hour, minute, second, nanoOfSecond, zoneObject);
        }
        String errorContextTextAt = TemporalZonedDateTimeDeserializer.createErrorContextText(buf, i);
        throw new JSONException("Syntax error, at pos " + i + ", context text by '" + errorContextTextAt + "', unexpected token '" + (char)c + "', expected '" + endChar + "'");
    }

    protected boolean supportedZoneRegion() {
        return true;
    }

    protected Object getDefaultZoneId() throws Exception {
        return TemporalZonedDateTimeDeserializer.defaultZoneId();
    }

    protected Temporal ofTemporalDateTime(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, Object zone) throws Exception {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, (ZoneId)zone);
    }

    @Override
    protected Object valueOf(String value, Class<?> actualType) throws Exception {
        return ZonedDateTime.parse(value);
    }
}

