/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.log;

import io.github.wycst.wast.log.LoggerManagerHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log {
    private final String loggerName;
    private final Logger logger;

    Log(Class<?> nameClass) {
        this.loggerName = this.getLoggerName(nameClass);
        this.logger = Logger.getLogger(this.loggerName);
        this.logger.setLevel(Level.ALL);
        this.logger.setFilter(new LogFilter());
        this.logger.setUseParentHandlers(false);
    }

    void addHandler(Handler handler) {
        this.logger.addHandler(handler);
    }

    void removeHandler(Handler handler) {
        this.logger.removeHandler(handler);
    }

    private String getLoggerName(Class<?> nameClass) {
        String className = nameClass.getName();
        if (className.indexOf(46) == -1) {
            return className;
        }
        if (className.length() < 40) {
            return className;
        }
        return className.replaceAll("(\\w)\\w*[.]", "$1.");
    }

    public void debug(String msg, Object ... args) {
        this.log(Level.CONFIG, msg, args);
    }

    public void info(String msg, Object ... args) {
        this.log(Level.INFO, msg, args);
    }

    public void warn(String msg, Object ... args) {
        this.log(Level.WARNING, msg, args);
    }

    public void error(String msg, Object ... args) {
        this.log(Level.SEVERE, msg, args);
    }

    private void log(Level level, String msg, Object[] args) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(level, msg, args);
        }
    }

    public void error(String msg, Throwable throwable, Object ... args) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, msg);
            logRecord.setParameters(args);
            logRecord.setLoggerName(this.loggerName);
            logRecord.setThrown(throwable);
            this.logger.log(logRecord);
        }
    }

    void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    class LogFilter
    implements Filter {
        LogFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            Level level = record.getLevel();
            Level logLevel = LoggerManagerHandler.getLogLevel();
            return logLevel == null || level.intValue() >= logLevel.intValue();
        }
    }
}

