/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.impl;

import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

abstract class AbstractHttpClientResponse
implements HttpClientResponse {
    private final int status;
    private final String reasonPhrase;
    private final int contentLength;
    private byte[] content;

    public AbstractHttpClientResponse(int code, String reasonPhrase, InputStream is, int contentLength) {
        this.status = code;
        this.reasonPhrase = reasonPhrase;
        this.contentLength = contentLength;
        this.writeStreamToContent(is);
    }

    public AbstractHttpClientResponse(int code, String reasonPhrase, byte[] content) {
        this.status = code;
        this.reasonPhrase = reasonPhrase;
        this.content = content;
        this.contentLength = content == null ? -1 : content.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamToContent(InputStream is) {
        if (is != null) {
            try {
                if (this.contentLength > 0) {
                    byte[] buf = new byte[this.contentLength];
                    int len = is.read(buf);
                    this.content = len < this.contentLength ? Arrays.copyOf(buf, len) : buf;
                } else {
                    int len;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((len = is.read(buf)) > 0) {
                        os.write(buf, 0, len);
                    }
                    this.content = os.toByteArray();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean checkIfRead(ByteArrayOutputStream os) {
        if (this.contentLength == -1) {
            return true;
        }
        return os.size() < this.contentLength;
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public String reasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    public byte[] content() {
        return this.content;
    }

    @Override
    public int length() {
        return this.content == null ? -1 : this.content.length;
    }
}

