/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.provider.consul;

import io.github.wycst.wast.clients.http.definition.HttpClientConfig;
import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import io.github.wycst.wast.clients.http.provider.CloudServiceProvider;
import io.github.wycst.wast.clients.http.provider.FetchPropertiesCallback;
import io.github.wycst.wast.clients.http.provider.ServerZone;
import io.github.wycst.wast.clients.http.provider.consul.HealthServiceInstance;
import io.github.wycst.wast.clients.http.provider.consul.ServiceInfo;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.json.options.ReadOption;
import io.github.wycst.wast.log.Log;
import io.github.wycst.wast.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConsulServiceProvider
extends CloudServiceProvider {
    private static Log log = LogFactory.getLog(ConsulServiceProvider.class);
    private final String CLOUD_CONSUL_SERVER_ADDR_KEY = "cloud.consul.server_addr";
    private final String CLOUD_CONSUL_USERNAME_KEY = "cloud.consul.username";
    private final String CLOUD_CONSUL_PASSWORD_KEY = "cloud.consul.password";
    private final String CLOUD_CONSUL_ACL_ENABLED_KEY = "cloud.consul.acl.enabled";
    private final String CLOUD_CONSUL_ACL_TOKEN_KEY = "cloud.consul.acl.token";
    private final String CLOUD_CONSUL_INSTANCE_IP_KEY = "cloud.consul.instance.ip";
    private final String CLOUD_CONSUL_INSTANCE_SERVICE_NAME_KEY = "cloud.consul.instance.serviceName";
    private final String CLOUD_CONSUL_INSTANCE_SERVICE_PORT_KEY = "cloud.consul.instance.servicePort";
    private final String CLOUD_CONSUL_INSTANCE_NAMESPACE_ID_KEY = "cloud.consul.instance.namespaceId";
    private final String CLOUD_CONSUL_INSTANCE_HEALTH_CHECK_URI_KEY = "cloud.consul.instance.health-check-uri";
    private final String CLOUD_CONSUL_INSTANCE_CHECK_HEALTHY_INTERVAL_KEY = "cloud.consul.instance.checkHealthyInterval";
    private final String CLOUD_CONSUL_SERVER_CHECK_HEALTHY_INTERVAL_KEY = "cloud.consul.server.checkHealthyInterval";
    private final String CLOUD_CONSUL_INSTANCE_ENABLE_KEY = "cloud.consul.instance.enable";
    private String serverAddr;
    private String consulServerName;
    private String username;
    private String password;
    private boolean aclEnabled;
    private String aclToken;
    private String instanceIp;
    private String instanceServiceName;
    private String instancePort;
    private String instanceNamespaceId;
    private String serverContextPath;
    private String checkUri;
    private long serverCheckHealthyInterval;
    private boolean status;
    private boolean serverUp;

    public ConsulServiceProvider(Properties consulProperties, FetchPropertiesCallback fetchPropertiesCallback) {
        super(consulProperties, fetchPropertiesCallback);
    }

    public ConsulServiceProvider(FetchPropertiesCallback fetchPropertiesCallback) {
        this(null, fetchPropertiesCallback);
    }

    public ConsulServiceProvider(Properties consulProperties) {
        this(consulProperties, null);
    }

    @Override
    protected void initBase() {
        this.serverAddr = this.getProperty("cloud.consul.server_addr");
        if (this.serverAddr == null) {
            log.info("consul config '{}' is required ", "cloud.consul.server_addr");
            return;
        }
        this.enableClient = true;
        log.info("consul serverAddr {}", this.serverAddr);
        this.username = this.getProperty("cloud.consul.username");
        this.password = this.getProperty("cloud.consul.password");
        this.aclEnabled = "true".equals(this.getProperty("cloud.consul.acl.enabled"));
        if (this.aclEnabled) {
            this.aclToken = this.getProperty("cloud.consul.acl.token");
        }
        this.checkUri = this.getProperty("cloud.consul.instance.health-check-uri");
        if (this.checkUri == null) {
            this.checkUri = "/";
        } else {
            String string = this.checkUri = this.checkUri.startsWith("/") ? this.checkUri : "/" + this.checkUri;
        }
        if (this.serverAddr.indexOf(",") == -1) {
            this.consulServerName = this.serverAddr;
        } else {
            String[] servers = this.serverAddr.split(",");
            this.consulServerName = "consul-cluster";
            ServerZone serverZone = new ServerZone(this.consulServerName, servers, true);
            this.setHttpClientServiceProvider();
            this.registerServer(serverZone);
        }
    }

    @Override
    protected void initInstanceConfig() {
        this.instanceIp = this.getProperty("cloud.consul.instance.ip");
        this.instanceServiceName = this.getProperty("cloud.consul.instance.serviceName");
        this.instancePort = this.getProperty("cloud.consul.instance.servicePort");
        if (this.instancePort == null) {
            this.instancePort = this.getProperty("server.port");
        }
        this.serverContextPath = this.getProperty("server.context-path");
        this.instanceNamespaceId = this.getProperty("cloud.consul.instance.namespaceId");
        String instanceCheckHealthyInterval = this.getProperty("cloud.consul.instance.checkHealthyInterval");
        try {
            this.instanceCheckHealthyInterval = Long.parseLong(instanceCheckHealthyInterval.trim());
        }
        catch (Throwable throwable) {
            this.instanceCheckHealthyInterval = 30L;
        }
        String serverCheckHealthyInterval = this.getProperty("cloud.consul.server.checkHealthyInterval");
        try {
            this.serverCheckHealthyInterval = Long.parseLong(serverCheckHealthyInterval.trim());
        }
        catch (Throwable throwable) {
            this.serverCheckHealthyInterval = 15L;
        }
        String enable = this.getProperty("cloud.consul.instance.enable");
        this.instanceEnable = enable != null && !"false".equals(enable);
    }

    @Override
    protected void fetchClientConfig() {
    }

    @Override
    protected void fetchServiceInstanceList() {
        try {
            String serviceListUrl = String.format("http://%s/v1/catalog/services%s", this.consulServerName, this.aclEnabled ? "?token=" + this.aclToken : "");
            Map services = this.httpClient.get(serviceListUrl, Map.class);
            Set serverNames = services.keySet();
            HashSet<String> healthServerNames = new HashSet<String>();
            for (String serviceName : serverNames) {
                String instanceListUrl = String.format("http://%s/v1/health/service/%s?passing=true%s", this.consulServerName, serviceName, this.aclEnabled ? "&token=" + this.aclToken : "");
                HttpClientResponse clientResponse = this.httpClient.get(instanceListUrl);
                List healthServiceInstances = clientResponse.getEntity(GenericParameterizedType.collectionType(List.class, HealthServiceInstance.class), new ReadOption[0]);
                ArrayList<String> serviceUrls = new ArrayList<String>();
                if (healthServiceInstances == null || healthServiceInstances.size() <= 0) continue;
                for (HealthServiceInstance healthServiceInstance : healthServiceInstances) {
                    ServiceInfo service = healthServiceInstance.getService();
                    String ip = service.getAddress();
                    if (ip.isEmpty()) continue;
                    int port = service.getPort();
                    serviceUrls.add(ip + ":" + port);
                }
                if (serviceUrls.size() <= 0) continue;
                ServerZone serverZone = new ServerZone(serviceName, serviceUrls);
                this.registerServer(serverZone);
                healthServerNames.add(serviceName);
            }
            this.clearIfNotExist(healthServerNames);
        }
        catch (Throwable throwable) {
            log.debug("fetchServiceInstanceList error: {}", throwable.getMessage());
        }
    }

    @Override
    protected void registerInstance() {
        try {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("ID", this.instanceIp + ":" + this.instancePort);
            body.put("Name", this.instanceServiceName);
            body.put("Address", this.instanceIp);
            body.put("Port", Integer.parseInt(this.instancePort));
            body.put("Tags", Arrays.asList("version=1.0.0"));
            HashMap<String, String> check = new HashMap<String, String>();
            check.put("Interval", this.serverCheckHealthyInterval + "s");
            check.put("HTTP", String.format("http://%s:%s%s", this.instanceIp, this.instancePort, this.checkUri));
            body.put("Check", check);
            String targetUrl = String.format("http://%s/v1/agent/service/register%s", this.consulServerName, this.aclEnabled ? "?token=" + this.aclToken : "");
            HttpClientConfig clientConfig = new HttpClientConfig();
            clientConfig.setRequestBody(body, "application/json", true);
            this.httpClient.put(targetUrl, String.class, clientConfig);
            this.status = true;
        }
        catch (Throwable throwable) {
            log.debug("consul register fail - {}", new Object[0]);
            log.error(throwable.getMessage(), throwable, new Object[0]);
        }
    }

    @Override
    protected void doHealthyCheck() {
        try {
            if (this.serverUp && !this.status) {
                this.registerInstance();
            } else {
                String result = this.httpClient.get(String.format("http://%s/v1/status/leader", this.consulServerName), String.class);
                if (result != null) {
                    this.serverUp = true;
                }
            }
        }
        catch (Throwable throwable) {
            this.status = false;
            this.serverUp = false;
        }
    }

    @Override
    public void destroy() {
        this.deregister();
        super.destroy();
    }

    private void deregister() {
        if (this.status) {
            try {
                String serviceId = this.instanceIp + ":" + this.instancePort;
                this.httpClient.put(String.format("http://%s/v1/agent/service/deregister/%s%s", this.consulServerName, serviceId, this.aclEnabled ? "?token=" + this.aclToken : ""), String.class);
                log.debug("deregister success", new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

