/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.url;

import io.github.wycst.wast.clients.http.definition.HttpClientConfig;
import io.github.wycst.wast.clients.http.definition.HttpClientParameter;
import io.github.wycst.wast.clients.http.definition.HttpClientRequest;
import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import io.github.wycst.wast.clients.http.impl.HttpClientResponseImpl;
import io.github.wycst.wast.clients.http.provider.RequestServiceInstance;
import io.github.wycst.wast.clients.http.provider.ServiceInstance;
import io.github.wycst.wast.clients.http.url.AbstractUrlHttpClientExecutor;
import io.github.wycst.wast.json.JSON;
import io.github.wycst.wast.log.Log;
import io.github.wycst.wast.log.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public class UrlHttpClientExecutor
extends AbstractUrlHttpClientExecutor {
    private Log log = LogFactory.getLog(UrlHttpClientExecutor.class);

    @Override
    protected HttpClientResponse doExecuteRequest(HttpClientRequest httpRequest) throws Throwable {
        RequestServiceInstance requestServiceInstance = this.getRequestServiceInstance(httpRequest);
        try {
            return this.doExecuteRequestInstance(requestServiceInstance, httpRequest);
        }
        catch (Throwable throwable) {
            boolean keepAliveOnTimeout;
            ServiceInstance serviceInstance = requestServiceInstance.getServiceInstance();
            if (serviceInstance == null) {
                throw throwable;
            }
            boolean bl = keepAliveOnTimeout = this.isKeepAliveOnTimeout() || httpRequest.isKeepAliveOnTimeout();
            if (keepAliveOnTimeout && throwable instanceof SocketTimeoutException) {
                throw throwable;
            }
            serviceInstance.setAlive(false);
            return this.doExecuteRequest(httpRequest);
        }
    }

    private HttpClientResponse doExecuteRequestInstance(RequestServiceInstance requestServiceInstance, HttpClientRequest httpRequest) throws Throwable {
        URL instanceUrl = requestServiceInstance.getUrl();
        String method = httpRequest.getMethod();
        this.log.debug("{} {} ", method, instanceUrl);
        HttpClientConfig clientConfig = httpRequest.getHttpClientConfig();
        URL url = this.parseQueryUrl(instanceUrl, method, clientConfig);
        Proxy proxy = clientConfig.getProxy();
        HttpURLConnection httpConnection = null;
        httpConnection = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
        httpConnection.setRequestMethod(method);
        httpConnection.setConnectTimeout((int)clientConfig.getMaxConnectTimeout());
        httpConnection.setReadTimeout((int)clientConfig.getMaxReadTimeout());
        httpConnection.setUseCaches(clientConfig.isUseCaches());
        httpConnection.setInstanceFollowRedirects(clientConfig.isFollowRedirect());
        Map<String, Serializable> header = clientConfig.getHeaders();
        if (header != null) {
            for (Map.Entry<String, Serializable> entry : header.entrySet()) {
                httpConnection.setRequestProperty(entry.getKey().toLowerCase(), String.valueOf(entry.getValue()));
            }
        }
        httpConnection.setRequestProperty("content-type", clientConfig.getContentType());
        if ("POST".equals(method) || "PUT".equals(method)) {
            this.postRequestData(clientConfig, httpConnection);
        }
        int resCode = httpConnection.getResponseCode();
        int contentLength = httpConnection.getContentLength();
        String resContentType = httpConnection.getContentType();
        InputStream is = null;
        try {
            is = httpConnection.getErrorStream();
            if (is == null) {
                is = httpConnection.getInputStream();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        HttpClientResponseImpl clientResponse = new HttpClientResponseImpl(resCode, httpConnection.getResponseMessage(), is, contentLength);
        clientResponse.setContentType(resContentType);
        clientResponse.setHeaders(httpConnection.getHeaderFields());
        httpConnection.disconnect();
        return clientResponse;
    }

    private void postRequestData(HttpClientConfig clientConfig, HttpURLConnection httpConnection) throws IOException {
        byte[] postData = this.parsePostRequestData(clientConfig);
        httpConnection.setRequestProperty("content-length", String.valueOf(postData.length));
        httpConnection.setDoOutput(true);
        httpConnection.connect();
        DataOutputStream dataOutputStream = new DataOutputStream(httpConnection.getOutputStream());
        dataOutputStream.write(postData);
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    private byte[] parsePostRequestData(HttpClientConfig clientConfig) throws IOException {
        byte[] requestData = null;
        List<HttpClientParameter> clientParameters = clientConfig.getParameterList();
        boolean chunked = clientConfig.isChunked();
        boolean multipart = clientConfig.isMultipart();
        String boundary = clientConfig.getBoundary();
        if (multipart) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String formDataSeparator = "--" + boundary;
            byte[] lineSign = new byte[]{13, 10};
            StringBuilder builder = null;
            for (HttpClientParameter clientParameter : clientParameters) {
                baos.write(formDataSeparator.getBytes());
                baos.write(lineSign);
                String name = clientParameter.getName();
                String value = clientParameter.getValue();
                String itemContentType = clientParameter.getContentType();
                long contentLength = clientParameter.getContentLength();
                builder = new StringBuilder();
                if (clientParameter.isFileUpload()) {
                    builder.append("content-disposition: form-data; name=\"").append(name).append("\"; filename=\"").append(value).append("\"\r\n");
                    builder.append("content-transfer-encoding: binary").append("\r\n");
                } else {
                    builder.append("content-disposition: form-data; name=\"").append(name).append("\"\r\n");
                }
                builder.append("content-length: ").append(contentLength).append("\r\n");
                if (itemContentType != null && itemContentType.length() > 0) {
                    builder.append("content-type: ").append(itemContentType).append("\r\n");
                }
                builder.append("\r\n");
                baos.write(builder.toString().getBytes());
                clientParameter.writeContentTo(baos);
                baos.write(lineSign);
            }
            baos.write(("--" + boundary + "--").getBytes());
            baos.write(lineSign);
            requestData = baos.toByteArray();
        } else if (!chunked) {
            Object requestBody = clientConfig.getRequestBody();
            if (requestBody != null) {
                boolean applicationJson = clientConfig.isApplicationJson();
                if (applicationJson) {
                    String content = requestBody == null ? "" : JSON.toJsonString(requestBody);
                    return content.getBytes();
                }
                if (requestBody instanceof byte[]) {
                    return (byte[])requestBody;
                }
                return requestBody.toString().getBytes();
            }
            StringBuilder builder = new StringBuilder();
            int length = clientParameters.size();
            int i = 0;
            for (HttpClientParameter clientParameter : clientParameters) {
                builder.append(URLEncoder.encode(clientParameter.getName(), "UTF-8")).append('=').append(URLEncoder.encode(clientParameter.getValue(), "UTF-8"));
                if (i++ >= length - 1) continue;
                builder.append('&');
            }
            requestData = builder.toString().getBytes();
        }
        return requestData;
    }
}

