/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.GeneralDate;
import io.github.wycst.wast.common.beans.GregorianDate;
import io.github.wycst.wast.common.utils.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public final class DateTemplate {
    private final String pattern;
    private int yearIndex = -1;
    private int fullYearIndex = -1;
    private int monthIndex = -1;
    private int dayIndex = -1;
    private int hourIndex = -1;
    private int minuteIndex = -1;
    private int secondIndex = -1;
    private int millisecondIndex = -1;
    private final List<DateFieldIndex> fieldIndexs = new ArrayList<DateFieldIndex>();
    private static final String[] WEEK_DAYS = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    static final char[] DigitOnes = NumberUtils.copyDigitOnes();
    static final char[] DigitTens = NumberUtils.copyDigitTens();

    public DateTemplate(String template) {
        this.pattern = template = template.trim();
        int length = template.length();
        int count = 0;
        int lowerYearNum = 0;
        int j = 0;
        block10: for (int i = 0; i < length; ++i) {
            char ch = template.charAt(i);
            switch (ch) {
                case 'Y': {
                    if (this.fullYearIndex != -1) continue block10;
                    this.fullYearIndex = j++ + count;
                    count += 3;
                    continue block10;
                }
                case 'y': {
                    if (this.yearIndex == -1) {
                        this.yearIndex = j + count;
                        ++count;
                    } else {
                        ++j;
                    }
                    ++lowerYearNum;
                    continue block10;
                }
                case 'M': {
                    if (this.monthIndex != -1) continue block10;
                    this.monthIndex = j++ + count;
                    ++count;
                    continue block10;
                }
                case 'd': {
                    if (this.dayIndex != -1) continue block10;
                    this.dayIndex = j++ + count;
                    ++count;
                    continue block10;
                }
                case 'H': {
                    if (this.hourIndex != -1) continue block10;
                    this.hourIndex = j++ + count;
                    ++count;
                    continue block10;
                }
                case 'm': {
                    if (this.minuteIndex != -1) continue block10;
                    this.minuteIndex = j++ + count;
                    ++count;
                    continue block10;
                }
                case 's': {
                    if (this.secondIndex != -1) continue block10;
                    this.secondIndex = j++ + count;
                    ++count;
                    continue block10;
                }
                case 'S': {
                    if (this.millisecondIndex != -1) continue block10;
                    this.millisecondIndex = j++ + count;
                    count += 2;
                    continue block10;
                }
                default: {
                    ++j;
                }
            }
        }
        if (this.yearIndex > -1 && lowerYearNum > 2) {
            this.fullYearIndex = this.yearIndex;
        }
        if (this.fullYearIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(1, this.fullYearIndex, 4));
        } else if (this.yearIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(1, this.yearIndex, 2));
        }
        if (this.monthIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(2, this.monthIndex, 2));
        }
        if (this.dayIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(3, this.dayIndex, 2));
        }
        if (this.hourIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(4, this.hourIndex, 2));
        }
        if (this.minuteIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(5, this.minuteIndex, 2));
        }
        if (this.secondIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(6, this.secondIndex, 2));
        }
        if (this.millisecondIndex > -1) {
            this.fieldIndexs.add(new DateFieldIndex(7, this.millisecondIndex, 3));
        }
        Collections.sort(this.fieldIndexs);
    }

    public GeneralDate parseGeneralDate(char[] buf, int offset, int len, TimeZone timeZone) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        int factor = 0;
        int bufLength = offset + len;
        block9: for (DateFieldIndex fieldIndex : this.fieldIndexs) {
            switch (fieldIndex.field) {
                case 1: {
                    int yearLen = fieldIndex.len;
                    if (yearLen == 2) {
                        year = NumberUtils.parseInt2(buf, this.yearIndex + offset + factor);
                        year += new GregorianDate().getYear() / 100 * 100;
                        continue block9;
                    }
                    year = NumberUtils.parseInt4(buf, this.fullYearIndex + offset + factor);
                    continue block9;
                }
                case 2: {
                    int monOffset = this.monthIndex + offset + factor;
                    month = NumberUtils.parseInt1(buf, monOffset++);
                    if (monOffset >= bufLength) continue block9;
                    int mon2 = NumberUtils.digitDecimal(buf[monOffset]);
                    if (mon2 == -1) {
                        --factor;
                        continue block9;
                    }
                    month = month * 10 + mon2;
                    continue block9;
                }
                case 3: {
                    int dayOffset = this.dayIndex + offset + factor;
                    day = NumberUtils.parseInt1(buf, dayOffset++);
                    if (dayOffset >= bufLength) continue block9;
                    int d2 = NumberUtils.digitDecimal(buf[dayOffset]);
                    if (d2 == -1) {
                        --factor;
                        continue block9;
                    }
                    day = day * 10 + d2;
                    continue block9;
                }
                case 4: {
                    int hourOffset = this.hourIndex + offset + factor;
                    hour = NumberUtils.parseInt1(buf, hourOffset++);
                    if (hourOffset >= bufLength) continue block9;
                    int h2 = NumberUtils.digitDecimal(buf[hourOffset]);
                    if (h2 == -1) {
                        --factor;
                        continue block9;
                    }
                    hour = hour * 10 + h2;
                    continue block9;
                }
                case 5: {
                    int minOffset = this.minuteIndex + offset + factor;
                    minute = NumberUtils.parseInt1(buf, minOffset++);
                    if (minOffset >= bufLength) continue block9;
                    int minute2 = NumberUtils.digitDecimal(buf[minOffset]);
                    if (minute2 == -1) {
                        --factor;
                        continue block9;
                    }
                    minute = minute * 10 + minute2;
                    continue block9;
                }
                case 6: {
                    int secOffset = this.secondIndex + offset + factor;
                    second = NumberUtils.parseInt1(buf, secOffset++);
                    if (secOffset >= bufLength) continue block9;
                    int s2 = NumberUtils.digitDecimal(buf[secOffset]);
                    if (s2 == -1) {
                        --factor;
                        continue block9;
                    }
                    second = second * 10 + s2;
                    continue block9;
                }
                case 7: {
                    int v2;
                    int msOffset = this.millisecondIndex + offset + factor;
                    int digit = NumberUtils.digitDecimal(buf[msOffset++]);
                    if (digit != -1) {
                        millisecond = digit;
                    }
                    if (msOffset >= bufLength) continue block9;
                    if ((v2 = NumberUtils.digitDecimal(buf[msOffset++])) != -1) {
                        millisecond = millisecond * 10 + v2;
                        if (msOffset >= bufLength) continue block9;
                        int v3 = NumberUtils.digitDecimal(buf[msOffset]);
                        if (v3 != -1) {
                            millisecond = millisecond * 10 + v3;
                            continue block9;
                        }
                        --factor;
                        continue block9;
                    }
                    factor -= 2;
                    continue block9;
                }
            }
        }
        return new GeneralDate(year, month, day, hour, minute, second, millisecond, timeZone);
    }

    public GeneralDate parseGeneralDate(byte[] buf, int offset, int len, TimeZone timeZone) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        int factor = 0;
        int bufLength = offset + len;
        block9: for (DateFieldIndex fieldIndex : this.fieldIndexs) {
            switch (fieldIndex.field) {
                case 1: {
                    int yearLen = fieldIndex.len;
                    if (yearLen == 2) {
                        year = NumberUtils.parseInt2(buf, this.yearIndex + offset + factor);
                        year += new GregorianDate().getYear() / 100 * 100;
                        continue block9;
                    }
                    year = NumberUtils.parseInt4(buf, this.fullYearIndex + offset + factor);
                    continue block9;
                }
                case 2: {
                    int monOffset = this.monthIndex + offset + factor;
                    month = NumberUtils.parseInt1(buf, monOffset++);
                    if (monOffset >= bufLength) continue block9;
                    int mon2 = NumberUtils.digitDecimal((char)buf[monOffset]);
                    if (mon2 == -1) {
                        --factor;
                        continue block9;
                    }
                    month = month * 10 + mon2;
                    continue block9;
                }
                case 3: {
                    int dayOffset = this.dayIndex + offset + factor;
                    day = NumberUtils.parseInt1(buf, dayOffset++);
                    if (dayOffset >= bufLength) continue block9;
                    int d2 = NumberUtils.digitDecimal((char)buf[dayOffset]);
                    if (d2 == -1) {
                        --factor;
                        continue block9;
                    }
                    day = day * 10 + d2;
                    continue block9;
                }
                case 4: {
                    int hourOffset = this.hourIndex + offset + factor;
                    hour = NumberUtils.parseInt1(buf, hourOffset++);
                    if (hourOffset >= bufLength) continue block9;
                    int h2 = NumberUtils.digitDecimal(buf[hourOffset]);
                    if (h2 == -1) {
                        --factor;
                        continue block9;
                    }
                    hour = hour * 10 + h2;
                    continue block9;
                }
                case 5: {
                    int minOffset = this.minuteIndex + offset + factor;
                    minute = NumberUtils.parseInt1(buf, minOffset++);
                    if (minOffset >= bufLength) continue block9;
                    int minute2 = NumberUtils.digitDecimal(buf[minOffset]);
                    if (minute2 == -1) {
                        --factor;
                        continue block9;
                    }
                    minute = minute * 10 + minute2;
                    continue block9;
                }
                case 6: {
                    int secOffset = this.secondIndex + offset + factor;
                    second = NumberUtils.parseInt1(buf, secOffset++);
                    if (secOffset >= bufLength) continue block9;
                    int s2 = NumberUtils.digitDecimal(buf[secOffset]);
                    if (s2 == -1) {
                        --factor;
                        continue block9;
                    }
                    second = second * 10 + s2;
                    continue block9;
                }
                case 7: {
                    int v2;
                    int msOffset = this.millisecondIndex + offset + factor;
                    int digit = NumberUtils.digitDecimal(buf[msOffset++]);
                    if (digit != -1) {
                        millisecond = digit;
                    }
                    if (msOffset >= bufLength) continue block9;
                    if ((v2 = NumberUtils.digitDecimal(buf[msOffset++])) != -1) {
                        millisecond = millisecond * 10 + v2;
                        if (msOffset >= bufLength) continue block9;
                        int v3 = NumberUtils.digitDecimal(buf[msOffset]);
                        if (v3 != -1) {
                            millisecond = millisecond * 10 + v3;
                            continue block9;
                        }
                        --factor;
                        continue block9;
                    }
                    factor -= 2;
                    continue block9;
                }
            }
        }
        return new GeneralDate(year, month, day, hour, minute, second, millisecond, timeZone);
    }

    public long parseTime(char[] buf, int offset, int len, TimeZone timeZone) {
        GeneralDate generalDate = this.parseGeneralDate(buf, offset, len, timeZone);
        generalDate.updateTime();
        return generalDate.timeMills;
    }

    public long parseTime(byte[] buf, int offset, int len, TimeZone timeZone) {
        GeneralDate generalDate = this.parseGeneralDate(buf, offset, len, timeZone);
        generalDate.updateTime();
        return generalDate.timeMills;
    }

    public GregorianDate parse(char[] buf, int offset, int len, TimeZone timeZone) {
        GeneralDate generalDate = this.parseGeneralDate(buf, offset, len, timeZone);
        return new GregorianDate(generalDate.year, generalDate.month, generalDate.dayOfMonth, generalDate.hourOfDay, generalDate.minute, generalDate.second, generalDate.millisecond, timeZone);
    }

    public GregorianDate parse(char[] buf, int offset, int len) {
        return this.parse(buf, offset, len, null);
    }

    public GregorianDate parse(String dateStr, TimeZone timeZone) {
        char[] buf = dateStr.toCharArray();
        return this.parse(buf, 0, buf.length, timeZone);
    }

    public GregorianDate parse(String dateStr) {
        return this.parse(dateStr, null);
    }

    public String format(GregorianDate date) {
        StringBuilder writer = new StringBuilder();
        date.formatTo(this.pattern, writer);
        return writer.toString();
    }

    public void formatTo(GregorianDate date, Appendable appendable) {
        date.formatTo(this.pattern, appendable);
    }

    public void formatTo(GregorianDate date, Appendable appendable, boolean escapeQuot) {
        date.formatTo(this.pattern, appendable, escapeQuot);
    }

    static void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond, int dayOfWeek, int daysOfYear, int weekOfMonth, int weekOfYear, TimeZone timeZone, String template, Appendable appendable) {
        DateTemplate.formatTo(year, month, dayOfMonth, hour, minute, second, millisecond, dayOfWeek, daysOfYear, weekOfMonth, weekOfYear, timeZone, template, appendable, false);
    }

    static void formatTo(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond, int dayOfWeek, int daysOfYear, int weekOfMonth, int weekOfYear, TimeZone timeZone, String template, Appendable appendable, boolean escape) {
        try {
            String pattern = template.trim();
            int len = pattern.length();
            char prevChar = '\u0000';
            int count = 0;
            for (int i = 0; i <= len; ++i) {
                char ch = '\u0000';
                if (i < len) {
                    ch = pattern.charAt(i);
                }
                if (ch == 'Y') {
                    ch = 'y';
                }
                if (prevChar == ch) {
                    ++count;
                } else {
                    switch (prevChar) {
                        case 'y': {
                            if (year < 0) {
                                appendable.append('-');
                                year = -year;
                            }
                            int y2 = year % 100;
                            if (count == 2) {
                                appendable.append(DigitTens[y2]);
                                appendable.append(DigitOnes[y2]);
                                break;
                            }
                            int y1 = year / 100;
                            appendable.append(DigitTens[y1]);
                            appendable.append(DigitOnes[y1]);
                            appendable.append(DigitTens[y2]);
                            appendable.append(DigitOnes[y2]);
                            break;
                        }
                        case 'M': {
                            appendable.append(DigitTens[month]);
                            appendable.append(DigitOnes[month]);
                            break;
                        }
                        case 'd': {
                            appendable.append(DigitTens[dayOfMonth]);
                            appendable.append(DigitOnes[dayOfMonth]);
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            if (hour < 12) {
                                appendable.append("\u4e0a\u5348");
                                break;
                            }
                            appendable.append("\u4e0b\u5348");
                            break;
                        }
                        case 'H': {
                            appendable.append(DigitTens[hour]);
                            appendable.append(DigitOnes[hour]);
                            break;
                        }
                        case 'h': {
                            int h = hour % 12;
                            if (h == 0) {
                                h = 12;
                            }
                            appendable.append(DigitTens[h]);
                            appendable.append(DigitOnes[h]);
                            break;
                        }
                        case 'm': {
                            appendable.append(DigitTens[minute]);
                            appendable.append(DigitOnes[minute]);
                            break;
                        }
                        case 's': {
                            appendable.append(DigitTens[second]);
                            appendable.append(DigitOnes[second]);
                            break;
                        }
                        case 'S': {
                            char s1 = (char)(millisecond / 100 + 48);
                            int v = millisecond % 100;
                            appendable.append(s1);
                            appendable.append(DigitTens[v]);
                            appendable.append(DigitOnes[v]);
                            break;
                        }
                        case 'E': {
                            appendable.append(WEEK_DAYS[dayOfWeek - 1 & 7]);
                            break;
                        }
                        case 'D': {
                            appendable.append(String.valueOf(daysOfYear));
                            break;
                        }
                        case 'F': {
                            appendable.append(String.valueOf(weekOfMonth));
                            break;
                        }
                        case 'W': {
                            int firstDayOfWeek = (dayOfWeek + 7 - dayOfMonth % 7) % 7 + 1;
                            if (dayOfWeek < firstDayOfWeek) {
                                appendable.append(String.valueOf(weekOfMonth + 1));
                                break;
                            }
                            appendable.append(String.valueOf(weekOfMonth));
                            break;
                        }
                        case 'w': {
                            appendable.append(String.valueOf(weekOfYear));
                            break;
                        }
                        case 'z': {
                            TimeZone tz = timeZone == null ? GeneralDate.getDefaultTimeZone() : timeZone;
                            appendable.append(tz.getID());
                            break;
                        }
                        default: {
                            if (prevChar == '\u0000') break;
                            int n = count;
                            while (n-- > 0) {
                                if (escape && prevChar == '\"') {
                                    appendable.append('\\');
                                }
                                appendable.append(prevChar);
                            }
                            break block1;
                        }
                    }
                    count = 1;
                }
                prevChar = ch;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(throwable.getMessage(), throwable);
        }
    }

    public int write(int year, int month, int dayOfMonth, int hour, int minute, int second, int millisecond, char[] buf, int off) {
        int beginIndex = off;
        try {
            String pattern = this.pattern;
            int len = pattern.length();
            int prevChar = 0;
            int count = 0;
            for (int i = 0; i <= len; ++i) {
                int ch = 0;
                if (i < len) {
                    ch = pattern.charAt(i);
                }
                if (ch == 89) {
                    ch = 121;
                }
                if (prevChar == ch) {
                    ++count;
                } else {
                    switch (prevChar) {
                        case 121: {
                            if (year < 0) {
                                buf[off++] = 45;
                                year = -year;
                            }
                            int y2 = year % 100;
                            if (count == 2) {
                                buf[off++] = DigitTens[y2];
                                buf[off++] = DigitOnes[y2];
                                break;
                            }
                            int y1 = year / 100;
                            buf[off++] = DigitTens[y1];
                            buf[off++] = DigitOnes[y1];
                            buf[off++] = DigitTens[y2];
                            buf[off++] = DigitOnes[y2];
                            break;
                        }
                        case 77: {
                            buf[off++] = DigitTens[month];
                            buf[off++] = DigitOnes[month];
                            break;
                        }
                        case 100: {
                            buf[off++] = DigitTens[dayOfMonth];
                            buf[off++] = DigitOnes[dayOfMonth];
                            break;
                        }
                        case 65: 
                        case 97: {
                            if (hour < 12) {
                                buf[off++] = 19978;
                                buf[off++] = 21320;
                                break;
                            }
                            buf[off++] = 19979;
                            buf[off++] = 21320;
                            break;
                        }
                        case 72: {
                            buf[off++] = DigitTens[hour];
                            buf[off++] = DigitOnes[hour];
                            break;
                        }
                        case 104: {
                            int h = hour % 12;
                            if (h == 0) {
                                h = 12;
                            }
                            buf[off++] = DigitTens[h];
                            buf[off++] = DigitOnes[h];
                            break;
                        }
                        case 109: {
                            buf[off++] = DigitTens[minute];
                            buf[off++] = DigitOnes[minute];
                            break;
                        }
                        case 115: {
                            buf[off++] = DigitTens[second];
                            buf[off++] = DigitOnes[second];
                            break;
                        }
                        case 83: {
                            char s1 = (char)(millisecond / 100 + 48);
                            int v = millisecond % 100;
                            buf[off++] = s1;
                            buf[off++] = DigitTens[v];
                            buf[off++] = DigitOnes[v];
                            break;
                        }
                        default: {
                            if (prevChar == 0) break;
                            int n = count;
                            while (n-- > 0) {
                                if (prevChar == 34) {
                                    buf[off++] = 92;
                                }
                                buf[off++] = prevChar;
                            }
                            break block1;
                        }
                    }
                    count = 1;
                }
                prevChar = ch;
            }
            return off - beginIndex;
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(throwable.getMessage(), throwable);
        }
    }

    public int estimateSize() {
        int size = 0;
        try {
            String pattern = this.pattern;
            int len = pattern.length();
            int prevChar = 0;
            int count = 0;
            for (int i = 0; i <= len; ++i) {
                int ch = 0;
                if (i < len) {
                    ch = pattern.charAt(i);
                }
                if (ch == 89) {
                    ch = 121;
                }
                if (prevChar == ch) {
                    ++count;
                } else {
                    switch (prevChar) {
                        case 121: {
                            size += 4;
                            break;
                        }
                        case 65: 
                        case 72: 
                        case 77: 
                        case 97: 
                        case 100: 
                        case 104: 
                        case 109: 
                        case 115: 
                        case 119: {
                            size += 2;
                            break;
                        }
                        case 68: 
                        case 69: 
                        case 70: 
                        case 83: 
                        case 87: {
                            size += 3;
                            break;
                        }
                        case 122: {
                            size += 20;
                            break;
                        }
                        default: {
                            if (prevChar == 0) break;
                            int n = count;
                            while (n-- > 0) {
                                if (prevChar == 34) {
                                    ++size;
                                }
                                ++size;
                            }
                            break block1;
                        }
                    }
                    count = 1;
                }
                prevChar = ch;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(throwable.getMessage(), throwable);
        }
        return size;
    }

    public void formatTo(int year, int month, int day, int hour, int minute, int second, int millisecond, Appendable appendable) {
        DateTemplate.formatTo(year, month, day, hour, minute, second, millisecond, 0, 0, 0, 0, null, this.pattern, appendable);
    }

    public void formatTo(int year, int month, int day, int hour, int minute, int second, int millisecond, Appendable appendable, boolean escape) {
        DateTemplate.formatTo(year, month, day, hour, minute, second, millisecond, 0, 0, 0, 0, null, this.pattern, appendable, escape);
    }

    public String toString() {
        return "DateTemplate{pattern='" + this.pattern + '\'' + '}';
    }

    public static class DateFieldIndex
    implements Comparable<DateFieldIndex> {
        final int field;
        final Integer index;
        final int len;

        DateFieldIndex(int field, int index, int len) {
            this.field = field;
            this.index = index;
            this.len = len;
        }

        @Override
        public int compareTo(DateFieldIndex o) {
            return this.index.compareTo(o.index);
        }
    }
}

