/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;
import io.github.wycst.wast.common.beans.geo.Point;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class Geometry {
    private final GeometryType type;

    Geometry(GeometryType type) {
        this.type = type;
    }

    public static Geometry from(String source) {
        return Geometry.from(source, false);
    }

    public static Geometry from(String source, boolean strict) {
        if (source == null) {
            return null;
        }
        source = source.trim();
        GeometryContext geometryContext = new GeometryContext();
        geometryContext.strict = strict;
        return Geometry.from(source, geometryContext);
    }

    static Geometry from(String source, GeometryContext geometryContext) {
        char[] chars = UnsafeHelper.getChars(source.toUpperCase());
        GeometryType geometryType = Geometry.readGeometryType(chars, geometryContext);
        Geometry geometry = geometryType.newInstance();
        try {
            geometry.readBody(chars, geometryContext);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Error Geometry source: " + source, runtimeException);
        }
        if (geometryContext.offset != chars.length - 1) {
            throw new IllegalArgumentException("Error Geometry source: " + source + ", extra characters found '" + new String(source.substring(geometryContext.offset + 1)) + "'");
        }
        return geometry;
    }

    void readBody(char[] chars, GeometryContext geometryContext) {
    }

    static GeometryType readGeometryType(char[] chars, GeometryContext geometryContext) {
        int offset;
        int beginIndex = offset = geometryContext.offset;
        while (chars[++offset] != '(') {
        }
        geometryContext.offset = offset;
        String type = new String(chars, beginIndex, offset - beginIndex).trim();
        return GeometryType.valueOf(type);
    }

    static void readPoint(char[] chars, GeometryContext geometryContext) {
        char ch;
        int offset;
        int beginIndex = offset = geometryContext.offset;
        boolean decimalPoint = false;
        while ((ch = chars[++offset]) != ' ') {
            if (ch != '.') continue;
            decimalPoint = true;
        }
        String numberStr = new String(chars, beginIndex, offset - beginIndex);
        Double doubleVal = Double.parseDouble(numberStr);
        Number number = geometryContext.x = decimalPoint ? (Number)doubleVal : (Number)((Number)doubleVal).longValue();
        while (chars[++offset] == ' ') {
        }
        beginIndex = offset;
        decimalPoint = false;
        while ((ch = chars[++offset]) != ')' && ch != ',') {
            if (ch != '.') continue;
            decimalPoint = true;
        }
        numberStr = new String(chars, beginIndex, offset - beginIndex).trim();
        doubleVal = Double.parseDouble(numberStr);
        geometryContext.setOffset(offset);
        geometryContext.y = decimalPoint ? (Number)doubleVal : (Number)((Number)doubleVal).longValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<Point> readPoints(char[] chars, GeometryContext geometryContext) {
        boolean useBracket;
        char ch;
        int offset = geometryContext.offset;
        ArrayList<Point> points = new ArrayList<Point>();
        while ((ch = chars[++offset]) == ' ') {
        }
        boolean bl = useBracket = ch == '(';
        do {
            if (useBracket) {
                while (chars[++offset] == ' ') {
                }
            }
            geometryContext.offset = offset;
            Geometry.readPoint(chars, geometryContext);
            Point point = Point.of(geometryContext.x, geometryContext.y);
            points.add(point);
            offset = geometryContext.offset;
            ch = chars[offset];
            if (useBracket) {
                if (ch != ')') {
                    throw new IllegalArgumentException("Geometry syntax error, offset " + offset + " , expected ')', actual '" + ch + "'");
                }
                while ((ch = chars[++offset]) == ' ') {
                }
                geometryContext.offset = offset;
                if (ch == ')') return points;
                if (ch != ',') {
                    throw new IllegalArgumentException("Geometry syntax error, offset " + offset + " , expected ',', actual '" + ch + "'");
                }
            } else {
                if (ch == ')') return points;
                if (ch != ',') {
                    throw new IllegalArgumentException("Geometry syntax error, offset " + offset + " , expected ',', actual '" + ch + "'");
                }
            }
            while ((ch = chars[++offset]) == ' ') {
            }
        } while (!useBracket || ch == '(');
        throw new IllegalArgumentException("Geometry syntax error, offset " + offset + " , expected '(', actual '" + ch + "'");
    }

    abstract void appendBody(StringBuilder var1);

    final void appendTo(StringBuilder builder) {
        builder.append((Object)this.type);
        this.appendBody(builder);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    public final String toGeometryString() {
        return this.toString();
    }

    public GeometryType getType() {
        return this.type;
    }
}

