/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans.geo;

import io.github.wycst.wast.common.beans.geo.AbstractMultiGeometry;
import io.github.wycst.wast.common.beans.geo.GeometryContext;
import io.github.wycst.wast.common.beans.geo.GeometryType;
import io.github.wycst.wast.common.beans.geo.PolygonPlane;
import java.util.ArrayList;
import java.util.List;

public class Polygon
extends AbstractMultiGeometry {
    List<PolygonPlane> elements = new ArrayList<PolygonPlane>();

    public Polygon() {
        super(GeometryType.POLYGON);
    }

    public void add(PolygonPlane plane) {
        this.elements.add(plane);
    }

    public void addAll(PolygonPlane ... elements) {
        for (PolygonPlane plane : elements) {
            this.elements.add(plane);
        }
    }

    public void addAll(List<PolygonPlane> elements) {
        this.elements.addAll(elements);
    }

    public PolygonPlane removeAt(int index) {
        return this.elements.remove(index);
    }

    public boolean remove(PolygonPlane plane) {
        return this.elements.remove(plane);
    }

    public void clear() {
        this.elements.clear();
    }

    @Override
    void appendBody(StringBuilder builder) {
        builder.append("(");
        int deleteDotIndex = -1;
        for (PolygonPlane plane : this.elements) {
            plane.appendBody(builder);
            builder.append(",");
            deleteDotIndex = builder.length() - 1;
        }
        if (deleteDotIndex > -1) {
            builder.deleteCharAt(deleteDotIndex);
        }
        builder.append(")");
    }

    @Override
    protected void readElement(char[] chars, GeometryContext geometryContext) {
        this.elements.add(new PolygonPlane(Polygon.readPoints(chars, geometryContext)));
    }

    public List<PolygonPlane> getElements() {
        return this.elements;
    }

    public void setElements(List<PolygonPlane> elements) {
        this.elements = elements;
    }
}

