/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression.invoker;

import io.github.wycst.wast.common.expression.invoker.Invoker;
import io.github.wycst.wast.common.expression.invoker.VariableInvoker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ChainVariableInvoker
implements Invoker {
    final VariableInvoker variableInvoke;
    ChainVariableInvoker next;

    ChainVariableInvoker(VariableInvoker variableInvoke) {
        this.variableInvoke = variableInvoke;
    }

    @Override
    public Object invoke(Object context) {
        try {
            this.variableInvoke.invoke(context);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invoke(context);
    }

    @Override
    public Object invoke(Map context) {
        try {
            this.variableInvoke.invoke(context);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invoke(context);
    }

    @Override
    public Object invokeDirect(Object context) {
        throw new UnsupportedOperationException("chain invoker is not supported");
    }

    @Override
    public Object invokeDirect(Map context) {
        throw new UnsupportedOperationException("chain invoker is not supported");
    }

    @Override
    public Object invoke(Object entityContext, Object[] variableValues) {
        try {
            this.variableInvoke.invoke(entityContext, variableValues);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invoke(entityContext, variableValues);
    }

    @Override
    public Object invoke(Map mapContext, Object[] variableValues) {
        try {
            this.variableInvoke.invoke(mapContext, variableValues);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
        }
        return this.next.invoke(mapContext, variableValues);
    }

    @Override
    public void reset() {
        this.variableInvoke.reset();
        this.next.reset();
    }

    @Override
    public List<VariableInvoker> tailInvokers() {
        ArrayList<VariableInvoker> variableInvokers = new ArrayList<VariableInvoker>();
        if (this.variableInvoke.isTail()) {
            variableInvokers.add(this.variableInvoke);
        }
        ChainVariableInvoker next = this.next;
        while (next != null) {
            if (next.variableInvoke.isTail()) {
                variableInvokers.add(next.variableInvoke);
            }
            next = next.next;
        }
        return variableInvokers;
    }

    @Override
    public void internKey() {
        this.variableInvoke.internKey();
        if (this.next != null) {
            this.next.internKey();
        }
    }

    @Override
    public int size() {
        return this.next == null ? 1 : 1 + this.next.size();
    }

    public static Invoker build(Map<String, VariableInvoker> variableInvokes) {
        return ChainVariableInvoker.build(variableInvokes, false);
    }

    public static Invoker build(Map<String, VariableInvoker> variableInvokes, boolean indexVariable) {
        Collection<VariableInvoker> collection = variableInvokes.values();
        int length = collection.size();
        int index = 0;
        boolean onlyOne = length == 1;
        ChainVariableInvoker head = null;
        ChainVariableInvoker prev = null;
        for (VariableInvoker variableInvoke : collection) {
            ChainVariableInvoker node;
            if (indexVariable) {
                variableInvoke.setIndex(index);
            }
            if (onlyOne) {
                return variableInvoke;
            }
            boolean tail = ++index == length;
            ChainVariableInvoker chainVariableInvoker = node = tail ? new TailVariableInvoke(variableInvoke) : new ChainVariableInvoker(variableInvoke);
            if (head == null) {
                head = node;
            } else {
                prev.next = node;
            }
            prev = node;
        }
        return head;
    }

    static class TailVariableInvoke
    extends ChainVariableInvoker {
        TailVariableInvoke(VariableInvoker variableInvoke) {
            super(variableInvoke);
        }

        @Override
        public Object invoke(Object context) {
            return this.variableInvoke.invoke(context);
        }

        @Override
        public Object invoke(Map context) {
            return this.variableInvoke.invoke(context);
        }

        @Override
        public Object invoke(Object entityContext, Object[] variableValues) {
            try {
                return this.variableInvoke.invoke(entityContext, variableValues);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
            }
        }

        @Override
        public Object invoke(Map mapContext, Object[] variableValues) {
            try {
                return this.variableInvoke.invoke(mapContext, variableValues);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(String.format("Unresolved field '%s', reason: %s", this.variableInvoke.toString(), runtimeException.getMessage()));
            }
        }

        @Override
        public void reset() {
            this.variableInvoke.reset();
        }
    }
}

